/*
 * Decompiled with CFR 0.152.
 */
package hec.statistics.confidence;

import hec.statistics.EmpiricalDist;
import hec.statistics.confidence.OrderStatistics;

public class BinomialApproximationOrderStatistics
extends OrderStatistics {
    public BinomialApproximationOrderStatistics(EmpiricalDist dist) {
        super(dist);
    }

    @Override
    public double getStandardDeviation(double frequency, int equivalentRecordLength) {
        double delta = 1.0E-16;
        if (frequency < 0.01) {
            frequency = 0.01;
        } else if (frequency >= 0.99) {
            frequency = 0.99;
        }
        double pdf = 2.0 * delta / (this.getDistribution().invCDF(frequency + delta) - this.getDistribution().invCDF(frequency - delta));
        return Math.sqrt(frequency * (1.0 - frequency) / (double)equivalentRecordLength) / pdf;
    }
}

