/*
 * Decompiled with CFR 0.152.
 */
package hec.statistics.confidence;

import hec.statistics.EmpiricalDist;
import hec.statistics.confidence.OrderStatistics;

public class NormalApproximationOrderStatistics
extends OrderStatistics {
    private double _mean;
    private double _variance;
    private final boolean _useLog;

    public NormalApproximationOrderStatistics(EmpiricalDist dist, boolean useLog) {
        super(dist);
        this._useLog = useLog;
        if (this._useLog) {
            this.convertToLog();
        }
        this._mean = this.mean();
        this._variance = this.variance();
    }

    private void convertToLog() {
        double[] values = this.getDistribution().getValues();
        for (int i = 0; i < values.length; ++i) {
            values[i] = Math.log10(values[i]);
        }
        this.getDistribution().setValues(values);
    }

    @Override
    public double getStandardDeviation(double frequency, int equivalentRecordLength) {
        double yValue = this.getDistribution().invCDF(frequency);
        double zVariance = (yValue - this._mean) * (yValue - this._mean);
        this.mean();
        return Math.sqrt((this._variance + 0.5 * zVariance) / (double)equivalentRecordLength);
    }

    private double mean() {
        double retval = 0.0;
        for (int i = 1; i < this.getDistribution().size(); ++i) {
            retval += 0.5 * (this.getDistribution().getValue(i - 1) + this.getDistribution().getValue(i)) * this.getMultiplier(this.getDistribution().getCumProb(0), this.getDistribution().getCumProb(i - 1), this.getDistribution().getCumProb(i), this.getDistribution().getCumProb(this.getDistribution().size() - 1));
        }
        return retval;
    }

    private double variance() {
        double retval = 0.0;
        for (int i = 1; i < this.getDistribution().size(); ++i) {
            double diff_i_1 = this.getDistribution().getValue(i - 1) - this._mean;
            double diff_i = this.getDistribution().getValue(i) - this._mean;
            retval += 0.5 * (diff_i_1 * diff_i_1 + diff_i * diff_i) * this.getMultiplier(this.getDistribution().getCumProb(0), this.getDistribution().getCumProb(i - 1), this.getDistribution().getCumProb(i), this.getDistribution().getCumProb(this.getDistribution().size() - 1));
        }
        return retval;
    }

    private double getMultiplier(double p1, double pi_1, double pi, double pn) {
        return (1.0 - pi_1 - (1.0 - pi)) / (1.0 - p1 - (1.0 - pn));
    }

    @Override
    public double[] computeConfidenceLimit(double confidenceLimit, double[] frequencyOrdinates, int equivalentRecordLength) {
        double[] retval = super.computeConfidenceLimit(confidenceLimit, frequencyOrdinates, equivalentRecordLength);
        if (this._useLog) {
            this.unlogResults(retval);
        }
        return retval;
    }

    private void unlogResults(double[] retval) {
        for (int i = 0; i < retval.length; ++i) {
            retval[i] = Math.pow(10.0, retval[i]);
        }
    }
}

