/*
 * Decompiled with CFR 0.152.
 */
package hec.statistics.confidence;

import hec.statistics.EmpiricalDist;
import hec.statistics.NormalDist;

public abstract class OrderStatistics {
    private static final NormalDist NORMAL = new NormalDist();
    private EmpiricalDist _distribution;

    public OrderStatistics(EmpiricalDist dist) {
        if (dist == null) {
            throw new NullPointerException("Distribution must be non-null for Order Statistics");
        }
        if (dist.isEmpty()) {
            throw new IllegalArgumentException("Distribution must be defined for Order Statistics");
        }
        if (!this.isIncreasing(dist.getCumProbs())) {
            throw new IllegalArgumentException("Distribution must have strictly increasing cumulative probabilities for Order Statistics");
        }
        this._distribution = (EmpiricalDist)dist.clone();
    }

    private boolean isIncreasing(double[] cumProbs) {
        for (int i = 1; i < cumProbs.length; ++i) {
            if (!(cumProbs[i - 1] >= cumProbs[i])) continue;
            return false;
        }
        return true;
    }

    public double[] computeConfidenceLimit(double confidenceLimit, double[] frequencyOrdinates, int equivalentRecordLength) {
        double[] retval = new double[frequencyOrdinates.length];
        double standardNormalDeviate = NORMAL.invCDF(confidenceLimit);
        for (int i = 0; i < frequencyOrdinates.length; ++i) {
            double standardDeviation = this.getStandardDeviation(frequencyOrdinates[i], equivalentRecordLength);
            retval[i] = this._distribution.invCDF(frequencyOrdinates[i]) + standardDeviation * standardNormalDeviate;
        }
        return retval;
    }

    public abstract double getStandardDeviation(double var1, int var3);

    protected EmpiricalDist getDistribution() {
        return this._distribution;
    }
}

