/*
 * Decompiled with CFR 0.152.
 */
package hec.statistics.sampling;

import hec.statistics.sampling.StratificationBinDefinition;
import java.util.NavigableSet;
import java.util.Optional;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StratificationBinContainer {
    private static final Logger LOGGER = Logger.getLogger(StratificationBinContainer.class.getName());
    private NavigableSet<StratificationBinDefinition> _binDefinitionList = new TreeSet<StratificationBinDefinition>();

    public int getNumberOfBins() {
        return this._binDefinitionList.size();
    }

    public double getBinWeight(int binNumber) {
        return this.getBinForIndex(binNumber).getBinWeight();
    }

    public double stratify(int binNumber, double value) {
        return this.getBinForIndex(binNumber).convertProbabilityToBinSpace(value);
    }

    public double getMaxValueForBin(int binNumber) {
        return this.getBinForIndex(binNumber).getUpperBound();
    }

    private StratificationBinDefinition getBinForIndex(int binNumber) {
        if (binNumber < 0 || binNumber >= this._binDefinitionList.size()) {
            throw new ArrayIndexOutOfBoundsException("Index: " + binNumber + " does not exist in the bin container. Container has " + this._binDefinitionList.size() + " bins.");
        }
        StratificationBinDefinition retval = null;
        int currInt = 0;
        for (StratificationBinDefinition currBin : this._binDefinitionList) {
            if (currInt == binNumber) {
                retval = currBin;
                break;
            }
            ++currInt;
        }
        return retval;
    }

    public boolean add(StratificationBinDefinition newBin) {
        boolean success;
        Optional<StratificationBinDefinition> overlappingBin = this.findOverlappingBin(newBin);
        if (overlappingBin.isPresent()) {
            success = false;
            LOGGER.log(Level.SEVERE, "Bin: " + newBin + " overlaps with existing bin: " + overlappingBin.get() + ". Cannot add this bin to container.");
        } else {
            success = true;
            this._binDefinitionList.add(newBin);
        }
        return success;
    }

    public boolean isBinContainerValid() {
        boolean retval = true;
        StringBuilder sb = new StringBuilder();
        if (this._binDefinitionList.isEmpty()) {
            retval = false;
            sb.append("No bin definitions in this container");
        } else {
            if (Double.compare(((StratificationBinDefinition)this._binDefinitionList.first()).getLowerBound(), 0.0) != 0) {
                sb.append("First bin does not have a lower bound of 0: " + this._binDefinitionList.first() + "\n");
                retval = false;
            }
            for (StratificationBinDefinition bin : this._binDefinitionList) {
                StratificationBinDefinition nextBin = this._binDefinitionList.higher(bin);
                if (nextBin == null || Double.compare(bin.getUpperBound(), nextBin.getLowerBound()) == 0) continue;
                sb.append("Probability gap detected between " + bin + " and " + nextBin + "\n");
                retval = false;
            }
            if (Double.compare(((StratificationBinDefinition)this._binDefinitionList.last()).getUpperBound(), 1.0) != 0) {
                sb.append("Last bin does not have an upper bound of 1: " + this._binDefinitionList.last() + "\n");
                retval = false;
            }
        }
        if (!retval) {
            LOGGER.log(Level.SEVERE, sb.toString());
        }
        return retval;
    }

    private Optional<StratificationBinDefinition> findOverlappingBin(StratificationBinDefinition newBin) {
        StratificationBinDefinition retval = null;
        for (StratificationBinDefinition bin : this._binDefinitionList) {
            if (!bin.doesBinOverlap(newBin)) continue;
            retval = bin;
            break;
        }
        return Optional.ofNullable(retval);
    }
}

