/*
 * Decompiled with CFR 0.152.
 */
package hec.statistics.sampling;

import hec.statistics.ContDist;
import hec.statistics.sampling.StratificationBinContainer;
import hec.statistics.sampling.StratificationBinDefinition;

public class StratificationBinCreator {
    private ContDist _binDefinitionDistributionSpace;
    private double _maximumExceedanceProbability;
    private double _minimumExceedanceProbability;
    private int _numberOfBins;

    public StratificationBinCreator(ContDist binDefinitionDistributionSpace, double minimumExceedanceProbability, double maximumExceedanceProbability, int numberOfBins) {
        if (binDefinitionDistributionSpace == null) {
            throw new NullPointerException("Cannot create bins with null bin space definition distribution.");
        }
        if (minimumExceedanceProbability >= maximumExceedanceProbability || minimumExceedanceProbability <= 0.0 || Double.isInfinite(binDefinitionDistributionSpace.getCDF(1.0 - maximumExceedanceProbability))) {
            throw new IllegalArgumentException("Maximum and minimum exceedance probabilities must be between zero and one,\nand the maximum exceedance probability must be greater than the minimum exceedance probability.");
        }
        if (numberOfBins <= 2) {
            throw new IllegalArgumentException("Must have more than two bins.");
        }
        this._binDefinitionDistributionSpace = binDefinitionDistributionSpace;
        this._maximumExceedanceProbability = maximumExceedanceProbability;
        this._minimumExceedanceProbability = minimumExceedanceProbability;
        this._numberOfBins = numberOfBins;
    }

    public void setNumberOfBins(int numberOfBins) {
        if (numberOfBins <= 2) {
            throw new IllegalArgumentException("Must have more than two bins.");
        }
        this._numberOfBins = numberOfBins;
    }

    public StratificationBinContainer createBins() {
        StratificationBinContainer retval = new StratificationBinContainer();
        double lowerBoundInDistributionSpace = this._binDefinitionDistributionSpace.invCDF(1.0 - this._maximumExceedanceProbability);
        double upperBoundInDistributionSpace = this._binDefinitionDistributionSpace.invCDF(1.0 - this._minimumExceedanceProbability);
        double interval = (upperBoundInDistributionSpace - lowerBoundInDistributionSpace) / (double)this._numberOfBins;
        retval.add(new StratificationBinDefinition(0.0, this._binDefinitionDistributionSpace.getCDF(lowerBoundInDistributionSpace + interval)));
        double currentLowerBound = lowerBoundInDistributionSpace + interval;
        for (int i = 0; i < this._numberOfBins - 2; ++i) {
            retval.add(new StratificationBinDefinition(this._binDefinitionDistributionSpace.getCDF(currentLowerBound), this._binDefinitionDistributionSpace.getCDF(currentLowerBound + interval)));
            currentLowerBound += interval;
        }
        retval.add(new StratificationBinDefinition(this._binDefinitionDistributionSpace.getCDF(currentLowerBound), 1.0));
        if (!retval.isBinContainerValid()) {
            retval = null;
        }
        return retval;
    }
}

