/*
 * Decompiled with CFR 0.152.
 */
package hec.statistics.sampling;

import mil.army.usace.hec.metadata.constants.NumericalConstants;

public class StratificationBinDefinition
implements Comparable<StratificationBinDefinition> {
    private double _lowerBound;
    private double _upperBound;

    public StratificationBinDefinition(double lower, double upper) {
        this.validateProbability(lower);
        this.validateProbability(upper);
        if (upper <= lower) {
            throw new IllegalArgumentException("Invalid probability bounds: Upper=" + upper + ", Lower=" + lower + "\nUpper bound must be greater than lower bound");
        }
        this._lowerBound = lower;
        this._upperBound = upper;
    }

    public double convertProbabilityToBinSpace(double probability) {
        this.validateProbability(probability);
        return this._lowerBound + probability * (this._upperBound - this._lowerBound);
    }

    private void validateProbability(double probability) {
        if (!NumericalConstants.isValidValue((double)probability) || probability < 0.0 || probability > 1.0) {
            throw new IllegalArgumentException("Invalid probability: " + probability);
        }
    }

    public double getBinWeight() {
        return this._upperBound - this._lowerBound;
    }

    public boolean doesBinOverlap(StratificationBinDefinition other) {
        return other._lowerBound > this._lowerBound && other._lowerBound < this._upperBound || other._upperBound > this._lowerBound && other._upperBound < this._upperBound || this._upperBound > other._lowerBound && this._upperBound < other._upperBound;
    }

    @Override
    public int compareTo(StratificationBinDefinition o) {
        int retval = o == null || o._lowerBound < this._lowerBound ? 1 : (o._lowerBound > this._lowerBound ? -1 : 0);
        return retval;
    }

    double getLowerBound() {
        return this._lowerBound;
    }

    double getUpperBound() {
        return this._upperBound;
    }

    public String toString() {
        return "Lower:" + this._lowerBound + ",Upper:" + this._upperBound;
    }
}

