/*
 * Decompiled with CFR 0.152.
 */
package hec.statistics.util;

public final class Interpolate {
    private Interpolate() {
        throw new IllegalStateException("Interpolate is a Utility class");
    }

    public static double interpolatePairedArrays(double xValue, double[] xArray, double[] yArray) {
        int index = Interpolate.binarySearch(xValue, xArray);
        Double retval = Interpolate.interpolate(xValue, xArray[index], yArray[index], xArray[index + 1], yArray[index + 1]);
        return retval;
    }

    private static int binarySearch(double xValue, double[] xArray) {
        int index = xArray[1] - xArray[0] > 0.0 ? Interpolate.binarySearchAscending(xArray, 0, xArray.length - 1, xValue) : Interpolate.binarySearchDescending(xArray, 0, xArray.length - 1, xValue);
        if (index < 0) {
            index = Interpolate.correctIndexForArray(xArray, index);
        }
        return index;
    }

    private static int correctIndexForArray(double[] array, int index) {
        if ((index = -index - 2) < 0) {
            index = 0;
        }
        if (index > array.length - 2) {
            index = array.length - 2;
        }
        return index;
    }

    private static Double interpolate(Double x, Double x1, Double y1, Double x2, Double y2) {
        double xDiff = x2 - x1;
        double yDiff = y2 - y1;
        double slope = yDiff / xDiff;
        return y1 + (x - x1) * slope;
    }

    private static int binarySearchAscending(double[] a, int fromIndex, int toIndex, double value) {
        double key = value;
        int low = fromIndex;
        int high = toIndex - 1;
        while (low <= high) {
            long keyBits;
            int mid = low + high >>> 1;
            double midVal = a[mid];
            if (midVal < key) {
                low = mid + 1;
                continue;
            }
            if (midVal > key) {
                high = mid - 1;
                continue;
            }
            long midBits = Double.doubleToLongBits(midVal);
            if (midBits == (keyBits = Double.doubleToLongBits(key))) {
                return mid;
            }
            if (midBits < keyBits) {
                low = mid + 1;
                continue;
            }
            high = mid - 1;
        }
        return -(low + 1);
    }

    private static int binarySearchDescending(double[] a, int fromIndex, int toIndex, double value) {
        double key = value;
        int low = fromIndex;
        int high = toIndex - 1;
        while (low <= high) {
            long keyBits;
            int mid = low + high >>> 1;
            double midVal = a[mid];
            if (midVal > key) {
                low = mid + 1;
                continue;
            }
            if (midVal < key) {
                high = mid - 1;
                continue;
            }
            long midBits = Double.doubleToLongBits(midVal);
            if (midBits == (keyBits = Double.doubleToLongBits(key))) {
                return mid;
            }
            if (midBits > keyBits) {
                low = mid + 1;
                continue;
            }
            high = mid - 1;
        }
        return -(low + 1);
    }
}

