/*
 * Decompiled with CFR 0.152.
 */
package hec.statistics.util;

public class StringUtil {
    private StringUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static String getFirstToken(String line, String delim) {
        int idx = line.indexOf(delim);
        if (idx > -1) {
            return line.substring(0, idx).trim();
        }
        return line.trim();
    }

    public static String getSecondToken(String line, String delim) {
        String param = "";
        int idx = line.indexOf(delim);
        if (idx > -1) {
            int len = delim.length();
            param = line.substring(idx + len);
            if ((param = param.trim()).isEmpty()) {
                param = "";
            }
        }
        return param;
    }

    public static int toInt(String str) {
        int val;
        if (str == null) {
            return Integer.MIN_VALUE;
        }
        int idx = (str = str.trim()).indexOf(44);
        if (idx >= 0) {
            str = StringUtil.removeChar(str, ',');
        }
        try {
            val = Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            val = Integer.MIN_VALUE;
        }
        return val;
    }

    private static String removeChar(String s, char c) {
        if (s == null) {
            return s;
        }
        StringBuilder buf = new StringBuilder(s.length());
        buf.setLength(s.length());
        int current = 0;
        int cnt = 0;
        for (int i = 0; i < s.length(); ++i) {
            char cur = s.charAt(i);
            if (cur != c) {
                buf.setCharAt(current++, cur);
                continue;
            }
            ++cnt;
        }
        buf.setLength(buf.length() - cnt);
        return buf.toString();
    }

    public static double toDouble(String str) {
        double val;
        double def = Double.NEGATIVE_INFINITY;
        if (str == null) {
            return def;
        }
        String tmp = str;
        if (tmp.length() == 0) {
            return def;
        }
        int idx = tmp.indexOf(68);
        if (idx >= 0) {
            tmp = tmp.replace('D', 'E');
        }
        if ((idx = tmp.indexOf(100)) >= 0) {
            tmp = tmp.replace('d', 'E');
        }
        if ((idx = tmp.indexOf(44)) >= 0) {
            tmp = StringUtil.removeChar(tmp, ',');
        }
        str = tmp;
        try {
            val = Double.parseDouble(str);
        }
        catch (NumberFormatException e) {
            val = def;
        }
        return val;
    }
}

