/*
 * Decompiled with CFR 0.152.
 */
package hec.client;

import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.MessageFormat;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import rma.swing.RmaInsets;
import rma.swing.RmaJDialog;

public class NewWorkspaceSummaryDialog
extends RmaJDialog {
    public static final int OK_OPTION = 0;
    public static final int CANCEL_OPTION = 1;
    public static final int BACK_OPTION = 2;
    MessageFormat summaryFormat = new MessageFormat("<HTML><BODY><CENTER><H2>Watershed Summary</H2></CENTER><br><B>Name: </B>{0}<br> <B>Description: </B>{1}<br> <B>Unit System: </B>{2}<br> <B>Time Zone: </B>{3}<br> <B>Base Directory: </B>{4} </BODY></HTML>");
    JEditorPane _summaryPane;
    JButton _backButton;
    JButton _okButton;
    JButton _cancelButton;
    int _returnCode = 0;

    public NewWorkspaceSummaryDialog(Frame parent, String title, boolean modal) {
        super(parent, modal);
        this.buildControls();
        if (title != null && title.length() > 0) {
            this.setTitle(title);
        }
    }

    private void buildControls() {
        this.setTitle("Watershed Summary");
        GridBagConstraints gbc = new GridBagConstraints();
        Container cp = this.getContentPane();
        cp.setLayout(new GridBagLayout());
        this._summaryPane = new JEditorPane();
        this._summaryPane.setEditable(false);
        this._summaryPane.setContentType("text/html");
        this._summaryPane.setBackground(null);
        JScrollPane sp = new JScrollPane(this._summaryPane);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = RmaInsets.INSETS5505;
        cp.add((Component)sp, gbc);
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 14;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS0000;
        cp.add((Component)buttonPanel, gbc);
        ButtonListener listener = new ButtonListener();
        this._backButton = new JButton("< Back");
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 13;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5555;
        buttonPanel.add((Component)this._backButton, gbc);
        this._backButton.addActionListener(listener);
        this._okButton = new JButton("OK");
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 13;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5050;
        buttonPanel.add((Component)this._okButton, gbc);
        this._okButton.addActionListener(listener);
        this._cancelButton = new JButton("Cancel");
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 13;
        gbc.fill = 0;
        gbc.insets = new Insets(5, 0, 5, 5);
        buttonPanel.add((Component)this._cancelButton, gbc);
        this._cancelButton.addActionListener(listener);
        this._summaryPane.setText(this.summaryFormat.format(new String[0]));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                NewWorkspaceSummaryDialog.this._returnCode = 1;
            }
        });
    }

    public int getResults() {
        return this._returnCode;
    }

    public void closeWindow(int returnCode) {
        this.setVisible(false);
        this._returnCode = returnCode;
    }

    public void setText(String text) {
        if (text == null) {
            text = "";
        }
        this._summaryPane.setText(text);
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        NewWorkspaceSummaryDialog dlg = new NewWorkspaceSummaryDialog(null, null, true);
        dlg.setLocation(500, 500);
        dlg.setSize(450, 350);
        dlg.setVisible(true);
    }

    private class ButtonListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            Object src = e.getSource();
            if (src == NewWorkspaceSummaryDialog.this._backButton) {
                NewWorkspaceSummaryDialog.this.closeWindow(2);
            } else if (src == NewWorkspaceSummaryDialog.this._okButton) {
                NewWorkspaceSummaryDialog.this.closeWindow(0);
            } else if (src == NewWorkspaceSummaryDialog.this._cancelButton) {
                NewWorkspaceSummaryDialog.this.closeWindow(1);
            }
        }
    }
}

