/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.rmi.admin;

import hec.io.FileLock;
import hec.io.Identifier;
import hec.io.RmiFileInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;
import mil.army.usace.hec.rmi.admin.InfoJDialog;
import mil.army.usace.hec.rmi.client.FileLockInfoJDialog;
import mil.army.usace.hec.rmi.csinterface.RmiFile;
import mil.army.usace.hec.rmi.csinterface.RmiFileManager;
import mil.army.usace.hec.rmi.server.RemoteWrapper;
import rma.swing.RmaInsets;
import rma.swing.RmaJTable;
import rma.swing.RmaJTableSorter;
import rma.swing.event.ReflectListener;
import rma.swing.list.RmaListModel;
import rma.swing.table.AbstractRmaTableModel;
import rma.swing.table.RmaTableModelInterface;
import rma.util.RMAIO;
import rma.util.RMASort;

public class FileManagerInfoJDialog
extends InfoJDialog {
    public static final int FILE_COL = 0;
    public static final int TYPE_COL = 1;
    public static final int PATH_COL = 2;
    public static final int USER_COL = 3;
    public static final int LOCKED_BY_COL = 4;
    public static final int EDIT_BY_COL = 5;
    public static final int CALLBACK_COL = 6;
    public static final int REF_CNT_COL = 7;
    public static final int MAPPED_PATH_COL = 8;
    Vector _fileList = null;
    String[] headers = new String[]{" \nFile", " \nType", " \nPath", " \nUser", "Locked\nBy", "Edit Locked\nBy", "CallBack\nCount", "Ref\nCount", " \nMapped Path"};
    RmiFileTableModel _model;
    RmaJTable fileTable;
    RmiFileManager _fm;
    JLabel totalFiles;
    JLabel startTime;
    JButton unlockButton;
    int total;
    JPopupMenu _popup;

    public FileManagerInfoJDialog(Frame parent) {
        super(parent);
        this.setTitle("File Manager Information");
        this.setSize(400, 400);
        JLabel label = new JLabel("Start Time:");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.anchor = 18;
        gbc.fill = 0;
        this.getContentPane().add((Component)label, gbc);
        this.startTime = new JLabel("Unknown");
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.anchor = 18;
        gbc.fill = 0;
        this.getContentPane().add((Component)this.startTime, gbc);
        this._model = new RmiFileTableModel(this.fileTable);
        final RmaJTableSorter sorter = new RmaJTableSorter((RmaTableModelInterface)this._model);
        this.fileTable = new RmaJTable((Component)((Object)this), this.headers){

            public String getToolTipText(MouseEvent e) {
                Point p = e.getPoint();
                int col = this.columnAtPoint(p);
                int row = this.rowAtPoint(p);
                if (col < 0 || row < 0) {
                    return null;
                }
                row = sorter.convertRowToModelRow(row);
                return FileManagerInfoJDialog.this._model.getToolTipText(row, col);
            }

            public Dimension getPreferredScrollableViewportSize() {
                Dimension d = super.getPreferredScrollableViewportSize();
                d.height = 200;
                return d;
            }

            public Color getRowForeground(int row) {
                Object obj = this.getValueAt(row, 4);
                if (obj == null || "".equals(obj)) {
                    obj = this.getValueAt(row, 5);
                    if (obj == null || "".equals(obj)) {
                        return super.getForeground();
                    }
                    return Color.blue;
                }
                return Color.red;
            }

            public Color getRowForeground(int row, int col) {
                return this.getRowForeground(row);
            }
        };
        this.fileTable.setCellSelectionEnabled(false);
        this.fileTable.setRowSelectionAllowed(true);
        sorter.addMouseListenerToHeaderInTable((JTable)this.fileTable);
        this.fileTable.setModel((TableModel)sorter);
        this.fileTable.setMlHeaderRenderer();
        this.fileTable.setHorizontalAlignment(4, 6);
        this.fileTable.setHorizontalAlignment(4, 7);
        this.fileTable.setAutoResizeMode(0);
        this.fileTable.setEnabled(false);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 3;
        gbc.weightx = 2.0;
        gbc.weighty = 4.0;
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.anchor = 18;
        gbc.fill = 1;
        this.getContentPane().add((Component)this.fileTable.getScrollPane(), gbc);
        label = new JLabel("Total Files: ");
        label.setFont(this.textFont);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.anchor = 18;
        gbc.fill = 0;
        this.getContentPane().add((Component)label, gbc);
        this.totalFiles = new JLabel("");
        label.setFont(this.textFont);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.anchor = 18;
        gbc.fill = 2;
        this.getContentPane().add((Component)this.totalFiles, gbc);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setBackground(this.backColor);
        buttonPanel.setLayout(new GridBagLayout());
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.weightx = 1.0;
        gbc.gridwidth = 3;
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.anchor = 10;
        gbc.fill = 2;
        this.getContentPane().add((Component)buttonPanel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.anchor = 10;
        gbc.fill = 0;
        buttonPanel.add((Component)this.okButton, gbc);
        JButton removeButton = new JButton("Remove");
        removeButton.setEnabled(false);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.anchor = 10;
        gbc.fill = 0;
        buttonPanel.add((Component)removeButton, gbc);
        this.unlockButton = new JButton("Unlock");
        this.unlockButton.setEnabled(false);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.anchor = 10;
        gbc.fill = 0;
        buttonPanel.add((Component)this.unlockButton, gbc);
        JButton lockInfoButton = new JButton("Lock Info");
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.anchor = 10;
        gbc.fill = 0;
        buttonPanel.add((Component)lockInfoButton, gbc);
        JButton remoteObjButton = new JButton("Remote Objects");
        gbc = new GridBagConstraints();
        gbc.gridx = 4;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.anchor = 10;
        gbc.fill = 0;
        buttonPanel.add((Component)remoteObjButton, gbc);
        remoteObjButton.addActionListener((ActionListener)new ReflectListener((Object)this, "remoteObjectAction"));
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileManagerInfoJDialog.this.setVisible(false);
                FileManagerInfoJDialog.this.dispose();
            }
        });
        this.unlockButton.addActionListener((ActionListener)new ReflectListener((Object)this, "unlockFiles"));
        removeButton.addActionListener((ActionListener)new ReflectListener((Object)this, "removeFiles"));
        this.unlockButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.isPopupTrigger() || SwingUtilities.isRightMouseButton(e)) {
                    if (FileManagerInfoJDialog.this._popup == null) {
                        FileManagerInfoJDialog.this._popup = new JPopupMenu();
                        JMenuItem mi = new JMenuItem("Unlock all files for User");
                        mi.addActionListener((ActionListener)new ReflectListener((Object)FileManagerInfoJDialog.this, "unlockFilesForUser"));
                        FileManagerInfoJDialog.this._popup.add(mi);
                    }
                    FileManagerInfoJDialog.this._popup.show(FileManagerInfoJDialog.this.unlockButton, e.getX(), e.getY());
                }
            }
        });
        lockInfoButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileManagerInfoJDialog.this.lockInfo();
            }
        });
        this.fileTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                int row = FileManagerInfoJDialog.this.fileTable.getSelectedRow();
                Object obj = FileManagerInfoJDialog.this.fileTable.getCell(row, 4);
                Object obj2 = FileManagerInfoJDialog.this.fileTable.getCell(row, 5);
                if (!(obj != null && obj.toString().length() >= 1 || obj2 != null && obj2.toString().length() >= 1)) {
                    FileManagerInfoJDialog.this.unlockButton.setEnabled(false);
                } else {
                    FileManagerInfoJDialog.this.unlockButton.setEnabled(true);
                }
            }
        });
        this.fileTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() != 2) {
                    return;
                }
                FileManagerInfoJDialog.this.lockInfo();
            }
        });
        ((JPanel)this.getContentPane()).registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        FileManagerInfoJDialog.this.reload();
                    }
                });
            }
        }, KeyStroke.getKeyStroke(116, 0, true), 1);
    }

    public void setFileManager(RmiFileManager fm) {
        this._fm = fm;
    }

    public void unlockFilesForUser() {
        String s = (String)JOptionPane.showInputDialog((Component)((Object)this), "Enter User Ids to Unlock All Files for", "Unlock Files", 3, null, null, "");
        if (s == null) {
            return;
        }
        StringTokenizer tokenizer = new StringTokenizer(s, ",");
        this.setCursor(Cursor.getPredefinedCursor(3));
        while (tokenizer.hasMoreTokens()) {
            String userId = tokenizer.nextToken().trim();
            try {
                this._fm.unlockAll(userId);
            }
            catch (RemoteException re) {
                System.out.println("unlockFilesForUser: RMI Error unlocking all files for " + userId + " Error " + re);
            }
        }
        this.setCursor(Cursor.getDefaultCursor());
        this.reload();
    }

    public void unlockFiles() {
        int[] rows = this.fileTable.getSelectedRows();
        if (rows == null || rows.length == 0) {
            return;
        }
        Identifier id = new Identifier();
        for (int i = 0; i < rows.length; ++i) {
            String fileName = (String)this.fileTable.getValueAt(rows[i], 2);
            id.setPath(fileName);
            String lockedBy = (String)this.fileTable.getValueAt(rows[i], 4);
            if (lockedBy != null && lockedBy.length() > 0) {
                System.out.println("Write Unlocking " + fileName + " locked by " + lockedBy);
                if (this.unlockFile(id, lockedBy, 5)) {
                    this.refreshFile(fileName, rows[i]);
                }
            }
            if ((lockedBy = (String)this.fileTable.getValueAt(rows[i], 5)) == null || lockedBy.length() <= 0) continue;
            System.out.println("Edit Unlocking " + fileName + " locked by " + lockedBy);
            if (!this.unlockFile(id, lockedBy, 7)) continue;
            this.refreshFile(fileName, rows[i]);
        }
    }

    private boolean unlockFile(Identifier id, String lockedBy, int unlockType) {
        FileLock fLock = new FileLock(lockedBy, unlockType);
        try {
            return this._fm.unlockFile(id, fLock);
        }
        catch (RemoteException re) {
            System.out.println("Failed to unlock file " + id.getPath() + " error " + re);
            return false;
        }
    }

    private void refreshFile(String path, int rowNum) {
        if (this._fileList == null) {
            return;
        }
        for (int i = rowNum - 1; i < this._fileList.size(); ++i) {
            RemoteWrapper wrapper;
            Remote remote;
            Object obj = this._fileList.elementAt(i);
            if (!(obj instanceof RemoteWrapper) || !((remote = (wrapper = (RemoteWrapper)obj).getRemote()) instanceof RmiFile)) continue;
            RmiFile file = (RmiFile)remote;
            try {
                if (!path.equals(file.getTruePath())) continue;
                this.fileTable.setValueAt((Object)file.getLockedBy(), rowNum, 4);
                continue;
            }
            catch (RemoteException re) {
                System.out.println("refreshFile: RemoteException getting truepath " + re);
            }
        }
    }

    private void removeFiles() {
        int[] rows = this.fileTable.getSelectedRows();
        if (rows == null || rows.length == 0) {
            return;
        }
        Identifier id = new Identifier();
        for (int i = 0; i < rows.length; ++i) {
            String lockedBy = (String)this.fileTable.getCell(rows[i], 4);
            if (lockedBy == null || lockedBy.trim().equals("")) continue;
            String fileName = (String)this.fileTable.getCell(rows[i], 2);
            System.out.println("Removing " + fileName);
            id.setPath(fileName);
            FileLock fLock = new FileLock("*", 2);
            try {
                this._fm.unlockFile(id, fLock);
                continue;
            }
            catch (RemoteException re) {
                System.out.println("Failed to remove file " + fileName + " error " + re);
            }
        }
    }

    public void setStartTime(String stime) {
        this.startTime.setText(stime);
    }

    public void setFileList(Vector list) {
        this.fileTable.clearColors();
        final Vector table = new Vector();
        this._fileList = list;
        this.total = 0;
        for (int i = 0; i < list.size(); ++i) {
            Vector<Object> row = new Vector<Object>(5);
            Object obj = list.elementAt(i);
            if (obj instanceof RemoteWrapper) {
                RemoteWrapper wrapper = (RemoteWrapper)obj;
                Remote remote = wrapper.getRemote();
                if (remote instanceof RmiFile) {
                    RmiFile file = (RmiFile)remote;
                    try {
                        row.addElement(file.getFileName());
                        row.addElement(file.getTruePath());
                        row.addElement(file.getUser());
                        row.addElement(file.getLockedBy());
                        row.addElement("");
                        ++this.total;
                    }
                    catch (RemoteException re) {
                        System.out.println("Error getting file info " + re);
                    }
                } else {
                    row.addElement(wrapper);
                    row.addElement("");
                }
            } else {
                row.addElement(obj);
                row.addElement("");
            }
            table.addElement(row);
        }
        RMASort.multipleColumnSort((int[])new int[]{0}, table, (boolean)true);
        int size = table.size();
        for (int i = 0; i < size; ++i) {
            String locker = ((Vector)table.get(i)).get(3).toString();
            if (locker != null && locker.length() <= 0) continue;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                FileManagerInfoJDialog.this.fileTable.deleteCells();
                FileManagerInfoJDialog.this.fileTable.setCells(table);
                FileManagerInfoJDialog.this.totalFiles.setText("" + FileManagerInfoJDialog.this.total);
            }
        });
    }

    public void setFileList(Hashtable hTable) {
        this.fileTable.clearColors();
        if (hTable == null) {
            return;
        }
        final Vector<RmiFileInfo> table = new Vector<RmiFileInfo>();
        this._fileList = null;
        this.total = 0;
        Enumeration keys = hTable.keys();
        while (keys.hasMoreElements()) {
            RemoteWrapper wrapper;
            Remote remote;
            String path = (String)keys.nextElement();
            Object obj = hTable.get(path);
            if (!(obj instanceof RemoteWrapper) || !((remote = (wrapper = (RemoteWrapper)obj).getRemote()) instanceof RmiFile)) continue;
            RmiFile file = (RmiFile)remote;
            try {
                RmiFileInfo fileInfo = file.getFileInfo();
                if (fileInfo != null) {
                    fileInfo.path = path;
                    table.add(fileInfo);
                }
                ++this.total;
            }
            catch (RemoteException re) {
                System.out.println("Error getting file info " + re);
            }
        }
        Collections.sort(table);
        int size = table.size();
        for (int i = 0; i < size; ++i) {
            String locker = ((RmiFileInfo)table.get((int)i)).lockedBy.toString();
            if (locker != null && locker.length() <= 0) continue;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                FileManagerInfoJDialog.this._model.setFileInfoVector(table);
                FileManagerInfoJDialog.this.totalFiles.setText("" + FileManagerInfoJDialog.this.total);
            }
        });
    }

    public void lockInfo() {
        int[] rows = this.fileTable.getSelectedRows();
        if (rows == null || rows.length == 0) {
            return;
        }
        Identifier id = new Identifier();
        for (int i = 0; i < rows.length; ++i) {
            String fileName = (String)this.fileTable.getCell(rows[i], 2);
            id.setPath(fileName);
            try {
                Vector v = this._fm.getLockers(id);
                FileLockInfoJDialog dialog = new FileLockInfoJDialog((Dialog)((Object)this));
                dialog.setFileManager(this._fm);
                dialog.fillForm(id, v);
                dialog.pack();
                dialog.setVisible(true);
                continue;
            }
            catch (RemoteException re) {
                System.out.println("Failed to remove file " + fileName + " error " + re);
            }
        }
    }

    public void reload() {
        if (this._fm == null) {
            return;
        }
        try {
            Hashtable h = this._fm.getFileWrappersTable();
            this.setFileList(h);
        }
        catch (RemoteException re) {
            System.out.println("reload:RMI Error with fileManager " + re);
        }
    }

    public void remoteObjectAction() {
        Vector objs = null;
        try {
            objs = this._fm.getRemoteObjects();
        }
        catch (RemoteException e) {
            System.out.println("remoteObjectAction:RemoteException on getRemoteObjects() " + e);
        }
        int size = objs != null ? objs.size() : 0;
        JPanel panel = new JPanel(new GridBagLayout());
        JLabel label = new JLabel("FileManager has " + size + " remote objects");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        panel.add((Component)label, gbc);
        JList list = new JList(new RmaListModel(false, (Collection)objs));
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = RmaInsets.INSETS5505;
        panel.add((Component)new JScrollPane(list), gbc);
        JOptionPane.showMessageDialog((Component)((Object)this), panel, "Remote Object Count", 1);
    }

    public class RmiFileTableModel
    extends AbstractRmaTableModel {
        RmaJTable _table;
        Vector _fileInfo;

        public RmiFileTableModel(RmaJTable table) {
            this._table = table;
        }

        public void setFileInfoVector(Vector v) {
            this._fileInfo = v;
            super.fireTableDataChanged();
        }

        public Object getValueAt(int row, int col) {
            if (this._fileInfo != null) {
                if (row < 0 || row >= this._fileInfo.size()) {
                    return "";
                }
                RmiFileInfo fileInfo = (RmiFileInfo)this._fileInfo.get(row);
                switch (col) {
                    case 0: {
                        return fileInfo.fileName;
                    }
                    case 1: {
                        return RMAIO.getFileExtension((String)fileInfo.fileName);
                    }
                    case 2: {
                        return fileInfo.truePath;
                    }
                    case 3: {
                        return fileInfo.user;
                    }
                    case 4: {
                        return fileInfo.lockedBy;
                    }
                    case 5: {
                        return fileInfo.editLockedBy;
                    }
                    case 6: {
                        return new Integer(fileInfo.callbackCnt);
                    }
                    case 7: {
                        return new Integer(fileInfo.refCount);
                    }
                    case 8: {
                        return fileInfo.path;
                    }
                }
            }
            return null;
        }

        public int getColumnCount() {
            return FileManagerInfoJDialog.this.headers.length;
        }

        public int getRowCount() {
            int rowCnt = 0;
            if (this._fileInfo != null) {
                rowCnt = this._fileInfo.size();
            }
            return rowCnt;
        }

        public String getToolTipText(int row, int col) {
            RmiFileInfo info;
            if ((col == 6 || col == 7) && (info = (RmiFileInfo)this._fileInfo.get(row)) != null) {
                StringBuffer tip = new StringBuffer("<html>");
                Vector v = col == 6 ? info.callbacks : info.referenceUsers;
                int size = v.size();
                if (size == 0) {
                    return null;
                }
                for (int i = 0; i < size; ++i) {
                    tip.append(v.get(i));
                    if (i == size - 1) continue;
                    tip.append("<BR>");
                }
                tip.append("</html>");
                return tip.toString();
            }
            return this.getValueAt(row, col).toString();
        }

        public String getColumnName(int col) {
            return FileManagerInfoJDialog.this.headers[col];
        }
    }
}

