/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.rmi.admin;

import hec.server.LoginHistory;
import hec.server.UnknownUserItem;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;
import mil.army.usace.hec.rmi.admin.InfoJDialog;
import mil.army.usace.hec.rmi.csinterface.ClientServerUtil;
import mil.army.usace.hec.rmi.csinterface.Naming;
import mil.army.usace.hec.rmi.csinterface.RmiLogin;
import mil.army.usace.hec.rmi.model.UserLoginStatus;
import rma.swing.RmaInsets;
import rma.swing.RmaJDialog;
import rma.swing.RmaJTable;
import rma.swing.RmaJTableSorter;
import rma.swing.event.ReflectMultiListener;
import rma.swing.table.RmaTableModelInterface;

public class LoginServerInfoJDialog
extends InfoJDialog {
    private RmaJTable userTable;
    private RmiLogin _rl;
    private JLabel totalUsers;
    private JLabel unknownUsers;
    private JLabel startTime;
    private JMenuItem logoutMenu;
    private JMenuItem statusMenu;
    private JMenuItem reloadMenu;
    private JMenuItem refreshMenu;
    private JMenuItem historyMenu;
    private JMenuItem invalidLoginMenu;
    private JMenuItem loginListenerUrlsMenu;
    private int _total;
    private ReflectMultiListener _listener;
    List _unknownUserList;
    private HistoryDialog _historyDialog;
    private UnknownLoginsDialog _unknownLoginInfoDialog;

    public LoginServerInfoJDialog(Frame parent) {
        super(parent);
        this.setTitle("Login Server Information");
        this._listener = new ReflectMultiListener();
        JLabel label = new JLabel("Start Time:");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.anchor = 18;
        gbc.fill = 0;
        this.getContentPane().add((Component)label, gbc);
        this.startTime = new JLabel("Unknown");
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.anchor = 18;
        gbc.fill = 0;
        this.getContentPane().add((Component)this.startTime, gbc);
        Object[] headers = new String[]{"UserId", "User Name", "Login", "Application", "Login Time", "URL", "Failed Login Attempts"};
        this.userTable = new RmaJTable((Component)((Object)this), headers){

            public Dimension getPreferredScrollableViewportSize() {
                Dimension d = super.getPreferredScrollableViewportSize();
                d.height = 200;
                return d;
            }
        };
        RmaJTableSorter sorter = new RmaJTableSorter((RmaTableModelInterface)this.userTable.getModel());
        sorter.addMouseListenerToHeaderInTable((JTable)this.userTable);
        this.userTable.setModel((TableModel)sorter);
        this.userTable.setEnabled(false);
        this.userTable.setCellSelectionEnabled(false);
        this.userTable.setRowSelectionAllowed(true);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 4;
        gbc.weightx = 2.0;
        gbc.weighty = 2.0;
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.anchor = 18;
        gbc.fill = 1;
        this.getContentPane().add((Component)this.userTable.getScrollPane(), gbc);
        label = new JLabel("Total Users: ");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.weightx = 0.0;
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.anchor = 18;
        gbc.fill = 0;
        this.getContentPane().add((Component)label, gbc);
        this.totalUsers = new JLabel("");
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.weightx = 0.0;
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.anchor = 18;
        gbc.fill = 0;
        this.getContentPane().add((Component)this.totalUsers, gbc);
        label = new JLabel("Unknown User login Attempts: ");
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 2;
        gbc.weightx = 0.0;
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.anchor = 18;
        gbc.fill = 0;
        this.getContentPane().add((Component)label, gbc);
        label.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    LoginServerInfoJDialog.this.displayUnknownLoginInfo();
                }
            }
        });
        this.unknownUsers = new JLabel("");
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = 2;
        gbc.weightx = 0.1;
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.anchor = 18;
        gbc.fill = 0;
        this.getContentPane().add((Component)this.unknownUsers, gbc);
        this.buildMenu();
        ((JPanel)this.getContentPane()).registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        LoginServerInfoJDialog.this.fillForm();
                    }
                });
            }
        }, KeyStroke.getKeyStroke(116, 0, true), 1);
        this.userTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                boolean enabled = LoginServerInfoJDialog.this.userTable.getSelectedRow() >= 0;
                LoginServerInfoJDialog.this.logoutMenu.setEnabled(enabled);
                LoginServerInfoJDialog.this.statusMenu.setEnabled(enabled);
            }
        });
    }

    protected void buildMenu() {
        JMenuBar mbar = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        fileMenu.setMnemonic('F');
        mbar.add(fileMenu);
        this.reloadMenu = new JMenuItem("Reload");
        this.reloadMenu.setToolTipText("Reload user information from file");
        this.reloadMenu.setMnemonic('r');
        fileMenu.add(this.reloadMenu);
        JMenuItem closeMenuItem = new JMenuItem("Close", 67);
        fileMenu.add(closeMenuItem);
        JMenu viewMenu = new JMenu("View");
        viewMenu.setMnemonic('V');
        mbar.add(viewMenu);
        this.historyMenu = new JMenuItem("History");
        this.historyMenu.setToolTipText("Login History");
        this.historyMenu.setMnemonic('H');
        viewMenu.add(this.historyMenu);
        this.invalidLoginMenu = new JMenuItem("Invalid Login Attempts");
        this.invalidLoginMenu.setToolTipText("Invalid Login Attempts");
        this.invalidLoginMenu.setMnemonic('I');
        viewMenu.add(this.invalidLoginMenu);
        this.loginListenerUrlsMenu = new JMenuItem("Login Listeners");
        this.loginListenerUrlsMenu.setToolTipText("Invalid Login Attempts");
        this.loginListenerUrlsMenu.setMnemonic('L');
        viewMenu.add(this.loginListenerUrlsMenu);
        viewMenu.addSeparator();
        this.refreshMenu = new JMenuItem("Refresh");
        this.refreshMenu.setToolTipText("Refresh Information");
        this.refreshMenu.setMnemonic('R');
        viewMenu.add(this.refreshMenu);
        JMenu userMenu = new JMenu("User");
        userMenu.setMnemonic('U');
        mbar.add(userMenu);
        this.statusMenu = new JMenuItem("Status");
        this.statusMenu.setToolTipText("Login Status for Selected User");
        this.statusMenu.setMnemonic('s');
        this.statusMenu.setEnabled(false);
        userMenu.add(this.statusMenu);
        this.logoutMenu = new JMenuItem("Clear");
        this.logoutMenu.setToolTipText("Clear Selected User");
        this.logoutMenu.setMnemonic('c');
        this.logoutMenu.setEnabled(false);
        userMenu.add(this.logoutMenu);
        closeMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoginServerInfoJDialog.this.setVisible(false);
                LoginServerInfoJDialog.this.dispose();
            }
        });
        this.logoutMenu.addActionListener((ActionListener)this._listener.add((Object)this, (Object)this.logoutMenu, "logoutUsers"));
        this.statusMenu.addActionListener((ActionListener)this._listener.add((Object)this, (Object)this.statusMenu, "userStatus"));
        this.reloadMenu.addActionListener((ActionListener)this._listener.add((Object)this, (Object)this.reloadMenu, "reload"));
        this.historyMenu.addActionListener((ActionListener)this._listener.add((Object)this, (Object)this.historyMenu, "history"));
        this.invalidLoginMenu.addActionListener((ActionListener)this._listener.add((Object)this, (Object)this.invalidLoginMenu, "displayUnknownLoginInfo"));
        this.loginListenerUrlsMenu.addActionListener((ActionListener)this._listener.add((Object)this, (Object)this.loginListenerUrlsMenu, "displayLoginListeners"));
        this.refreshMenu.addActionListener((ActionListener)this._listener.add((Object)this, (Object)this.refreshMenu, "fillForm"));
        this.setJMenuBar(mbar);
    }

    public void setLoginServer(RmiLogin rl) {
        this._rl = rl;
    }

    private void logoutUsers() {
        int[] rows = this.userTable.getSelectedRows();
        if (rows == null || rows.length == 0) {
            return;
        }
        for (int i = 0; i < rows.length; ++i) {
            String user = (String)this.userTable.getCell(rows[i], 0);
            if (user == null || user.trim().equals("")) continue;
            System.out.println("Logging out " + user);
            try {
                this._rl.clearUser(user, InetAddress.getLocalHost().getHostName());
                continue;
            }
            catch (UnknownHostException | RemoteException re) {
                System.out.println("Failed to logout user " + user + " error " + re);
            }
        }
        this.fillForm();
    }

    private void userStatus() {
        int[] rows = this.userTable.getSelectedRows();
        if (rows == null || rows.length == 0) {
            return;
        }
        boolean loggedIn = false;
        for (int i = 0; i < rows.length; ++i) {
            String user = (String)this.userTable.getCell(rows[i], 0);
            if (user == null || user.trim().equals("")) continue;
            System.out.println("Login Status for " + user);
            try {
                String msg;
                this.setCursor(Cursor.getPredefinedCursor(3));
                loggedIn = this._rl.isLoggedIn(user);
                if (loggedIn) {
                    msg = user + " is currently logged in";
                    this.userTable.setRowForeground(rows[i], Color.black);
                } else {
                    msg = user + " is no longer logged in";
                    this.userTable.setRowForeground(rows[i], Color.red);
                }
                this.setCursor(Cursor.getDefaultCursor());
                JOptionPane.showMessageDialog((Component)((Object)this), msg, "Login Status", 1);
                continue;
            }
            catch (RemoteException re) {
                this.setCursor(Cursor.getDefaultCursor());
                System.out.println("Failed to logout user " + user + " error " + re);
            }
        }
    }

    public void setUnknownUserCnt(int cnt) {
        this.unknownUsers.setText("" + cnt);
    }

    public void setUnknownUserList(List unknownUserList) {
        this._unknownUserList = unknownUserList;
    }

    public void setStartTime(String stime) {
        this.startTime.setText(stime);
    }

    public void fillForm() {
        this.userTable.deleteCells();
        this.userTable.clearColors();
        if (this._rl == null) {
            return;
        }
        List<UserLoginStatus> userStatusList = null;
        try {
            userStatusList = this._rl.getLoggedInUsersInfo();
        }
        catch (RemoteException re) {
            System.out.println("fillForm: RMI Error get User status list from loginServer " + re);
            return;
        }
        int size = userStatusList.size();
        int cnt = 0;
        int cols = this.userTable.getColumnCount();
        for (int i = 0; i < size; ++i) {
            UserLoginStatus obj = userStatusList.get(i);
            if (!(obj instanceof UserLoginStatus)) continue;
            UserLoginStatus uls = obj;
            Vector<Object> row = new Vector<Object>(cols);
            row.add(uls.userId);
            row.add(uls.userName);
            row.add(uls.getLoginName());
            row.add(uls.appName);
            row.add(new Date(uls.loginTime));
            row.add(uls.getUrl());
            row.add("" + uls.loginFailureCnt);
            this.userTable.appendRow(row);
            ++cnt;
        }
        this.totalUsers.setText("" + cnt);
    }

    public void reload() {
        if (this._rl == null) {
            return;
        }
        try {
            this._rl.reload();
        }
        catch (RemoteException re) {
            System.out.println("reload: rmi error communicating with login server " + re);
        }
    }

    void history() {
        if (this._historyDialog == null) {
            this._historyDialog = new HistoryDialog();
        }
        this._historyDialog.fillForm();
        this._historyDialog.setVisible(true);
    }

    void displayUnknownLoginInfo() {
        if (this._unknownLoginInfoDialog == null) {
            this._unknownLoginInfoDialog = new UnknownLoginsDialog();
        }
        this._unknownLoginInfoDialog.fillForm();
        this._unknownLoginInfoDialog.setVisible(true);
    }

    void displayLoginListeners() {
        Set<String> listeners = ClientServerUtil.getLoginListenerUrls();
        RmaJTable table = new RmaJTable((Component)((Object)this), new String[]{"Server", "Status"}){

            public Dimension getPreferredScrollableViewportSize() {
                Dimension d = super.getPreferredScrollableViewportSize();
                d.height = this.getRowCount() * this.getRowHeight();
                return d;
            }
        };
        table.deleteCells();
        for (String url : listeners) {
            Vector<String> row = new Vector<String>(2);
            row.add(url);
            try {
                Naming.lookup(url);
                row.add("OK");
            }
            catch (MalformedURLException | NotBoundException | RemoteException re) {
                System.out.println("displayLoginListeners: RMI error contacting " + url + " Error:" + re);
                row.add("Error");
                table.setCellForeground(table.getRowCount() + 1, 1, Color.red);
            }
            table.appendRow(row);
        }
        table.setEditable(false);
        table.setColumnWidths(new int[]{100, 25});
        table.setHorizontalAlignment(0, 1);
        table.setAddRemoveEnabled(false);
        JOptionPane.showMessageDialog((Component)((Object)this), table.getScrollPane(), "Login Listener Information", -1);
    }

    class HistoryDialog
    extends RmaJDialog {
        RmaJTable historyTable;
        JLabel timeLabel;

        public HistoryDialog() {
            super((Dialog)((Object)LoginServerInfoJDialog.this), "Login Server History", false);
            this.buildControls();
        }

        void buildControls() {
            this.getContentPane().setLayout(new GridBagLayout());
            this.timeLabel = new JLabel("Users that have logged into the system since " + LoginServerInfoJDialog.this.startTime.getText());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.gridwidth = 1;
            gbc.weightx = 1.0;
            gbc.anchor = 17;
            gbc.fill = 1;
            gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
            this.getContentPane().add((Component)this.timeLabel, gbc);
            this.historyTable = new RmaJTable((Component)((Object)this), new String[]{" \nUser Id", " \nUser Name", " \nApplication", " \nLog in", " \nLog out", "Forced\nLogoff"}){

                public Dimension getPreferredScrollableViewportSize() {
                    Dimension d = super.getPreferredScrollableViewportSize();
                    d.height = 100;
                    d.width += 50;
                    return d;
                }
            };
            RmaJTableSorter sorter = new RmaJTableSorter((RmaTableModelInterface)this.historyTable.getModel());
            this.historyTable.setModel((TableModel)sorter);
            sorter.addMouseListenerToHeaderInTable((JTable)this.historyTable);
            gbc = new GridBagConstraints();
            this.historyTable.setEditable(false);
            this.historyTable.setCheckBoxCellEditor(5);
            this.historyTable.setColumnWidths(new int[]{65, 89, 81, 106, 105, 54});
            this.historyTable.setMlHeaderRenderer();
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.gridwidth = 1;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.anchor = 17;
            gbc.fill = 1;
            gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
            this.getContentPane().add((Component)this.historyTable.getScrollPane(), gbc);
            JButton button = new JButton("Close");
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 2;
            gbc.gridwidth = 1;
            gbc.weightx = 1.0;
            gbc.anchor = 13;
            gbc.fill = 0;
            gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
            this.getContentPane().add((Component)button, gbc);
            button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    HistoryDialog.this.setVisible(false);
                    HistoryDialog.this.dispose();
                }
            });
            ((JPanel)this.getContentPane()).registerKeyboardAction(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            HistoryDialog.this.fillForm();
                        }
                    });
                }
            }, KeyStroke.getKeyStroke(116, 0, true), 1);
            this.pack();
            this.setLocation();
        }

        void fillForm() {
            this.historyTable.deleteCells();
            if (LoginServerInfoJDialog.this._rl == null) {
                return;
            }
            try {
                Map<String, LoginHistory> history = LoginServerInfoJDialog.this._rl.getLoginHistory();
                if (history == null) {
                    return;
                }
                Date date = new Date();
                for (LoginHistory lh : history.values()) {
                    if (lh == null) {
                        return;
                    }
                    Vector<Object> row = new Vector<Object>(6);
                    row.add(lh.userId);
                    row.add(lh.userName);
                    row.add(lh.application);
                    date.setTime(lh.loginTime);
                    row.add(date.toString().substring(4));
                    if (lh.logoutTime != 0L) {
                        date.setTime(lh.logoutTime);
                        row.add(date.toString().substring(4));
                        row.add("" + lh.forcedLogout);
                    } else {
                        row.add("Currently logged in");
                        row.add("");
                    }
                    this.historyTable.appendRow(row);
                }
            }
            catch (Exception e) {
                System.out.println("Error getting login history from loginServer " + e);
            }
        }
    }

    class UnknownLoginsDialog
    extends RmaJDialog {
        private RmaJTable loginTable;
        private JLabel timeLabel;

        public UnknownLoginsDialog() {
            super((Dialog)((Object)LoginServerInfoJDialog.this), "Unknown Logins Information", false);
            this.buildControls();
        }

        void buildControls() {
            this.getContentPane().setLayout(new GridBagLayout());
            this.timeLabel = new JLabel("Unknown Login attempts since " + LoginServerInfoJDialog.this.startTime.getText());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.gridwidth = 1;
            gbc.weightx = 1.0;
            gbc.anchor = 17;
            gbc.fill = 1;
            gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
            this.getContentPane().add((Component)this.timeLabel, gbc);
            this.loginTable = new RmaJTable((Component)((Object)this), new String[]{"Attempt", "Login Name", "Application", "Time", "Host"}){

                public Dimension getPreferredScrollableViewportSize() {
                    Dimension d = super.getPreferredScrollableViewportSize();
                    d.height = 100;
                    d.width += 50;
                    return d;
                }
            };
            RmaJTableSorter sorter = new RmaJTableSorter((RmaTableModelInterface)this.loginTable.getModel());
            this.loginTable.setModel((TableModel)sorter);
            sorter.addMouseListenerToHeaderInTable((JTable)this.loginTable);
            gbc = new GridBagConstraints();
            this.loginTable.setEditable(false);
            this.loginTable.setColumnWidths(new int[]{54, 105, 127, 214});
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.gridwidth = 1;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.anchor = 17;
            gbc.fill = 1;
            gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
            this.getContentPane().add((Component)this.loginTable.getScrollPane(), gbc);
            JButton button = new JButton("Close");
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 2;
            gbc.gridwidth = 1;
            gbc.weightx = 1.0;
            gbc.anchor = 13;
            gbc.fill = 0;
            gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
            this.getContentPane().add((Component)button, gbc);
            button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    UnknownLoginsDialog.this.setVisible(false);
                    UnknownLoginsDialog.this.dispose();
                }
            });
            ((JPanel)this.getContentPane()).registerKeyboardAction(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            UnknownLoginsDialog.this.fillForm();
                        }
                    });
                }
            }, KeyStroke.getKeyStroke(116, 0, true), 1);
            this.pack();
            this.setLocation();
        }

        void fillForm() {
            this.loginTable.deleteCells();
            if (LoginServerInfoJDialog.this._rl == null) {
                return;
            }
            try {
                List<UnknownUserItem> history = LoginServerInfoJDialog.this._rl.getUnknownLoginHistory();
                if (history == null) {
                    return;
                }
                Iterator<UnknownUserItem> i = history.iterator();
                Date date = new Date();
                int cnt = 0;
                while (i.hasNext()) {
                    ++cnt;
                    UnknownUserItem uui = i.next();
                    if (uui == null) {
                        return;
                    }
                    Vector<Object> row = new Vector<Object>(4);
                    row.add(new Integer(cnt));
                    row.add(uui.getUserName());
                    row.add(uui.getApp());
                    date.setTime(uui.getLoginTime());
                    row.add(date.toString().substring(4));
                    row.add(uui.getHost());
                    this.loginTable.appendRow(row);
                }
            }
            catch (Exception e) {
                System.out.println("Error getting unknown login history from loginServer " + e);
            }
        }
    }
}

