/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.rmi.admin;

import hec.io.StatusObject;
import java.awt.Frame;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.Date;
import java.util.List;
import mil.army.usace.hec.rmi.admin.LoginServerInfoJDialog;
import mil.army.usace.hec.rmi.csinterface.RmiLogin;
import mil.army.usace.hec.rmi.model.UserLoginStatus;
import rma.util.RMAIO;

public class LoginServerStatus
implements StatusObject,
Serializable {
    private static final long serialVersionUID = -3286631696940326776L;
    String[] _userNames;
    RmiLogin _rl;
    String _startTime;
    String _lastLoginTime;
    int _unknownUserCnt = 0;
    int _totalLogins = 0;
    String _owner;
    List _unknownUserList;
    int _statusType;

    public String getClassName() {
        return "hec.admin.LoginServerInfoJDialog";
    }

    public void displayStatus(Frame parent) {
        LoginServerInfoJDialog lsd = new LoginServerInfoJDialog(parent);
        lsd.setLoginServer(this._rl);
        lsd.fillForm();
        lsd.setStartTime(this._startTime);
        lsd.setUnknownUserCnt(this._unknownUserCnt);
        lsd.setUnknownUserList(this._unknownUserList);
        lsd.setVisible(true);
    }

    public void setOwner(String owner) {
        this._owner = owner;
    }

    public void setUserList(String[] users) {
        this._userNames = users;
    }

    public void setLoginServer(RmiLogin rl) {
        this._rl = rl;
    }

    public void setStartTime(String stime) {
        this._startTime = stime;
    }

    public void setLastLoginTime(String dt) {
        this._lastLoginTime = dt;
    }

    public void setTotalLogins(int cnt) {
        this._totalLogins = cnt;
    }

    public void setStatusType(int type) {
        this._statusType = type;
    }

    public String toString() {
        List<UserLoginStatus> userStatusList = null;
        StringBuffer buf = new StringBuffer();
        if (this._statusType == 0) {
            buf.append("Login Server Information");
            buf.append("\n Started=");
            buf.append(this._startTime);
            buf.append("\n Owner=");
            buf.append(this._owner);
            buf.append("\n Total Logins=");
            buf.append(this._totalLogins);
            buf.append("\n Current Users=");
            buf.append(this._userNames.length);
            buf.append("\n Last Login=");
            buf.append(this._lastLoginTime);
            buf.append("\n Unknown Login Failure Attempts=");
            buf.append(this._unknownUserCnt);
            try {
                userStatusList = this._rl.getLoggedInUsersInfo();
                Date dt = new Date();
                for (int i = 0; i < userStatusList.size(); ++i) {
                    UserLoginStatus obj = userStatusList.get(i);
                    if (!(obj instanceof UserLoginStatus)) continue;
                    UserLoginStatus uls = obj;
                    if (i > 0) {
                        buf.append("\n");
                    }
                    buf.append("\n============= ");
                    buf.append(uls.userName);
                    buf.append(" =============");
                    buf.append("\n UserID=");
                    buf.append(uls.userId);
                    buf.append("\n User Name=");
                    buf.append(uls.userName);
                    buf.append("\n Login Name=");
                    buf.append(uls.getLoginName());
                    buf.append("\n Product=");
                    buf.append(uls.appName);
                    buf.append("\n Login Time=");
                    dt.setTime(uls.loginTime);
                    buf.append(dt.toString());
                    buf.append("\n Login Failures=");
                    buf.append("" + uls.loginFailureCnt);
                    buf.append("\n URL=");
                    buf.append(uls.getUrl());
                }
            }
            catch (RemoteException re) {
                System.out.println("toString: RMI Error get User status list from loginServer " + re);
            }
        } else {
            try {
                userStatusList = this._rl.getLoggedInUsersInfo();
                Date dt = new Date();
                buf.append(RMAIO.rightJustify2((int)20, (String)"User Name"));
                buf.append(RMAIO.rightJustify2((int)30, (String)"User ID"));
                buf.append(RMAIO.rightJustify2((int)10, (String)"Login"));
                buf.append(RMAIO.rightJustify2((int)12, (String)"Product"));
                buf.append(RMAIO.rightJustify2((int)25, (String)"Login Time"));
                buf.append("URL\n");
                buf.append("=================================================================================================================\n");
                for (int i = 0; i < userStatusList.size(); ++i) {
                    UserLoginStatus obj = userStatusList.get(i);
                    if (!(obj instanceof UserLoginStatus)) continue;
                    UserLoginStatus uls = obj;
                    buf.append(RMAIO.rightJustify2((int)20, (String)uls.userName));
                    buf.append(RMAIO.rightJustify2((int)30, (String)uls.userId));
                    buf.append(RMAIO.rightJustify2((int)10, (String)uls.getLoginName()));
                    buf.append(RMAIO.rightJustify2((int)12, (String)uls.appName));
                    dt.setTime(uls.loginTime);
                    buf.append(RMAIO.rightJustify2((int)25, (String)dt.toString().substring(4)));
                    buf.append(uls.getUrl());
                }
            }
            catch (RemoteException re) {
                System.out.println("toString: RMI Error get User status list from loginServer " + re);
            }
        }
        return buf.toString();
    }

    public void setUnknownUserCnt(int userCnt) {
        this._unknownUserCnt = userCnt;
    }

    public void setUnknownUserList(List unknownUserList) {
        this._unknownUserList = unknownUserList;
    }
}

