/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.rmi.client;

import com.google.common.flogger.FluentLogger;
import com.google.common.flogger.StackSize;
import hec.io.DSSIdentifier;
import hec.io.DssManagerBridge;
import hec.io.TimeSeriesContainer;
import java.io.FileNotFoundException;
import java.rmi.RemoteException;
import mil.army.usace.hec.rmi.csinterface.BaseDSSManager;

public class ClientDssManagerBridge
implements DssManagerBridge {
    private static final FluentLogger LOGGER = FluentLogger.forEnclosingClass();
    private final BaseDSSManager _dssManager;

    public ClientDssManagerBridge(BaseDSSManager dssManager) {
        if (dssManager == null) {
            StackSize stackSize = StackSize.NONE;
            if (((FluentLogger.Api)LOGGER.atFine()).isEnabled()) {
                stackSize = StackSize.MEDIUM;
            }
            ((FluentLogger.Api)((FluentLogger.Api)LOGGER.atWarning()).withStackTrace(stackSize)).log("Passed a null DSSManager into: %s", this.getClass());
        }
        this._dssManager = dssManager;
    }

    public int recordType(String file, String pathname) {
        int retVal = 0;
        if (this._dssManager != null) {
            try {
                retVal = this._dssManager.recordType(file, pathname);
            }
            catch (RemoteException e) {
                ((FluentLogger.Api)((FluentLogger.Api)LOGGER.atWarning()).withCause((Throwable)e)).log("Unable to reach remote file: " + file + " and path: " + pathname);
            }
        }
        return retVal;
    }

    public TimeSeriesContainer readTS(DSSIdentifier dssId, boolean b) {
        TimeSeriesContainer tsContainer = null;
        if (this._dssManager != null) {
            try {
                tsContainer = this._dssManager.readTS(dssId, b);
            }
            catch (FileNotFoundException | RemoteException e) {
                ((FluentLogger.Api)((FluentLogger.Api)LOGGER.atWarning()).withCause((Throwable)e)).log("Unable to reach remote DSS identifier: " + dssId);
            }
        }
        return tsContainer;
    }

    public int writeTS(TimeSeriesContainer timeSeriesContainer, int regularStoreMethod, int irregularStoreMethod) {
        int retVal = 0;
        if (this._dssManager != null) {
            try {
                retVal = this._dssManager.writeTS(timeSeriesContainer, regularStoreMethod, irregularStoreMethod);
            }
            catch (RemoteException e) {
                ((FluentLogger.Api)((FluentLogger.Api)LOGGER.atWarning()).withCause((Throwable)e)).log("Unable to write to remote DSS: " + timeSeriesContainer);
            }
        }
        return retVal;
    }
}

