/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.rmi.client;

import hec.io.FileLock;
import hec.io.Identifier;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.util.Date;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import mil.army.usace.hec.rmi.csinterface.RmiFileManager;
import rma.swing.RmaJDialog;
import rma.swing.RmaJTable;

public class FileLockInfoJDialog
extends RmaJDialog {
    private Vector _fileList = null;
    private Identifier _id = null;
    private JLabel fileName;
    private JLabel userId;
    private RmaJTable fileTable;
    private RmiFileManager _fileManager;
    private JButton unlockButton;
    private JButton okButton;
    private boolean _wasUnlocked;

    public FileLockInfoJDialog(Frame parent) {
        super(parent);
        this.buildControls();
    }

    public FileLockInfoJDialog(Dialog parent) {
        super(parent);
        this.buildControls();
    }

    private void buildControls() {
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("File Lock Information");
        this.setSize(200, 200);
        this.setLocation();
        JLabel label = new JLabel("File Name:");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.anchor = 18;
        gbc.fill = 0;
        this.getContentPane().add((Component)label, gbc);
        this.fileName = new JLabel("");
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.anchor = 18;
        gbc.fill = 0;
        this.getContentPane().add((Component)this.fileName, gbc);
        label = new JLabel("UserId:");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.anchor = 18;
        gbc.fill = 0;
        this.getContentPane().add((Component)label, gbc);
        this.userId = new JLabel("");
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.anchor = 18;
        gbc.fill = 0;
        this.getContentPane().add((Component)this.userId, gbc);
        Object[] headers = new String[]{"UserId", "Type", "Ref Cnt", "Date"};
        this.fileTable = new RmaJTable((Component)((Object)this), headers){

            public Dimension getPreferredScrollableViewportSize() {
                Dimension d = super.getPreferredScrollableViewportSize();
                d.height = 100;
                return d;
            }
        };
        this.fileTable.setColumnWidths(new int[]{113, 76, 59, 202});
        this.fileTable.setDoubleCellEditor(2);
        this.fileTable.setEnabled(false);
        this.fileTable.setCellSelectionEnabled(false);
        this.fileTable.setRowSelectionAllowed(true);
        this.fileTable.getSelectionModel().setSelectionMode(0);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 2;
        gbc.weightx = 2.0;
        gbc.weighty = 4.0;
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.anchor = 18;
        gbc.fill = 1;
        this.getContentPane().add((Component)this.fileTable.getScrollPane(), gbc);
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.anchor = 14;
        gbc.fill = 0;
        this.getContentPane().add((Component)buttonPanel, gbc);
        this.okButton = new JButton("Close");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.anchor = 14;
        gbc.fill = 0;
        buttonPanel.add((Component)this.okButton, gbc);
        this.unlockButton = new JButton("Unlock");
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.anchor = 14;
        gbc.fill = 0;
        buttonPanel.add((Component)this.unlockButton, gbc);
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileLockInfoJDialog.this.setVisible(false);
            }
        });
        this.unlockButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileLockInfoJDialog.this.unlock();
            }
        });
        ((JPanel)this.getContentPane()).registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (FileLockInfoJDialog.this._fileManager == null) {
                            return;
                        }
                        try {
                            Vector v = FileLockInfoJDialog.this._fileManager.getLockers(FileLockInfoJDialog.this._id);
                            FileLockInfoJDialog.this.fillForm(FileLockInfoJDialog.this._id, v);
                        }
                        catch (RemoteException re) {
                            System.out.println("RMI Error with fileManager " + re);
                        }
                    }
                });
            }
        }, KeyStroke.getKeyStroke(116, 0, true), 1);
    }

    public void setFileManager(RmiFileManager fm) {
        this._fileManager = fm;
    }

    public void fillForm(Identifier id, Vector fileLocks) {
        this._wasUnlocked = false;
        this.fileTable.deleteCells();
        this._id = id;
        if (id != null) {
            this.fileName.setText(id.getPath());
        }
        this.unlockButton.setVisible(this._fileManager != null);
        if (fileLocks == null) {
            return;
        }
        int size = fileLocks.size();
        Date date = new Date();
        for (int i = 0; i < size; ++i) {
            Object obj = fileLocks.get(i);
            if (!(obj instanceof FileLock)) continue;
            FileLock fLock = (FileLock)obj;
            Vector<Object> row = new Vector<Object>(4);
            row.add(fLock.getUserId());
            row.add(fLock.getLockTypeString());
            row.add(new Integer(fLock.getRefCount()));
            date.setTime(fLock.getLockedTime());
            row.add(date.toString());
            this.fileTable.appendRow(row);
        }
        this.fileTable.sizeColumnsToFit(true);
    }

    public void unlock() {
        if (this._fileManager == null) {
            return;
        }
        int[] rows = this.fileTable.getSelectedRows();
        if (rows == null || rows.length == 0) {
            return;
        }
        Identifier id = new Identifier();
        for (int i = 0; i < rows.length; ++i) {
            String lockedBy = (String)this.fileTable.getCell(rows[i], 0);
            if (lockedBy == null || lockedBy.trim().equals("")) continue;
            String lockTypeString = (String)this.fileTable.getCell(rows[i], 1);
            int lockType = "Write Lock".equals(lockTypeString) ? 5 : ("Edit Lock".equals(lockTypeString) ? 7 : 1);
            FileLock fLock = new FileLock(lockedBy, lockType);
            try {
                boolean unlocked = this._fileManager.unlockFile(this._id, fLock);
                Vector v = this._fileManager.getLockers(this._id);
                this.fillForm(this._id, v);
                if (!unlocked || this.fileTable.getRowCount() != 0) continue;
                this._wasUnlocked = true;
                continue;
            }
            catch (RemoteException re) {
                System.out.println("unlock: RMI error unlocking file " + re);
            }
        }
    }

    public boolean wasUnlocked() {
        return this._wasUnlocked;
    }

    public void setUserId(String uid) {
        if (uid != null) {
            this.userId.setText(uid);
        } else {
            this.userId.setText("");
        }
    }
}

