/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.rmi.client;

import hec.gfx2d.AbstractPlotDefaults;
import hec.gfx2d.AxisLabelDrawProp;
import hec.gfx2d.AxisTicsDrawProp;
import hec.gfx2d.G2dLabelDrawProp;
import hec.gfx2d.G2dLineProperties;
import hec.gfx2d.G2dPanelProp;
import hec.gfx2d.LegendPanelProp;
import hec.gfx2d.PlotDefaults;
import hec.gfx2d.PlotDefaultsManager;
import hec.gfx2d.TitleDrawProp;
import hec.gfx2d.ViewportDrawProp;
import hec.lang.PreferencesConstants;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.util.HashMap;
import java.util.Map;
import mil.army.usace.hec.rmi.model.PreferencesManager;
import rma.util.logging.MarkingClassLogger;
import rma.util.logging.marking.PlotDefaultsLoggingMarker;

public class HecPlotDefaults
extends AbstractPlotDefaults
implements PreferencesConstants {
    private static final MarkingClassLogger PLOT_DEFAULTS_LOGGER = MarkingClassLogger.forMarkingClass(PlotDefaultsLoggingMarker.class);
    static Map HEC_PLOT_DEFAULTS = new HashMap();

    public HecPlotDefaults() {
        this.m_plotDefaultsTable = HEC_PLOT_DEFAULTS;
    }

    public BufferedWriter getBufferedWriter(Class plotCompClass) {
        String fileName = PlotDefaultsManager.getFileName((Class)plotCompClass);
        BufferedWriter writer = null;
        writer = PreferencesManager.getBufferedWriter(1, fileName);
        if (writer == null) {
            System.out.println("getBufferedWriter:Failed to get Writer for " + fileName);
            return null;
        }
        return writer;
    }

    public boolean loadPlotComponentDefaults(Class plotCompClass) {
        if (plotCompClass == null) {
            return false;
        }
        String fileName = PlotDefaultsManager.getFileName((Class)plotCompClass);
        if (fileName == null || fileName.length() == 0) {
            System.out.println("loadPlotComponentDefaults:No default properties file returned for " + plotCompClass);
            return false;
        }
        for (int loc = 3; loc > 0; --loc) {
            String locFilename = PreferencesManager.getFileName(loc, fileName);
            ((MarkingClassLogger.Api)PLOT_DEFAULTS_LOGGER.atFine()).log("attempting to read %s", (Object)locFilename);
            BufferedReader reader = PreferencesManager.getBufferedReader(loc, fileName);
            HecPlotDefaults.loadDefaults((BufferedReader)reader, (Class)plotCompClass);
        }
        return true;
    }

    public static void main(String[] args) {
        new HecPlotDefaults();
    }

    static {
        PlotDefaults oldDefaults = PlotDefaultsManager.getDefaults();
        HEC_PLOT_DEFAULTS.putAll(PROGRAM_DEFAULTS);
        HecPlotDefaults defaults = new HecPlotDefaults();
        PlotDefaultsManager.setDefaults((PlotDefaults)defaults);
        defaults.loadPlotComponentDefaults(G2dLabelDrawProp.class);
        defaults.loadPlotComponentDefaults(G2dLabelDrawProp.class);
        defaults.loadPlotComponentDefaults(AxisLabelDrawProp.class);
        defaults.loadPlotComponentDefaults(AxisTicsDrawProp.class);
        defaults.loadPlotComponentDefaults(LegendPanelProp.class);
        defaults.loadPlotComponentDefaults(G2dPanelProp.class);
        defaults.loadPlotComponentDefaults(TitleDrawProp.class);
        defaults.loadPlotComponentDefaults(ViewportDrawProp.class);
        defaults.loadPlotComponentDefaults(G2dLineProperties.class);
        HEC_PLOT_DEFAULTS.putAll(PlotDefaultsManager.getDefaults().getDefaultsTable());
        PlotDefaultsManager.setDefaults((PlotDefaults)oldDefaults);
    }
}

