/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.rmi.client;

import hec.io.Identifier;
import hec.lang.PreferencesConstants;
import hec.lang.UserId;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.Document;
import mil.army.usace.hec.rmi.client.SavePreferencesDialog;
import mil.army.usace.hec.rmi.csinterface.RmiFileManager;
import mil.army.usace.hec.rmi.model.PreferencesManager;
import rma.swing.ButtonCmdPanel;
import rma.swing.ButtonCmdPanelListener;
import rma.swing.RmaInsets;
import rma.swing.RmaJDialog;
import rma.swing.RmaJList;
import rma.swing.RmaJRadioButton;
import rma.swing.RmaJTextField;
import rma.swing.list.RmaListModel;
import rma.swing.text.FilenameDocument;
import rma.util.RMAIO;

public class PreferencesChooserDialog
extends RmaJDialog
implements PreferencesConstants {
    public static final int LOAD = 0;
    public static final int SAVE = 1;
    private static final int DELETE = 2;
    private static final int NEW = 3;
    private static final int OPEN = 4;
    private static final int SAVEAS = 5;
    private static final int RENAME = 6;
    private static final String ALL_WATERSHEDS = "All Watersheds";
    private static final String ALL_APPLICATIONS = "All Applications";
    private boolean _canceled = false;
    private Vector _filters = new Vector();
    private RmiFileManager _fileManager;
    private String _subDir = null;
    private String _defaultName = null;
    protected RmaJRadioButton _allAppsLocRB;
    protected RmaJRadioButton _thisWatershedLocRB;
    protected RmaJRadioButton _thisWatershedThisAppRB;
    protected Vector _userDefinedRadioButtons = new Vector();
    private ActionListener _radioActionListener;
    private int _nextRadioButtonPanelRow = 0;
    private JPanel _radioButtonPanel;
    protected RmaJList _filesList;
    protected JLabel _nameLabel;
    protected RmaJTextField _nameTxt;
    protected JScrollPane _filesListSP;
    protected ButtonCmdPanel cmdPanel;
    protected ButtonGroup _buttonGroup;
    protected int _mode;
    protected String _modeString = "";
    protected boolean _showFileExtensions = false;

    public PreferencesChooserDialog(Frame parent, boolean modal, int mode) {
        super(parent, modal);
        this.buildControls(mode);
    }

    public PreferencesChooserDialog(Dialog parent, boolean modal, int mode) {
        super(parent, modal);
        this.buildControls(mode);
    }

    protected void buildControls(int mode) {
        this.getContentPane().setLayout(new GridBagLayout());
        this._buttonGroup = new ButtonGroup();
        this._mode = mode;
        this._radioButtonPanel = new JPanel(new GridBagLayout());
        this._radioButtonPanel.setBorder(new TitledBorder("Availability"));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.gridwidth = 2;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this.getContentPane().add((Component)this._radioButtonPanel, gbc);
        this._allAppsLocRB = new RmaJRadioButton(ALL_WATERSHEDS);
        this._allAppsLocRB.setActionCommand("");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets((int)0, (int)5, (int)0, (int)5);
        this._radioButtonPanel.add((Component)this._allAppsLocRB, gbc);
        this._thisWatershedLocRB = new RmaJRadioButton("This Watershed only");
        this._thisWatershedLocRB.setActionCommand("");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets((int)0, (int)5, (int)0, (int)5);
        this._radioButtonPanel.add((Component)this._thisWatershedLocRB, gbc);
        this._nextRadioButtonPanelRow = 2;
        this._filesList = new RmaJList((ListModel)new RmaListModel(true));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.gridwidth = 2;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets((int)0, (int)5, (int)0, (int)5);
        this._filesListSP = new JScrollPane((Component)this._filesList);
        this.getContentPane().add((Component)this._filesListSP, gbc);
        this._nameLabel = new JLabel("Name:", 4);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this.getContentPane().add((Component)this._nameLabel, gbc);
        this._nameTxt = new RmaJTextField((Document)new FilenameDocument(), "", 20);
        this._nameTxt.setTrimWhiteSpace(true);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.weightx = 1.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this.getContentPane().add((Component)this._nameTxt, gbc);
        int buttons = 12;
        switch (this._mode) {
            case 6: {
                buttons = 1028;
                this._modeString = "Rename";
                this._nameTxt.setEditable(true);
                break;
            }
            case 1: 
            case 5: {
                buttons = 20;
                this._modeString = "Save";
                this._nameTxt.setEditable(true);
                break;
            }
            case 0: 
            case 4: {
                buttons = 36;
                this._modeString = "Open";
                this._nameTxt.setEditable(false);
                break;
            }
            case 2: {
                buttons = 68;
                this._modeString = "Delete";
                this._nameTxt.setEditable(false);
                break;
            }
            case 3: {
                buttons = 516;
                this._modeString = "New";
                this._nameTxt.setEditable(true);
            }
        }
        this.cmdPanel = new ButtonCmdPanel(buttons);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridwidth = 2;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this.getContentPane().add((Component)this.cmdPanel, gbc);
        this.setTitle(this._modeString + " Preference");
        this.setOKButtonSearchString(this._modeString);
        this._radioActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreferencesChooserDialog.this.updateList();
            }
        };
        this._allAppsLocRB.addActionListener(this._radioActionListener);
        this._thisWatershedLocRB.addActionListener(this._radioActionListener);
        this._filesList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                PreferencesChooserDialog.this.listItemSelected();
            }
        });
        this.cmdPanel.addCmdPanelListener(new ButtonCmdPanelListener(){

            public void buttonCmdActionPerformed(ActionEvent e) {
                switch (e.getID()) {
                    case 8: 
                    case 16: 
                    case 32: 
                    case 64: 
                    case 1024: {
                        if (!PreferencesChooserDialog.this.validForm()) break;
                        PreferencesChooserDialog.this._canceled = false;
                        PreferencesChooserDialog.this.setVisible(false);
                        break;
                    }
                    case 512: {
                        break;
                    }
                    case 4: {
                        PreferencesChooserDialog.this._canceled = true;
                        PreferencesChooserDialog.this.setVisible(false);
                    }
                }
            }
        });
        this._buttonGroup.add((AbstractButton)this._allAppsLocRB);
        this._buttonGroup.add((AbstractButton)this._thisWatershedLocRB);
        this.pack();
        this.setLocation();
    }

    protected boolean validForm() {
        if (this._buttonGroup.getSelection() == null) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Please select a location.", "No Location Selected", 1);
            return false;
        }
        if (this._nameTxt.isVisible() && this._nameTxt.getText().length() < 1) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Please enter a preference name.", "No Name Specified", 1);
            return false;
        }
        return true;
    }

    private JRadioButton getSelectedRadioButton() {
        if (this._allAppsLocRB.isSelected()) {
            return this._allAppsLocRB;
        }
        if (this._thisWatershedLocRB.isSelected()) {
            return this._thisWatershedLocRB;
        }
        int size = this._userDefinedRadioButtons.size();
        for (int i = 0; i < size; ++i) {
            JRadioButton rb = (JRadioButton)this._userDefinedRadioButtons.get(i);
            if (!rb.isSelected()) continue;
            return rb;
        }
        return null;
    }

    public int getPreferenceLocation() {
        if (this._allAppsLocRB.isSelected()) {
            return 1;
        }
        if (this._thisWatershedLocRB.isSelected()) {
            return 0;
        }
        int size = this._userDefinedRadioButtons.size();
        for (int i = 0; i < size; ++i) {
            JRadioButton rb = (JRadioButton)this._userDefinedRadioButtons.get(i);
            if (!rb.isSelected()) continue;
            return RMAIO.parseInt((String)rb.getName(), (int)-2);
        }
        return -1;
    }

    public String getPreferenceName() {
        return RMAIO.userNameToFileName((String)this._nameTxt.getText());
    }

    public void setFileManager(RmiFileManager fm) {
        this._fileManager = fm;
    }

    public void setVisible(boolean b) {
        if (b && this._fileManager == null) {
            this._filesListSP.setVisible(false);
            this.pack();
        }
        super.setVisible(b);
    }

    protected void listItemSelected() {
        String value = this._filesList.getSelectedValue().toString();
        this._nameTxt.setText(value);
    }

    public boolean isCanceled() {
        return this._canceled;
    }

    public Identifier getIdentifier() {
        switch (this._mode) {
            case 0: 
            case 2: 
            case 4: {
                Identifier id = (Identifier)this._filesList.getSelectedValue();
                return id;
            }
        }
        String subDir = this.getSubDir();
        String fileName = (String)(subDir != null ? subDir + "/" : "") + this._nameTxt.getText();
        String filePath = PreferencesManager.getFileName(this.getPreferenceLocation(), fileName);
        return new Identifier(filePath);
    }

    public void updateList() {
        if (this._fileManager == null) {
            return;
        }
        Object path = PreferencesManager.getDirectoryForLocation(this.getPreferenceLocation());
        if (this._subDir != null) {
            path = (String)path + "/" + this.getSubDir();
        }
        System.out.println("updateList: getting listing for " + (String)path);
        Vector<Identifier> idList = null;
        try {
            idList = this._fileManager.getRemoteFileIDList(UserId.getUserId(), (String)path, this._filters);
        }
        catch (RemoteException re) {
            System.out.println("updateList: RMI error getting list of files from FileManager " + re);
        }
        for (int i = idList.size() - 1; i >= 0; --i) {
            Identifier id = idList.get(i);
            if (!this.showIdentifier(id)) {
                idList.remove(i);
                continue;
            }
            this.fixIdentifierName(id);
        }
        RmaListModel model = (RmaListModel)this._filesList.getModel();
        model.clear();
        if (idList != null) {
            model.addAll(idList);
        }
    }

    protected boolean showIdentifier(Identifier id) {
        return id != null && !id.isDirectory();
    }

    protected void fixIdentifierName(Identifier id) {
        if (id == null) {
            return;
        }
        if (!this._showFileExtensions) {
            String name = id.getName();
            int idx = name.lastIndexOf(".");
            if (idx == -1) {
                return;
            }
            id.setName(name.substring(0, idx));
        }
    }

    public void setFileFilters(List filters) {
        this._filters.clear();
        this._filters.addAll(filters);
    }

    public void setSubDirectory(String subDir) {
        this._subDir = subDir;
        this._allAppsLocRB.setActionCommand(subDir);
        this._thisWatershedLocRB.setActionCommand(subDir);
        this._allAppsLocRB.setLabel(ALL_WATERSHEDS);
    }

    public void setNameSelectable(boolean b) {
        this._filesListSP.setVisible(b);
        this._nameTxt.setVisible(b);
        this.pack();
    }

    public void setDefaultName(String name) {
        this._defaultName = name;
        if (this._defaultName != null) {
            this._nameTxt.setText(this._defaultName);
        }
    }

    public void addUserDefinedLocation(String label, String subDir, int location) {
        RmaJRadioButton userDefinedRadio = new RmaJRadioButton(label);
        userDefinedRadio.setActionCommand(subDir == null ? "" : subDir);
        userDefinedRadio.setName("" + location);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = this._nextRadioButtonPanelRow++;
        gbc.weightx = 1.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets((int)0, (int)5, (int)0, (int)5);
        this._radioButtonPanel.add((Component)userDefinedRadio, gbc);
        this._userDefinedRadioButtons.add(userDefinedRadio);
        userDefinedRadio.addActionListener(this._radioActionListener);
        this._buttonGroup.add((AbstractButton)userDefinedRadio);
        this.pack();
    }

    public String getSubDir() {
        JRadioButton rb = this.getSelectedRadioButton();
        if (rb == null) {
            return "";
        }
        return rb.getActionCommand();
    }

    public void setShowFileExtensions(boolean showEm) {
        this._showFileExtensions = showEm;
    }

    public static void main(String[] args) {
        new SavePreferencesDialog(new Frame(), false).setVisible(true);
    }
}

