/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.rmi.client;

import hec.appInterface.AppDaddy;
import hec.appInterface.FileOpener;
import hec.io.FilePropertiesJDialog;
import hec.io.HecFile;
import hec.io.Identifier;
import hec.lang.ApplicationProperties;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FilenameFilter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileSystemView;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import javax.swing.text.Document;
import mil.army.usace.hec.rmi.csinterface.ClientServerUtil;
import rma.swing.FlatPanelButton;
import rma.swing.FlatPanelToggleButton;
import rma.swing.RmaImage;
import rma.swing.RmaJDialog;
import rma.swing.RmaJList;
import rma.swing.RmaJTable;
import rma.swing.RmaJTextField;
import rma.swing.list.RmaListModel;
import rma.swing.text.FilenameDocument;
import rma.util.RMAFilenameFilter;
import rma.util.RMAIO;
import rma.util.WildCardFileFilter;

public class RmiFileDialog
extends RmaJDialog {
    private static final Logger LOGGER = Logger.getLogger(RmiFileDialog.class.getName());
    public static final String DIRECTORY_SELECTED_PROPERTY = "DIRECTORY_SELECTED_PROPERTY";
    public static final String PATHS_SELECTED_PROPERTY = "PATHS_SELECTED_PROPERTY";
    public static final String FILE_SELECTED_PROPERTY = "FILE_SELECTED_PROPERTY";
    Window _parent = null;
    private static final String OPEN_FILE_TITLE = "Open File";
    private static final String SAVE_FILE_TITLE = "Save File";
    private static final String OPEN_DIR_TITLE = "Open Folder";
    private static final String PARENT_DIR = "..";
    private static ArrayList<Shortcut> _staticShortcuts = new ArrayList();
    String _currentDir;
    boolean _canceled = false;
    private FileOpener _fileOpener = null;
    private String _lastLocalDir = null;
    private String _lastRemoteDir = null;
    private String _selectedFile = null;
    private Vector<String> _selectedPaths = new Vector();
    private boolean _openingDir = false;
    private boolean _openingBoth = false;
    private NewDirDialog _ndd = null;
    Vector<Identifier> _dirs = new Vector();
    int _mouseClicked = 0;
    Font font = UIManager.getFont("TextField.font");
    Color backColor = UIManager.getColor("text");
    private ActionListener _shortcutActionListener;
    private SimpleDateFormat _dateFormat = new SimpleDateFormat("MM/dd/yyyy, kk:mm");
    JPanel topPanel;
    JPanel dirListPanel;
    JPanel fileListPanel;
    JPanel bottomPanel;
    JTextField jT_currentDir;
    JTextField jT_currentFile;
    JLabel fileNameLabel;
    JComboBox jCB_fileType;
    JComboBox jCB_currentDrive;
    JRadioButton jRB_local;
    JRadioButton jRB_remote;
    JList jL_directorys;
    JList jL_files;
    JLabel label2;
    JButton jB_ok;
    JButton jB_cancel;
    JButton jB_upDir;
    JButton jB_newDir;
    JToggleButton jB_ListOnly;
    JToggleButton jB_Details;
    JScrollPane jDirScrollPane;
    JScrollPane jFileScrollPane;
    ActionListener currentDriveAL = null;
    JSplitPane jSp_pane;
    RmaJTable jTbl_files;
    JPopupMenu _propPopup;
    FileSystemView _fsv = FileSystemView.getFileSystemView();
    Insets zeroInsets = new Insets(0, 0, 0, 0);
    private JPanel _shortCutPanel;
    private boolean _visibleActionsEnabled = true;
    private boolean _bRemote = true;
    private String _topFolder;

    public RmiFileDialog(Dialog owner, boolean modal) {
        super(owner, modal);
        this._parent = owner;
        this.buildControls();
    }

    public RmiFileDialog(Dialog owner, boolean modal, boolean remote) {
        super(owner, modal);
        this._parent = owner;
        this._bRemote = remote;
        this.buildControls();
    }

    public RmiFileDialog(Frame owner, boolean modal) {
        super(owner, modal);
        this._parent = owner;
        this.buildControls();
    }

    public RmiFileDialog(Frame owner, boolean modal, boolean bRemote) {
        super(owner, modal);
        this._bRemote = bRemote;
        this._parent = owner;
        this.buildControls();
    }

    public RmiFileDialog(Dialog owner, boolean modal, String startDir, List fileMask) {
        this(owner, modal);
        this._parent = owner;
        this.setStartDir(startDir);
        this.setFileMask(fileMask);
    }

    public RmiFileDialog(Dialog owner, boolean modal, String startDir, List fileMask, FileOpener fileOpener) {
        this(owner, modal);
        this._parent = owner;
        this._fileOpener = fileOpener;
        this.setStartDir(startDir);
        this.setFileMask(fileMask);
    }

    public RmiFileDialog(Frame owner, boolean modal, String startDir, List fileMask) {
        this(owner, modal);
        this._parent = owner;
        this.setStartDir(startDir);
        this.setFileMask(fileMask);
    }

    public RmiFileDialog(Frame owner, boolean modal, String startDir, List fileMask, boolean remote) {
        this(owner, modal, remote);
        this._parent = owner;
        this.setStartDir(startDir);
        this.setFileMask(fileMask);
    }

    private void buildControls() {
        this.registerEnterKey(true);
        this.registerEscapeKey(true);
        this.setTitle(OPEN_FILE_TITLE);
        this.getContentPane().setLayout(new GridBagLayout());
        this.setSize(700, 500);
        this._shortcutActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JButton btn;
                Object src = e.getSource();
                if (src instanceof JButton && (btn = (JButton)src).getName() != null) {
                    RmiFileDialog.this.setCurrentDir(btn.getName());
                    RmiFileDialog.this.updateLists();
                }
            }
        };
        this._shortCutPanel = new JPanel(new GridLayout(6, 1));
        this._shortCutPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        this._shortCutPanel.setBackground(Color.gray);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 1.0;
        gbc.gridheight = 2;
        gbc.fill = 3;
        gbc.insets = this.zeroInsets;
        this.fillShortCutPanel();
        this.getContentPane().add((Component)this._shortCutPanel, gbc);
        this.topPanel = this.buildTopPanel();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 2;
        gbc.gridheight = 1;
        gbc.anchor = 11;
        gbc.fill = 2;
        gbc.insets = new Insets(5, 0, 5, 5);
        this.getContentPane().add((Component)this.topPanel, gbc);
        this.dirListPanel = this.buildDirListPanel();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 4.0;
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        gbc.anchor = 11;
        gbc.fill = 1;
        gbc.insets = this.zeroInsets;
        this.getContentPane().add((Component)this.dirListPanel, gbc);
        this.bottomPanel = this.buildBottomPanel();
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        gbc.anchor = 15;
        gbc.fill = 2;
        gbc.insets = this.zeroInsets;
        this.getContentPane().add((Component)this.bottomPanel, gbc);
        this.getRootPane().setDefaultButton(this.jB_ok);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                RmiFileDialog.this.windowClosingEvent(evt);
            }

            @Override
            public void windowActivated(WindowEvent evt) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        RmiFileDialog.this.jL_directorys.requestFocus();
                    }
                });
            }
        });
        if (AppDaddy.getWorkspace() != null) {
            this._fileOpener = AppDaddy.getWorkspace();
        }
        if (this._fileOpener == null) {
            this.jRB_remote.setEnabled(false);
            this.jRB_local.setSelected(true);
        }
        if (AppDaddy.getApp() != null && !AppDaddy.getApp().isNetworked()) {
            this.jRB_remote.setEnabled(false);
            this.jRB_local.setEnabled(false);
        }
        this.pack();
        this.setSize(700, 500);
        this.setDefaultSize(700, 500);
        this.jRB_remote.setVisible(false);
        this.jRB_local.setVisible(false);
    }

    protected void fillShortCutPanel() {
        if (AppDaddy.getApp() != null) {
            String appHome = null;
            if (this._bRemote) {
                appHome = ClientServerUtil.getCWMSHome();
            }
            if (appHome == null && AppDaddy.getWorkspace() != null) {
                this.addShortcutButton("Watershed", AppDaddy.getWorkspace().getWorkspacePath(), "Images/desktop.gif");
            }
            if (appHome == null) {
                appHome = AppDaddy.getApp().getApplicationProperty(ApplicationProperties.getAppHomeVariable());
            }
            if (".".equals(appHome) && !AppDaddy.getApp().isNetworked()) {
                appHome = System.getProperty("user.dir");
            }
            this.addShortcutButton(ApplicationProperties.getAppHomeVariable(), appHome, "Images/documents.gif");
        } else if (_staticShortcuts.size() == 0) {
            this._shortCutPanel.setVisible(false);
        }
        this.addStaticShortcuts();
    }

    private void addStaticShortcuts() {
        for (int i = 0; i < _staticShortcuts.size(); ++i) {
            Shortcut sc = _staticShortcuts.get(i);
            this.addShortcutButton(sc.buttonText, sc.directory, sc.buttonIcon);
        }
    }

    public void addShortcutButton(String buttonText, String location, String iconName) {
        if (location == null) {
            System.out.println("addShortcutButton: no location specified for " + buttonText);
            return;
        }
        ImageIcon icon = null;
        if (iconName == null) {
            iconName = "Images/directory.gif";
            icon = RmaImage.getImageIcon((String)iconName);
        } else {
            icon = RmaImage.getImageIcon((String)iconName);
        }
        if (icon == null) {
            System.out.println("addShortcutButton: failed to load icon " + iconName);
            return;
        }
        FlatPanelButton button = new FlatPanelButton(buttonText, (Icon)icon);
        button.setName(location);
        button.addActionListener(this._shortcutActionListener);
        button.setBackground(Color.gray);
        button.setVerticalTextPosition(3);
        button.setHorizontalTextPosition(0);
        button.setMargin(new Insets(0, 5, 0, 5));
        button.setToolTipText(location);
        this._shortCutPanel.add((Component)button);
    }

    public static void addStaticShortcutButton(String buttonText, String location, String iconName) {
        Shortcut sc = new Shortcut(buttonText, location, iconName);
        if (_staticShortcuts.contains(sc)) {
            _staticShortcuts.remove(sc);
        }
        _staticShortcuts.add(sc);
    }

    public void setFileOpener(FileOpener fileOpener) {
        if (fileOpener == null) {
            return;
        }
        this._fileOpener = fileOpener;
        this.jRB_remote.setEnabled(true);
        this.jRB_remote.setSelected(true);
    }

    private JPanel buildPanel(int top, int left, int bottom, int right) {
        JPanel panel = new JPanel(new GridBagLayout());
        return panel;
    }

    private JPanel buildTopPanel() {
        JPanel panel = this.buildPanel(0, 0, 0, 0);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.anchor = 11;
        gbc.fill = 1;
        gbc.insets = new Insets(0, 0, 0, 0);
        JLabel label = new JLabel("Drive: ");
        label.setDisplayedMnemonic('r');
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = new Insets(0, 5, 0, 0);
        panel.add((Component)label, gbc);
        RmaListModel newModel = new RmaListModel(true);
        newModel.setCaseInsensitiveSort(true);
        this.jCB_currentDrive = new JComboBox(newModel);
        Dimension d = this.jCB_currentDrive.getPreferredSize();
        d.width = 75;
        this.jCB_currentDrive.setPreferredSize(d);
        this.jCB_currentDrive.setMinimumSize(d);
        label.setLabelFor(this.jCB_currentDrive);
        this.jCB_currentDrive.setActionCommand("currentDrive");
        this.jCB_currentDrive.setToolTipText("List of currently available drives");
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 2.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = new Insets(0, 5, 0, 0);
        this.jCB_currentDrive.setRenderer(new DriveCellRenderer());
        panel.add((Component)this.jCB_currentDrive, gbc);
        JPanel optionsPanel = this.buildPanel(0, 0, 0, 0);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.anchor = 11;
        gbc.fill = 0;
        gbc.insets = new Insets(0, 0, 0, 2);
        panel.add((Component)optionsPanel, gbc);
        Icon icon = UIManager.getIcon("FileChooser.upFolderIcon");
        if (icon != null) {
            this.jB_upDir = new FlatPanelButton(icon);
            this.jB_upDir.setMargin(new Insets(0, 0, 0, 0));
        } else {
            this.jB_upDir = new FlatPanelButton("Up");
            this.jB_upDir.setMnemonic('u');
        }
        this.jB_upDir.setActionCommand("upDir");
        this.jB_upDir.setToolTipText("Up One Level");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.anchor = 11;
        gbc.fill = 0;
        gbc.insets = new Insets(0, 0, 0, 2);
        optionsPanel.add((Component)this.jB_upDir, gbc);
        Icon icon2 = UIManager.getIcon("FileChooser.newFolderIcon");
        if (icon2 != null) {
            this.jB_newDir = new FlatPanelButton(icon2);
            this.jB_newDir.setMargin(new Insets(0, 0, 0, 0));
        } else {
            this.jB_newDir = new FlatPanelButton("New");
            this.jB_newDir.setMnemonic('w');
        }
        this.jB_newDir.setActionCommand("newDir");
        this.jB_newDir.setToolTipText("Create New Folder");
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.anchor = 11;
        gbc.fill = 0;
        gbc.insets = new Insets(0, 2, 0, 0);
        optionsPanel.add((Component)this.jB_newDir, gbc);
        Icon icon3 = UIManager.getIcon("FileChooser.listViewIcon");
        if (icon3 != null) {
            this.jB_ListOnly = new FlatPanelToggleButton(icon3, true);
            this.jB_ListOnly.setMargin(new Insets(0, 0, 0, 0));
        } else {
            this.jB_ListOnly = new JToggleButton("List", true);
            this.jB_ListOnly.setMnemonic('l');
        }
        this.jB_ListOnly.setActionCommand("listView");
        this.jB_ListOnly.setToolTipText("List");
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.anchor = 11;
        gbc.fill = 0;
        gbc.insets = new Insets(0, 2, 0, 0);
        optionsPanel.add((Component)this.jB_ListOnly, gbc);
        Icon icon4 = UIManager.getIcon("FileChooser.detailsViewIcon");
        if (icon4 != null) {
            this.jB_Details = new FlatPanelToggleButton(icon4, false);
            this.jB_Details.setMargin(new Insets(0, 0, 0, 0));
        } else {
            this.jB_Details = new JToggleButton("Details");
            this.jB_Details.setMnemonic('e');
        }
        this.jB_Details.setActionCommand("detailsView");
        this.jB_Details.setToolTipText("Details");
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.anchor = 11;
        gbc.fill = 0;
        gbc.insets = new Insets(0, 2, 0, 0);
        optionsPanel.add((Component)this.jB_Details, gbc);
        this.jRB_local = new JRadioButton("Local");
        this.jRB_local.setMnemonic('o');
        this.jRB_local.setActionCommand("local");
        this.jRB_local.setToolTipText("Gets listing from local drive");
        gbc = new GridBagConstraints();
        gbc.gridx = 4;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = new Insets(0, 5, 0, 0);
        panel.add((Component)this.jRB_local, gbc);
        JLabel label1 = new JLabel("Folder: ");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = new Insets(3, 5, 0, 0);
        panel.add((Component)label1, gbc);
        this.jT_currentDir = new RmaJTextField(25);
        this.jT_currentDir.setActionCommand("protected");
        this.jT_currentDir.setEditable(false);
        this.jT_currentDir.setDisabledTextColor(Color.black);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.weightx = 5.0;
        gbc.gridwidth = 2;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = new Insets(3, 5, 0, 0);
        panel.add((Component)this.jT_currentDir, gbc);
        this.jRB_remote = new JRadioButton("Remote");
        this.jRB_remote.setMnemonic('r');
        this.jRB_remote.setActionCommand("remote");
        this.jRB_remote.setToolTipText("Gets listing from server's drive");
        gbc = new GridBagConstraints();
        gbc.gridx = 4;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = new Insets(1, 5, 0, 0);
        panel.add((Component)this.jRB_remote, gbc);
        ButtonGroup bG_bankGroup = new ButtonGroup();
        bG_bankGroup.add(this.jRB_local);
        bG_bankGroup.add(this.jRB_remote);
        this.jRB_remote.setSelected(true);
        this.jRB_remote.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RmiFileDialog.this.jRBremote_Action();
            }
        });
        this.jRB_local.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RmiFileDialog.this.jRBlocal_Action();
            }
        });
        this.jB_newDir.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RmiFileDialog.this.jBnewDir_Action();
            }
        });
        this.jB_upDir.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RmiFileDialog.this.jBupDir_Action();
            }
        });
        this.jB_Details.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RmiFileDialog.this.jBDetails_Action();
            }
        });
        this.jB_ListOnly.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RmiFileDialog.this.jBListOnly_Action();
            }
        });
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.jB_Details);
        bg.add(this.jB_ListOnly);
        return panel;
    }

    private JPanel buildDirListPanel() {
        JPanel panel = this.buildPanel(0, 0, 0, 0);
        RmaListModel model = new RmaListModel(true);
        model.setCaseInsensitiveSort(true);
        this.jL_directorys = new RmaJList((ListModel)model){};
        this.jL_directorys.setVisibleRowCount(0);
        this.jL_directorys.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RmiFileDialog.this.updateLists();
            }
        }, KeyStroke.getKeyStroke(116, 0, true), 1);
        this.jL_directorys.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RmiFileDialog.this.jBupDir_Action();
            }
        }, KeyStroke.getKeyStroke(8, 0, true), 1);
        this.jL_directorys.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RmiFileDialog.this.directorySelected(true);
            }
        }, KeyStroke.getKeyStroke(32, 0, true), 1);
        this.jL_directorys.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RmiFileDialog.this.directorySelected(true);
            }
        }, KeyStroke.getKeyStroke(10, 0, true), 1);
        this.jL_directorys.setForeground(new Color(0));
        this.jL_directorys.setBackground(Color.white);
        this.jL_directorys.setCellRenderer(new MyListCellRenderer("FileView.directoryIcon"));
        this.jDirScrollPane = new JScrollPane(this.jL_directorys);
        BevelBorder bBorder = new BevelBorder(1);
        TitledBorder border = new TitledBorder(bBorder, "Folders");
        border.setTitleFont(this.font);
        this.jDirScrollPane.setBorder(border);
        this.jDirScrollPane.setOpaque(true);
        this.jDirScrollPane.setBackground(Color.white);
        model = new RmaListModel(true);
        model.setCaseInsensitiveSort(true);
        this.jL_files = new RmaJList((ListModel)model){};
        this.jL_files.setVisibleRowCount(0);
        this.jL_files.setLayoutOrientation(1);
        this.jL_files.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RmiFileDialog.this.updateLists();
            }
        }, KeyStroke.getKeyStroke(116, 0, true), 1);
        this.jL_files.setSelectionMode(0);
        this.jL_files.setCellRenderer(new MyListCellRenderer("FileView.fileIcon"));
        this.jFileScrollPane = new JScrollPane(this.jL_files);
        BevelBorder bBorder2 = new BevelBorder(1);
        TitledBorder border2 = new TitledBorder(bBorder2, "Files");
        this.jFileScrollPane.setBorder(border2);
        this.jFileScrollPane.setOpaque(true);
        this.jFileScrollPane.setBackground(Color.white);
        this.jL_files.setBackground(this.jFileScrollPane.getBackground());
        Object[] headers = new String[]{"Name", "Size", "Modified"};
        this.jTbl_files = new RmaJTable((Component)((Object)this), headers);
        TableRowSorter<TableModel> rowSorter = new TableRowSorter<TableModel>();
        rowSorter.setModel(this.jTbl_files.getModel());
        rowSorter.setComparator(1, new FileSizeComparator());
        rowSorter.setComparator(2, new ModifiedDateComparator());
        this.jTbl_files.setRowSorter(rowSorter);
        this.jTbl_files.setBackground(this.jFileScrollPane.getBackground());
        this.jTbl_files.setEditable(false);
        this.jTbl_files.setColumnEnabled(false, 0);
        this.jTbl_files.setColumnEnabled(false, 1);
        this.jTbl_files.setColumnEnabled(false, 2);
        this.jTbl_files.setShowGrid(false);
        this.jTbl_files.setCellSelectionEnabled(false);
        this.jTbl_files.setPopupMenuEnabled(false);
        this.jTbl_files.setRowSelectionAllowed(true);
        this.jTbl_files.setSelectionMode(0);
        this.jTbl_files.setPrecision(0);
        this.jTbl_files.setDoubleCellEditor(1, true);
        this.jSp_pane = new JSplitPane(1, this.jDirScrollPane, this.jFileScrollPane);
        this.jSp_pane.setDividerLocation(0.5);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 4.0;
        gbc.anchor = 17;
        gbc.fill = 1;
        gbc.insets = new Insets(0, 5, 0, 0);
        panel.add((Component)this.jSp_pane, gbc);
        this.jL_directorys.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                if (me.isPopupTrigger() || SwingUtilities.isRightMouseButton(me)) {
                    RmiFileDialog.this.fileProperties(me);
                } else {
                    RmiFileDialog.this.directorySelected(me);
                }
            }
        });
        this.jL_files.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                RmiFileDialog.this.fileSelected(evt);
            }
        });
        this.jL_files.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                if (me.isPopupTrigger() || SwingUtilities.isRightMouseButton(me)) {
                    RmiFileDialog.this.fileProperties(me);
                } else {
                    RmiFileDialog.this.fileSelectClicked(me);
                }
            }
        });
        this.jTbl_files.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                if (me.isPopupTrigger() || SwingUtilities.isRightMouseButton(me)) {
                    RmiFileDialog.this.fileProperties(me);
                } else {
                    RmiFileDialog.this.fileSelectClicked(me);
                }
            }
        });
        this.jTbl_files.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                RmiFileDialog.this.fileSelected(evt);
            }
        });
        return panel;
    }

    private JPanel buildBottomPanel() {
        JPanel panel = this.buildPanel(0, 0, 0, 0);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.anchor = 11;
        gbc.fill = 1;
        gbc.insets = new Insets(0, 0, 0, 0);
        this.fileNameLabel = new JLabel("File name : ");
        this.fileNameLabel.setDisplayedMnemonic('n');
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.insets = new Insets(2, 5, 0, 0);
        panel.add((Component)this.fileNameLabel, gbc);
        this.jT_currentFile = new JTextField(30);
        this.fileNameLabel.setLabelFor(this.jT_currentFile);
        this.jT_currentFile.setActionCommand("currentFile");
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.weightx = 2.0;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.insets = new Insets(2, 5, 0, 0);
        panel.add((Component)this.jT_currentFile, gbc);
        this.jB_ok = new JButton("OK");
        this.jB_ok.setActionCommand("ok");
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.insets = new Insets(2, 5, 0, 5);
        panel.add((Component)this.jB_ok, gbc);
        this.label2 = new JLabel("Files of Type : ");
        this.label2.setDisplayedMnemonic('t');
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.insets = new Insets(2, 5, 0, 0);
        panel.add((Component)this.label2, gbc);
        this.jCB_fileType = new JComboBox();
        this.label2.setLabelFor(this.jCB_fileType);
        this.jCB_fileType.setActionCommand("fileType");
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 1;
        gbc.weightx = 2.0;
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.insets = new Insets(2, 5, 5, 0);
        panel.add((Component)this.jCB_fileType, gbc);
        this.jB_cancel = new JButton("Cancel");
        this.jB_cancel.setActionCommand("cancel");
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.insets = new Insets(2, 5, 5, 5);
        panel.add((Component)this.jB_cancel, gbc);
        this.jB_ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RmiFileDialog.this.jBok_Action();
            }
        });
        this.jB_cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RmiFileDialog.this.jBcancel_Action();
            }
        });
        this.jCB_fileType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RmiFileDialog.this.jCBfileType_Action();
            }
        });
        return panel;
    }

    public void addNotify() {
        super.addNotify();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                RmiFileDialog.this.jSp_pane.setDividerLocation(0.4);
                RmiFileDialog.this.jL_directorys.requestFocus();
            }
        });
    }

    public void windowClosingEvent(WindowEvent event) {
        Object object = event.getSource();
        if (object == this) {
            this.jBcancel_Action();
        }
    }

    private void jCBfileType_Action() {
        if (this.isVisible()) {
            this.updateLists();
        }
    }

    private void jCBcurrentDrive_Action(ActionEvent evt) {
        this.setCurrentDir((String)this.jCB_currentDrive.getSelectedItem());
        this.updateLists();
    }

    private void jBcancel_Action() {
        this.setCanceled(true);
        if (this._visibleActionsEnabled) {
            this.setVisible(false);
        }
    }

    private void jBok_Action() {
        if (!this._openingDir && (this.jT_currentFile.getText() == null || this.jT_currentFile.getText().equals(""))) {
            return;
        }
        this.setSelectedFile(this.jT_currentFile.getText(), this.jT_currentDir.getText());
        this.setCanceled(false);
        if (this._visibleActionsEnabled) {
            this.setVisible(false);
        }
    }

    private void jRBlocal_Action() {
        String curDir = this.jT_currentDir.getText();
        File dir = new File(curDir);
        if (!dir.canRead() || !dir.isDirectory()) {
            curDir = System.getProperty("user.dir");
        }
        this._lastRemoteDir = curDir;
        if (this._lastLocalDir == null || this._lastLocalDir.equals("")) {
            this.setCurrentDir(System.getProperty("user.dir"));
        } else {
            this.setCurrentDir(this._lastLocalDir);
        }
        this.updateLists();
        this.updateDrives();
    }

    private void jRBremote_Action() {
        String curDir;
        this._lastLocalDir = curDir = this.jT_currentDir.getText();
        if (this._lastRemoteDir == null || this._lastRemoteDir.equals("")) {
            this.setCurrentDir(AppDaddy.getApp().getWorkingDir());
        } else {
            this.setCurrentDir(this._lastRemoteDir);
        }
        this.updateLists();
        this.updateDrives();
    }

    private void jBnewDir_Action() {
        boolean duplicate = false;
        String newdirName = null;
        if (this._ndd == null) {
            this._ndd = this._parent instanceof Dialog ? new NewDirDialog((Dialog)this._parent, true) : new NewDirDialog((Frame)this._parent, true);
        } else {
            this._ndd.clearNewDirName();
        }
        block0: do {
            this._ndd.setVisible(true);
            newdirName = this._ndd.getNewDirName();
            if (newdirName == null || newdirName.equals("")) {
                return;
            }
            duplicate = false;
            for (int i = 0; i < this._dirs.size(); ++i) {
                Identifier obj = this._dirs.elementAt(i);
                if (obj == null || !(obj instanceof String) || !newdirName.equalsIgnoreCase((String)obj)) continue;
                duplicate = true;
                continue block0;
            }
        } while (duplicate);
        Identifier id = new Identifier(this.jT_currentDir.getText() + "/" + newdirName + "/");
        id.setName(newdirName);
        Identifier id2 = null;
        id2 = this._fileOpener.createFile(id);
        if (id2 != null) {
            this._dirs.addElement(id2);
            this.updateDirList(this._dirs);
        } else {
            id2 = this._fileOpener.openFile(id, false);
            if (id2 != null) {
                boolean isDir = false;
                if (id2.getFile() != null) {
                    isDir = id2.getFile().isDirectory();
                }
                JOptionPane.showMessageDialog((Component)((Object)this), (isDir ? "Folder " : "File ") + id.getPath() + " already exists", "Duplicate Name", 2);
            }
            System.out.println("Failed to get valid id back for " + id.getPath());
        }
    }

    private void jBDetails_Action() {
        this.jFileScrollPane.setViewportView((Component)this.jTbl_files);
        this.jFileScrollPane.setBackground(Color.white);
        this.jFileScrollPane.getViewport().setBackground(Color.white);
        this.jTbl_files.clearSelection();
        this.jFileScrollPane.revalidate();
        this.jTbl_files.revalidate();
        this.updateLists();
    }

    private void jBListOnly_Action() {
        this.jFileScrollPane.setViewportView(this.jL_files);
        this.jFileScrollPane.setBackground(Color.white);
        this.jFileScrollPane.getViewport().setBackground(Color.white);
        this.jFileScrollPane.setColumnHeader(new JViewport());
        this.jFileScrollPane.revalidate();
        this.updateLists();
    }

    private void jBupDir_Action() {
        String dir = this.jT_currentDir.getText();
        if (RmiFileDialog.isRootDir(dir)) {
            return;
        }
        if (this._topFolder != null && RMAIO.pathsEqual((String)this._topFolder, (String)dir)) {
            this.jB_upDir.setEnabled(false);
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.setCurrentDir(RmiFileDialog.stripDir(dir));
        this.updateLists();
        this.jL_directorys.setSelectedIndex(0);
        this.jL_directorys.requestFocus();
        this.setCursor(Cursor.getDefaultCursor());
    }

    private void setCurrentDir(String dir) {
        String currentDrive;
        if (dir == null) {
            return;
        }
        Object newDir = dir.replace('\\', '/');
        if (dir.equals(".") || dir.equals("./")) {
            newDir = AppDaddy.getApp() == null ? System.getProperty("user.dir") : (AppDaddy.getWorkspace() != null ? AppDaddy.getWorkspace().getWorkspacePath() : AppDaddy.getApp().getApplicationProperty(ApplicationProperties.getAppHomeVariable()));
            newDir = ((String)newDir).replace('\\', '/');
        }
        if (((String)newDir).endsWith("/") && !RmiFileDialog.isRootDir((String)newDir)) {
            newDir = ((String)newDir).substring(0, ((String)newDir).length() - 1);
        }
        if (((String)newDir).length() >= 2 && ((String)newDir).charAt(1) == ':') {
            this.updateDrives();
            currentDrive = (String)this.jCB_currentDrive.getSelectedItem();
            String drive = ((String)newDir).substring(0, 3).toUpperCase();
            System.out.println("setCurrentDir:setting drive to " + drive + " dir=" + dir);
            if (!drive.equalsIgnoreCase(currentDrive)) {
                this.jCB_currentDrive.setSelectedItem(drive);
            }
        }
        if (((String)newDir).startsWith("/")) {
            this.updateDrives();
            currentDrive = (String)this.jCB_currentDrive.getSelectedItem();
            if (currentDrive.contains(":")) {
                newDir = currentDrive + (String)newDir;
            }
        }
        if (((String)newDir).endsWith("//")) {
            newDir = ((String)newDir).substring(0, ((String)newDir).length() - 1);
        }
        this.jT_currentDir.setText((String)newDir);
        if (this._topFolder != null) {
            this.jB_upDir.setEnabled(!RMAIO.pathsEqual((String)this._topFolder, (String)newDir));
        }
        this.jT_currentDir.setToolTipText((String)newDir);
        this._selectedPaths.removeAllElements();
        if (this.isVisible()) {
            this.syncDriveListToDirectory();
        }
    }

    protected void syncDriveListToDirectory() {
        this.currentDriveActionListener(false);
        Object newDir = this.jT_currentDir.getText();
        if (this._openingDir || this._openingBoth) {
            this.jT_currentFile.setText((String)newDir);
        }
        if (((String)newDir).length() >= 2 && ((String)newDir).charAt(1) == ':') {
            newDir = ((String)newDir).substring(0, 2).toUpperCase() + "/";
            this.jCB_currentDrive.setSelectedItem(newDir);
        }
        this.currentDriveActionListener(true);
    }

    public void setOpenTitle() {
        super.setTitle(OPEN_FILE_TITLE);
        this._openingDir = false;
    }

    public void setSaveTitle() {
        super.setTitle(SAVE_FILE_TITLE);
        this._openingDir = false;
        this.jT_currentFile.setEditable(true);
        this.jT_currentFile.setBackground(Color.white);
    }

    public void setOpenDirectory() {
        super.setTitle(OPEN_DIR_TITLE);
        this.fileNameLabel.setText("Folder name:");
        this._openingDir = true;
        this.jSp_pane.remove(this.jFileScrollPane);
        this.jB_ListOnly.doClick();
        this.jB_ListOnly.setVisible(false);
        this.jB_Details.setVisible(false);
        this.label2.setVisible(false);
        this.jCB_fileType.setVisible(false);
        this.jL_directorys.setLayoutOrientation(1);
    }

    public void setOpenDirectoryOrFiles() {
        super.setTitle("Open");
        this.fileNameLabel.setText("Name:");
        this._openingBoth = true;
    }

    public void setStartDir(String startDir) {
        this.setCurrentDir(startDir);
    }

    public void setDefaultFilename(String defaultFilename) {
        this.jT_currentFile.setText(defaultFilename);
    }

    public boolean getLocal() {
        return this.jRB_local.isSelected();
    }

    public void setLocal(boolean local) {
        if (local) {
            this.jRB_local.setSelected(true);
        } else {
            this.jRB_remote.setSelected(true);
        }
    }

    public void setLocalOnly(boolean b) {
        this.jRB_local.setEnabled(true);
        if (b) {
            this.jRB_remote.setEnabled(false);
        } else {
            this.jRB_remote.setEnabled(true);
        }
    }

    public void setFileMask(List fileMask) {
        for (int i = 0; i < fileMask.size(); ++i) {
            Object obj = fileMask.get(i);
            if (!(obj instanceof String) && !(obj instanceof RMAFilenameFilter)) continue;
            this.jCB_fileType.addItem(obj);
        }
    }

    public void setVisible(boolean b) {
        if (b) {
            this.fillForm();
            this.setLocation();
        }
        super.setVisible(b);
    }

    public void fillForm() {
        if (this.jT_currentDir.getText().length() < 1) {
            if (AppDaddy.getWorkspace() != null) {
                this.jT_currentDir.setText(AppDaddy.getWorkspace().getWorkspacePath());
            } else {
                this.jT_currentDir.setText(System.getProperty("user.dir"));
            }
        }
        this.updateDrives();
        this.updateLists();
        this.syncDriveListToDirectory();
    }

    private void currentDriveActionListener(boolean setActionListener) {
        if (this.currentDriveAL == null) {
            this.currentDriveAL = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    RmiFileDialog.this.jCBcurrentDrive_Action(evt);
                }
            };
        }
        if (setActionListener) {
            this.jCB_currentDrive.removeActionListener(this.currentDriveAL);
            this.jCB_currentDrive.addActionListener(this.currentDriveAL);
        } else {
            this.jCB_currentDrive.removeActionListener(this.currentDriveAL);
        }
    }

    protected void updateDrives() {
        int i;
        if (this.jCB_currentDrive.getItemCount() > 0) {
            return;
        }
        Vector<String> drives = this.getDrives();
        this.currentDriveActionListener(false);
        String curdir = this.jT_currentDir.getText();
        if (this.jCB_currentDrive.getSelectedIndex() > -1) {
            this.jCB_currentDrive.removeAllItems();
        }
        ((RmaListModel)this.jCB_currentDrive.getModel()).addAll(drives);
        if (drives.size() == 0) {
            this.jCB_currentDrive.setEnabled(false);
        } else {
            this.jCB_currentDrive.setEnabled(true);
        }
        if (curdir.length() > 0) {
            this.setCurrentDir(curdir);
            char start = this.jT_currentDir.getText().charAt(0);
            for (i = 0; i < drives.size(); ++i) {
                if (start != drives.elementAt(i).charAt(0)) continue;
                this.jCB_currentDrive.setSelectedIndex(i);
                this.currentDriveActionListener(true);
                return;
            }
        }
        for (i = 0; i < drives.size(); ++i) {
            char curDrive = drives.elementAt(i).charAt(0);
            if (curDrive == 'A' || curDrive == 'B') continue;
            System.out.println("updateDrives:setting drive to " + curDrive + " index=" + i);
            this.jCB_currentDrive.setSelectedIndex(i);
            return;
        }
        this.currentDriveActionListener(true);
    }

    protected void updateLists() {
        List<Object> addToFileList;
        int ii;
        String[] ext;
        Vector<Identifier> fileList = new Vector<Identifier>();
        this.setCursor(Cursor.getPredefinedCursor(3));
        Vector<Object> files = new Vector<Object>();
        this._dirs.removeAllElements();
        if (this.jT_currentDir.getText().equals("")) {
            this.setCurrentDir(AppDaddy.getApp().getWorkingDir());
        }
        if (this.jRB_remote.isSelected()) {
            ext = null;
            if (this.jCB_fileType.getSelectedItem() instanceof RMAFilenameFilter) {
                ext = ((RMAFilenameFilter)this.jCB_fileType.getSelectedItem()).getExtensions();
            } else {
                ext = new String[1];
                if (this.jCB_fileType.getSelectedItem() != null) {
                    ext[0] = this.jCB_fileType.getSelectedItem().toString();
                }
            }
            for (ii = 0; ii < ext.length; ++ii) {
                addToFileList = this._fileOpener.getFileList(this.jT_currentDir.getText(), ext[ii]);
                if (addToFileList == null) continue;
                fileList.addAll(addToFileList);
            }
        } else {
            ext = null;
            if (this.jCB_fileType.getSelectedItem() instanceof RMAFilenameFilter) {
                ext = ((RMAFilenameFilter)this.jCB_fileType.getSelectedItem()).getExtensions();
            } else {
                ext = new String[1];
                if (this.jCB_fileType.getSelectedItem() != null) {
                    ext[0] = this.jCB_fileType.getSelectedItem().toString();
                }
            }
            for (ii = 0; ii < ext.length; ++ii) {
                addToFileList = this.getLocalFileIDList(this.jT_currentDir.getText(), ext[ii]);
                if (addToFileList == null) continue;
                fileList.addAll(addToFileList);
            }
        }
        long date = 0L;
        long size = 0L;
        for (int i = 0; i < fileList.size(); ++i) {
            Object obj = fileList.elementAt(i);
            if (!(obj instanceof Identifier)) continue;
            Identifier id = (Identifier)obj;
            if (id._directory) {
                if (this._dirs.contains(id)) continue;
                this._dirs.addElement(id);
                continue;
            }
            if (this._openingDir) continue;
            if (this.jB_ListOnly.isSelected()) {
                files.addElement(id);
                continue;
            }
            HecFile file = id.getFile();
            Vector<Object> row = new Vector<Object>(3);
            row.add(id);
            date = id.lastModified();
            size = id.length();
            row.add(new Long(size));
            row.add(this._dateFormat.format(new Date(date)));
            files.add(row);
        }
        this.updateFileList(files);
        this.updateDirList(this._dirs);
        this.setCursor(Cursor.getDefaultCursor());
    }

    private void updateFileList(Vector<Object> files) {
        if (this.jB_ListOnly.isSelected()) {
            RmaListModel model = (RmaListModel)this.jL_files.getModel();
            model.removeAllElements();
            if (files != null) {
                model.addAll(files);
            }
            this.jL_files.ensureIndexIsVisible(0);
            this.jL_files.repaint();
            this.jL_files.revalidate();
        } else {
            this.jTbl_files.deleteCells();
            this.jTbl_files.setCells(files);
            this.jTbl_files.removeLastRow();
        }
    }

    private void updateDirList(Vector dirs) {
        ((RmaListModel)this.jL_directorys.getModel()).removeAllElements();
        ((RmaListModel)this.jL_directorys.getModel()).addAll((Collection)dirs);
        this.jL_directorys.ensureIndexIsVisible(0);
        this.jL_directorys.repaint();
        this.jL_directorys.revalidate();
    }

    private void directorySelected(MouseEvent evt) {
        if (evt.getClickCount() == 1) {
            this.directorySelected(false);
        } else if (evt.getClickCount() > 1) {
            this.directorySelected(true);
        }
    }

    private void directorySelected(boolean updateList) {
        if (this.jL_directorys.getSelectedValue() == null || this.jL_directorys.getSelectedValue().equals("")) {
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        Object obj = this.jL_directorys.getSelectedValue();
        String newdir = obj.toString();
        Object replDir = newdir.equals(PARENT_DIR) ? RmiFileDialog.stripDir(this.jT_currentDir.getText()) : this.jT_currentDir.getText() + (RmiFileDialog.isRootDir(this.jT_currentDir.getText()) ? "" : "/") + newdir;
        if (updateList) {
            this.setCurrentDir((String)replDir);
            this.updateLists();
            if (this.jL_directorys.getModel().getSize() < 1) {
                if (this.jFileScrollPane.getViewport().getView() == this.jL_files) {
                    if (this.jL_files.getModel().getSize() > 0 && !this._openingBoth) {
                        this.jL_files.setSelectedIndex(0);
                        this.jL_files.requestFocus();
                    }
                } else if (this.jFileScrollPane.getViewport().getView() == this.jTbl_files && this.jTbl_files.getRowCount() > 0) {
                    this.jTbl_files.setRowSelectionInterval(0, 0);
                    this.jTbl_files.requestFocus();
                }
            }
        } else {
            this.jT_currentFile.setText((String)replDir);
            this._selectedPaths.clear();
            this._selectedPaths.addElement((String)replDir);
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    private void fileSelectClicked(MouseEvent me) {
        if (this.jT_currentFile.getText() != null && me.getClickCount() >= 2) {
            this.jBok_Action();
        }
    }

    private void fileSelected(ListSelectionEvent evt) {
        int i;
        Object source = evt.getSource();
        Object[] objs = null;
        if (evt.getValueIsAdjusting()) {
            return;
        }
        String currentDir = this.jT_currentDir.getText();
        if (source == this.jL_files) {
            if (this.jL_files.getSelectedValue() == null || this.jL_files.getSelectedValue().equals("")) {
                return;
            }
            objs = this.jL_files.getSelectedValues();
        } else if (source == this.jTbl_files.getSelectionModel()) {
            int[] rows = this.jTbl_files.getSelectedRows();
            if (rows == null || rows.length < 1) {
                return;
            }
            objs = new Object[rows.length];
            for (i = 0; i < rows.length; ++i) {
                objs[i] = this.jTbl_files.getValueAt(rows[i], 0);
            }
        }
        if (objs[0].toString() instanceof String) {
            String newfile = objs[0].toString();
            StringBuffer buf = new StringBuffer();
            for (int i2 = 0; i2 < objs.length; ++i2) {
                if (i2 <= objs.length - 1 && i2 != 0) {
                    buf.append(", ");
                }
                buf.append(objs[i2].toString());
            }
            this.jT_currentFile.setText(buf.toString());
            try {
                this.jT_currentFile.setCaretPosition(0);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this._selectedPaths.removeAllElements();
        for (i = 0; i < objs.length; ++i) {
            String fullPath = currentDir + "/" + objs[i];
            if (this._selectedPaths.contains(fullPath)) continue;
            this._selectedPaths.addElement(fullPath);
        }
    }

    public boolean isCanceled() {
        return this._canceled;
    }

    private void setCanceled(boolean canceled) {
        this._canceled = canceled;
    }

    private void setSelectedFile(String selectedFile, String selectedDir) {
        this._selectedFile = selectedFile;
        this._selectedPaths.clear();
        String sep = "";
        if (!RmiFileDialog.isRootDir(selectedDir) && !this._openingDir) {
            sep = "/";
        }
        if (this._openingDir) {
            this._selectedPaths.addElement(selectedFile);
            this.firePropertyChange(DIRECTORY_SELECTED_PROPERTY, null, this._selectedFile);
            return;
        }
        StringTokenizer tokenizer = new StringTokenizer(selectedFile, ",");
        boolean hasPaths = tokenizer.hasMoreTokens();
        while (tokenizer.hasMoreTokens()) {
            String selectedPath = tokenizer.nextToken().trim();
            if (!selectedPath.startsWith(selectedDir)) {
                selectedPath = selectedDir.concat(sep).concat(selectedPath);
            }
            if (this._selectedPaths.contains(selectedPath)) continue;
            this._selectedPaths.add(selectedPath);
        }
        if (hasPaths) {
            this.firePropertyChange(PATHS_SELECTED_PROPERTY, null, this._selectedPaths);
        } else {
            this.firePropertyChange(FILE_SELECTED_PROPERTY, null, this._selectedFile);
        }
    }

    public Identifier getIdentifier() {
        if (this._selectedPaths.isEmpty()) {
            return null;
        }
        Identifier id = new Identifier(this._selectedPaths.get(0));
        Identifier returnId = this._fileOpener.openFile(id, false);
        if (returnId == null) {
            returnId = id;
        }
        returnId.setName(this._selectedFile);
        return returnId;
    }

    public Identifier[] getIdentifierList() {
        Identifier[] selections = new Identifier[this._selectedPaths.size()];
        for (int i = 0; i < selections.length; ++i) {
            Identifier id = new Identifier(this._selectedPaths.get(i));
            Identifier returnId = this._fileOpener.openFile(id, false);
            if (returnId == null) {
                returnId = id;
            }
            selections[i] = returnId;
        }
        return selections;
    }

    public String getDirectory() {
        return this.jT_currentDir.getText();
    }

    private void enterPressed() {
        Component c = SwingUtilities.findFocusOwner((Component)((Object)this));
        if (c == this.jL_directorys) {
            return;
        }
        JButton b = this.getRootPane().getDefaultButton();
        if (b != null) {
            b.doClick();
        }
    }

    private static boolean isRootDir(String d) {
        if (d.length() == 0) {
            return false;
        }
        if (d.charAt(0) == '/' && d.length() == 1) {
            return true;
        }
        return d.length() > 1 && d.charAt(1) == ':' && (d.length() == 2 || d.length() == 3);
    }

    private static String stripDir(String dir) {
        int idx = dir.lastIndexOf("/");
        if (idx < 0) {
            return "/";
        }
        Object newdir = dir.substring(0, idx);
        if (((String)newdir).length() == 0 || ((String)newdir).length() == 2 && ((String)newdir).charAt(1) == ':') {
            int len = ((String)newdir).length() - 1;
            if (len < 0) {
                len = 0;
            }
            if (len == 0 || ((String)newdir).charAt(len) != "/".charAt(0)) {
                newdir = (String)newdir + "/";
            }
        }
        return newdir;
    }

    private Vector<String> getDrives() {
        Vector<String> driveList = new Vector<String>();
        if (this.jRB_local.isSelected()) {
            File[] rootList = File.listRoots();
            for (int i = 0; i < rootList.length; ++i) {
                driveList.addElement(rootList[i].getPath().replace('\\', '/'));
            }
        } else {
            List drivesBack = this._fileOpener.getDriveList();
            for (int i = 0; i < drivesBack.size(); ++i) {
                Object obj = drivesBack.get(i);
                if (!(obj instanceof Identifier)) continue;
                driveList.addElement(((Identifier)obj).getPath().replace('\\', '/'));
            }
        }
        return driveList;
    }

    private Vector<Identifier> getLocalFileIDList(String dirName, String stringFilter) {
        String sep = "/";
        WildCardFileFilter filter = null;
        if (stringFilter != null) {
            filter = new WildCardFileFilter(stringFilter);
        }
        Vector<Identifier> vectorList = new Vector<Identifier>();
        File dir = new File(dirName);
        if (dir == null) {
            return vectorList;
        }
        File file = null;
        if (dir.isDirectory()) {
            String[] stringList = null;
            stringList = filter == null ? dir.list() : dir.list((FilenameFilter)filter);
            if (stringList == null) {
                return vectorList;
            }
            for (int ii = 0; ii < stringList.length; ++ii) {
                String fileRelativePath = dirName + sep + stringList[ii];
                Identifier pathId = new Identifier(fileRelativePath);
                pathId.setName(stringList[ii]);
                file = new File(fileRelativePath);
                pathId.initToFile(file);
                vectorList.add(pathId);
            }
        }
        return vectorList;
    }

    public void setCancelInvisible() {
        this.jB_cancel.setVisible(false);
        this.jB_cancel.setEnabled(false);
    }

    public void setOkButtonVisible(boolean visible) {
        this.jB_ok.setVisible(visible);
    }

    public void setVisibleActionsEnabled(boolean tf) {
        this._visibleActionsEnabled = tf;
    }

    public void setMultipleSelectionAllowed(boolean b) {
        if (b) {
            this.jL_files.setSelectionMode(2);
            this.jTbl_files.setSelectionMode(2);
        } else {
            this.jL_files.setSelectionMode(0);
            this.jTbl_files.setSelectionMode(0);
        }
    }

    public void fileProperties(MouseEvent me) {
        final MouseEvent finalMe = me;
        this._propPopup = new JPopupMenu("Properties");
        JMenuItem item = new JMenuItem("Properties");
        this._propPopup.add(item);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int index;
                if (finalMe == null) {
                    return;
                }
                Identifier id = null;
                if (finalMe.getSource() == RmiFileDialog.this.jL_files) {
                    index = RmiFileDialog.this.jL_files.locationToIndex(finalMe.getPoint());
                    if (index < 0) {
                        return;
                    }
                    id = (Identifier)RmiFileDialog.this.jL_files.getModel().getElementAt(index);
                } else if (finalMe.getSource() == RmiFileDialog.this.jTbl_files) {
                    int row = RmiFileDialog.this.jTbl_files.rowAtPoint(finalMe.getPoint());
                    if (row < 0) {
                        return;
                    }
                    id = (Identifier)RmiFileDialog.this.jTbl_files.getValueAt(row, 0);
                } else if (finalMe.getSource() == RmiFileDialog.this.jL_directorys) {
                    index = RmiFileDialog.this.jL_directorys.locationToIndex(finalMe.getPoint());
                    if (index < 0) {
                        return;
                    }
                    id = (Identifier)RmiFileDialog.this.jL_directorys.getModel().getElementAt(index);
                }
                if (id != null) {
                    FilePropertiesJDialog dialog = new FilePropertiesJDialog((Dialog)((Object)RmiFileDialog.this), true);
                    dialog.fillForm(id);
                    dialog.setVisible(true);
                }
            }
        });
        this._propPopup.show((Component)me.getSource(), me.getPoint().x, me.getPoint().y);
    }

    public void setTopFolder(String startFolder) {
        this._topFolder = startFolder;
    }

    public class NewDirDialog
    extends RmaJDialog {
        private JPanel jPanel;
        private JTextField jT_newDir;
        private JButton jB_Ok;
        private JButton jB_Cancel;
        private boolean _canceled;

        public NewDirDialog(Dialog owner, boolean modal) {
            super(owner, modal);
            this.jPanel = null;
            this.jT_newDir = null;
            this.jB_Ok = null;
            this.jB_Cancel = null;
            this._canceled = false;
            this.buildControls();
        }

        public NewDirDialog(Frame owner, boolean modal) {
            super(owner, modal);
            this.jPanel = null;
            this.jT_newDir = null;
            this.jB_Ok = null;
            this.jB_Cancel = null;
            this._canceled = false;
            this.buildControls();
        }

        private void buildControls() {
            int iy;
            this.setTitle("Create Folder");
            GridBagLayout gridBagLayout = new GridBagLayout();
            this.getContentPane().setLayout(gridBagLayout);
            this.setVisible(false);
            this.setSize(325, 100);
            this.setResizable(false);
            this.jPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.fill = 1;
            gbc.insets = new Insets(0, 0, 0, 0);
            gbc.ipady = 315;
            this.getContentPane().add((Component)this.jPanel, gbc);
            JPanel panel = this.buildDialog();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.weightx = 1.0;
            gbc.anchor = 11;
            gbc.fill = 1;
            gbc.insets = new Insets(0, 0, 0, 15);
            ((GridBagLayout)this.jPanel.getLayout()).setConstraints(panel, gbc);
            this.jPanel.add(panel);
            this.registerEnterKey(true);
            this.registerEscapeKey(true);
            this.getRootPane().setDefaultButton(this.jB_Ok);
            Rectangle bounds = RmiFileDialog.this.getBounds();
            Rectangle abounds = this.getBounds();
            int ix = bounds.x + (bounds.width - abounds.width) / 2;
            if (ix < 10) {
                ix = 10;
            }
            if ((iy = bounds.y + (bounds.height - abounds.height) / 2) < 10) {
                iy = 10;
            }
            this.setLocation(ix, iy);
        }

        private JPanel buildDialog() {
            JPanel panel = RmiFileDialog.this.buildPanel(0, 0, 0, 0);
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.weightx = 1.0;
            gbc.anchor = 11;
            gbc.fill = 1;
            gbc.insets = new Insets(0, 0, 0, 0);
            JLabel label = new JLabel("Folder Name: ");
            label.setDisplayedMnemonic('f');
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.weightx = 1.0;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = new Insets(5, 5, 0, 0);
            panel.add((Component)label, gbc);
            this.jT_newDir = new JTextField((Document)new FilenameDocument(), "", 10);
            label.setLabelFor(this.jT_newDir);
            this.jT_newDir.setActionCommand("currentFile");
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 0;
            gbc.weightx = 2.0;
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.insets = new Insets(5, 5, 0, 0);
            panel.add((Component)this.jT_newDir, gbc);
            JPanel buttonPanel = new JPanel(new GridBagLayout());
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.gridwidth = 2;
            gbc.weightx = 1.0;
            gbc.anchor = 14;
            gbc.fill = 0;
            gbc.insets = new Insets(2, 5, 0, 5);
            panel.add((Component)buttonPanel, gbc);
            this.jB_Ok = new JButton("OK");
            this.jB_Ok.setActionCommand("ok");
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.weightx = 1.0;
            gbc.anchor = 10;
            gbc.fill = 0;
            gbc.insets = new Insets(2, 5, 5, 5);
            buttonPanel.add((Component)this.jB_Ok, gbc);
            this.jB_Cancel = new JButton("Cancel");
            this.jB_Cancel.setActionCommand("cancel");
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 0;
            gbc.weightx = 1.0;
            gbc.anchor = 10;
            gbc.fill = 0;
            gbc.insets = new Insets(2, 5, 5, 5);
            buttonPanel.add((Component)this.jB_Cancel, gbc);
            this.jB_Ok.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    NewDirDialog.this.jBOk_Action();
                }
            });
            this.jB_Cancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    NewDirDialog.this.jBCancel_Action();
                }
            });
            return panel;
        }

        private void jBCancel_Action() {
            this._canceled = true;
            this.setVisible(false);
        }

        private void jBOk_Action() {
            if (this.jT_newDir.getText() == null || this.jT_newDir.getText().equals("")) {
                JOptionPane.showMessageDialog((Component)((Object)this), "Folder name can not be empty");
                return;
            }
            this._canceled = false;
            this.setVisible(false);
        }

        public String getNewDirName() {
            if (this._canceled) {
                return null;
            }
            return this.jT_newDir.getText();
        }

        public void clearNewDirName() {
            this.jT_newDir.setText("");
        }

        public void setVisible() {
            Rectangle bounds = this.getParent().getBounds();
            Rectangle abounds = this.getBounds();
            this.setLocation(bounds.x + (bounds.width - abounds.width) / 2, bounds.y + (bounds.height - abounds.height) / 2);
            this.jT_newDir.requestFocus();
            super.setVisible(true);
        }
    }

    private static class Shortcut {
        String buttonText;
        String directory;
        String buttonIcon;

        Shortcut(String text, String location, String iconName) {
            this.buttonText = text;
            this.directory = location;
            this.buttonIcon = iconName;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Shortcut)) {
                return false;
            }
            return this.buttonText.equals(((Shortcut)obj).buttonText);
        }
    }

    class DriveCellRenderer
    extends JLabel
    implements ListCellRenderer {
        Icon hdIcon;
        Icon floppyIcon;
        Color selectedBackground = UIManager.getColor("ComboBox.selectionBackground");
        Color selectedForeground = UIManager.getColor("ComboBox.selectionForeground");
        Color background = UIManager.getColor("ComboBox.background");
        Color foreground = UIManager.getColor("ComboBox.foreground");
        Map<String, Icon> _driveIcons = new HashMap<String, Icon>();

        public DriveCellRenderer() {
            try {
                this.hdIcon = UIManager.getIcon("FileView.hardDriveIcon");
                this.floppyIcon = UIManager.getIcon("FileView.floppyDriveIcon");
            }
            catch (Exception e) {
                this.hdIcon = null;
                this.floppyIcon = null;
            }
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            block13: {
                if (value == null) {
                    return this;
                }
                String s = value.toString();
                this.setText(s);
                char drive = s.charAt(0);
                String driveString = Character.toString(drive);
                Icon icon = this._driveIcons.get(driveString);
                if (icon != null) {
                    this.setIcon(icon);
                } else if (AppDaddy.getApp() != null && !AppDaddy.getApp().isNetworked()) {
                    try {
                        File f = new File(s);
                        if (f.exists()) {
                            Icon i = RmiFileDialog.this._fsv.getSystemIcon(new File(s));
                            this.setIcon(i);
                            this._driveIcons.put(driveString, i);
                            break block13;
                        }
                        if (this.floppyIcon == null || this.hdIcon == null) break block13;
                        if (Character.toUpperCase(drive) == 'A' || Character.toUpperCase(drive) == 'B') {
                            this.setIcon(this.floppyIcon);
                            this._driveIcons.put(driveString, this.floppyIcon);
                            break block13;
                        }
                        this.setIcon(this.hdIcon);
                        this._driveIcons.put(driveString, this.hdIcon);
                    }
                    catch (Exception e) {
                        if (this.floppyIcon == null || this.hdIcon == null) break block13;
                        if (Character.toUpperCase(drive) == 'A' || Character.toUpperCase(drive) == 'B') {
                            this.setIcon(this.floppyIcon);
                            this._driveIcons.put(driveString, this.floppyIcon);
                            break block13;
                        }
                        this.setIcon(this.hdIcon);
                        this._driveIcons.put(driveString, this.hdIcon);
                    }
                } else if (this.floppyIcon != null && this.hdIcon != null) {
                    if (Character.toUpperCase(drive) == 'A' || Character.toUpperCase(drive) == 'B') {
                        this.setIcon(this.floppyIcon);
                        this._driveIcons.put(driveString, this.floppyIcon);
                    } else {
                        this.setIcon(this.hdIcon);
                        this._driveIcons.put(driveString, this.hdIcon);
                    }
                }
            }
            this.setBackground(isSelected ? this.selectedBackground : this.background);
            this.setForeground(isSelected ? this.selectedForeground : this.foreground);
            return this;
        }
    }

    class MyListCellRenderer
    extends JLabel
    implements ListCellRenderer {
        Icon icon = null;
        Color selectedBackground = UIManager.getColor("List.selectionBackground");
        Color selectedForeground = UIManager.getColor("List.selectionForeground");
        Color background = UIManager.getColor("List.background");
        Color foreground = UIManager.getColor("List.foreground");
        Border noFocusBorder;
        HashMap<String, Icon> _iconCache = new HashMap();

        public MyListCellRenderer(String iconName) {
            this.noFocusBorder = new EmptyBorder(1, 1, 1, 1);
            this.setOpaque(true);
            if (UIManager.getLookAndFeel().getName().indexOf("Metal") > -1) {
                this.icon = null;
                return;
            }
            try {
                this.icon = UIManager.getIcon(iconName);
            }
            catch (Exception e) {
                this.icon = null;
            }
            this._iconCache.put("C:/pagefile.sys", this.icon);
        }

        public Icon getIcon(String file) {
            String dir = RmiFileDialog.this.jT_currentDir.getText();
            if (!dir.endsWith("/")) {
                dir = dir.concat("/");
            }
            String fullName = dir + file;
            Icon obj = this._iconCache.get(fullName);
            Icon theIcon = null;
            if (obj == null) {
                block12: {
                    if (AppDaddy.getApp() != null && !AppDaddy.getApp().isNetworked()) {
                        try {
                            File f = new File(fullName);
                            if (f.exists()) {
                                theIcon = RmiFileDialog.this._fsv.getSystemIcon(new File(fullName));
                            } else if (this.icon != null) {
                                theIcon = this.icon;
                            }
                            break block12;
                        }
                        catch (Exception e) {
                            if (this.icon != null) {
                                theIcon = this.icon;
                            }
                            break block12;
                        }
                    }
                    if (this.icon != null) {
                        theIcon = this.icon;
                    }
                }
                if (theIcon != null) {
                    this._iconCache.put(file, theIcon);
                }
            } else {
                theIcon = obj;
            }
            return theIcon;
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value == null) {
                return this;
            }
            String s = value.toString();
            this.setText(s);
            Icon theIcon = this.getIcon(s);
            this.setIcon(theIcon);
            this.setBackground(isSelected ? this.selectedBackground : this.background);
            this.setForeground(isSelected ? this.selectedForeground : this.foreground);
            this.setBorder(cellHasFocus ? UIManager.getBorder("List.focusCellHighlightBorder") : this.noFocusBorder);
            return this;
        }
    }

    private static class FileSizeComparator
    implements Comparator<Object> {
        private FileSizeComparator() {
        }

        @Override
        public int compare(Object one, Object two) {
            Long longOne = null;
            Long longTwo = null;
            if (one instanceof Long) {
                longOne = (Long)one;
            }
            if (two instanceof Long) {
                longTwo = (Long)two;
            }
            if (one instanceof String) {
                longOne = RMAIO.parseLong((String)((String)one));
            }
            if (two instanceof String) {
                longTwo = RMAIO.parseLong((String)((String)two));
            }
            if (longOne != null && longTwo != null) {
                return Long.compare(longOne, longTwo);
            }
            LOGGER.log(Level.WARNING, "Invalid comparison of " + one + " and " + two);
            return 0;
        }
    }

    private class ModifiedDateComparator
    implements Comparator<String> {
        private ModifiedDateComparator() {
        }

        @Override
        public int compare(String one, String two) {
            try {
                Date dateOne = RmiFileDialog.this._dateFormat.parse(one);
                Date dateTwo = RmiFileDialog.this._dateFormat.parse(two);
                return dateOne.compareTo(dateTwo);
            }
            catch (ParseException e) {
                LOGGER.log(Level.WARNING, "Invalid date!", e);
                return 0;
            }
        }
    }
}

