/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.rmi.client;

import java.lang.reflect.Method;
import java.rmi.Remote;
import mil.army.usace.hec.rmi.csinterface.Naming;

public class RmiPortScanner {
    public static void main(String[] args) {
        if (args.length < 1) {
            RmiPortScanner.printUsage();
        }
        boolean fullDisplay = false;
        Object url = null;
        if (args.length > 1) {
            if ("-f".equalsIgnoreCase(args[0])) {
                fullDisplay = true;
                url = args[1];
            } else if ("-f".equalsIgnoreCase(args[1])) {
                fullDisplay = true;
                url = args[0];
            }
        } else {
            url = args[0];
        }
        if (url == null) {
            RmiPortScanner.printUsage();
            return;
        }
        if (((String)url).indexOf("/") == -1) {
            url = "//" + (String)url;
        }
        try {
            String[] names = Naming.list((String)url);
            for (int ii = 0; ii < names.length; ++ii) {
                System.out.println(names[ii]);
            }
            if (fullDisplay) {
                RmiPortScanner.displayFullInfo(names);
            }
        }
        catch (Exception e) {
            System.out.println(e);
            System.exit(1);
        }
        System.exit(0);
    }

    protected static void printUsage() {
        System.out.println("use:  RmiPortScanner [-f] url \nex:   RmiPortScanner 207.214.198.115:8089");
        System.exit(-1);
    }

    protected static void displayFullInfo(String[] names) {
        for (String name : names) {
            try {
                Remote remote = Naming.lookup(name);
                System.out.println("Info for " + name);
                System.out.println("Class is " + remote.getClass().getName());
                Class<?>[] interfaces = remote.getClass().getInterfaces();
                System.out.println("Interfaces implemented are:");
                for (Class<?> anInterface : interfaces) {
                    System.out.println("\t" + anInterface.getName());
                    Method[] methods = anInterface.getMethods();
                    if (methods.length <= 0) continue;
                    System.out.println("\t\tMethods:");
                    for (Method method : methods) {
                        System.out.println("\t\t" + method.toString());
                    }
                }
            }
            catch (Exception e) {
                System.out.println("Error retrieving object in registry for " + name + " Error=" + e);
            }
        }
    }
}

