/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.rmi.client;

import hec.io.Identifier;
import hec.lang.PreferencesConstants;
import hec.lang.UserId;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.rmi.RemoteException;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import mil.army.usace.hec.rmi.csinterface.RmiFileManager;
import mil.army.usace.hec.rmi.model.PreferencesManager;
import rma.swing.ButtonCmdPanel;
import rma.swing.ButtonCmdPanelListener;
import rma.swing.RmaInsets;
import rma.swing.RmaJDialog;
import rma.swing.RmaJList;
import rma.swing.RmaJRadioButton;
import rma.swing.RmaJTextField;
import rma.swing.list.RmaListModel;
import rma.util.RMAIO;

public class SavePreferencesDialog
extends RmaJDialog
implements PreferencesConstants {
    private boolean _canceled = false;
    private Vector _filters = new Vector();
    private RmiFileManager _fileManager;
    private String _subDir = null;
    private String _defaultName = null;
    protected RmaJRadioButton allWatershedsLocRB;
    protected RmaJRadioButton thisWatershedLocRB;
    protected RmaJRadioButton thisWatershedThisAppRB;
    protected Vector _userDefinedRadioButtons = new Vector();
    private ActionListener _radioActionListener;
    private int _nextRadioButtonPanelRow = 0;
    private JPanel radioButtonPanel;
    private RmaJList filesList;
    protected JLabel nameLabel;
    protected RmaJTextField nameTxt;
    protected JScrollPane filesListSP;
    protected ButtonCmdPanel cmdPanel;
    protected ButtonGroup _buttonGroup;
    protected boolean _showFileExtensions = false;

    public SavePreferencesDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.buildControls();
    }

    public SavePreferencesDialog(Dialog parent, boolean modal) {
        super(parent, modal);
        this.buildControls();
    }

    protected void buildControls() {
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Save Preference");
        this._buttonGroup = new ButtonGroup();
        this.radioButtonPanel = new JPanel(new GridBagLayout());
        this.radioButtonPanel.setBorder(new TitledBorder("Availability"));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.gridwidth = 2;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this.getContentPane().add((Component)this.radioButtonPanel, gbc);
        this.allWatershedsLocRB = new RmaJRadioButton("All Applications");
        this.allWatershedsLocRB.setActionCommand("");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets((int)0, (int)5, (int)0, (int)5);
        this.radioButtonPanel.add((Component)this.allWatershedsLocRB, gbc);
        this.thisWatershedLocRB = new RmaJRadioButton("This Watershed only");
        this.thisWatershedLocRB.setActionCommand("");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets((int)0, (int)5, (int)0, (int)5);
        this.radioButtonPanel.add((Component)this.thisWatershedLocRB, gbc);
        this._nextRadioButtonPanelRow = 2;
        this.filesList = new RmaJList((ListModel)new RmaListModel(true));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridwidth = 2;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = RmaInsets.insets((int)0, (int)5, (int)0, (int)5);
        this.filesListSP = new JScrollPane((Component)this.filesList);
        this.getContentPane().add((Component)this.filesListSP, gbc);
        this.nameLabel = new JLabel("Name:", 4);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this.getContentPane().add((Component)this.nameLabel, gbc);
        this.nameTxt = new RmaJTextField(20);
        this.nameTxt.setTrimWhiteSpace(true);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.weightx = 1.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this.getContentPane().add((Component)this.nameTxt, gbc);
        this.cmdPanel = new ButtonCmdPanel(12);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.weightx = 1.0;
        gbc.gridwidth = 2;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this.getContentPane().add((Component)this.cmdPanel, gbc);
        this._radioActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SavePreferencesDialog.this.updateList();
            }
        };
        this.allWatershedsLocRB.addActionListener(this._radioActionListener);
        this.thisWatershedLocRB.addActionListener(this._radioActionListener);
        this.filesList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                SavePreferencesDialog.this.listItemSelected();
            }
        });
        this.cmdPanel.addCmdPanelListener(new ButtonCmdPanelListener(){

            public void buttonCmdActionPerformed(ActionEvent e) {
                switch (e.getID()) {
                    case 8: {
                        if (!SavePreferencesDialog.this.validForm()) break;
                        SavePreferencesDialog.this._canceled = false;
                        SavePreferencesDialog.this.setVisible(false);
                        break;
                    }
                    case 4: {
                        SavePreferencesDialog.this._canceled = true;
                        SavePreferencesDialog.this.setVisible(false);
                    }
                }
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                SavePreferencesDialog.this._canceled = true;
            }
        });
        this._buttonGroup.add((AbstractButton)this.allWatershedsLocRB);
        this._buttonGroup.add((AbstractButton)this.thisWatershedLocRB);
        this.thisWatershedLocRB.setSelected(true);
        this.pack();
        this.setDefaultSize(this.getPreferredSize().height, this.getPreferredSize().width);
        this.setLocation();
    }

    protected boolean validForm() {
        if (this._buttonGroup.getSelection() == null) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Please select a location to save to.", "No Location Selected", 1);
            return false;
        }
        if (this.nameTxt.isVisible() && this.nameTxt.getText().length() < 1) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Please enter a preference name.", "No Name Specified", 1);
            return false;
        }
        return true;
    }

    private JRadioButton getSelectedRadioButton() {
        if (this.allWatershedsLocRB.isSelected()) {
            return this.allWatershedsLocRB;
        }
        if (this.thisWatershedLocRB.isSelected()) {
            return this.thisWatershedLocRB;
        }
        int size = this._userDefinedRadioButtons.size();
        for (int i = 0; i < size; ++i) {
            JRadioButton rb = (JRadioButton)this._userDefinedRadioButtons.get(i);
            if (!rb.isSelected()) continue;
            return rb;
        }
        return null;
    }

    public int getPreferenceLocation() {
        if (this.allWatershedsLocRB.isSelected()) {
            return 1;
        }
        if (this.thisWatershedLocRB.isSelected()) {
            return 0;
        }
        int size = this._userDefinedRadioButtons.size();
        for (int i = 0; i < size; ++i) {
            JRadioButton rb = (JRadioButton)this._userDefinedRadioButtons.get(i);
            if (!rb.isSelected()) continue;
            return RMAIO.parseInt((String)rb.getName(), (int)-2);
        }
        return -1;
    }

    public String getPreferenceName() {
        return RMAIO.userNameToFileName((String)this.nameTxt.getText());
    }

    public void setFileManager(RmiFileManager fm) {
        this._fileManager = fm;
    }

    public void setVisible(boolean b) {
        if (b && this._fileManager == null) {
            this.filesListSP.setVisible(false);
            this.pack();
        }
        super.setVisible(b);
    }

    protected void listItemSelected() {
        String value = this.filesList.getSelectedValue().toString();
        this.nameTxt.setText(value);
    }

    public boolean isCanceled() {
        return this._canceled;
    }

    public Identifier getIdentifier() {
        String subDir = this.getSubDir();
        String fileName = (String)(subDir != null ? subDir + "/" : "") + this.nameTxt.getText();
        String filePath = PreferencesManager.getFileName(this.getPreferenceLocation(), fileName);
        return new Identifier(filePath);
    }

    public void updateList() {
        if (this._fileManager == null) {
            return;
        }
        Object path = PreferencesManager.getDirectoryForLocation(this.getPreferenceLocation());
        if (this._subDir != null) {
            path = (String)path + "/" + this.getSubDir();
        }
        System.out.println("updateList: getting listing for " + (String)path);
        Vector<Identifier> idList = null;
        try {
            idList = this._fileManager.getRemoteFileIDList(UserId.getUserId(), (String)path, this._filters);
        }
        catch (RemoteException re) {
            System.out.println("updateList: RMI error getting list of files from FileManager " + re);
        }
        RmaListModel model = (RmaListModel)this.filesList.getModel();
        model.clear();
        for (int i = idList.size() - 1; i >= 0; --i) {
            String name;
            int idx;
            Identifier id = idList.get(i);
            if (id._directory) {
                idList.remove(i);
                continue;
            }
            if (this._showFileExtensions || (idx = (name = id.getName()).lastIndexOf(".")) == -1) continue;
            id.setName(name.substring(0, idx));
        }
        if (idList != null) {
            model.addAll(idList);
        }
    }

    public void setFileFilters(Vector filters) {
        this._filters.clear();
        this._filters.addAll(filters);
    }

    public void setSubDirectory(String subDir) {
        this._subDir = subDir;
        this.allWatershedsLocRB.setActionCommand(subDir);
        this.thisWatershedLocRB.setActionCommand(subDir);
    }

    public void setNameSelectable(boolean b) {
        this.filesListSP.setVisible(b);
        this.nameTxt.setVisible(b);
        this.pack();
    }

    public void setDefaultName(String name) {
        this._defaultName = name;
        if (this._defaultName != null) {
            this.nameTxt.setText(this._defaultName);
        }
    }

    public void addUserDefinedLocation(String label, String subDir, int location) {
        RmaJRadioButton userDefinedRadio = new RmaJRadioButton(label);
        userDefinedRadio.setActionCommand(subDir == null ? "" : subDir);
        userDefinedRadio.setName("" + location);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = this._nextRadioButtonPanelRow++;
        gbc.weightx = 1.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets((int)0, (int)5, (int)0, (int)5);
        this.radioButtonPanel.add((Component)userDefinedRadio, gbc);
        this._userDefinedRadioButtons.add(userDefinedRadio);
        userDefinedRadio.addActionListener(this._radioActionListener);
        this._buttonGroup.add((AbstractButton)userDefinedRadio);
        this.pack();
    }

    public String getSubDir() {
        JRadioButton rb = this.getSelectedRadioButton();
        if (rb == null) {
            return "";
        }
        return rb.getActionCommand();
    }

    public void setShowFileExtensions(boolean showEm) {
        this._showFileExtensions = showEm;
    }

    public static void main(String[] args) {
        new SavePreferencesDialog(new Frame(), false).setVisible(true);
    }
}

