/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.rmi.csinterface;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.rmi.AlreadyBoundException;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMISocketFactory;
import java.util.Objects;
import mil.army.usace.hec.rmi.server.LimitedPortServerSocketFactory;

public final class Naming {
    private static RMIClientSocketFactory _socketFactory = new LimitedPortServerSocketFactory();

    private Naming() {
    }

    public static Remote lookup(String name, Class[] references) throws NotBoundException, MalformedURLException, RemoteException {
        ParsedNamingURL parsed = Naming.parseURL(name);
        Registry registry = Naming.getRegistry(parsed);
        if (parsed.name == null) {
            return registry;
        }
        return registry.lookup(parsed.name);
    }

    public static Remote lookup(String name) throws NotBoundException, MalformedURLException, RemoteException {
        ParsedNamingURL parsed = Naming.parseURL(name);
        Registry registry = Naming.getRegistry(parsed);
        if (parsed.name == null) {
            return registry;
        }
        return registry.lookup(parsed.name);
    }

    public static void bind(String name, Remote obj) throws AlreadyBoundException, MalformedURLException, RemoteException {
        ParsedNamingURL parsed = Naming.parseURL(name);
        Registry registry = Naming.getRegistry(parsed);
        if (obj == null) {
            throw new NullPointerException("cannot bind to null");
        }
        registry.bind(parsed.name, obj);
    }

    public static void unbind(String name) throws RemoteException, NotBoundException, MalformedURLException {
        ParsedNamingURL parsed = Naming.parseURL(name);
        Registry registry = Naming.getRegistry(parsed);
        registry.unbind(parsed.name);
    }

    public static void rebind(String name, Remote obj) throws RemoteException, MalformedURLException {
        Objects.requireNonNull(obj, "cannot bind to null");
        ParsedNamingURL parsed = Naming.parseURL(name);
        Registry registry = Naming.getRegistry(parsed);
        registry.rebind(parsed.name, obj);
    }

    public static String[] list(String name) throws RemoteException, MalformedURLException {
        ParsedNamingURL parsed = Naming.parseURL(name);
        Registry registry = Naming.getRegistry(parsed);
        Object prefix = "";
        if (parsed.port > 0 || !parsed.host.equals("")) {
            prefix = (String)prefix + "//" + parsed.host;
        }
        if (parsed.port > 0) {
            prefix = (String)prefix + ":" + parsed.port;
        }
        prefix = (String)prefix + "/";
        String[] names = registry.list();
        for (int i = 0; i < names.length; ++i) {
            names[i] = (String)prefix + names[i];
        }
        return names;
    }

    private static Registry getRegistry(ParsedNamingURL parsed) throws RemoteException {
        RMIClientSocketFactory factory = RMISocketFactory.getSocketFactory();
        if (factory == null) {
            factory = _socketFactory;
        }
        return LocateRegistry.getRegistry(parsed.host, parsed.port, factory);
    }

    private static ParsedNamingURL parseURL(String str) throws MalformedURLException {
        try {
            int port;
            String host;
            URI uri = new URI(str);
            if (uri.getFragment() != null) {
                throw new MalformedURLException("invalid character, '#', in URL name: " + str);
            }
            if (uri.getQuery() != null) {
                throw new MalformedURLException("invalid character, '?', in URL name: " + str);
            }
            if (uri.getUserInfo() != null) {
                throw new MalformedURLException("invalid character, '@', in URL host: " + str);
            }
            String scheme = uri.getScheme();
            if (scheme != null && !scheme.equals("rmi")) {
                throw new MalformedURLException("invalid URL scheme: " + str);
            }
            String name = uri.getPath();
            if (name != null) {
                if (name.startsWith("/")) {
                    name = name.substring(1);
                }
                if (name.length() == 0) {
                    name = null;
                }
            }
            if ((host = uri.getHost()) == null) {
                Object authority;
                host = "";
                if (uri.getPort() == -1 && (authority = uri.getAuthority()) != null && ((String)authority).startsWith(":")) {
                    authority = "localhost" + (String)authority;
                    uri = new URI(null, (String)authority, null, null, null);
                }
            }
            if ((port = uri.getPort()) == -1) {
                port = 1099;
            }
            return new ParsedNamingURL(host, port, name);
        }
        catch (URISyntaxException ex) {
            throw (MalformedURLException)new MalformedURLException("invalid URL string: " + str).initCause(ex);
        }
    }

    private static class ParsedNamingURL {
        String host;
        int port;
        String name;

        ParsedNamingURL(String host, int port, String name) {
            this.host = host;
            this.port = port;
            this.name = name;
        }
    }
}

