/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.rmi.extractpost;

import com.google.common.flogger.FluentLogger;
import hec.lang.Const;
import hec.lang.Transaction;
import java.io.Serializable;
import java.util.Objects;
import java.util.SimpleTimeZone;
import java.util.StringTokenizer;
import java.util.TimeZone;
import mil.army.usace.hec.rmi.csinterface.ClientServerUtil;
import mil.army.usace.hec.rmi.csinterface.DSSManager;
import mil.army.usace.hec.rmi.csinterface.RmiFileManager;
import mil.army.usace.hec.rmi.extractpost.ListFileModel;
import mil.army.usace.hec.rmi.extractpost.ListStatisticsModel;
import mil.army.usace.hec.rmi.msgsystem.Msg;
import rma.util.RMAIO;
import rma.util.Timer;

public final class DssAction
implements Serializable,
Transaction {
    private static final long serialVersionUID = -6850000963810531601L;
    private static final FluentLogger LOGGER = FluentLogger.forEnclosingClass();
    private static final String DELIM = ";";
    private static final String KEY_FUNCTION = "Function";
    public static final String FUNCTION_EXTRACT = "ExtractToDss";
    public static final String FUNCTION_POST = "PostToOracle";
    private static final String KEY_REQUEST = "RequestType";
    private static final String REQUEST_DO_FUNCTION = "DoFunction";
    private static final String REQUEST_CONFIRMATION = "Confirmation";
    private static final String KEY_START_TIME_STANDARD = "StartTimeStandard";
    private static final String KEY_START_TIME = "StartTime";
    private static final String KEY_END_TIME_STANDARD = "EndTimeStandard";
    private static final String KEY_END_TIME = "EndTime";
    private static final String KEY_TZ = "TZ";
    private static final String KEY_TZ_OVERRIDE = "TZOverride";
    private static final String KEY_EXTRACT_DSS_FILE = "DestinationDss";
    private static final String KEY_POST_DSS_FILE = "SourceDss";
    private static final String KEY_LIST_FILE = "ListFile";
    private static final String KEY_RULE = "ReplaceRule";
    private TimeZone _timeZone = null;
    private String _startTime = null;
    private String _endTime = null;
    private String _startTimeStandard = null;
    private String _endTimeStandard = null;
    private String _unparsedDssFilePath;
    private String _dssServerUrl = null;
    private Serializable _dssServerRemote = null;
    private String _parsedDssFilePath = null;
    private String _fileServerUrl = null;
    private Serializable _fileServerRemote = null;
    private String _unparsedListFilePath = null;
    private String _parsedListFilePath = null;
    private ListFileModel _listModel = null;
    private boolean _set = true;
    private String _request = null;
    private String _function = null;
    private int _rule;
    private boolean _overrideProtection = false;
    private Msg _msg;
    private String _body = null;
    private ListStatisticsModel _statisticsModel = null;
    private Serializable _fatalError = null;
    private Timer _timer = null;
    private boolean _processed;
    private String _processedBy;
    private TimeZone _timeZoneOverride;

    public DssAction(String to, String from) {
        this._msg = new Msg(to, from, "", 5);
    }

    public DssAction(Msg dssMsg) {
        this._msg = dssMsg;
        this._body = dssMsg.getBody();
        StringTokenizer st = new StringTokenizer(this._body, DELIM);
        int tc = st.countTokens();
        if (tc < 7) {
            this._set = false;
            this._fatalError = "DssAction: Only " + tc + " tokens. Should have 7 tokens delimited by ';'.";
        } else {
            while (st.hasMoreTokens()) {
                boolean tf;
                String line = st.nextToken();
                String type = RMAIO.getType((String)line, (String)"=");
                String param = RMAIO.getParam((String)line, (String)"=");
                if (type.equalsIgnoreCase(KEY_REQUEST)) {
                    tf = this.setRequest(param);
                    if (tf) continue;
                    this._set = false;
                    this._fatalError = "Invalid Request: " + param;
                    break;
                }
                if (type.equalsIgnoreCase(KEY_START_TIME)) {
                    tf = this.setStartTime(param);
                    if (tf) continue;
                    this._set = false;
                    this._fatalError = "Invalid Local Start Time: " + param;
                    break;
                }
                if (type.equalsIgnoreCase(KEY_START_TIME_STANDARD)) {
                    tf = this.setStartTimeStandard(param);
                    if (tf) continue;
                    this._set = false;
                    this._fatalError = "Invalid Standard Start Time: " + param;
                    break;
                }
                if (type.equalsIgnoreCase(KEY_END_TIME)) {
                    tf = this.setEndTime(param);
                    if (tf) continue;
                    this._set = false;
                    this._fatalError = "Invalid Local End Time: " + param;
                    break;
                }
                if (type.equalsIgnoreCase(KEY_END_TIME_STANDARD)) {
                    tf = this.setEndTimeStandard(param);
                    if (tf) continue;
                    this._set = false;
                    this._fatalError = "Invalid Standard End Time: " + param;
                    break;
                }
                if (type.equalsIgnoreCase(KEY_TZ)) {
                    this.setTimeZone(param);
                    continue;
                }
                if (type.equalsIgnoreCase(KEY_TZ_OVERRIDE)) {
                    this.setTimeZoneOverride(param);
                    continue;
                }
                if (type.equalsIgnoreCase(KEY_EXTRACT_DSS_FILE)) {
                    this.setDssUrl(param);
                    continue;
                }
                if (type.equalsIgnoreCase(KEY_POST_DSS_FILE)) {
                    this.setDssUrl(param);
                    continue;
                }
                if (type.equalsIgnoreCase(KEY_LIST_FILE)) {
                    this.setFileUrl(param);
                    continue;
                }
                if (type.equalsIgnoreCase(KEY_FUNCTION)) {
                    tf = this.setFunction(param);
                    if (tf) continue;
                    this._set = false;
                    this._fatalError = "Invalid Function: " + param;
                    break;
                }
                if (!type.equalsIgnoreCase(KEY_RULE) || (tf = this.setRule(param))) continue;
                this._set = false;
                this._fatalError = "Invalid Storage Option: " + param;
                break;
            }
            long starttime = this.getStartTime();
            long endtime = this.getEndTime();
            if (this._set && starttime >= endtime) {
                this._fatalError = "Start time must be before End time.";
                this._set = false;
            }
        }
        if (!this._set) {
            ((FluentLogger.Api)LOGGER.atSevere()).log(this._fatalError.toString());
        }
    }

    public String toString() {
        String ruleString;
        StringBuilder sb = new StringBuilder();
        String to = this.getTo();
        String from = this.getFrom();
        String source = this.getSource();
        if (to != null) {
            sb.append(to);
        } else {
            sb.append(" ");
        }
        sb.append(DELIM);
        if (from != null) {
            sb.append(from);
        } else {
            sb.append(" ");
        }
        sb.append(DELIM);
        if (source != null) {
            sb.append(source);
        } else {
            sb.append(" ");
        }
        sb.append("\n");
        if (this._request != null) {
            sb.append(KEY_REQUEST);
            sb.append("=");
            sb.append(this._request);
            sb.append(DELIM);
        }
        if (this._startTime != null) {
            sb.append(KEY_START_TIME);
            sb.append("=");
            sb.append(this._startTime);
            sb.append(DELIM);
        } else if (this._startTimeStandard != null) {
            sb.append(KEY_START_TIME_STANDARD);
            sb.append("=");
            sb.append(this._startTimeStandard);
            sb.append(DELIM);
        }
        if (this._endTime != null) {
            sb.append(KEY_END_TIME);
            sb.append("=");
            sb.append(this._endTime);
            sb.append(DELIM);
        } else if (this._endTimeStandard != null) {
            sb.append(KEY_END_TIME_STANDARD);
            sb.append("=");
            sb.append(this._endTimeStandard);
            sb.append(DELIM);
        }
        if (this._timeZone != null) {
            String tzStr = this._timeZone.getID();
            sb.append(KEY_TZ);
            sb.append("=");
            sb.append(tzStr);
            sb.append(DELIM);
        }
        if (this._function != null && this._dssServerUrl != null && this._unparsedDssFilePath != null) {
            String dssServer = RMAIO.getHostFromUrl((String)this._dssServerUrl, (boolean)false);
            String dssFile = this._unparsedDssFilePath;
            String dssUrl = dssServer + "/" + dssFile;
            if (this._function.equals(FUNCTION_EXTRACT)) {
                sb.append(KEY_EXTRACT_DSS_FILE);
                sb.append("=");
                sb.append(dssUrl);
                sb.append(DELIM);
            } else if (this._function.equals(FUNCTION_POST)) {
                sb.append(KEY_POST_DSS_FILE);
                sb.append("=");
                sb.append(dssUrl);
                sb.append(DELIM);
            }
        }
        if (this._fileServerUrl != null && this._unparsedListFilePath != null) {
            String fileServer = RMAIO.getHostFromUrl((String)this._fileServerUrl, (boolean)false);
            String listFile = this._unparsedListFilePath;
            String fileUrl = fileServer + "/" + listFile;
            sb.append(KEY_LIST_FILE);
            sb.append("=");
            sb.append(fileUrl);
            sb.append(DELIM);
        }
        if (this._function != null) {
            sb.append(KEY_FUNCTION);
            sb.append("=");
            sb.append(this._function);
            sb.append(DELIM);
        }
        if ((ruleString = Const.getRule((int)this._rule)) != null) {
            sb.append(KEY_RULE);
            sb.append("=");
            sb.append(ruleString);
            sb.append(DELIM);
        }
        sb.append("\n");
        return sb.toString();
    }

    public boolean isSet() {
        return this._set;
    }

    public boolean setRequest(String s) {
        if (s.equalsIgnoreCase(REQUEST_DO_FUNCTION)) {
            this._request = REQUEST_DO_FUNCTION;
        } else if (s.equalsIgnoreCase(REQUEST_CONFIRMATION)) {
            this._request = REQUEST_CONFIRMATION;
        } else {
            return false;
        }
        return true;
    }

    public boolean setFunction(String s) {
        if (s.equalsIgnoreCase(FUNCTION_EXTRACT)) {
            this._function = FUNCTION_EXTRACT;
        } else if (s.equalsIgnoreCase(FUNCTION_POST)) {
            this._function = FUNCTION_POST;
        } else {
            return false;
        }
        return true;
    }

    public boolean setStartTime(String startTime) {
        long starttime = RMAIO.parseDate((String)startTime);
        if (starttime == Long.MIN_VALUE) {
            return false;
        }
        this._startTime = startTime;
        this._startTimeStandard = null;
        return true;
    }

    public boolean setStartTimeStandard(String startTimeStandard) {
        long starttime = RMAIO.parseDate((String)startTimeStandard);
        if (starttime == Long.MIN_VALUE) {
            return false;
        }
        this._startTime = null;
        this._startTimeStandard = startTimeStandard;
        return true;
    }

    public boolean setEndTime(String endTime) {
        long endtime = RMAIO.parseDate((String)endTime);
        if (endtime == Long.MIN_VALUE) {
            return false;
        }
        this._endTime = endTime;
        this._endTimeStandard = null;
        return true;
    }

    public boolean setEndTimeStandard(String endTimeStandard) {
        long endtime = RMAIO.parseDate((String)endTimeStandard);
        if (endtime == Long.MIN_VALUE) {
            return false;
        }
        this._endTime = null;
        this._endTimeStandard = endTimeStandard;
        return true;
    }

    private void setTimeZone(String s) {
        this._timeZone = TimeZone.getTimeZone(s);
    }

    public void setTimeZone(TimeZone tz) {
        this._timeZone = tz;
    }

    private void setTimeZoneOverride(String s) {
        this._timeZoneOverride = TimeZone.getTimeZone(s);
    }

    public void setTimeZoneOverride(TimeZone tz) {
        this._timeZoneOverride = tz;
    }

    public TimeZone getTimeZoneOverride() {
        return this._timeZoneOverride;
    }

    public TimeZone getStandardTimeZoneOverride() {
        SimpleTimeZone tz = null;
        if (this._timeZoneOverride != null) {
            tz = new SimpleTimeZone(this._timeZoneOverride.getRawOffset(), this._timeZoneOverride.getID());
        }
        return tz;
    }

    public boolean setRule(String s) {
        int rule = Const.getRuleNumber((String)s);
        if (rule == Integer.MIN_VALUE) {
            return false;
        }
        this._rule = rule;
        this._overrideProtection = Const.getOverrideProtection((String)s);
        return true;
    }

    public void setOverrideProtection(boolean tf) {
        this._overrideProtection = tf;
    }

    public void setRule(int num) {
        this._rule = num;
    }

    public void setTimer(Timer timer) {
        this._timer = timer;
    }

    public Timer getTimer() {
        return this._timer;
    }

    public String getBody() {
        return this._body;
    }

    public long getStartTime() {
        if (this._startTime != null) {
            TimeZone tz = this.getTimeZoneOverride() != null ? this.getTimeZoneOverride() : this.getLocalTimeZoneObject();
            return RMAIO.parseDate((String)this._startTime, (TimeZone)tz);
        }
        if (this._startTimeStandard != null) {
            TimeZone tz = this.getTimeZoneOverride() != null ? this.getStandardTimeZoneOverride() : this.getStandardTimeZoneObject();
            return RMAIO.parseDate((String)this._startTimeStandard, (TimeZone)tz);
        }
        return Long.MIN_VALUE;
    }

    public long getEndTime() {
        if (this._endTime != null) {
            TimeZone tz = this.getTimeZoneOverride() != null ? this.getTimeZoneOverride() : this.getLocalTimeZoneObject();
            return RMAIO.parseDate((String)this._endTime, (TimeZone)tz);
        }
        if (this._endTimeStandard != null) {
            TimeZone tz = this.getTimeZoneOverride() != null ? this.getStandardTimeZoneOverride() : this.getStandardTimeZoneObject();
            return RMAIO.parseDate((String)this._endTimeStandard, (TimeZone)tz);
        }
        return Long.MIN_VALUE;
    }

    public TimeZone getTimeZone() {
        return this._timeZone;
    }

    public TimeZone getLocalTimeZoneObject() {
        return this._timeZone;
    }

    public TimeZone getStandardTimeZoneObject() {
        SimpleTimeZone tz = null;
        if (this._timeZone != null) {
            tz = new SimpleTimeZone(this._timeZone.getRawOffset(), this._timeZone.getID());
        }
        return tz;
    }

    public boolean getOverrideProtection() {
        return this._overrideProtection;
    }

    public String getTo() {
        return this._msg.getTo();
    }

    public String getFrom() {
        return this._msg.getFrom();
    }

    public String getSource() {
        return this._msg.getFrom();
    }

    public String getFunction() {
        return this._function;
    }

    public int getTransactionType() {
        if (this._function.equalsIgnoreCase(FUNCTION_EXTRACT)) {
            return 1000;
        }
        if (this._function.equalsIgnoreCase(FUNCTION_POST)) {
            return 2000;
        }
        return Integer.MIN_VALUE;
    }

    public int getRule() {
        return this._rule;
    }

    public void setListFilePath(String s) {
        this._parsedListFilePath = s;
        this._unparsedListFilePath = s;
    }

    public void setFileUrl(String s) {
        this._fileServerUrl = RMAIO.getHostFromUrl((String)s, (boolean)false) + "/FileManager";
        this._unparsedListFilePath = RMAIO.getFilePathFromUrl((String)s, (boolean)false);
        this._parsedListFilePath = RMAIO.getFilePathFromUrl((String)s, (boolean)true);
    }

    public void setFileServer(Serializable s) {
        if (s instanceof String) {
            this._fileServerUrl = (String)((Object)s);
        } else {
            this._fileServerRemote = s;
        }
    }

    public String getFileServerUrl() {
        return this._fileServerUrl;
    }

    public Serializable getFileServer() {
        if (this._fileServerRemote != null) {
            return this._fileServerRemote;
        }
        return this._fileServerUrl;
    }

    public String getListFilePath() {
        return this._parsedListFilePath;
    }

    public String getUnparsedListFilePath() {
        return this._unparsedListFilePath;
    }

    public RmiFileManager getFileServerRemote() {
        if (this._fileServerUrl == null && this._fileServerRemote == null) {
            return null;
        }
        if (this._fileServerRemote instanceof RmiFileManager) {
            return (RmiFileManager)((Object)this._fileServerRemote);
        }
        RmiFileManager r = null;
        try {
            r = ClientServerUtil.getRmiFileManager(this._fileServerUrl);
            this._fileServerRemote = (Serializable)((Object)r);
        }
        catch (Exception e) {
            ((FluentLogger.Api)((FluentLogger.Api)LOGGER.atWarning()).withCause((Throwable)e)).log("Error Looking up File Server @ " + this._fileServerUrl + ".  ");
        }
        return r;
    }

    public void setListFileModel(ListFileModel lm) {
        this._listModel = lm;
    }

    public ListFileModel getListFileModel() {
        return this._listModel;
    }

    public void setDssUrl(String s) {
        this._dssServerUrl = RMAIO.getHostFromUrl((String)s, (boolean)false) + "/DssFileManager";
        this._unparsedDssFilePath = RMAIO.getFilePathFromUrl((String)s, (boolean)false);
        this._parsedDssFilePath = RMAIO.getFilePathFromUrl((String)s, (boolean)true);
    }

    public String getDssServerUrl() {
        return this._dssServerUrl;
    }

    public void setDssFilePath(String s) {
        this._parsedDssFilePath = s;
        this._unparsedDssFilePath = s;
    }

    public void setDssServer(Serializable s) {
        if (s instanceof String) {
            this._dssServerUrl = (String)((Object)s);
        } else {
            this._dssServerRemote = s;
        }
    }

    public String getDssFilePath() {
        return this._parsedDssFilePath;
    }

    public String getUnparsedDssFilePath() {
        return this._unparsedDssFilePath;
    }

    public Serializable getDssServer() {
        if (this._dssServerRemote != null) {
            return this._dssServerRemote;
        }
        return this._dssServerUrl;
    }

    public DSSManager getDssServerRemote() {
        if (this._dssServerRemote == null && this._dssServerUrl == null) {
            return null;
        }
        if (this._dssServerRemote instanceof DSSManager) {
            return (DSSManager)((Object)this._dssServerRemote);
        }
        DSSManager r = null;
        try {
            r = ClientServerUtil.getDssManager(this._dssServerUrl);
            this._dssServerRemote = (Serializable)((Object)r);
        }
        catch (Exception e) {
            ((FluentLogger.Api)((FluentLogger.Api)LOGGER.atWarning()).withCause((Throwable)e)).log("Error Looking up DSS Server @ " + this._dssServerUrl + ".  ");
        }
        return r;
    }

    public void clearForReturn() {
        this._listModel = null;
    }

    public boolean fatalErrorOccurred() {
        return this._fatalError != null;
    }

    public Serializable getFatalError() {
        return this._fatalError;
    }

    public void setFatalError(Serializable s) {
        this._fatalError = s;
    }

    public ListStatisticsModel getStatistics() {
        return this._statisticsModel;
    }

    public void setStatistics(ListStatisticsModel lsm) {
        this._statisticsModel = lsm;
    }

    public void setProcessed(boolean tf) {
        this._processed = tf;
    }

    public void setProcessedBy(String who) {
        this._processedBy = who;
    }

    public void setReturnValue(String str) {
        this.setFatalError((Serializable)((Object)str));
    }

    public String getReturnValue() {
        if (this._fatalError != null) {
            return this._fatalError.toString();
        }
        return null;
    }

    public boolean getProcessed() {
        return this._processed;
    }

    public String getProcessedBy() {
        return this._processedBy;
    }

    public boolean isExtract() {
        return Objects.equals(this.getFunction(), FUNCTION_EXTRACT);
    }

    public boolean isPost() {
        return Objects.equals(this.getFunction(), FUNCTION_POST);
    }
}

