/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.rmi.extractpost;

import hec.data.Units;
import hec.data.tx.DSSTimeSeries;
import hec.data.tx.DataSetTx;
import hec.data.tx.DataSetTxIllegalArgumentException;
import hec.data.tx.DataSetTxTemplate;
import hec.data.tx.DescriptionTx;
import hec.heclib.dss.DSSPathname;
import java.util.StringTokenizer;
import java.util.TimeZone;
import mil.army.usace.hec.rmi.extractpost.ListParameter;
import rma.util.RMAIO;

public class Extract
extends ListParameter {
    static final long serialVersionUID = 1926837816687429805L;
    public static final String TYPE = "type";
    public static final String UNITS = "units";
    public static final String SI = "SI";
    public static final String ENGLISH = "English";
    public static final String ACTIVE = "active";
    String _dssUnits;
    String _dssType;
    String _unitSystem;
    String _active;
    int _maxTimeGapDefinedByIntervals;
    int _maxTimeGapDefinedByMinutes;

    public Extract(String s) throws Exception {
        super(s);
        this.parseString(s);
        this.init();
    }

    public Extract(String s, boolean preserveRejectedAndMissingValues, int maximumIntervalsOverWhichToInterpolate, int maximumTimeInMinutesOverWhichToInterpolate, long startTime, long endTime, TimeZone timeZone, String unitSystem) throws Exception {
        this(s, preserveRejectedAndMissingValues, maximumIntervalsOverWhichToInterpolate, maximumTimeInMinutesOverWhichToInterpolate, startTime, endTime, timeZone, null, unitSystem);
    }

    public Extract(String s, boolean preserveRejectedAndMissingValues, int maximumIntervalsOverWhichToInterpolate, int maximumTimeInMinutesOverWhichToInterpolate, long startTime, long endTime, TimeZone timeZone, TimeZone timeZoneOverride, String unitSystem) throws Exception {
        super(s);
        this.parseString(s);
        this._unitSystem = unitSystem;
        this._maxTimeGapDefinedByIntervals = maximumIntervalsOverWhichToInterpolate;
        this._maxTimeGapDefinedByMinutes = maximumTimeInMinutesOverWhichToInterpolate;
        this.setPreserveRejectedAndMissingValues(preserveRejectedAndMissingValues);
        this.setTimeWindow(startTime, endTime, timeZone, timeZoneOverride);
        if (maximumTimeInMinutesOverWhichToInterpolate > 0) {
            this._constructTempl.setMaxTimeGapDefinedByMinutes(maximumTimeInMinutesOverWhichToInterpolate);
        } else {
            this._constructTempl.setMaxTimeGapDefinedByIntervals(maximumIntervalsOverWhichToInterpolate);
        }
        if (this._deriveToTempl != null) {
            if (maximumTimeInMinutesOverWhichToInterpolate > 0) {
                this._deriveToTempl.setMaxTimeGapDefinedByMinutes(maximumTimeInMinutesOverWhichToInterpolate);
            } else {
                this._deriveToTempl.setMaxTimeGapDefinedByIntervals(maximumIntervalsOverWhichToInterpolate);
            }
        }
        this.init();
    }

    private void init() throws Exception {
        String oracleUnits = this._constructTempl.getDescriptionTx().getParameter().getUnitsString();
        if (this._dssUnits == null) {
            if (this._unitSystem == null) {
                this._dssUnits = oracleUnits;
            } else {
                int unitSystemId = 2;
                if (this._unitSystem.equalsIgnoreCase(ENGLISH)) {
                    unitSystemId = 1;
                }
                this._dssUnits = this._constructTempl.getDescriptionTx().getParameter().getUnitsStringForSystem(unitSystemId);
                if (this._dssUnits.equalsIgnoreCase("undef")) {
                    this._dssUnits = oracleUnits;
                }
            }
        } else if (!oracleUnits.equalsIgnoreCase(this._dssUnits) && !Units.canConvertBetweenUnits((String)oracleUnits, (String)this._dssUnits)) {
            throw new Exception("Unsupported unit conversion: \"" + oracleUnits + "\" to \"" + this._dssUnits + "\"");
        }
        Units units = new Units(this._dssUnits, true);
        this._constructTempl.setUnits(units);
        if (this._deriveToTempl != null) {
            this._deriveToTempl.setUnits(units);
        }
        if (this._dssType == null) {
            this._dssType = this._deriveToTempl == null ? DSSTimeSeries.getDSSType((DescriptionTx)this._constructTempl.getDescriptionTx()) : DSSTimeSeries.getDSSType((DescriptionTx)this._deriveToTempl.getDescriptionTx());
        }
    }

    public Extract(Extract ex) throws DataSetTxIllegalArgumentException {
        super(ex);
        if (ex._dssUnits != null) {
            this._dssUnits = new String(ex._dssUnits);
        }
        if (ex._dssType != null) {
            this._dssType = new String(ex._dssType);
        }
        if (ex._unitSystem != null) {
            this._unitSystem = new String(ex._unitSystem);
        }
        this._maxTimeGapDefinedByIntervals = ex._maxTimeGapDefinedByIntervals;
        this._maxTimeGapDefinedByMinutes = ex._maxTimeGapDefinedByMinutes;
    }

    public void setPreserveRejectedAndMissingValues(boolean tf) {
        this._constructTempl.setPreserveRejectedAndMissingValues(tf);
        if (this._deriveToTempl != null) {
            this._deriveToTempl.setPreserveRejectedAndMissingValues(tf);
        }
    }

    public boolean getPreserveRejectedAndMissingValues() {
        return this._constructTempl.getPreserveRejectedAndMissingValues();
    }

    public int getMaxIntervalsOverWhichToInterpolate() {
        return this._maxTimeGapDefinedByIntervals;
    }

    public int getMaxTimeInMinutesOverWhichToInterpolate() {
        return this._maxTimeGapDefinedByMinutes;
    }

    public String getUnitSystem() {
        return this._unitSystem;
    }

    @Override
    public Units getUnits() {
        return this._constructTempl.getUnits();
    }

    @Override
    public String getType() {
        return this._dssType;
    }

    @Override
    protected void buildParameterParts(StringBuffer sb) {
        sb.append(this._constructTempl.getDescriptionTx().toString());
        if (this._deriveToTempl != null) {
            sb.append("=>");
            sb.append(this._deriveToTempl.getDescriptionTx().toString());
        }
        sb.append("=");
        sb.append(this._dsspath);
    }

    @Override
    protected void parseString(String s) throws Exception {
        StringTokenizer st = new StringTokenizer(s, ";");
        StringBuffer excep = new StringBuffer();
        if (st.countTokens() < 1) {
            throw new Exception("  CountTokens returned " + st.countTokens() + ".  Unable to do extract for this line.\n");
        }
        String mapping = st.nextToken();
        Object dssUnits = null;
        while (st.hasMoreTokens()) {
            String str = st.nextToken();
            String type = RMAIO.getType((String)str, (String)"=");
            String param = RMAIO.getParam((String)str, (String)"=");
            if (type.equalsIgnoreCase(UNITS)) {
                this._dssUnits = param;
                continue;
            }
            if (type.equalsIgnoreCase(TYPE)) {
                this._dssType = param;
                continue;
            }
            if (type.equalsIgnoreCase(ACTIVE)) {
                if (param.equalsIgnoreCase("true")) {
                    super.setActive(true);
                    continue;
                }
                if (param.equalsIgnoreCase("false")) {
                    super.setActive(false);
                    continue;
                }
                if (excep.length() > 0) {
                    excep.append("\n");
                }
                excep.append("Key Word Setting for \"Active=\" must be either \"true\" or \"false\"");
                continue;
            }
            if (excep.length() > 0) {
                excep.append("\n");
            }
            excep.append("Key Word String: \"" + type + "=\" must be either \"Type=\", \"Units=\", or \"Active=\"");
        }
        DescriptionTx retrieveDesc = null;
        DescriptionTx deriveToDesc = null;
        int equalsIdx = mapping.indexOf("=");
        String retrieveStr = equalsIdx == -1 ? mapping : mapping.substring(0, equalsIdx);
        if (DSSPathname.isValidPathname((String)retrieveStr)) {
            throw new Exception("Must start with CWMS Times Series Description.\n  DSS Pathname not allowed at beginning of extract lines.");
        }
        try {
            retrieveDesc = new DescriptionTx(retrieveStr);
            this._constructTempl = new DataSetTxTemplate(retrieveDesc);
        }
        catch (Exception e) {
            if (excep.length() > 0) {
                excep.append("\n");
            }
            excep.append(e.getMessage());
        }
        if (equalsIdx == -1) {
            if (retrieveDesc != null) {
                this.setDssPath(DSSTimeSeries.getDefaultPathname((DescriptionTx)retrieveDesc));
            }
            this._deriveToTempl = null;
        } else {
            int deriveIdx = mapping.indexOf("=>");
            if (deriveIdx == -1) {
                String dsspathStr = mapping.substring(equalsIdx + 1);
                if (!DSSPathname.isValidPathname((String)dsspathStr)) {
                    if (excep.length() > 0) {
                        excep.append("\n");
                    }
                    excep.append("DSS Pathname is not valid:\n\"" + dsspathStr);
                    StringTokenizer pt = new StringTokenizer(dsspathStr, "/");
                    if (pt.countTokens() != 6) {
                        excep.append("\n  " + pt.countTokens() + " pathname parts  are present.\n  Six pathname parts are required.");
                    }
                } else {
                    try {
                        deriveToDesc = DSSTimeSeries.getDefaultDescription((String)dsspathStr, (String)this._dssType, (DescriptionTx)retrieveDesc);
                    }
                    catch (Exception e) {
                        if (excep.length() > 0) {
                            excep.append("\n");
                        }
                        excep.append(e.getMessage());
                    }
                }
                if (retrieveDesc != null && deriveToDesc != null && !retrieveDesc.describesSameDataAs(deriveToDesc)) {
                    StringBuffer sb = DSSTimeSeries.getDescriptionDifferences((DescriptionTx)retrieveDesc, (DescriptionTx)deriveToDesc, (String)this._dssType);
                    if (sb != null) {
                        sb.insert(0, "Time Series description is not equivalent to DSS Pathame");
                    }
                    if (sb.length() > 0) {
                        if (excep.length() > 0) {
                            excep.append("\n");
                        }
                        excep.append(sb.toString());
                    }
                }
                if (excep.length() > 0) {
                    throw new Exception(excep.toString());
                }
                this._deriveToTempl = null;
                this.setDssPath(dsspathStr);
                return;
            }
            equalsIdx = mapping.lastIndexOf("=");
            if (equalsIdx > deriveIdx) {
                String paramDer2;
                String paramRet;
                String deriveStr = mapping.substring(deriveIdx + 2, equalsIdx);
                String dsspathStr = mapping.substring(equalsIdx + 1);
                if (!DSSPathname.isValidPathname((String)dsspathStr)) {
                    if (excep.length() > 0) {
                        excep.append("\n");
                    }
                    excep.append("DSS Pathname is not valid:\n\"" + dsspathStr);
                    StringTokenizer pt = new StringTokenizer(dsspathStr, "/");
                    if (pt.countTokens() != 6) {
                        excep.append("\n  " + pt.countTokens() + " pathname parts  are present.\n  Six pathname parts are required.");
                    }
                } else {
                    try {
                        deriveToDesc = new DescriptionTx(deriveStr);
                    }
                    catch (Exception e) {
                        if (excep.length() > 0) {
                            excep.append("\n");
                        }
                        excep.append(e.getMessage());
                    }
                }
                if (!(retrieveDesc == null || deriveToDesc == null || (paramRet = retrieveDesc.getParameter().getBaseParameter().toString()).equals(paramDer2 = deriveToDesc.getParameter().getBaseParameter().toString()) || paramRet.equalsIgnoreCase("elev") && paramDer2.equalsIgnoreCase("stage"))) {
                    if (excep.length() > 0) {
                        excep.append("\n");
                    }
                    excep.append("Parameter is not the same across the derive: \"" + paramRet + "\" (=>) \"" + paramDer2 + "\".");
                }
                DescriptionTx pathDeflDesc = null;
                if (retrieveDesc != null) {
                    try {
                        pathDeflDesc = DSSTimeSeries.getDefaultDescription((String)dsspathStr, (String)this._dssType, (DescriptionTx)retrieveDesc);
                    }
                    catch (Exception paramDer2) {
                        // empty catch block
                    }
                }
                if (deriveToDesc != null && pathDeflDesc != null && !deriveToDesc.describesSameDataAs(pathDeflDesc)) {
                    StringBuffer sb = DSSTimeSeries.getDescriptionDifferences((DescriptionTx)deriveToDesc, (DescriptionTx)pathDeflDesc, (String)this._dssType);
                    if (sb != null) {
                        sb.insert(0, "Time Series description is not equivalent to DSS Pathame");
                    }
                    if (sb.length() > 0) {
                        if (excep.length() > 0) {
                            excep.append("\n");
                        }
                        excep.append(sb.toString());
                    }
                }
                if (excep.length() > 0) {
                    throw new Exception(excep.toString());
                }
                this._deriveToTempl = new DataSetTxTemplate(deriveToDesc);
                this.setDssPath(dsspathStr);
            } else {
                String dsspathStr = mapping.substring(equalsIdx + 2);
                if (DSSPathname.isValidPathname((String)dsspathStr)) {
                    this.setDssPath(dsspathStr);
                    try {
                        deriveToDesc = DSSTimeSeries.getDefaultDescription((String)dsspathStr, (String)this._dssType, (DescriptionTx)retrieveDesc);
                    }
                    catch (Exception e) {
                        if (excep.length() > 0) {
                            excep.append("\n");
                        }
                        excep.append(e.getMessage());
                    }
                    this._deriveToTempl = new DataSetTxTemplate(deriveToDesc);
                    if (retrieveDesc != null && deriveToDesc != null && retrieveDesc.describesSameDataAs(deriveToDesc)) {
                        if (excep.length() > 0) {
                            excep.append("\n");
                            if (retrieveDesc.toString().equalsIgnoreCase(deriveToDesc.toString())) {
                                excep.append("Warning: Time Series Descriptions are identical across =>");
                            } else {
                                excep.append("Warning: Derive changes only Time Series Description, not data.");
                            }
                        }
                        this._deriveToTempl = null;
                    }
                } else {
                    String deriveStr = dsspathStr;
                    try {
                        deriveToDesc = new DescriptionTx(deriveStr);
                    }
                    catch (Exception e) {
                        if (excep.length() > 0) {
                            excep.append("\n");
                        }
                        excep.append(e.getMessage());
                    }
                    if (deriveToDesc != null) {
                        this._deriveToTempl = new DataSetTxTemplate(deriveToDesc);
                        try {
                            this.setDssPath(DSSTimeSeries.getDefaultPathname((DescriptionTx)deriveToDesc));
                        }
                        catch (Exception e) {
                            if (excep.length() > 0) {
                                excep.append("\n");
                            }
                            excep.append(e.getMessage());
                        }
                    }
                }
            }
        }
        if (retrieveDesc != null && deriveToDesc != null) {
            String paramDer;
            Units unitsC = retrieveDesc.getParameter().getUnits();
            DataSetTxTemplate deriTempl = new DataSetTxTemplate(deriveToDesc, unitsC);
            String paramRet = retrieveDesc.getParameter().getBaseParameter().toString();
            if (!(paramRet.equals(paramDer = deriveToDesc.getParameter().getBaseParameter().toString()) || paramRet.equalsIgnoreCase("elev") && paramDer.equalsIgnoreCase("stage"))) {
                if (excep.length() > 0) {
                    excep.append("\n");
                }
                excep.append("Parameter is not the same across the derive: \"" + paramRet + "\" (=>) \"" + paramDer + "\".");
                paramRet = retrieveDesc.getParameter().toString();
                paramDer = deriveToDesc.getParameter().toString();
                String deriveToStr = deriveToDesc.toString();
                int paraBegIdx = deriveToStr.indexOf("." + paramDer + ".");
                if (paraBegIdx > -1) {
                    int paraEndIdx = ++paraBegIdx + paramDer.length();
                    int deriEndIdx = deriveToStr.length();
                    String desc1 = deriveToStr.substring(0, paraBegIdx);
                    String desc2 = deriveToStr.substring(paraEndIdx, deriEndIdx);
                    deriTempl = new DataSetTxTemplate(new DescriptionTx(desc1 + paramRet + desc2), unitsC);
                } else {
                    deriTempl = null;
                }
            }
            if (retrieveDesc != null && deriTempl != null) {
                DataSetTx constDs = new DataSetTx(retrieveDesc, unitsC);
                constDs.setPreserveRejectedAndMissingValues(deriTempl.getPreserveRejectedAndMissingValues());
                try {
                    deriTempl.setStartTime(0L);
                    deriTempl.setEndTime(0L);
                    constDs.combine(deriTempl.getStartTime(), 0.0, null, 100, false);
                    constDs.derive(deriTempl);
                }
                catch (Exception e) {
                    if (excep.length() > 0) {
                        excep.append("\n");
                    }
                    excep.append(e.getMessage());
                }
            }
        }
        if (excep.length() > 0) {
            throw new Exception(excep.toString());
        }
    }

    @Override
    public void tabulateMembers() {
        super.tabulateMembers();
        System.out.println("        _dssType= " + this._dssType);
        System.out.println("        _units= " + this._dssUnits);
    }
}

