/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.rmi.extractpost;

import com.google.common.flogger.FluentLogger;
import hec.data.tx.InvalidTimeWindowException;
import java.io.BufferedWriter;
import java.util.TimeZone;
import mil.army.usace.hec.rmi.csinterface.RmiFileManager;
import mil.army.usace.hec.rmi.extractpost.Extract;
import mil.army.usace.hec.rmi.extractpost.ExtractStatistic;
import mil.army.usace.hec.rmi.extractpost.ExtractStatisticsModel;
import mil.army.usace.hec.rmi.extractpost.ListFileModel;
import mil.army.usace.hec.rmi.extractpost.SyntaxError;
import rma.util.RMAIO;

public final class ExtractModel
extends ListFileModel {
    private static final long serialVersionUID = -6677757557739814491L;
    private static final FluentLogger LOGGER = FluentLogger.forEnclosingClass();
    public static final String PRESERVE_REJ_MISS_VALS_KEYWORD = "PreserveRejectedAndMissingValues";
    public static final String MAX_INTERP_INTERVALS_KEYWORD = "MaximumIntervalsOverWhichToInterpolate";
    public static final String MAX_INTERP_MINUTES_KEYWORD = "MaximumTimeInMinutesOverWhichToInterpolate";
    public static final String UNIT_SYSTEM_KEYWORD = "UnitSystem";
    private boolean _preserveRejectedAndMissingValues = true;
    private int _maximumIntervalsOverWhichToInterpolate = 1;
    private int _maximumTimeInMinutesOverWhichToInterpolate = 0;
    private String _unitSystem = "SI";

    public ExtractModel(RmiFileManager fm, String filepath, long startTime, long endTime, TimeZone tz) throws InvalidTimeWindowException {
        this(fm, filepath, startTime, endTime, tz, null);
    }

    public ExtractModel(RmiFileManager fm, String filepath, long startTime, long endTime, TimeZone tz, TimeZone timeZoneOverride) throws InvalidTimeWindowException {
        super(fm, filepath, startTime, endTime, tz, timeZoneOverride);
        this._statistics = new ExtractStatisticsModel();
    }

    @Override
    protected void parseLine(String s) {
        String type = RMAIO.getType((String)s, (String)"=");
        String param = RMAIO.getParam((String)s, (String)"=");
        if (type.equalsIgnoreCase(PRESERVE_REJ_MISS_VALS_KEYWORD)) {
            if ("true".equalsIgnoreCase(param)) {
                this._preserveRejectedAndMissingValues = true;
            } else if ("false".equalsIgnoreCase(param)) {
                this._preserveRejectedAndMissingValues = false;
            } else {
                String errmess = "Incorrect keyword syntax, must specify 'true' or 'false' after '=': " + s;
                this.add(null, new SyntaxError(errmess));
            }
            return;
        }
        if (type.equalsIgnoreCase(MAX_INTERP_INTERVALS_KEYWORD) || type.equalsIgnoreCase(MAX_INTERP_MINUTES_KEYWORD)) {
            int value;
            try {
                value = new Integer(param);
            }
            catch (NumberFormatException n) {
                String errmess = "Incorrect keyword syntax, integer must follow '=' in line: " + s;
                ((FluentLogger.Api)((FluentLogger.Api)LOGGER.atWarning()).withCause((Throwable)n)).log(errmess);
                this.add(null, new SyntaxError(errmess));
                return;
            }
            if (value < 0 || value > 999999) {
                String errmess = "Invalid value on keyword line, must be from 0 to 999999: " + s;
                ((FluentLogger.Api)LOGGER.atWarning()).log(errmess);
                this.add(null, new SyntaxError(errmess));
                return;
            }
            if (type.equalsIgnoreCase(MAX_INTERP_INTERVALS_KEYWORD)) {
                this._maximumIntervalsOverWhichToInterpolate = value;
                this._maximumTimeInMinutesOverWhichToInterpolate = 0;
            } else {
                this._maximumIntervalsOverWhichToInterpolate = 0;
                this._maximumTimeInMinutesOverWhichToInterpolate = value;
            }
            return;
        }
        if (type.equalsIgnoreCase(UNIT_SYSTEM_KEYWORD)) {
            if (param.equalsIgnoreCase("SI")) {
                this._unitSystem = "SI";
            } else if (param.equalsIgnoreCase("English")) {
                this._unitSystem = "English";
            } else if (((FluentLogger.Api)LOGGER.atFine()).isEnabled()) {
                String errmess = "Incorrect keyword syntax, must specify 'SI' or 'English' after '=': " + s;
                this.add(null, new SyntaxError(errmess));
            }
            return;
        }
        try {
            Extract ex = new Extract(s, this._preserveRejectedAndMissingValues, this._maximumIntervalsOverWhichToInterpolate, this._maximumTimeInMinutesOverWhichToInterpolate, this._startTime, this._endTime, this._timeZone, this._timeZoneOverride, this._unitSystem);
            this.add(ex, new ExtractStatistic(ex));
        }
        catch (Exception e) {
            StringBuilder sb = new StringBuilder("\n").append("Extract Syntax error: ").append(s).append("\n").append(e.getMessage()).append("\n");
            FluentLogger.Api api = (FluentLogger.Api)LOGGER.atWarning();
            if (((FluentLogger.Api)LOGGER.atFine()).isEnabled()) {
                api = (FluentLogger.Api)api.withCause((Throwable)e);
            }
            api.log(sb.toString());
            this.add(null, new SyntaxError(sb.toString()));
        }
    }

    public Extract get(int i) {
        return (Extract)this._paramList.get(i);
    }

    public Extract get(String param) {
        this.rebuildMap();
        return (Extract)this._paramMap.get(param);
    }

    @Override
    public boolean saveToFile() {
        try (BufferedWriter bw = this.getBufferedWriter();){
            this._preserveRejectedAndMissingValues = true;
            this._maximumIntervalsOverWhichToInterpolate = 1;
            this._maximumTimeInMinutesOverWhichToInterpolate = 0;
            this._unitSystem = "SI";
            for (Object o : this._paramList) {
                if (!(o instanceof Extract)) continue;
                Extract ex = (Extract)o;
                boolean preserveRejectedAndMissingValues = ex.getPreserveRejectedAndMissingValues();
                int maxIntervalsOverWhichToInterpolate = ex.getMaxIntervalsOverWhichToInterpolate();
                int maxTimeInMinutesOverWhichToInterpolate = ex.getMaxTimeInMinutesOverWhichToInterpolate();
                String unitSystem = ex.getUnitSystem();
                if (preserveRejectedAndMissingValues != this._preserveRejectedAndMissingValues) {
                    this._preserveRejectedAndMissingValues = preserveRejectedAndMissingValues;
                    bw.write(PRESERVE_REJ_MISS_VALS_KEYWORD);
                    bw.write("=");
                    bw.write(Boolean.toString(this._preserveRejectedAndMissingValues));
                    bw.newLine();
                }
                if (maxIntervalsOverWhichToInterpolate != this._maximumIntervalsOverWhichToInterpolate) {
                    this._maximumIntervalsOverWhichToInterpolate = maxIntervalsOverWhichToInterpolate;
                    this._maximumTimeInMinutesOverWhichToInterpolate = 0;
                    bw.write(MAX_INTERP_INTERVALS_KEYWORD);
                    bw.write("=");
                    bw.write(Integer.toString(this._maximumIntervalsOverWhichToInterpolate));
                    bw.newLine();
                } else if (maxTimeInMinutesOverWhichToInterpolate != this._maximumTimeInMinutesOverWhichToInterpolate) {
                    this._maximumTimeInMinutesOverWhichToInterpolate = maxTimeInMinutesOverWhichToInterpolate;
                    this._maximumIntervalsOverWhichToInterpolate = 0;
                    bw.write(MAX_INTERP_MINUTES_KEYWORD);
                    bw.write("=");
                    bw.write(Integer.toString(this._maximumTimeInMinutesOverWhichToInterpolate));
                    bw.newLine();
                }
                if (unitSystem != null && !unitSystem.equalsIgnoreCase(this._unitSystem)) {
                    this._unitSystem = unitSystem;
                    bw.write(UNIT_SYSTEM_KEYWORD);
                    bw.write("=");
                    bw.write(this._unitSystem);
                    bw.newLine();
                }
                String s = ex.toString();
                bw.write(s);
                bw.newLine();
            }
        }
        catch (Exception e) {
            ((FluentLogger.Api)((FluentLogger.Api)LOGGER.atSevere()).withCause((Throwable)e)).log("Error saving List File.  ");
            return false;
        }
        return true;
    }
}

