/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.rmi.extractpost;

import mil.army.usace.hec.rmi.extractpost.Extract;
import mil.army.usace.hec.rmi.extractpost.ListStatistic;

public class ExtractStatistic
extends ListStatistic {
    protected int _numOracleValues = Integer.MIN_VALUE;
    protected int _numMissingValues = Integer.MIN_VALUE;
    protected int _numWrittenValues = Integer.MIN_VALUE;
    protected String _oracleDesc = null;
    protected String _deriveDesc = null;
    protected String _dsspath = null;
    protected boolean _definedInOracle = false;

    public ExtractStatistic(Extract ex) {
        super(ex.getParameter());
        if (ex.getConstructTemplate() != null) {
            this._oracleDesc = ex.getConstructTemplate().getDescriptionTx().toString();
        }
        if (ex.getDeriveToTemplate() != null) {
            this._deriveDesc = ex.getDeriveToTemplate().getDescriptionTx().toString();
        }
        if (ex.getDssPath() != null) {
            this._dsspath = ex.getDssPath();
        }
        this._active = ex.isActive();
    }

    public void setNumberOracleValues(int numOracleValues) {
        this._numOracleValues = numOracleValues;
    }

    public void setNumberMissingValues(int numMissingValues) {
        this._numMissingValues = numMissingValues;
    }

    public void setNumberWrittenValues(int numWrittenValues) {
        this._numWrittenValues = numWrittenValues;
    }

    public void setDefinedInOracle(boolean tf) {
        this._definedInOracle = tf;
    }

    public String getOracleDescription() {
        return this._oracleDesc;
    }

    public String getDeriveDescription() {
        return this._deriveDesc;
    }

    public String getDSSPath() {
        return this._dsspath;
    }

    public int getNumberOracleValues() {
        return this._numOracleValues;
    }

    public int getNumberMissingValues() {
        return this._numMissingValues;
    }

    public int getNumberWrittenValues() {
        return this._numWrittenValues;
    }

    public boolean definedInOracle() {
        return this._definedInOracle;
    }

    public boolean dataRetrieved() {
        return this._numOracleValues > 0;
    }

    public boolean dataWritten() {
        return this._numWrittenValues > 0;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this._oracleDesc);
        sb.append(":");
        if (this._definedInOracle) {
            if (this._numOracleValues < 1) {
                sb.append("No Values In Time Window.");
            } else {
                sb.append(this._numOracleValues);
                sb.append(" values retrieved. ");
                if (this._deriveDesc != null) {
                    sb.append("Derived to: ");
                    sb.append(this._deriveDesc);
                    sb.append(". ");
                }
                sb.append(this._numMissingValues);
                sb.append(" values missing. ");
                sb.append(this._numWrittenValues);
                sb.append(" written to: ");
                sb.append(this._dsspath);
            }
        } else if (!this._active) {
            sb.append("Time Series Was Ignored/Not Extracted.");
        } else {
            sb.append("Time Series Does Not Exist.");
        }
        return sb.toString();
    }
}

