/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.rmi.extractpost;

import java.io.BufferedWriter;
import java.io.IOException;
import mil.army.usace.hec.rmi.extractpost.ExtractStatistic;
import mil.army.usace.hec.rmi.extractpost.ListError;
import mil.army.usace.hec.rmi.extractpost.ListStatistic;
import mil.army.usace.hec.rmi.extractpost.ListStatisticsModel;
import mil.army.usace.hec.rmi.extractpost.SyntaxError;
import rma.util.RMAIO;

public final class ExtractStatisticsModel
extends ListStatisticsModel {
    public ExtractStatisticsModel() {
        this(50);
    }

    public ExtractStatisticsModel(int size) {
        super(size);
    }

    @Override
    public void writeHeaderToStream(BufferedWriter bw) throws IOException {
        if (bw == null) {
            return;
        }
        bw.newLine();
        bw.newLine();
        bw.write("Extract Time-Series Data");
        bw.newLine();
        bw.write("Extract ");
        super.writeHeaderToStream(bw);
        int numDefined = 0;
        int dataWritten = 0;
        int syntaxError = 0;
        int runTimeError = 0;
        for (ListStatistic o : this._statList) {
            if (o instanceof ExtractStatistic) {
                ExtractStatistic es = (ExtractStatistic)o;
                if (es.dataRetrieved()) {
                    ++numDefined;
                }
                if (!es.dataWritten()) continue;
                ++dataWritten;
                continue;
            }
            if (o instanceof SyntaxError) {
                ++syntaxError;
                continue;
            }
            if (!(o instanceof ListError)) continue;
            ++runTimeError;
        }
        bw.write(" " + RMAIO.toTable((int)numDefined));
        bw.write(" time series out of ");
        bw.write(RMAIO.toTable((int)this._statList.size()));
        bw.write(" were extracted.");
        if (syntaxError > 0) {
            bw.newLine();
            bw.write(" " + RMAIO.toTable((int)syntaxError));
            bw.write(" syntax errors occured.");
        }
        if (runTimeError > 0) {
            bw.newLine();
            bw.write(" " + RMAIO.toTable((int)runTimeError));
            bw.write(" run time errors occured.");
        }
        bw.newLine();
        bw.newLine();
    }
}

