/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.rmi.extractpost;

import com.google.common.flogger.FluentLogger;
import hec.data.tx.InvalidTimeWindowException;
import hec.io.Identifier;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import mil.army.usace.hec.rmi.csinterface.RmiFileManager;
import mil.army.usace.hec.rmi.extractpost.ListParameter;
import mil.army.usace.hec.rmi.extractpost.ListStatistic;
import mil.army.usace.hec.rmi.extractpost.ListStatisticsModel;

public abstract class ListFileModel
implements Serializable {
    private static final FluentLogger LOGGER = FluentLogger.forEnclosingClass();
    protected RmiFileManager _fm;
    protected String _filepath;
    protected List _paramList = new ArrayList();
    protected Map _paramMap = new HashMap();
    protected boolean _rebuildMap = true;
    protected ListStatisticsModel _statistics = null;
    protected long _startTime;
    protected long _endTime;
    protected TimeZone _timeZone = null;
    protected TimeZone _timeZoneOverride;

    public ListFileModel(RmiFileManager fm, String filepath, long startTime, long endTime, TimeZone tz, TimeZone tzOverride) throws InvalidTimeWindowException {
        this._fm = fm;
        this._filepath = filepath;
        if (startTime > endTime) {
            throw new InvalidTimeWindowException("Start time cannot be greater than end time.");
        }
        this._startTime = startTime;
        this._endTime = endTime;
        this.setTimeZone(tz);
        this.setTimeZoneOverride(tzOverride);
    }

    public void setTimeZone(TimeZone tz) {
        this._timeZone = tz;
    }

    public TimeZone getTimeZone() {
        return this._timeZone;
    }

    public void setTimeZoneOverride(TimeZone tz) {
        this._timeZoneOverride = tz;
    }

    public final TimeZone getTimeZoneOverride() {
        return this._timeZoneOverride;
    }

    public boolean addAll(Collection params, Collection stats) {
        if (params.size() != stats.size()) {
            return false;
        }
        this._paramList.addAll(params);
        this._statistics.addAll(stats);
        this._rebuildMap = true;
        return true;
    }

    public void add(ListParameter lp, ListStatistic ls) {
        this._paramList.add(lp);
        this._statistics.add(ls);
        this._rebuildMap = true;
    }

    public void rebuildMap() {
        if (!this._rebuildMap) {
            return;
        }
        this._paramMap.clear();
        for (Object o : this._paramList) {
            ListParameter param = (ListParameter)o;
            if (param == null) continue;
            this._paramMap.put(param.toString(), param);
        }
        this._rebuildMap = false;
    }

    public BufferedWriter getBufferedWriter() throws IOException {
        BufferedWriter bw;
        if (this._fm != null) {
            Identifier request = new Identifier(this._filepath);
            Identifier file = this._fm.openFile("ListFileModel", request);
            if (file == null) {
                file = this._fm.newFile("ListFileModel", request);
            }
            bw = file.getFile().getBufferedWriter();
        } else {
            bw = Files.newBufferedWriter(Paths.get(this._filepath, new String[0]), new OpenOption[0]);
        }
        return bw;
    }

    public BufferedReader getBufferedReader() throws IOException {
        BufferedReader br = null;
        if (this._fm != null) {
            Identifier request = new Identifier(this._filepath);
            Identifier file = this._fm.openFile("ListFileModel", request);
            if (file != null) {
                br = file.getFile().getBufferedReader();
            }
        } else {
            br = Files.newBufferedReader(Paths.get(this._filepath, new String[0]));
        }
        return br;
    }

    public ListStatisticsModel getStatistics() {
        if (this._statistics != null) {
            this._statistics.setStartTime(this._startTime);
            this._statistics.setEndTime(this._endTime);
            this._statistics.setTimeZone(this._timeZone);
        }
        return this._statistics;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean loadFromFile() {
        try (BufferedReader br = this.getBufferedReader();){
            if (br == null) {
                ((FluentLogger.Api)LOGGER.atWarning()).log("Unable to load list file.");
                boolean bl2 = false;
                return bl2;
            }
            boolean bl = this.loadFromReader(br);
            return bl;
        }
        catch (Exception e) {
            ((FluentLogger.Api)((FluentLogger.Api)LOGGER.atSevere()).withCause((Throwable)e)).log("Error reading input stream from list file.");
            return false;
        }
    }

    public boolean loadFromReader(BufferedReader br) {
        this._paramList.clear();
        if (this._statistics != null) {
            this._statistics.clear();
        }
        try {
            String s = br.readLine();
            while (s != null) {
                if (s.trim().length() < 1 || s.charAt(0) == '#' || s.charAt(0) == '!') {
                    s = br.readLine();
                    continue;
                }
                s = s.trim();
                this.parseLine(s);
                s = br.readLine();
            }
            return true;
        }
        catch (IOException e) {
            ((FluentLogger.Api)((FluentLogger.Api)LOGGER.atSevere()).withCause((Throwable)e)).log("Error Loading List File.");
            return false;
        }
    }

    public abstract boolean saveToFile();

    protected abstract void parseLine(String var1);

    public int size() {
        return this._paramList.size();
    }

    public ListParameter getListParameter(int index) {
        return (ListParameter)this._paramList.get(index);
    }
}

