/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.rmi.extractpost;

import hec.data.Interval;
import hec.data.Units;
import hec.data.tx.DataSetTxIllegalArgumentException;
import hec.data.tx.DataSetTxTemplate;
import hec.heclib.dss.DSSPathname;
import java.io.Serializable;
import java.util.SimpleTimeZone;
import java.util.TimeZone;

public abstract class ListParameter
implements Serializable {
    protected static DSSPathname _dsspathname = new DSSPathname();
    public static final String DERIVE = "=>";
    public static final String EQUALS = "=";
    protected DataSetTxTemplate _constructTempl;
    protected DataSetTxTemplate _deriveToTempl;
    protected String _dsspath;
    protected String _param;
    protected boolean _active;

    public ListParameter(String s) {
        this._param = s;
        this._active = true;
    }

    public ListParameter(ListParameter p) throws DataSetTxIllegalArgumentException {
        if (p._constructTempl != null) {
            this._constructTempl = new DataSetTxTemplate(p._constructTempl);
        }
        if (p._deriveToTempl != null) {
            this._deriveToTempl = new DataSetTxTemplate(p._deriveToTempl);
        }
        if (p._dsspath != null) {
            this._dsspath = new String(p._dsspath);
        }
        if (p._param != null) {
            this._param = new String(p._param);
        }
        this._active = p._active;
    }

    protected abstract void parseString(String var1) throws Exception;

    public void setTimeWindow(long startTime, long endTime, TimeZone timeZone) throws Exception {
        this.setTimeWindow(startTime, endTime, timeZone, null);
    }

    public void setTimeWindow(long startTime, long endTime, TimeZone timeZone, TimeZone timeZoneOverride) throws Exception {
        TimeZone tz;
        if (startTime > endTime) {
            throw new Exception("Start time cannot be greater than end time.");
        }
        TimeZone timeZone2 = tz = timeZoneOverride != null ? timeZoneOverride : timeZone;
        if (tz == null) {
            tz = TimeZone.getDefault();
        }
        SimpleTimeZone stdTz = new SimpleTimeZone(tz.getRawOffset(), tz.getID());
        this._constructTempl.clearTimeWindow();
        this._constructTempl.setStartTime(startTime);
        this._constructTempl.setEndTime(endTime);
        if (this._deriveToTempl != null) {
            Interval intervalDeriveTo = this._deriveToTempl.getDescriptionTx().getInterval();
            long startTimeDeriveTo = startTime;
            long endTimeDeriveTo = endTime;
            if (intervalDeriveTo.isRegular() && endTimeDeriveTo < (startTimeDeriveTo = Interval.getTimeAtTopOfIntervalOnOrAfter((long)startTime, (String)intervalDeriveTo.toString(), (TimeZone)stdTz))) {
                endTimeDeriveTo = startTimeDeriveTo;
            }
            this._deriveToTempl.clearTimeWindow();
            this._deriveToTempl.setStartTime(startTimeDeriveTo);
            this._deriveToTempl.setEndTime(endTimeDeriveTo);
        }
    }

    public DataSetTxTemplate getConstructTemplate() {
        return this._constructTempl;
    }

    public DataSetTxTemplate getDeriveToTemplate() {
        return this._deriveToTempl;
    }

    public String getType() {
        return null;
    }

    public Units getUnits() {
        return null;
    }

    public String getDssPath() {
        return this._dsspath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDssPath(String s) throws Exception {
        int stat = 0;
        DSSPathname dSSPathname = _dsspathname;
        synchronized (dSSPathname) {
            stat = _dsspathname.setPathname(s);
            _dsspathname.notify();
        }
        if (stat != 0) {
            throw new Exception("Invalid DSS Path: " + s);
        }
        this._dsspath = s;
    }

    public void setActive(boolean tf) {
        this._active = tf;
    }

    public String toString() {
        return this._param;
    }

    public String getParameter() {
        return this._param;
    }

    public void rebuildParameter() {
        StringBuffer sb = new StringBuffer();
        this.buildParameterParts(sb);
        this._param = sb.toString();
    }

    protected abstract void buildParameterParts(StringBuffer var1);

    public boolean isActive() {
        return this._active;
    }

    public void tabulateMembers() {
        System.out.println("        _param= " + this._param);
        System.out.println("        _constructTempl= " + this._constructTempl);
        System.out.println("        _deriveToTempl= " + this._deriveToTempl);
        System.out.println("        _dsspath= " + this.getDssPath());
        System.out.println("        _active= " + this._active);
    }
}

