/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.rmi.extractpost;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import mil.army.usace.hec.rmi.extractpost.ListError;
import mil.army.usace.hec.rmi.extractpost.ListStatistic;
import rma.util.RMAIO;

public abstract class ListStatisticsModel
implements Serializable {
    public static String DATE_FORMAT = "ddMMMyyyy HHmm z";
    protected List<ListStatistic> _statList = null;
    protected String _name = null;
    protected long _startTime = Long.MIN_VALUE;
    protected long _endTime = Long.MIN_VALUE;
    protected TimeZone _tz = null;
    protected String _dssFile = null;

    public ListStatisticsModel() {
        this(50);
    }

    public ListStatisticsModel(int size) {
        this._statList = new ArrayList<ListStatistic>(size);
    }

    public void setName(String s) {
        this._name = s;
    }

    public String getName() {
        return this._name;
    }

    public void setDSSFile(String s) {
        this._dssFile = s;
    }

    public String getDSSFile() {
        return this._dssFile;
    }

    public void setStartTime(long t) {
        this._startTime = t;
    }

    public long getStartTime() {
        return this._startTime;
    }

    public void setEndTime(long t) {
        this._endTime = t;
    }

    public long getEndTime() {
        return this._endTime;
    }

    public void setTimeZone(TimeZone tz) {
        this._tz = tz;
    }

    public TimeZone getTimeZone() {
        return this._tz;
    }

    public ListStatistic get(int ii) {
        if (ii >= 0 && ii < this._statList.size()) {
            return this._statList.get(ii);
        }
        return null;
    }

    public boolean set(int ii, ListStatistic ls) {
        if (ii >= 0 && ii < this._statList.size()) {
            this._statList.set(ii, ls);
            return true;
        }
        return false;
    }

    public void clear() {
        if (this._statList != null) {
            this._statList.clear();
        }
    }

    public ListIterator<ListStatistic> listIterator() {
        return this._statList.listIterator();
    }

    public int size() {
        if (this._statList != null) {
            return this._statList.size();
        }
        return 0;
    }

    public List<ListStatistic> getStatisticsList() {
        return Collections.unmodifiableList(this._statList);
    }

    public boolean addAll(Collection<ListStatistic> vals) {
        if (this._statList == null) {
            return false;
        }
        return this._statList.addAll(vals);
    }

    public void add(ListStatistic ls) {
        if (this._statList != null) {
            this._statList.add(ls);
        }
    }

    public void writeHeaderToStream(BufferedWriter bw) throws IOException {
        if (bw == null) {
            return;
        }
        if (this._name != null) {
            bw.write(this._name);
            bw.write(".");
            bw.newLine();
        }
        if (this._startTime != Long.MIN_VALUE && this._endTime != Long.MIN_VALUE) {
            bw.write("Time Window: ");
            bw.write(RMAIO.formatDate((long)this._startTime, (String)DATE_FORMAT, (TimeZone)this._tz));
            bw.write("  ");
            bw.write(RMAIO.formatDate((long)this._endTime, (String)DATE_FORMAT, (TimeZone)this._tz));
        }
        bw.newLine();
    }

    public void writeBodyToStream(BufferedWriter bw) throws IOException {
        for (int ii = 0; ii < this._statList.size(); ++ii) {
            ListStatistic ls = this._statList.get(ii);
            bw.write(ls.toString());
            bw.newLine();
        }
    }

    public void writeErrorsToStream(BufferedWriter bw) throws IOException {
        for (int ii = 0; ii < this._statList.size(); ++ii) {
            ListStatistic ls = this._statList.get(ii);
            if (!(ls instanceof ListError)) continue;
            bw.write(ls.toString());
            bw.newLine();
        }
    }

    public String getHeaderString() {
        try {
            StringWriter sw = new StringWriter();
            BufferedWriter bw = new BufferedWriter(sw);
            this.writeHeaderToStream(bw);
            bw.close();
            sw.close();
            String header = sw.toString();
            return header;
        }
        catch (IOException e) {
            Logger logger = Logger.getLogger(ListStatisticsModel.class.getName());
            logger.log(Level.FINE, "Error generating extract header", e);
            return null;
        }
    }
}

