/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.rmi.extractpost;

import com.google.common.flogger.FluentLogger;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import mil.army.usace.hec.rmi.extractpost.DssAction;
import mil.army.usace.hec.rmi.msgsystem.Msg;

public final class MessageFileImporter {
    private static final FluentLogger LOGGER = FluentLogger.forEnclosingClass();
    private List<DssAction> _dssActionList = new ArrayList<DssAction>();

    public boolean parseMsg(BufferedReader bin) throws IOException {
        String addressing = bin.readLine();
        if (addressing == null) {
            ((FluentLogger.Api)LOGGER.atWarning()).log("Extract/Post: no data available on stdin.");
            return false;
        }
        StringTokenizer st = new StringTokenizer(addressing, ";");
        if (st.countTokens() < 3) {
            String message = "Extract/Post: Addressing data not properly formated. \nExpected: From;TupleHost;TupleSpace\n Extract/Post Received: " + addressing;
            ((FluentLogger.Api)LOGGER.atWarning()).log(message);
            return false;
        }
        String nameOfProcess = st.nextToken(";");
        String line = bin.readLine();
        if (line == null) {
            ((FluentLogger.Api)LOGGER.atInfo()).log("Extract/Post: No Extract/Post Requests.");
            return false;
        }
        ArrayList<String> list = new ArrayList<String>();
        while (line != null) {
            if (!line.trim().isEmpty()) {
                list.add(line);
            }
            line = bin.readLine();
        }
        int size = list.size();
        if (size < 1) {
            ((FluentLogger.Api)LOGGER.atInfo()).log("Extract/Post: No Extract/Post Requests.");
            return false;
        }
        String[] lines = new String[size];
        list.toArray(lines);
        return this.buildDssActions(nameOfProcess, lines) > 0;
    }

    private synchronized int buildDssActions(String from, String[] stringMsgs) {
        this._dssActionList = new ArrayList<DssAction>();
        String to = System.getProperty("cwms.process.ID.dbdss", "DBDSS");
        for (String stringMsg : stringMsgs) {
            Msg msg = new Msg(to, from, stringMsg, 5);
            DssAction dssAction = new DssAction(msg);
            if (!dssAction.isSet()) {
                ((FluentLogger.Api)LOGGER.atWarning()).log("Extract/Post: Received Invalid Request.\nRequest is: " + stringMsg);
                continue;
            }
            this._dssActionList.add(dssAction);
        }
        return this._dssActionList.size();
    }

    public List<DssAction> getDssActionList() {
        return Collections.unmodifiableList(this._dssActionList);
    }
}

