/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.rmi.extractpost;

import hec.data.Units;
import hec.data.tx.DSSTimeSeries;
import hec.data.tx.DataSetTxException;
import hec.data.tx.DataSetTxIllegalArgumentException;
import hec.data.tx.DataSetTxTemplate;
import hec.data.tx.DescriptionTx;
import hec.heclib.dss.DSSPathname;
import java.util.StringTokenizer;
import java.util.TimeZone;
import mil.army.usace.hec.rmi.extractpost.ListParameter;

public class Post
extends ListParameter {
    static final long serialVersionUID = -4748791272295553612L;

    public Post(String s, long startTime, long endTime, TimeZone timeZone) throws Exception {
        this(s, startTime, endTime, timeZone, null);
    }

    public Post(String s, long startTime, long endTime, TimeZone timeZone, TimeZone timeZoneOverride) throws Exception {
        super(s);
        this.parseString(s);
        this._constructTempl.setMaxTimeGapDefinedByIntervals(1);
        if (this._deriveToTempl != null) {
            this._deriveToTempl.setMaxTimeGapDefinedByIntervals(1);
        }
        this.setTimeWindow(startTime, endTime, timeZone, timeZoneOverride);
        String oracleUnits = this._constructTempl.getDescriptionTx().getParameter().getUnitsString();
        Units units = new Units(oracleUnits, true);
        this._constructTempl.setUnits(units);
        if (this._deriveToTempl != null) {
            this._deriveToTempl.setUnits(units);
        }
    }

    public Post(Post p) throws DataSetTxIllegalArgumentException {
        super(p);
    }

    @Override
    protected void buildParameterParts(StringBuffer sb) {
        sb.append(this._dsspath);
        if (this._constructTempl != null) {
            sb.append("=");
            sb.append(this._constructTempl.getDescriptionTx().toString());
            if (this._deriveToTempl != null) {
                sb.append("=>");
                sb.append(this._deriveToTempl.getDescriptionTx().toString());
            }
        } else if (this._deriveToTempl != null) {
            sb.append("=>");
            sb.append(this._deriveToTempl.getDescriptionTx().toString());
        }
    }

    @Override
    protected void parseString(String sIn) throws Exception {
        StringTokenizer st = new StringTokenizer(sIn, ";");
        if (st.countTokens() < 1) {
            throw new Exception("CountTokens returned " + st.countTokens() + ".  Unable to do post for this line.\n");
        }
        String s = st.nextToken();
        DescriptionTx deriveToDesc = null;
        DescriptionTx constructDesc = null;
        int equalsIdx = s.indexOf("=");
        int deriveIdx = s.indexOf("=>");
        String firstStr = equalsIdx == -1 ? s : s.substring(0, equalsIdx);
        if (DSSPathname.isValidPathname((String)firstStr)) {
            StringBuffer sb;
            this.setDssPath(firstStr);
            if (equalsIdx == -1) {
                throw new Exception("Invalid Post syntax, not allowed to specify only DSS Path:\n  " + s);
            }
            if (deriveIdx == -1) {
                constructDesc = new DescriptionTx(s.substring(equalsIdx + 1));
                this._constructTempl = new DataSetTxTemplate(constructDesc);
                this._deriveToTempl = null;
            } else if (deriveIdx == equalsIdx) {
                if (s.lastIndexOf("=") != deriveIdx) {
                    throw new Exception("Invalid Post syntax, '=' or '=>' may not follow '=>'");
                }
                deriveToDesc = new DescriptionTx(s.substring(deriveIdx + 2));
                this._deriveToTempl = new DataSetTxTemplate(deriveToDesc);
                constructDesc = DSSTimeSeries.getDefaultDescription((String)this.getDssPath(), null, (DescriptionTx)deriveToDesc);
                this._constructTempl = new DataSetTxTemplate(constructDesc);
            } else {
                constructDesc = new DescriptionTx(s.substring(equalsIdx + 1, deriveIdx));
                this._constructTempl = new DataSetTxTemplate(constructDesc);
                deriveToDesc = new DescriptionTx(s.substring(deriveIdx + 2));
                this._deriveToTempl = new DataSetTxTemplate(deriveToDesc);
            }
            if (!constructDesc.describesSameDataAs(DSSTimeSeries.getDefaultDescription((String)this.getDssPath(), null, (DescriptionTx)constructDesc)) && (sb = DSSTimeSeries.getDescriptionDifferences((DescriptionTx)DSSTimeSeries.getDefaultDescription((String)this.getDssPath(), null, (DescriptionTx)constructDesc), (String)this.getDssPath(), null, (DescriptionTx)constructDesc)) != null) {
                sb.insert(0, "DSS Pathame is not equivalent to Time Series description");
                throw new DataSetTxException(sb.toString());
            }
        } else {
            constructDesc = new DescriptionTx(firstStr);
            this._constructTempl = new DataSetTxTemplate(constructDesc);
            this.setDssPath(DSSTimeSeries.getDefaultPathname((DataSetTxTemplate)this._constructTempl));
            if (equalsIdx == -1) {
                this._deriveToTempl = null;
                return;
            }
            if (deriveIdx != equalsIdx) {
                throw new Exception("Invalid Post syntax, can not have both '=' and '=>' when line starts with TSD: " + s);
            }
            deriveToDesc = new DescriptionTx(s.substring(deriveIdx + 2));
            this._deriveToTempl = new DataSetTxTemplate(deriveToDesc);
        }
        if (deriveIdx != -1) {
            if (!deriveToDesc.getParameter().equals(constructDesc.getParameter())) {
                throw new Exception("Parameter is not the same across the derive (=>).\n");
            }
            if (deriveToDesc.describesSameDataAs(deriveToDesc)) {
                // empty if block
            }
        }
    }

    @Override
    public void tabulateMembers() {
        super.tabulateMembers();
    }
}

