/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.rmi.extractpost;

import com.google.common.flogger.FluentLogger;
import hec.data.tx.InvalidTimeWindowException;
import java.io.BufferedWriter;
import java.util.TimeZone;
import mil.army.usace.hec.rmi.csinterface.RmiFileManager;
import mil.army.usace.hec.rmi.extractpost.ListFileModel;
import mil.army.usace.hec.rmi.extractpost.Post;
import mil.army.usace.hec.rmi.extractpost.PostStatistic;
import mil.army.usace.hec.rmi.extractpost.PostStatisticsModel;
import mil.army.usace.hec.rmi.extractpost.SyntaxError;

public final class PostModel
extends ListFileModel {
    private static final long serialVersionUID = -415182229484347409L;
    private static final FluentLogger LOGGER = FluentLogger.forEnclosingClass();

    public PostModel(RmiFileManager fm, String filepath, long startTime, long endTime, TimeZone tz) throws InvalidTimeWindowException {
        this(fm, filepath, startTime, endTime, tz, null);
    }

    public PostModel(RmiFileManager fm, String listPath, long startTime, long endTime, TimeZone tz, TimeZone timeZoneOverride) throws InvalidTimeWindowException {
        super(fm, listPath, startTime, endTime, tz, timeZoneOverride);
        this._statistics = new PostStatisticsModel();
    }

    @Override
    protected void parseLine(String s) {
        try {
            Post p = new Post(s, this._startTime, this._endTime, this._timeZone, this._timeZoneOverride);
            this.add(p, new PostStatistic(p));
        }
        catch (Exception e) {
            StringBuilder sb = new StringBuilder("\n").append("Post Syntax error: ").append(s).append("\n").append(e.getMessage()).append("\n");
            FluentLogger.Api api = (FluentLogger.Api)LOGGER.atWarning();
            if (((FluentLogger.Api)LOGGER.atFine()).isEnabled()) {
                api = (FluentLogger.Api)api.withCause((Throwable)e);
            }
            api.log(sb.toString());
            this.add(null, new SyntaxError(sb.toString()));
        }
    }

    public Post get(int i) {
        return (Post)this._paramList.get(i);
    }

    public Post get(String param) {
        this.rebuildMap();
        return (Post)this._paramMap.get(param);
    }

    @Override
    public boolean saveToFile() {
        try (BufferedWriter bw = this.getBufferedWriter();){
            for (Object o : this._paramList) {
                if (o == null) continue;
                String s = o.toString();
                bw.write(s);
                bw.newLine();
            }
        }
        catch (Exception e) {
            ((FluentLogger.Api)((FluentLogger.Api)LOGGER.atSevere()).withCause((Throwable)e)).log("Error saving List File.");
            return false;
        }
        return true;
    }
}

