/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.rmi.extractpost;

import mil.army.usace.hec.rmi.extractpost.ListStatistic;
import mil.army.usace.hec.rmi.extractpost.Post;

public class PostStatistic
extends ListStatistic {
    protected String _readIntoDesc = null;
    protected String _derivedToDesc = null;
    protected String _dsspathReadFrom = null;
    protected boolean _definedInDss = false;
    protected int _numberDssValues = Integer.MIN_VALUE;

    public PostStatistic(Post p) {
        super(p.getParameter());
        if (p.getConstructTemplate() != null) {
            this._readIntoDesc = p.getConstructTemplate().getDescriptionTx().toString();
        }
        if (p.getDeriveToTemplate() != null) {
            this._derivedToDesc = p.getDeriveToTemplate().getDescriptionTx().toString();
        }
        if (p.getDssPath() != null) {
            this._dsspathReadFrom = p.getDssPath();
        }
        this._active = p.isActive();
    }

    public void setDefinedInDss(boolean tf) {
        this._definedInDss = tf;
    }

    public boolean definedInDss() {
        return this._definedInDss;
    }

    public void setNumberDssValues(int n) {
        this._numberDssValues = n;
    }

    public int getNumberDssValues() {
        return this._numberDssValues;
    }

    public boolean dataRetrieved() {
        return this._numberDssValues > 0;
    }

    public boolean dataWritten() {
        return false;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this._dsspathReadFrom);
        sb.append(":");
        if (!this._definedInDss && this._active) {
            sb.append("No Data Found for DSS Path.");
        } else if (!this._active) {
            sb.append("Time Series Was Ignored/Not Posted.");
        } else if (this._numberDssValues < 1) {
            sb.append("No Values In Time Window.");
        } else {
            boolean hasDssPath;
            sb.append(this._numberDssValues);
            sb.append(" values retrieved. ");
            int firstEqual = this._param.indexOf(61);
            int lastEqual = this._param.lastIndexOf(61);
            int firstGreaterThan = this._param.indexOf(62);
            boolean bl = hasDssPath = this._param.indexOf(47) != -1;
            if (firstEqual == -1 || firstGreaterThan == -1) {
                sb.append("\n  Stored to: ");
                if (this._derivedToDesc != null) {
                    sb.append(this._derivedToDesc.toString());
                } else if (this._readIntoDesc != null) {
                    sb.append(this._readIntoDesc.toString());
                }
            } else if (hasDssPath && firstEqual != -1 && firstGreaterThan == firstEqual + 1) {
                sb.append("\n  Derived/stored to: ");
                if (this._derivedToDesc != null) {
                    sb.append(this._derivedToDesc.toString());
                } else if (this._readIntoDesc != null) {
                    sb.append(this._readIntoDesc.toString());
                }
            } else {
                sb.append("\n  Retrieved to: ");
                if (this._readIntoDesc != null) {
                    sb.append(this._readIntoDesc.toString());
                }
                sb.append("\n  Derived/stored to: ");
                if (this._derivedToDesc != null) {
                    sb.append(this._derivedToDesc.toString());
                }
            }
        }
        return sb.toString();
    }
}

