/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.rmi.gfx2d;

import hec.gfx2d.G2dData;
import hec.gfx2d.text.TokenReplacer;
import hec.heclib.dss.DSSPathname;
import hec.io.TimeSeriesContainer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mil.army.usace.hec.rmi.gfx2d.SimpleDSSPairedData;
import mil.army.usace.hec.rmi.gfx2d.SimpleDSSTimeSeries;
import rma.services.annotations.ServiceProvider;
import rma.util.RMAIO;

@ServiceProvider(service=TokenReplacer.class)
public class RmiDssTokenReplacer
implements TokenReplacer {
    public static final Map<String, String> TOKEN_MAP = new HashMap<String, String>();

    public RmiDssTokenReplacer() {
        TOKEN_MAP.put("APART", "APART");
        TOKEN_MAP.put("BPART", "BPART");
        TOKEN_MAP.put("CPART", "CPART");
        TOKEN_MAP.put("DPART", "DPART");
        TOKEN_MAP.put("EPART", "EPART");
        TOKEN_MAP.put("FPART", "FPART");
        TOKEN_MAP.put("DSSPATH", "DSSPATH");
        TOKEN_MAP.put("DSSFILENAME", "DSSFILENAME");
        TOKEN_MAP.put("DSSFILEPATH", "DSSFILEPATH");
        TOKEN_MAP.put("DSSFILEDIR", "DSSFILEDIR");
        TOKEN_MAP.put("DSSFILEDATE", "DSSFILEDATE");
        TOKEN_MAP.put("LABEL", "LABEL");
    }

    public String resolveToken(String token, Object ... args) {
        if (token == null) {
            return null;
        }
        ArrayList<G2dData> plotObjects = new ArrayList<G2dData>();
        for (int i = 0; args != null && i < args.length; ++i) {
            if (!(args[i] instanceof SimpleDSSTimeSeries) && !(args[i] instanceof SimpleDSSPairedData)) continue;
            plotObjects.add((G2dData)args[i]);
        }
        return this.resolveToken(token, plotObjects);
    }

    private String resolveToken(String token, List<G2dData> plotObjects) {
        String key;
        TimeSeriesContainer dContainer = null;
        int sepIdx = -1;
        int dssIdx = 0;
        sepIdx = token.indexOf(":");
        if (sepIdx >= 0) {
            key = token.substring(0, sepIdx);
            if (sepIdx + 1 < token.length()) {
                dssIdx = RMAIO.parseInt((String)token.substring(sepIdx + 1), (int)0);
            }
        } else {
            key = token;
        }
        if (dssIdx < 0) {
            dssIdx = 0;
        }
        if (dssIdx >= plotObjects.size()) {
            dssIdx = plotObjects.size() - 1;
        }
        if (dssIdx < 0) {
            return null;
        }
        G2dData obj = plotObjects.get(dssIdx);
        if (obj instanceof SimpleDSSTimeSeries) {
            dContainer = ((SimpleDSSTimeSeries)obj).getTimeSeriesContainer();
        } else if (obj instanceof SimpleDSSPairedData) {
            dContainer = ((SimpleDSSPairedData)obj).getPairedDataContainer();
        }
        if (dContainer == null) {
            return null;
        }
        DSSPathname pathName = new DSSPathname(dContainer.fullName);
        if ("APART".equalsIgnoreCase(key)) {
            return pathName.aPart();
        }
        if ("BPART".equalsIgnoreCase(key)) {
            return pathName.bPart();
        }
        if ("CPART".equalsIgnoreCase(key)) {
            return pathName.cPart();
        }
        if ("DPART".equalsIgnoreCase(key)) {
            return pathName.dPart();
        }
        if ("EPART".equalsIgnoreCase(key)) {
            return pathName.ePart();
        }
        if ("FPART".equalsIgnoreCase(key)) {
            return pathName.fPart();
        }
        if ("DSSPATH".equals(key)) {
            return dContainer.fullName;
        }
        if ("DSSFILENAME".equals(key)) {
            String temp = RMAIO.getFileNameNoExtension((String)dContainer.fileName);
            temp = RMAIO.getFileFromPath((String)temp);
            return temp;
        }
        if ("DSSFILEDIR".equals(key)) {
            return RMAIO.getDirectoryFromPath((String)dContainer.fileName);
        }
        if ("DSSFILEPATH".equals(key)) {
            return dContainer.fileName;
        }
        return null;
    }
}

