/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.rmi.gfx2d;

import hec.data.DataSetIllegalArgumentException;
import hec.data.Parameter;
import hec.data.Units;
import hec.gfx2d.G2dGlyphFactory;
import hec.gfx2d.G2dObject;
import hec.heclib.util.Unit;
import hec.io.DSSIdentifier;
import java.io.FileNotFoundException;
import java.rmi.RemoteException;
import mil.army.usace.hec.rmi.csinterface.BaseDSSManager;
import mil.army.usace.hec.rmi.gfx2d.SimpleDSSTimeSeries;
import mil.army.usace.hec.rmi.gfx2d.SimpleDSSTimeSeriesGlyph;

public class SimpleBarDSSTimeSeries
extends SimpleDSSTimeSeries
implements G2dObject {
    public SimpleBarDSSTimeSeries(BaseDSSManager dssman, DSSIdentifier dssId) {
        super(dssman, dssId);
    }

    @Override
    public int size() {
        if (this._dssArray == null) {
            return 0;
        }
        return this._dssArray.numberValues;
    }

    @Override
    public void load() {
        double dy;
        int ii;
        if (this._loaded) {
            return;
        }
        if (this._dssManager == null || this._dssId == null) {
            return;
        }
        String fullPathname = this._dssId.getFileName() + "::" + this._dssId.getDSSPath();
        this._dssArray = null;
        try {
            this._dssArray = this._dssManager.readTS(this._dssId, true);
        }
        catch (RemoteException re) {
            System.out.println("Error in SimpleDSSTimeSeries with DSSManager  " + re);
            return;
        }
        catch (FileNotFoundException e) {
            System.out.println("SimpleDSSTimeSeries: DSS File not found " + e);
            return;
        }
        if (this._dssArray == null) {
            System.out.println("Error in TSRecord. Empty record.");
            return;
        }
        this._dataArray.array = this._dssArray.values;
        this.ydata = this._dssArray.values;
        this._timeArray.array = this._dssArray.times;
        this.tdata = this._dssArray.times;
        this.startIdx = 0;
        this.endIdx = this.tdata.length - 1;
        for (ii = 0; ii < this.tdata.length; ++ii) {
            dy = this.ydata[ii];
            if (dy == -3.4028234663852886E38 || dy == -4.9E-324 || dy == Double.NEGATIVE_INFINITY) continue;
            this.startIdx = ii;
            break;
        }
        for (ii = this.tdata.length - 1; ii >= 0; --ii) {
            dy = this.ydata[ii];
            if (dy == -3.4028234663852886E38 || dy == -4.9E-324 || dy == Double.NEGATIVE_INFINITY) continue;
            this.endIdx = ii;
            break;
        }
        System.out.println("\n\n\nSTART = " + this.startIdx);
        System.out.println("END = " + this.endIdx + "\n\n\n");
        this.yunits = this._dssArray.units;
        this.ytype = this._dssArray.type;
        System.out.println(fullPathname + " Number Read " + this._dssArray.numberValues);
        if (this._dssArray.numberValues <= 0) {
            System.out.println("Data Set " + fullPathname + " is empty?");
            return;
        }
        if (this._dssArray.timeZoneID != null && !this._dssArray.timeZoneID.equals("")) {
            super.setGmtOffset(this._dssArray.timeZoneRawOffset / 1000 * 60 * 60);
        }
        try {
            Parameter param = new Parameter(this._dssArray.parameter);
            int paramId = param.getParameterId();
            if (paramId != Integer.MIN_VALUE) {
                this.setYParameterId(paramId);
            }
        }
        catch (DataSetIllegalArgumentException param) {
            // empty catch block
        }
        String units = Units.getUnitsForAlias((String)this._dssArray.units);
        if (units != null) {
            int i;
            String[] unitsList = Unit.getUnitsForSystem((String)"English");
            boolean foundInEnglish = false;
            for (i = 0; unitsList != null && i < unitsList.length; ++i) {
                if (!unitsList[i].equalsIgnoreCase(units)) continue;
                this.setUnitSystem(1);
                foundInEnglish = true;
                break;
            }
            if (!foundInEnglish) {
                unitsList = Unit.getUnitsForSystem((String)"SI");
                for (i = 0; unitsList != null && i < unitsList.length; ++i) {
                    if (!unitsList[i].equalsIgnoreCase(units)) continue;
                    this.setUnitSystem(2);
                    break;
                }
            }
        }
        this._loaded = true;
    }

    public void fixData() {
        if (!this._loaded) {
            return;
        }
        this.getBounds();
        System.out.println("y length " + this.ydata.length + " xdata length " + this.tdata.length);
        this.ydata = this.fixYdata(this.ydata);
        this.tdata = this.fixTdata(this.tdata);
        System.out.println("fixed. y length " + this.ydata.length + " xdata length " + this.tdata.length);
        this.endIdx = this.tdata.length - 1;
    }

    double[] fixYdata(double[] ydata) {
        double[] newYdata = new double[ydata.length * 2 + 2];
        int rows = 0;
        newYdata[rows++] = this.bounds.s;
        for (int i = 0; i < ydata.length; ++i) {
            newYdata[rows++] = ydata[i];
            if (rows <= 1) continue;
            newYdata[rows++] = ydata[i];
        }
        newYdata[rows++] = this.bounds.s;
        return newYdata;
    }

    int[] fixTdata(int[] tdata) {
        int[] newTdata = new int[tdata.length * 2 + 2];
        int rows = 0;
        for (int i = 0; i < tdata.length; ++i) {
            newTdata[rows++] = tdata[i];
            newTdata[rows++] = tdata[i];
        }
        newTdata[rows] = newTdata[rows - 1];
        newTdata[++rows] = newTdata[rows - 1];
        ++rows;
        return newTdata;
    }

    static {
        G2dGlyphFactory.addMapping(SimpleBarDSSTimeSeries.class, SimpleDSSTimeSeriesGlyph.class);
    }
}

