/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.rmi.gfx2d;

import hec.heclib.dss.DSSPathname;
import hec.io.DSSIdentifier;
import java.rmi.RemoteException;
import java.util.List;
import mil.army.usace.hec.rmi.csinterface.BaseDSSManager;
import mil.army.usace.hec.rmi.gfx2d.SimpleDSSData;
import mil.army.usace.hec.rmi.gfx2d.SimpleDSSPairedData;
import mil.army.usace.hec.rmi.gfx2d.SimpleDSSTimeSeries;
import mil.army.usace.hec.rmi.gfx2d.SimpleDSSTimeSeriesCollection;

public class SimpleDSSDataFactory {
    BaseDSSManager _dssManager = null;

    public SimpleDSSDataFactory(BaseDSSManager dssman) {
        this._dssManager = dssman;
    }

    public SimpleDSSData newSimpleDSSData(String filename, String path, String timewin, List<String> collections) {
        if (this._dssManager == null) {
            return null;
        }
        SimpleDSSData data = null;
        DSSIdentifier id = new DSSIdentifier();
        id.setFileName(filename);
        id.setDSSPath(path);
        id.setTimeWindow(timewin);
        try {
            String typstr = this._dssManager.getPathType(id);
            if (typstr == null) {
                return null;
            }
            if (typstr.equals("TimeSeries")) {
                if (DSSPathname.isaCollectionPath((String)path) && collections != null && collections.size() > 1) {
                    data = new SimpleDSSTimeSeriesCollection(this._dssManager, id, collections);
                    data.load();
                } else {
                    data = new SimpleDSSTimeSeries(this._dssManager, id);
                    data.load();
                }
            } else if (typstr.equals("PairedData")) {
                data = new SimpleDSSPairedData(this._dssManager, id);
                data.load();
            }
        }
        catch (RemoteException e) {
            System.out.println("SimpleDSSDataFactory failed to create data");
        }
        return data;
    }

    public SimpleDSSData newSimpleDSSData(String filename, String path, String timewin) {
        return this.newSimpleDSSData(filename, path, timewin, null);
    }
}

