/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.rmi.gfx2d;

import hec.data.DataSetException;
import hec.data.Parameter;
import hec.data.Units;
import hec.geometry.WorldRect;
import hec.gfx2d.G2dGlyphFactory;
import hec.gfx2d.dss.G2dDssPairedData;
import hec.heclib.dss.DSSPathname;
import hec.heclib.util.Unit;
import hec.heclib.util.doubleArrayContainer;
import hec.io.DSSIdentifier;
import hec.io.DSSPairedDataContainer;
import hec.io.PairedDataContainer;
import hec.lang.DSSPathString;
import java.rmi.RemoteException;
import java.util.Vector;
import mil.army.usace.hec.rmi.csinterface.BaseDSSManager;
import mil.army.usace.hec.rmi.gfx2d.SimpleDSSData;
import mil.army.usace.hec.rmi.gfx2d.SimpleDSSPairedDataGlyph;
import rma.util.RMAConst;

public class SimpleDSSPairedData
extends SimpleDSSData
implements G2dDssPairedData {
    static final String DEFAULT_YUNITS = "yunits";
    static final String DEFAULT_XUNITS = "xunits";
    public Vector labels;
    public String xtype;
    public String ytype;
    public doubleArrayContainer xdata = null;
    public Vector ydata = null;
    boolean _loaded = false;

    public SimpleDSSPairedData(BaseDSSManager dssman, DSSIdentifier dssId) {
        super(dssman, dssId);
        this.name = "Simple Data";
        this.xunits = DEFAULT_XUNITS;
        this.yunits = DEFAULT_YUNITS;
        this.xtype = "x";
        this.ytype = "y";
        PairedDataContainer pdc = this.getPairedDataContainer();
        try {
            this.setXParameterId(new Parameter(pdc.xparameter).getParameterId());
            this.setYParameterId(new Parameter(pdc.yparameter).getParameterId());
        }
        catch (DataSetException e) {
            System.out.println("ERROR <SimpleDSSPairedData.init()> : Error Finding paramaeter");
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
        String unitx = Units.getUnitsForAlias((String)pdc.xunits);
        if (unitx != null) {
            int i;
            String[] unitsList = Unit.getUnitsForSystem((String)"English");
            boolean foundInEnglish = false;
            for (i = 0; unitsList != null && i < unitsList.length; ++i) {
                if (!unitsList[i].equalsIgnoreCase(unitx)) continue;
                this.setUnitSystem(1);
                foundInEnglish = true;
                break;
            }
            if (!foundInEnglish) {
                unitsList = Unit.getUnitsForSystem((String)"SI");
                for (i = 0; unitsList != null && i < unitsList.length; ++i) {
                    if (!unitsList[i].equalsIgnoreCase(unitx)) continue;
                    this.setUnitSystem(2);
                    break;
                }
            }
        }
    }

    @Override
    public void unload() {
    }

    @Override
    public WorldRect getBounds() {
        if (this.bounds == null) {
            doubleArrayContainer y = (doubleArrayContainer)this.ydata.elementAt(0);
            this.bounds = new WorldRect(this.xdata.array[0], y.array[0], this.xdata.array[0], y.array[0]);
            for (int i = 1; i < this.xdata.array.length; ++i) {
                if (!RMAConst.isValidValue((double)this.xdata.array[i])) continue;
                if (this.bounds.w > this.xdata.array[i]) {
                    this.bounds.w = this.xdata.array[i];
                    continue;
                }
                if (!(this.bounds.e < this.xdata.array[i])) continue;
                this.bounds.e = this.xdata.array[i];
            }
            for (int k = 0; k < this.ydata.size(); ++k) {
                if (!(this.ydata.elementAt(k) instanceof doubleArrayContainer)) continue;
                doubleArrayContainer yd = (doubleArrayContainer)this.ydata.elementAt(k);
                for (int j = 0; j < yd.array.length; ++j) {
                    if (!RMAConst.isValidValue((double)yd.array[j])) continue;
                    if (this.bounds.s > yd.array[j]) {
                        this.bounds.s = yd.array[j];
                        continue;
                    }
                    if (!(this.bounds.n < yd.array[j])) continue;
                    this.bounds.n = yd.array[j];
                }
            }
        }
        return this.bounds;
    }

    @Override
    public int size() {
        if (this.xdata == null) {
            return 0;
        }
        return this.xdata.array.length;
    }

    public int numYCoord() {
        if (this.ydata == null) {
            return 0;
        }
        return this.ydata.size();
    }

    @Override
    public String getXAxisName() {
        if (this.xunits.equals("") || this.xunits.equals(DEFAULT_XUNITS)) {
            return this.xunits;
        }
        return "%S";
    }

    @Override
    public String getYAxisName() {
        if (this.yunits.equals("") || this.yunits.equals(DEFAULT_XUNITS)) {
            return this.yunits;
        }
        return "%S";
    }

    @Override
    public int getXAxisType() {
        return 0;
    }

    @Override
    public int getYAxisType() {
        return 0;
    }

    @Override
    public void load() {
        if (this._loaded) {
            return;
        }
        if (this._dssManager == null || this._dssId == null) {
            return;
        }
        String fullPathname = this._dssId.getFileName() + "::" + this._dssId.getDSSPath();
        DSSPairedDataContainer dssPDC = null;
        try {
            dssPDC = this._dssManager.readPDContainer(this._dssId);
        }
        catch (RemoteException re) {
            System.out.println("Error in SimpleDSSPairedData with DSSManager  " + re);
            return;
        }
        if (dssPDC == null) {
            System.out.println("Error in Paired Data Record. Empty record.");
            return;
        }
        this.xdata = dssPDC.xdata;
        this.ydata = dssPDC.ydata;
        if (this.ydata == null || this.ydata.size() == 0) {
            System.out.println("Error in Y-Data from Paired Data Read. Empty.");
            return;
        }
        if (dssPDC.yunits != null && !dssPDC.yunits.equals("")) {
            this.yunits = dssPDC.yunits;
        }
        if (dssPDC.ytype != null && !dssPDC.ytype.equals("")) {
            this.ytype = dssPDC.ytype;
        }
        if (dssPDC.xunits != null && !dssPDC.xunits.equals("")) {
            this.xunits = dssPDC.xunits;
        }
        if (dssPDC.xtype != null && !dssPDC.xtype.equals("")) {
            this.xtype = dssPDC.xtype;
        }
        this.labels = dssPDC.labels;
        String[] sa = DSSPathString.parsePathname((String)this._dssId.getDSSPath());
        if (sa != null) {
            this.name = sa[1] + "." + sa[5] + "." + sa[2] + "." + sa[4];
        }
        if (dssPDC.numberRead <= 0) {
            System.out.println("Data Set " + fullPathname + " is empty?");
            return;
        }
        this._loaded = true;
    }

    public PairedDataContainer getPairedDataContainer() {
        int i;
        if (!this._loaded) {
            this.load();
        }
        if (!this._loaded) {
            System.out.println("Unable to retrieve data set: " + this._dssId.getFileName() + "::" + this._dssId.getDSSPath());
            return null;
        }
        PairedDataContainer pairedDataContainer = new PairedDataContainer();
        pairedDataContainer.fileName = this._dssId.getFileName();
        pairedDataContainer.fullName = this._dssId.getDSSPath();
        pairedDataContainer.numberOrdinates = this.xdata.array.length;
        pairedDataContainer.numberCurves = this.ydata.size();
        pairedDataContainer.xOrdinates = this.xdata.array;
        pairedDataContainer.yOrdinates = new double[pairedDataContainer.numberCurves][0];
        for (i = 0; i < pairedDataContainer.numberCurves; ++i) {
            doubleArrayContainer yd = (doubleArrayContainer)this.ydata.elementAt(i);
            pairedDataContainer.yOrdinates[i] = yd.array;
        }
        if (this.labels.size() > 0) {
            pairedDataContainer.labels = new String[this.labels.size()];
            for (i = 0; i < this.labels.size(); ++i) {
                pairedDataContainer.labels[i] = (String)this.labels.elementAt(i);
            }
            pairedDataContainer.labelsUsed = true;
        } else {
            pairedDataContainer.labelsUsed = false;
        }
        pairedDataContainer.xunits = this.xunits;
        pairedDataContainer.yunits = this.yunits;
        pairedDataContainer.xtype = this.xtype;
        pairedDataContainer.ytype = this.ytype;
        pairedDataContainer.xprecision = -1;
        pairedDataContainer.yprecision = -1;
        DSSPathname dssPathname = new DSSPathname(pairedDataContainer.fullName);
        pairedDataContainer.watershed = dssPathname.aPart();
        pairedDataContainer.location = dssPathname.bPart();
        pairedDataContainer.other = dssPathname.dPart();
        pairedDataContainer.date = dssPathname.ePart();
        pairedDataContainer.version = dssPathname.fPart();
        pairedDataContainer.subVersion = "";
        pairedDataContainer.xparameter = dssPathname.getPairedDataX();
        pairedDataContainer.yparameter = dssPathname.getPairedDataY();
        return pairedDataContainer;
    }

    static {
        G2dGlyphFactory.addMapping(SimpleDSSPairedData.class, SimpleDSSPairedDataGlyph.class);
    }
}

