/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.rmi.gfx2d;

import hec.data.DataSetIllegalArgumentException;
import hec.data.Parameter;
import hec.data.Units;
import hec.geometry.WorldPt;
import hec.geometry.WorldRect;
import hec.gfx2d.G2dGlyphFactory;
import hec.gfx2d.autoload.RefreshCookie;
import hec.gfx2d.dss.G2dDssTimeSeries;
import hec.heclib.util.HecTime;
import hec.heclib.util.Unit;
import hec.heclib.util.doubleArrayContainer;
import hec.heclib.util.intArrayContainer;
import hec.io.DSSIdentifier;
import hec.io.TimeSeriesContainer;
import hec.lang.DSSPathString;
import java.io.FileNotFoundException;
import java.rmi.RemoteException;
import mil.army.usace.hec.rmi.csinterface.BaseDSSManager;
import mil.army.usace.hec.rmi.gfx2d.SimpleDSSData;
import mil.army.usace.hec.rmi.gfx2d.SimpleDSSTimeSeriesGlyph;
import rma.util.RMAConst;
import rma.util.lookup.Lookups;

public class SimpleDSSTimeSeries
extends SimpleDSSData
implements G2dDssTimeSeries {
    protected transient TimeSeriesContainer _dssArray = null;
    protected transient intArrayContainer _timeArray = new intArrayContainer();
    protected transient doubleArrayContainer _dataArray = new doubleArrayContainer();
    public int[] tdata;
    public double[] ydata;
    public int startIdx;
    public int endIdx;
    public String xtype;
    public String ytype;
    public int numberValues;
    boolean _loaded = false;

    public SimpleDSSTimeSeries(BaseDSSManager dssman, DSSIdentifier dssId) {
        super(dssman, dssId);
        String[] sa = DSSPathString.parsePathname((String)dssId.getDSSPath());
        this.name = sa != null ? sa[1] + "." + sa[5] + "." + sa[2] + "." + sa[4] : "Time-Series";
        this.xunits = "min";
        this.xtype = "time";
        this.yunits = "yunits";
        this.ytype = "ytype";
        DSSPathString pathstr = new DSSPathString(dssId.getDSSPath());
        this.yunits = pathstr.getCPart();
        this._lookup = Lookups.fixed((Object[])new Object[]{new ReloadCookie()});
        this.load();
    }

    @Override
    public int size() {
        if (this._dssArray == null) {
            return 0;
        }
        return this.numberValues;
    }

    @Override
    public String getXAxisName() {
        return "Minutes";
    }

    @Override
    public String getYAxisName() {
        if (this.getUnitSystem() == 0 || this.getYParameterId() == -1) {
            return this.yunits;
        }
        return Parameter.getParamString((int)this.getYParameterId()) + " (%S)";
    }

    @Override
    public int getXAxisType() {
        return 1;
    }

    @Override
    public int getYAxisType() {
        return 0;
    }

    @Override
    public void load() {
        int ii;
        if (this._loaded) {
            return;
        }
        if (this._dssManager == null || this._dssId == null) {
            return;
        }
        String fullPathname = this._dssId.getFileName() + "::" + this._dssId.getDSSPath();
        this._dssArray = null;
        try {
            this._dssArray = this._dssManager.readTS(this._dssId, false, false);
        }
        catch (RemoteException re) {
            System.out.println("Error in SimpleDSSTimeSeries with DSSManager  " + re);
            return;
        }
        catch (FileNotFoundException e) {
            System.out.println("SimpleDSSTimeSeries.load: DSS File not found " + e);
            return;
        }
        if (this._dssArray == null || this._dssArray.times == null || this._dssArray.values == null) {
            System.out.println("\nSimpleDSSTimeSeries; No data for record " + fullPathname + "\n");
            return;
        }
        this._dataArray.array = this._dssArray.values;
        this.ydata = this._dssArray.values;
        this._timeArray.array = this._dssArray.times;
        this.tdata = this._dssArray.times;
        this.ytype = this._dssArray.type;
        this.numberValues = this._dssArray.numberValues;
        if (this.ytype != null && this.ytype.length() > 0 && !this.ytype.toUpperCase().startsWith("INST") && this._dssArray.times.length > 0) {
            int istart = 0;
            for (int i = 0; i < this.ydata.length; ++i) {
                if (!RMAConst.isValidValue((double)this.ydata[i])) continue;
                istart = i;
                break;
            }
            if (istart == 0) {
                int[] tempTime = this.tdata;
                double[] tempYData = this.ydata;
                this.tdata = new int[this.tdata.length + 1];
                this.ydata = new double[this.ydata.length + 1];
                System.arraycopy(tempTime, 0, this.tdata, 1, tempTime.length);
                System.arraycopy(tempYData, 0, this.ydata, 1, tempYData.length);
                this.ydata[0] = this.ydata[1];
                int interval = 0;
                if (this.tdata.length > 3) {
                    interval = this.tdata[2] - this.tdata[1];
                }
                this.tdata[0] = this.tdata[1] - interval;
                HecTime time0 = new HecTime(1);
                time0.setMinutes((long)this.tdata[1]);
                time0.increment(-1, interval);
                this.tdata[0] = time0.value();
                ++this.numberValues;
            } else {
                this.tdata = new int[this.tdata.length];
                this.ydata = new double[this.ydata.length];
                System.arraycopy(this._timeArray.array, 0, this.tdata, 0, this._timeArray.array.length);
                System.arraycopy(this._dataArray.array, 0, this.ydata, 0, this._dataArray.array.length);
                this.ydata[istart - 1] = this.ydata[istart];
            }
        }
        this.startIdx = 0;
        this.endIdx = this.tdata.length - 1;
        for (ii = 0; ii < this.tdata.length; ++ii) {
            double dy = this.ydata[ii];
            if (dy == -3.4028234663852886E38 || dy == -4.9E-324 || dy == Double.NEGATIVE_INFINITY) continue;
            this.startIdx = ii;
            break;
        }
        for (ii = this.tdata.length - 1; ii >= 0; --ii) {
            double dy = this.ydata[ii];
            if (dy == -3.4028234663852886E38 || dy == -4.9E-324 || dy == Double.NEGATIVE_INFINITY) continue;
            this.endIdx = ii;
            break;
        }
        this.yunits = this._dssArray.units;
        this.ytype = this._dssArray.type;
        System.out.println("Read " + this._dssArray.numberValues + " values for " + fullPathname);
        if (this._dssArray.numberValues <= 0) {
            System.out.println("No data found for " + fullPathname);
            return;
        }
        if (this.yunits.equalsIgnoreCase("FEET")) {
            this.yunits = "ft";
        }
        if (Units.getUnitsForAlias((String)this.yunits) != null) {
            this.yunits = Units.getUnitsForAlias((String)this.yunits);
        }
        if (this._dssArray.timeZoneID != null && !this._dssArray.timeZoneID.equals("")) {
            super.setGmtOffset(this._dssArray.timeZoneRawOffset / 3600000);
        }
        try {
            Parameter param = new Parameter(this._dssArray.parameter);
            int paramId = param.getParameterId();
            if (paramId != -1) {
                this.setYParameterId(paramId);
            }
        }
        catch (DataSetIllegalArgumentException e) {
            System.out.println("--------------------------------------------------------------------------");
            System.out.println("Invalid Parameter in SimpleDSSTimeSeries.load() " + e.getMessage());
            System.out.println("Will continue using UNDEFINED parameter");
            System.out.println("--------------------------------------------------------------------------");
        }
        String units = Units.getUnitsForAlias((String)this._dssArray.units);
        if (units != null) {
            int i;
            String[] unitsList = Unit.getUnitsForSystem((String)"English");
            boolean foundInEnglish = false;
            for (i = 0; unitsList != null && i < unitsList.length; ++i) {
                if (!unitsList[i].equalsIgnoreCase(units)) continue;
                this.setUnitSystem(1);
                foundInEnglish = true;
                break;
            }
            if (!foundInEnglish) {
                unitsList = Unit.getUnitsForSystem((String)"SI");
                for (i = 0; unitsList != null && i < unitsList.length; ++i) {
                    if (!unitsList[i].equalsIgnoreCase(units)) continue;
                    this.setUnitSystem(2);
                    break;
                }
            }
        }
        this._loaded = true;
        this.setChanged();
        this.notifyObservers("reset data");
    }

    @Override
    public WorldRect getBounds() {
        if (this.bounds == null) {
            for (int s = this.startIdx; s <= this.endIdx; ++s) {
                double min;
                double max;
                double d1 = this.tdata[s];
                if (!RMAConst.isValidValue((double)d1)) continue;
                if (this.hasDefaultMaxYValue()) {
                    max = this.getDefaultMaxYValue();
                } else {
                    if (!RMAConst.isValidValue((double)this.ydata[s])) continue;
                    max = this.ydata[s];
                }
                if (this.hasDefaultMinYValue()) {
                    min = this.getDefaultMinYValue();
                } else {
                    if (!RMAConst.isValidValue((double)this.ydata[s])) continue;
                    min = this.ydata[s];
                }
                this.bounds = new WorldRect(d1, max, d1, min);
                break;
            }
            for (int i = s + 1; i <= this.endIdx; ++i) {
                double dx = this.tdata[i];
                double dy = this.ydata[i];
                if (!RMAConst.isValidValue((double)dx) || !RMAConst.isValidValue((double)dy)) continue;
                if (this.bounds.w > dx) {
                    this.bounds.w = dx;
                } else if (this.bounds.e < dx) {
                    this.bounds.e = dx;
                }
                if (this.bounds.s > dy) {
                    this.bounds.s = dy;
                    continue;
                }
                if (!(this.bounds.n < dy)) continue;
                this.bounds.n = dy;
            }
        }
        return this.bounds;
    }

    public TimeSeriesContainer getTimeSeriesContainer() {
        if (!this._loaded) {
            this.load();
        }
        if (!this._loaded) {
            System.out.println("Unable to retrieve data set: " + this._dssId.getFileName() + "::" + this._dssId.getDSSPath());
            return null;
        }
        return this._dssArray;
    }

    public boolean equals(Object obj) {
        if (obj instanceof SimpleDSSTimeSeries) {
            return this.equals((SimpleDSSTimeSeries)((Object)obj));
        }
        return false;
    }

    public boolean equals(SimpleDSSTimeSeries tsObj) {
        if (tsObj == null) {
            return false;
        }
        boolean dssIdEqual = this._dssId.equals(tsObj._dssId);
        if (!dssIdEqual || this._modelVariable == null) {
            return dssIdEqual;
        }
        boolean mvEqual = this._modelVariable.equals(tsObj._modelVariable);
        return mvEqual;
    }

    public WorldPt getNearestDataPt(WorldPt pt) {
        if (this.size() == 0) {
            return null;
        }
        double y2 = -1.0;
        double y1 = -1.0;
        double x2 = -1.0;
        double x1 = -1.0;
        double dist = Double.POSITIVE_INFINITY;
        WorldPt closestPt = null;
        for (int z = 0; z < this.size(); ++z) {
            if (closestPt == null) {
                closestPt = new WorldPt((double)this.tdata[0], this.ydata[0]);
            }
            x1 = this.tdata[z];
            y1 = this.ydata[z];
            double dx = pt.e - x1;
            double dy = pt.n - y1;
            if (dx == 0.0 && dy == 0.0) {
                return pt;
            }
            double tmp = Math.sqrt(dx * dx + dy * dy);
            if (!(tmp < dist)) continue;
            dist = tmp;
            closestPt.init(x1, y1);
        }
        return closestPt;
    }

    public void setLoaded(boolean b) {
        this._loaded = b;
    }

    public String getYType() {
        return this.ytype;
    }

    static {
        G2dGlyphFactory.addMapping(SimpleDSSTimeSeries.class, SimpleDSSTimeSeriesGlyph.class);
    }

    private class ReloadCookie
    implements RefreshCookie {
        private ReloadCookie() {
        }

        public void refresh(String msg) {
            SimpleDSSTimeSeries.this.setLoaded(false);
            SimpleDSSTimeSeries.this.load();
        }
    }
}

