/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.rmi.gfx2d;

import hec.data.DataSetIllegalArgumentException;
import hec.data.Parameter;
import hec.data.Units;
import hec.geometry.WorldPt;
import hec.geometry.WorldRect;
import hec.gfx2d.G2dGlyphFactory;
import hec.gfx2d.dss.G2dDssTimeSeriesCollection;
import hec.heclib.dss.DSSPathname;
import hec.heclib.dss.HecTimeSeries;
import hec.heclib.util.HecTime;
import hec.heclib.util.Unit;
import hec.heclib.util.intArrayContainer;
import hec.hecmath.HecMath;
import hec.hecmath.HecMathException;
import hec.hecmath.TimeSeriesMath;
import hec.io.DSSIdentifier;
import hec.io.DataContainer;
import hec.io.TimeSeriesCollectionContainer;
import hec.io.TimeSeriesContainer;
import hec.lang.DSSPathString;
import java.util.List;
import mil.army.usace.hec.rmi.csinterface.BaseDSSManager;
import mil.army.usace.hec.rmi.gfx2d.SimpleDSSData;
import mil.army.usace.hec.rmi.gfx2d.SimpleDSSTimeSeriesCollectionGlyph;
import rma.util.RMAConst;

public class SimpleDSSTimeSeriesCollection
extends SimpleDSSData
implements G2dDssTimeSeriesCollection {
    protected transient TimeSeriesCollectionContainer _dssCollectionArray = null;
    protected transient intArrayContainer _timeArray = new intArrayContainer();
    protected TimeSeriesContainer _mean;
    protected TimeSeriesContainer _median;
    protected TimeSeriesContainer _p25;
    protected TimeSeriesContainer _p75;
    protected TimeSeriesContainer _max;
    protected TimeSeriesContainer _min;
    public static int MAX;
    public static int MIN;
    public static int MEAN;
    public static int SD1N;
    public static int SD1P;
    public int[] tdata;
    public double[][] ydata;
    public int startIdx;
    public int endIdx;
    public String xtype;
    public String ytype;
    public int numberValues;
    private TimeSeriesMath[] _hecMathArray;
    private TimeSeriesMath _tsMathGuy;
    private TimeSeriesContainer _outputDc;
    private HecMath _outputMath;
    private List<String> _collections;
    boolean _loaded = false;
    private BaseDSSManager _manager;

    public SimpleDSSTimeSeriesCollection(BaseDSSManager dssman, DSSIdentifier dssId, List<String> collections) {
        super(dssman, dssId);
        String[] sa = DSSPathString.parsePathname((String)dssId.getDSSPath());
        this.name = sa != null ? sa[1] + "." + sa[5] + "." + sa[2] + "." + sa[4] : "Time-Series";
        this.xunits = "min";
        this.xtype = "time";
        this.yunits = "yunits";
        this.ytype = "ytype";
        this._collections = collections;
        DSSPathString pathstr = new DSSPathString(dssId.getDSSPath());
        this.yunits = pathstr.getCPart();
        this._manager = dssman;
        this.load();
    }

    @Override
    public int size() {
        if (this._dssCollectionArray == null) {
            return 0;
        }
        return this._dssCollectionArray.size();
    }

    @Override
    public String getXAxisName() {
        return "Minutes";
    }

    @Override
    public String getYAxisName() {
        if (this.getUnitSystem() == 0 || this.getYParameterId() == -1) {
            return this.yunits;
        }
        return Parameter.getParamString((int)this.getYParameterId()) + " (%S)";
    }

    @Override
    public int getXAxisType() {
        return 1;
    }

    @Override
    public int getYAxisType() {
        return 0;
    }

    @Override
    public void load() {
        TimeSeriesContainer tsc;
        if (this._loaded) {
            return;
        }
        if (this._dssManager == null || this._dssId == null) {
            return;
        }
        String fullPathname = this._dssId.getFileName() + "::" + this._dssId.getDSSPath();
        HecTimeSeries timeSeries = new HecTimeSeries();
        timeSeries.setDSSFileName(this._dssId.getFileName());
        timeSeries.setPathname(this._dssId.getDSSPath().toUpperCase());
        timeSeries.setStartTime(this._dssId.getStartTime());
        timeSeries.setEndTime(this._dssId.getEndTime());
        TimeSeriesCollectionContainer tempContainer = new TimeSeriesCollectionContainer();
        this._dssCollectionArray = new TimeSeriesCollectionContainer();
        timeSeries.read(this._dssCollectionArray, true);
        if (this._dssCollectionArray == null || this._dssCollectionArray.getTimes() == null || this._dssCollectionArray.get() == null) {
            System.out.println("\nSimpleDSSTimeSeriesCollection; No data for record " + fullPathname + "\n");
            return;
        }
        String[] sequences = this._dssCollectionArray.getSequences();
        for (int i = 0; i < sequences.length; ++i) {
            if (this._collections.contains(sequences[i])) continue;
            tsc = this._dssCollectionArray.get(sequences[i]);
            this._dssCollectionArray.remove(tsc);
        }
        this._max = this.getMax();
        this._min = this.getMin();
        this._median = this.getMedian();
        this._p25 = this.getP25();
        this._p75 = this.getP75();
        this._dssCollectionArray.add(this._max);
        this._dssCollectionArray.add(this._min);
        this._dssCollectionArray.add(this._median);
        this._dssCollectionArray.add(this._p25);
        this._dssCollectionArray.add(this._p75);
        TimeSeriesContainer[] tsContainers = this._dssCollectionArray.get();
        this.ydata = new double[tsContainers.length][tsContainers[0].values.length];
        for (int i = 0; i < tsContainers.length; ++i) {
            tsc = tsContainers[i];
            if (i == 0) {
                this._timeArray.array = tsc.times;
                this.tdata = tsc.times;
            }
            this.ydata[i] = tsc.values;
        }
        this.ytype = this._dssCollectionArray.get()[0].type;
        this.numberValues = this._dssCollectionArray.get()[0].numberValues;
        if (this.ytype != null && this.ytype.length() > 0 && !this.ytype.toUpperCase().startsWith("INST") && this.tdata.length > 0) {
            for (int j = 0; j < this.ydata.length; ++j) {
                int istart = 0;
                for (int i = 0; i < this.ydata[j].length; ++i) {
                    if (RMAConst.isValidValue((double)this.ydata[j][i])) {
                        istart = i;
                    }
                    if (istart == 0) {
                        int[] tempTime = this.tdata;
                        double[] tempYData = this.ydata[j];
                        this.tdata = new int[this.tdata.length + 1];
                        this.ydata[j] = new double[this.ydata[j].length + 1];
                        System.arraycopy(tempTime, 0, this.tdata, 1, tempTime.length);
                        System.arraycopy(tempYData, 0, this.ydata[j], 1, tempYData.length);
                        int interval = 0;
                        if (this.tdata.length > 3) {
                            interval = this.tdata[2] - this.tdata[1];
                        }
                        this.tdata[0] = this.tdata[1] - interval;
                        HecTime time0 = new HecTime(1);
                        time0.setMinutes((long)this.tdata[1]);
                        time0.increment(-1, interval);
                        this.tdata[0] = time0.value();
                        continue;
                    }
                    this.tdata = new int[this._timeArray.array.length];
                    this.ydata[j] = new double[this._dssCollectionArray.get((int)j).values.length];
                    System.arraycopy(this._timeArray.array, 0, this.tdata, 0, this._timeArray.array.length);
                    System.arraycopy(this._dssCollectionArray.get((int)j).values, 0, this.ydata[j], 0, this._dssCollectionArray.get((int)j).values.length);
                }
            }
        }
        this.startIdx = 0;
        this.endIdx = this.tdata.length - 1;
        for (int ii = 0; ii < this.tdata.length; ++ii) {
            double dy = this.ydata[0][ii];
            if (dy == -3.4028234663852886E38 || dy == -4.9E-324 || dy == Double.NEGATIVE_INFINITY) continue;
            this.startIdx = ii;
            break;
        }
        for (int r = this.tdata.length - 1; r >= 0; --r) {
            double dy = this.ydata[0][r];
            if (dy == -3.4028234663852886E38 || dy == -4.9E-324 || dy == Double.NEGATIVE_INFINITY) continue;
            this.endIdx = r;
            break;
        }
        this.yunits = this._dssCollectionArray.get((int)0).units;
        this.ytype = this._dssCollectionArray.get((int)0).type;
        System.out.println("Read " + this._dssCollectionArray.get((int)0).numberValues + " values for " + fullPathname);
        if (this._dssCollectionArray.get((int)0).numberValues <= 0) {
            System.out.println("No data found for " + fullPathname);
            return;
        }
        if (this.yunits.equalsIgnoreCase("FEET")) {
            this.yunits = "ft";
        }
        if (Units.getUnitsForAlias((String)this.yunits) != null) {
            this.yunits = Units.getUnitsForAlias((String)this.yunits);
        }
        if (this._dssCollectionArray.get((int)0).timeZoneID != null && !this._dssCollectionArray.get((int)0).timeZoneID.equals("")) {
            super.setGmtOffset(this._dssCollectionArray.get((int)0).timeZoneRawOffset / 3600000);
        }
        try {
            Parameter param = new Parameter(this._dssCollectionArray.get((int)0).parameter);
            int paramId = param.getParameterId();
            if (paramId != -1) {
                this.setYParameterId(paramId);
            }
        }
        catch (DataSetIllegalArgumentException e) {
            System.out.println("--------------------------------------------------------------------------");
            System.out.println("Invalid Parameter in SimpleDSSTimeSeries.load() " + e.getMessage());
            System.out.println("Will continue using UNDEFINED parameter");
            System.out.println("--------------------------------------------------------------------------");
        }
        String units = Units.getUnitsForAlias((String)this._dssCollectionArray.get((int)0).units);
        if (units != null) {
            int i;
            String[] unitsList = Unit.getUnitsForSystem((String)"English");
            boolean foundInEnglish = false;
            for (i = 0; unitsList != null && i < unitsList.length; ++i) {
                if (!unitsList[i].equalsIgnoreCase(units)) continue;
                this.setUnitSystem(1);
                foundInEnglish = true;
                break;
            }
            if (!foundInEnglish) {
                unitsList = Unit.getUnitsForSystem((String)"SI");
                for (i = 0; unitsList != null && i < unitsList.length; ++i) {
                    if (!unitsList[i].equalsIgnoreCase(units)) continue;
                    this.setUnitSystem(2);
                    break;
                }
            }
        }
        this._loaded = true;
    }

    @Override
    public void unload() {
    }

    @Override
    public WorldRect getBounds() {
        if (this.bounds == null) {
            for (int s = this.startIdx; s <= this.endIdx; ++s) {
                double d1 = this.tdata[s];
                if (!RMAConst.isValidValue((double)d1)) continue;
                if (this.hasDefaultMaxYValue()) {
                    double d = this.getDefaultMaxYValue();
                }
                if (this.hasDefaultMinYValue()) {
                    double d = this.getDefaultMinYValue();
                }
                double max = this.getMax().maxmimumValue();
                double min = this.getMin().minimumValue();
                this.bounds = new WorldRect(d1, max, d1, min);
                break;
            }
            for (int i = s + 1; i <= this.endIdx; ++i) {
                double dx = this.tdata[i];
                double dy = this.ydata[0][i];
                if (!RMAConst.isValidValue((double)dx) || !RMAConst.isValidValue((double)dy)) continue;
                if (this.bounds.w > dx) {
                    this.bounds.w = dx;
                } else if (this.bounds.e < dx) {
                    this.bounds.e = dx;
                }
                if (this.bounds.s > dy) {
                    this.bounds.s = dy;
                    continue;
                }
                if (!(this.bounds.n < dy)) continue;
                this.bounds.n = dy;
            }
        }
        return this.bounds;
    }

    public TimeSeriesCollectionContainer getTimeSeriesContainer() {
        if (!this._loaded) {
            this.load();
        }
        if (!this._loaded) {
            System.out.println("Unable to retrieve data set: " + this._dssId.getFileName() + "::" + this._dssId.getDSSPath());
            return null;
        }
        return this._dssCollectionArray;
    }

    public int getCurveCount() {
        return this._dssCollectionArray.size();
    }

    public double[] getXValues(int curveNum) {
        return this._dssCollectionArray.get((int)curveNum).values;
    }

    public double[] getYValues(int curveNum) {
        return this.ydata[curveNum];
    }

    public boolean equals(Object obj) {
        if (obj instanceof SimpleDSSTimeSeriesCollection) {
            return this.equals((SimpleDSSTimeSeriesCollection)((Object)obj));
        }
        return false;
    }

    public boolean equals(SimpleDSSTimeSeriesCollection tsObj) {
        if (tsObj == null) {
            return false;
        }
        return this._dssId.equals(tsObj._dssId);
    }

    public WorldPt getNearestDataPt(WorldPt pt) {
        if (this.size() == 0) {
            return null;
        }
        double y2 = -1.0;
        double y1 = -1.0;
        double x2 = -1.0;
        double x1 = -1.0;
        double dist = Double.POSITIVE_INFINITY;
        WorldPt closestPt = null;
        for (int z = 0; z < this.size(); ++z) {
            if (closestPt == null) {
                closestPt = new WorldPt((double)this.tdata[0], this.ydata[0][0]);
            }
            x1 = this.tdata[z];
            y1 = this.ydata[0][z];
            double dx = pt.e - x1;
            double dy = pt.n - y1;
            if (dx == 0.0 && dy == 0.0) {
                return pt;
            }
            double tmp = Math.sqrt(dx * dx + dy * dy);
            if (!(tmp < dist)) continue;
            dist = tmp;
            closestPt.init(x1, y1);
        }
        return closestPt;
    }

    public void setLoaded(boolean b) {
        this._loaded = b;
    }

    public void createHecMathArray() {
        this._hecMathArray = new TimeSeriesMath[this._dssCollectionArray.size()];
        for (int i = 0; i < this._hecMathArray.length; ++i) {
            TimeSeriesMath tsMathGuy = new TimeSeriesMath();
            try {
                tsMathGuy.setData((DataContainer)this._dssCollectionArray.get(i));
                this._hecMathArray[i] = tsMathGuy;
                continue;
            }
            catch (HecMathException e) {
                e.printStackTrace();
            }
        }
    }

    public TimeSeriesContainer getMean() {
        if (this._hecMathArray == null) {
            this.createHecMathArray();
        }
        if (this._hecMathArray.length < 2) {
            return null;
        }
        this._tsMathGuy = new TimeSeriesMath();
        if (this._mean != null) {
            return this._mean;
        }
        this._mean = new TimeSeriesContainer();
        try {
            this._tsMathGuy.setData(this._hecMathArray[0].getData());
            DSSPathname pathname = new DSSPathname(this._tsMathGuy.getPath());
            pathname.setCollectionSequence("00MEAN");
            this._tsMathGuy.setPathname(pathname.getPathname());
            TimeSeriesMath[] tsMathArray = new TimeSeriesMath[this._hecMathArray.length - 1];
            System.arraycopy(this._hecMathArray, 1, tsMathArray, 0, tsMathArray.length);
            this._outputMath = this._tsMathGuy.mean((HecMath[])tsMathArray);
            this._outputMath.getData((DataContainer)this._mean);
        }
        catch (HecMathException e) {
            System.out.println("Unable to calculate Mean for time series collection: " + this._dssId.getDSSPath() + e);
            e.printStackTrace();
            return null;
        }
        DSSIdentifier id = new DSSIdentifier();
        id.setTimeWindow(this._dssId.getTimeWindow());
        id.setDSSPath(this._mean.fullName);
        id.setFileName(this._dssId.getFileName());
        return this._mean;
    }

    public TimeSeriesContainer getMedian() {
        if (this._hecMathArray == null) {
            this.createHecMathArray();
        }
        if (this._hecMathArray.length < 2) {
            return null;
        }
        this._tsMathGuy = new TimeSeriesMath();
        if (this._median != null) {
            return this._median;
        }
        this._median = new TimeSeriesContainer();
        try {
            this._tsMathGuy.setData(this._hecMathArray[0].getData());
            DSSPathname pathname = new DSSPathname(this._tsMathGuy.getPath());
            pathname.setCollectionSequence("MEDIAN");
            this._tsMathGuy.setPathname(pathname.getPathname());
            TimeSeriesMath[] tsMathArray = new TimeSeriesMath[this._hecMathArray.length - 1];
            System.arraycopy(this._hecMathArray, 1, tsMathArray, 0, tsMathArray.length);
            this._outputMath = this._tsMathGuy.med((HecMath[])tsMathArray);
            this._outputMath.getData((DataContainer)this._median);
        }
        catch (HecMathException e) {
            System.out.println("Unable to calculate Mean for time series collection: " + this._dssId.getDSSPath() + e);
            e.printStackTrace();
            return null;
        }
        DSSIdentifier id = new DSSIdentifier();
        id.setTimeWindow(this._dssId.getTimeWindow());
        id.setDSSPath(this._median.fullName);
        id.setFileName(this._dssId.getFileName());
        return this._median;
    }

    public TimeSeriesContainer getP25() {
        if (this._hecMathArray == null) {
            this.createHecMathArray();
        }
        if (this._hecMathArray.length < 2) {
            return null;
        }
        this._tsMathGuy = new TimeSeriesMath();
        if (this._p25 != null) {
            return this._p25;
        }
        this._p25 = new TimeSeriesContainer();
        try {
            this._tsMathGuy.setData(this._hecMathArray[0].getData());
            DSSPathname pathname = new DSSPathname(this._tsMathGuy.getPath());
            pathname.setCollectionSequence("000P25");
            this._tsMathGuy.setPathname(pathname.getPathname());
            TimeSeriesMath[] tsMathArray = new TimeSeriesMath[this._hecMathArray.length - 1];
            System.arraycopy(this._hecMathArray, 1, tsMathArray, 0, tsMathArray.length);
            this._outputMath = this._tsMathGuy.p25((HecMath[])tsMathArray);
            this._outputMath.getData((DataContainer)this._p25);
        }
        catch (HecMathException e) {
            System.out.println("Unable to calculate Mean for time series collection: " + this._dssId.getDSSPath() + e);
            e.printStackTrace();
            return null;
        }
        DSSIdentifier id = new DSSIdentifier();
        id.setTimeWindow(this._dssId.getTimeWindow());
        id.setDSSPath(this._p25.fullName);
        id.setFileName(this._dssId.getFileName());
        return this._p25;
    }

    public TimeSeriesContainer getP75() {
        if (this._hecMathArray == null) {
            this.createHecMathArray();
        }
        if (this._hecMathArray.length < 2) {
            return null;
        }
        this._tsMathGuy = new TimeSeriesMath();
        if (this._p75 != null) {
            return this._p75;
        }
        this._p75 = new TimeSeriesContainer();
        try {
            this._tsMathGuy.setData(this._hecMathArray[0].getData());
            DSSPathname pathname = new DSSPathname(this._tsMathGuy.getPath());
            pathname.setCollectionSequence("000P75");
            this._tsMathGuy.setPathname(pathname.getPathname());
            TimeSeriesMath[] tsMathArray = new TimeSeriesMath[this._hecMathArray.length - 1];
            System.arraycopy(this._hecMathArray, 1, tsMathArray, 0, tsMathArray.length);
            this._outputMath = this._tsMathGuy.p75((HecMath[])tsMathArray);
            this._outputMath.getData((DataContainer)this._p75);
        }
        catch (HecMathException e) {
            System.out.println("Unable to calculate Mean for time series collection: " + this._dssId.getDSSPath() + e);
            e.printStackTrace();
            return null;
        }
        DSSIdentifier id = new DSSIdentifier();
        id.setTimeWindow(this._dssId.getTimeWindow());
        id.setDSSPath(this._p75.fullName);
        id.setFileName(this._dssId.getFileName());
        return this._p75;
    }

    public TimeSeriesContainer[] getFirstStandardDeviations() {
        DSSPathname pathname;
        if (this._hecMathArray == null) {
            this.createHecMathArray();
        }
        if (this._hecMathArray.length < 2) {
            return null;
        }
        this._tsMathGuy = new TimeSeriesMath();
        this._outputDc = new TimeSeriesContainer();
        TimeSeriesContainer outputDc1 = new TimeSeriesContainer();
        TimeSeriesContainer outputDc2 = new TimeSeriesContainer();
        try {
            this._tsMathGuy.setData(this._hecMathArray[0].getData());
            pathname = new DSSPathname(this._hecMathArray[0].getPath());
            pathname.setCollectionSequence("00SD1P");
            this._tsMathGuy.setPathname(pathname.getPathname());
            TimeSeriesMath[] tsMathArray = new TimeSeriesMath[this._hecMathArray.length - 1];
            System.arraycopy(this._hecMathArray, 1, tsMathArray, 0, tsMathArray.length);
            this._outputMath = this._tsMathGuy.standardDeviation((HecMath[])tsMathArray);
            this._outputMath.getData((DataContainer)this._outputDc);
        }
        catch (HecMathException e) {
            System.out.println("Unable to calculate Mean for time series collection: " + this._dssId.getDSSPath() + e);
            e.printStackTrace();
            return null;
        }
        try {
            this._tsMathGuy = new TimeSeriesMath();
            if (this._mean != null) {
                this.getMean();
                this._tsMathGuy.setData((DataContainer)this._mean);
            }
            pathname = new DSSPathname(this._tsMathGuy.getPath());
            pathname.setCollectionSequence("00SD1P");
            this._tsMathGuy.setPathname(pathname.getPathname());
            this._outputMath = this._tsMathGuy.add((HecMath)new TimeSeriesMath(this._outputDc));
            this._outputMath.getData((DataContainer)outputDc1);
        }
        catch (HecMathException e) {
            System.out.println("Unable to calculate Mean for time series collection: " + this._dssId.getDSSPath() + e);
            e.printStackTrace();
            return null;
        }
        DSSIdentifier id = new DSSIdentifier();
        id.setTimeWindow(this._dssId.getTimeWindow());
        id.setDSSPath(outputDc1.fullName);
        id.setFileName(this._dssId.getFileName());
        TimeSeriesContainer[] cont = new TimeSeriesContainer[2];
        cont[0] = outputDc1;
        try {
            this._tsMathGuy = new TimeSeriesMath();
            this._outputMath = new TimeSeriesMath();
            this._tsMathGuy.setData((DataContainer)this._mean);
            DSSPathname pathname2 = new DSSPathname(this._tsMathGuy.getPath());
            pathname2.setCPart(pathname2.getCPart());
            pathname2.setCollectionSequence("00SD1N");
            this._tsMathGuy.setPathname(pathname2.getPathname());
            this._outputMath = this._tsMathGuy.subtract((HecMath)new TimeSeriesMath(this._outputDc));
            this._outputMath.getData((DataContainer)outputDc2);
        }
        catch (HecMathException e) {
            System.out.println("Unable to calculate Mean for time series collection: " + this._dssId.getDSSPath() + e);
            e.printStackTrace();
            return null;
        }
        id = new DSSIdentifier();
        id.setTimeWindow(this._dssId.getTimeWindow());
        id.setDSSPath(outputDc2.fullName);
        id.setFileName(this._dssId.getFileName());
        cont[1] = outputDc2;
        return cont;
    }

    public TimeSeriesContainer getMax() {
        if (this._hecMathArray == null) {
            this.createHecMathArray();
        }
        if (this._hecMathArray.length < 2) {
            return null;
        }
        if (this._max != null) {
            return this._max;
        }
        this._max = new TimeSeriesContainer();
        this._tsMathGuy = new TimeSeriesMath();
        try {
            this._tsMathGuy.setData(this._hecMathArray[0].getData());
            DSSPathname pathname = new DSSPathname(this._tsMathGuy.getPath());
            pathname.setCPart(pathname.getCPart());
            pathname.setCollectionSequence("000MAX");
            this._tsMathGuy.setPathname(pathname.getPathname());
            this._outputMath = this._tsMathGuy.max((HecMath[])this._hecMathArray);
            this._outputMath.getData((DataContainer)this._max);
        }
        catch (HecMathException e) {
            System.out.println("Unable to calculate Mean for time series collection: " + this._dssId.getDSSPath() + e);
            e.printStackTrace();
            return null;
        }
        DSSIdentifier id = new DSSIdentifier();
        id.setTimeWindow(this._dssId.getTimeWindow());
        id.setDSSPath(this._max.fullName);
        id.setFileName(this._dssId.getFileName());
        return this._max;
    }

    public TimeSeriesContainer getMin() {
        if (this._hecMathArray == null) {
            this.createHecMathArray();
        }
        if (this._hecMathArray.length < 2) {
            return null;
        }
        if (this._min != null) {
            return this._min;
        }
        this._min = new TimeSeriesContainer();
        this._tsMathGuy = new TimeSeriesMath();
        try {
            this._tsMathGuy.setData(this._hecMathArray[0].getData());
            DSSPathname pathname = new DSSPathname(this._tsMathGuy.getPath());
            pathname.setCollectionSequence("000MIN");
            this._tsMathGuy.setPathname(pathname.getPathname());
            this._outputMath = this._tsMathGuy.min((HecMath[])this._hecMathArray);
            this._outputMath.getData((DataContainer)this._min);
        }
        catch (HecMathException e) {
            System.out.println("Unable to calculate Mean for time series collection: " + this._dssId.getDSSPath() + e);
            e.printStackTrace();
            return null;
        }
        DSSIdentifier id = new DSSIdentifier();
        id.setTimeWindow(this._dssId.getTimeWindow());
        id.setDSSPath(this._min.fullName);
        id.setFileName(this._dssId.getFileName());
        return this._min;
    }

    public String getYType() {
        return this.ytype;
    }

    static {
        G2dGlyphFactory.addMapping(SimpleDSSTimeSeriesCollection.class, SimpleDSSTimeSeriesCollectionGlyph.class);
        MAX = 5;
        MIN = 4;
        MEAN = 3;
        SD1N = 2;
        SD1P = 1;
    }
}

