/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.rmi.gfx2d;

import hec.data.DataSetException;
import hec.data.Units;
import hec.geometry.IScale;
import hec.geometry.LocalPt;
import hec.geometry.Scale;
import hec.geometry.WorldPt;
import hec.gfx2d.G2dGlyph;
import hec.gfx2d.G2dLine;
import hec.gfx2d.G2dLineProperties;
import hec.gfx2d.G2dObject;
import hec.gfx2d.G2dTimeSeriesLine;
import hec.gfx2d.Viewport;
import hec.gfx2d.stats.StatisticsGlyph;
import hec.heclib.util.HecTime;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import javax.swing.SwingUtilities;
import mil.army.usace.hec.rmi.gfx2d.SimpleDSSTimeSeriesCollection;
import rma.util.RMAIO;

public class SimpleDSSTimeSeriesCollectionGlyph
extends G2dGlyph
implements StatisticsGlyph {
    SimpleDSSTimeSeriesCollection _obj;
    static double[] dxarray = new double[10000];
    static double[] dyarray = new double[10000];
    private boolean _statsShown = true;

    public SimpleDSSTimeSeriesCollectionGlyph(Viewport view, SimpleDSSTimeSeriesCollection map, Scale scl) {
        super(view, (G2dObject)map, scl);
        this._obj = map;
        this._lineArray = new G2dLine[map.getCurveCount() + 4];
        for (int i = 0; i < map.getCurveCount(); ++i) {
            this._lineArray[i] = this._line = new G2dTimeSeriesLine();
            this._line.setScale((IScale)scl);
            this._line.setName(this._obj._dssCollectionArray.get(i).getShortName());
            this._line.setGlyph((G2dGlyph)this);
            ((G2dTimeSeriesLine)this._line).setRawTimeSeriesData(this._obj.tdata, this._obj.ydata[i], null);
        }
    }

    public void draw(Graphics g) {
        if (this._obj == null) {
            return;
        }
        Rectangle rect = this.getVisibleRect();
        int maxLoc = this._obj.getCurveCount() - SimpleDSSTimeSeriesCollection.MAX;
        for (int i = 0; i < this._obj.getCurveCount(); ++i) {
            G2dLineProperties properties;
            rect = this.getVisibleRect();
            if (i == this._obj.getCurveCount() - SimpleDSSTimeSeriesCollection.MAX) {
                properties = new G2dLineProperties((G2dLineProperties)this._drawProp.lineProperties.get(0));
                properties._lineStylePattern = G2dLineProperties.DOT_STYLE_PATTERN;
                properties._lineWidth = ((G2dLineProperties)this._drawProp.lineProperties.get((int)0))._lineWidth + 1.5f;
                properties._lineTransparency = 0;
                properties._lineColor = ((G2dLineProperties)this._drawProp.lineProperties.get(0)).getLineColor().darker();
                if (properties._drawLine) {
                    properties._drawLine = this._statsShown;
                }
                if (properties._drawPoints) {
                    properties._drawPoints = this._statsShown;
                }
                this._lineArray[i].setProperties(properties);
            } else if (i == this._obj.getCurveCount() - SimpleDSSTimeSeriesCollection.MIN) {
                properties = new G2dLineProperties((G2dLineProperties)this._drawProp.lineProperties.get(0));
                properties._lineStylePattern = G2dLineProperties.DOT_STYLE_PATTERN;
                properties._lineWidth = ((G2dLineProperties)this._drawProp.lineProperties.get((int)0))._lineWidth + 1.5f;
                properties._lineTransparency = 0;
                properties._lineColor = ((G2dLineProperties)this._drawProp.lineProperties.get(0)).getLineColor().darker();
                if (properties._drawLine) {
                    properties._drawLine = this._statsShown;
                }
                if (properties._drawPoints) {
                    properties._drawPoints = this._statsShown;
                }
                this._lineArray[i].setProperties(properties);
            } else if (i == this._obj.getCurveCount() - SimpleDSSTimeSeriesCollection.MEAN) {
                properties = new G2dLineProperties((G2dLineProperties)this._drawProp.lineProperties.get(0));
                properties._lineStylePattern = G2dLineProperties.SOLID_STYLE_PATTERN;
                properties._lineWidth = ((G2dLineProperties)this._drawProp.lineProperties.get((int)0))._lineWidth + 1.5f;
                properties._lineTransparency = 0;
                properties._lineColor = ((G2dLineProperties)this._drawProp.lineProperties.get(0)).getLineColor().darker();
                if (properties._drawLine) {
                    properties._drawLine = this._statsShown;
                }
                if (properties._drawPoints) {
                    properties._drawPoints = this._statsShown;
                }
                this._lineArray[i].setProperties(properties);
            } else if (i == this._obj.getCurveCount() - SimpleDSSTimeSeriesCollection.SD1P) {
                properties = new G2dLineProperties((G2dLineProperties)this._drawProp.lineProperties.get(0));
                properties._lineStylePattern = G2dLineProperties.DASH_STYLE_PATTERN;
                properties._lineWidth = ((G2dLineProperties)this._drawProp.lineProperties.get((int)0))._lineWidth + 1.5f;
                properties._lineTransparency = 0;
                properties._lineColor = ((G2dLineProperties)this._drawProp.lineProperties.get(0)).getLineColor().darker();
                if (properties._drawLine) {
                    properties._drawLine = this._statsShown;
                }
                if (properties._drawPoints) {
                    properties._drawPoints = this._statsShown;
                }
                this._lineArray[i].setProperties(properties);
            } else if (i == this._obj.getCurveCount() - SimpleDSSTimeSeriesCollection.SD1N) {
                properties = new G2dLineProperties((G2dLineProperties)this._drawProp.lineProperties.get(0));
                properties._lineStylePattern = G2dLineProperties.DASH_STYLE_PATTERN;
                properties._lineWidth = ((G2dLineProperties)this._drawProp.lineProperties.get((int)0))._lineWidth + 1.5f;
                properties._lineTransparency = 0;
                properties._lineColor = ((G2dLineProperties)this._drawProp.lineProperties.get(0)).getLineColor().darker();
                if (properties._drawLine) {
                    properties._drawLine = this._statsShown;
                }
                if (properties._drawPoints) {
                    properties._drawPoints = this._statsShown;
                }
                this._lineArray[i].setProperties(properties);
            } else {
                this._lineArray[i].setProperties((G2dLineProperties)this._drawProp.lineProperties.get(0));
            }
            this._lineArray[i].drawLine(g, rect);
        }
    }

    public String getToolTipText(MouseEvent e) {
        WorldPt wp;
        double distance;
        if (e == null) {
            return null;
        }
        LocalPt pt = new LocalPt(e.getX(), e.getY());
        if (this._line.contains(pt) && (distance = this._line.getNearestLocation(pt, wp = new WorldPt())) != Double.NEGATIVE_INFINITY) {
            HecTime hTime = new HecTime();
            hTime.setMinutes(wp.e);
            this._scale.convertDataTime(hTime);
            String xvalstr = hTime.dateAndTime();
            try {
                double yVal = this._obj.getYParameterId() != -1 && this._obj.getUnitSystem() != 0 && this._scale.getDisplayUnitSystem() != 0 ? Units.convertUnits((double)wp.n, (int)this._obj.getYParameterId(), (int)this._obj.getUnitSystem(), (int)this._scale.getDisplayUnitSystem()) : wp.n;
                return "<html>" + this._obj.getName() + "<br>[" + xvalstr + ", " + RMAIO.setPrecision2((double)yVal, (int)2) + "]</html>";
            }
            catch (DataSetException exp) {
                return "<html>" + this._obj.getName() + "<br>[" + xvalstr + ", " + RMAIO.setPrecision2((double)wp.n, (int)2) + "]</html>";
            }
        }
        return null;
    }

    public boolean isCurveDrawn(int curveNumber) {
        if (curveNumber < 0 || curveNumber >= this._lineArray.length) {
            return false;
        }
        return this._lineArray[curveNumber] != null;
    }

    public void setLineVisible(boolean visible) {
        for (int i = 0; i < this._lineArray.length; ++i) {
            if (this._lineArray[i] == null) continue;
            this._lineArray[i].setVisible(visible);
        }
    }

    protected List getOKListeners() {
        ArrayList<PropertiesOKListener> l = new ArrayList<PropertiesOKListener>();
        l.add(new PropertiesOKListener());
        return l;
    }

    public boolean areStatsDisplayed() {
        return this._statsShown;
    }

    public void setStatsDisplayed(boolean displayed) {
        this._statsShown = displayed;
        this.update((Observable)((Object)this._obj), "update data");
    }

    public int getCurveCount() {
        return 1;
    }

    class PropertiesOKListener
    implements ActionListener {
        PropertiesOKListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Window w = SwingUtilities.windowForComponent((Component)SimpleDSSTimeSeriesCollectionGlyph.this.getViewport());
            if (w != null) {
                SimpleDSSTimeSeriesCollectionGlyph.this.getViewport().setDirty();
                w.repaint();
            }
            if (SimpleDSSTimeSeriesCollectionGlyph.this._viewport != null) {
                if (SimpleDSSTimeSeriesCollectionGlyph.this._viewport.getG2dPanel().getLegendPanel() != null) {
                    SimpleDSSTimeSeriesCollectionGlyph.this._viewport.getG2dPanel().getLegendPanel().refreshLegendItems();
                }
                SimpleDSSTimeSeriesCollectionGlyph.this._viewport.getG2dPanel().repaint();
            }
        }
    }
}

