/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.rmi.gfx2d;

import hec.data.DataSetException;
import hec.data.Units;
import hec.geometry.IScale;
import hec.geometry.LocalPt;
import hec.geometry.Scale;
import hec.geometry.WorldPt;
import hec.gfx2d.G2dGlyph;
import hec.gfx2d.G2dObject;
import hec.gfx2d.G2dTimeSeriesLine;
import hec.gfx2d.Viewport;
import hec.heclib.util.HecTime;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.Observable;
import mil.army.usace.hec.rmi.gfx2d.SimpleDSSTimeSeries;
import rma.util.RMAIO;

public class SimpleDSSTimeSeriesGlyph
extends G2dGlyph {
    SimpleDSSTimeSeries _obj;
    static double[] dxarray = new double[10000];
    static double[] dyarray = new double[10000];

    public SimpleDSSTimeSeriesGlyph(Viewport view, SimpleDSSTimeSeries map, Scale scl) {
        super(view, (G2dObject)map, scl);
        this._obj = map;
        this._lineArray[0] = this._line = new G2dTimeSeriesLine();
        this._line.setScale((IScale)scl);
        this._line.setName(map.getName());
        this._line.setGlyph((G2dGlyph)this);
        this._line.clearLineData();
        ((G2dTimeSeriesLine)this._line).setRawTimeSeriesData(this._obj.tdata, this._obj.ydata, null);
    }

    public void update(Observable o, Object arg) {
        ((G2dTimeSeriesLine)this._line).setRawTimeSeriesData(((SimpleDSSTimeSeries)((Object)o)).tdata, ((SimpleDSSTimeSeries)((Object)o)).ydata, null);
        super.update(o, arg);
    }

    public void draw(Graphics g) {
        if (this._obj == null) {
            return;
        }
        Rectangle rect = this.getVisibleRect();
        this._line.drawLine(g, rect);
    }

    public String getToolTipText(MouseEvent e) {
        WorldPt wp;
        double distance;
        if (e == null) {
            return null;
        }
        LocalPt pt = new LocalPt(e.getX(), e.getY());
        if (this._line.contains(pt) && (distance = this._line.getNearestLocation(pt, wp = new WorldPt())) != Double.NEGATIVE_INFINITY) {
            HecTime hTime = new HecTime();
            hTime.setMinutes(wp.e);
            this._scale.convertDataTime(hTime);
            String xvalstr = hTime.dateAndTime();
            try {
                double yVal = this._obj.getYParameterId() != -1 && this._obj.getUnitSystem() != 0 && this._scale.getDisplayUnitSystem() != 0 ? Units.convertUnits((double)wp.n, (int)this._obj.getYParameterId(), (int)this._obj.getUnitSystem(), (int)this._scale.getDisplayUnitSystem()) : wp.n;
                return "<html>" + this._obj.getName() + "<br>[" + xvalstr + ", " + RMAIO.setPrecision2((double)yVal, (int)2) + "]</html>";
            }
            catch (DataSetException exp) {
                return "<html>" + this._obj.getName() + "<br>[" + xvalstr + ", " + RMAIO.setPrecision2((double)wp.n, (int)2) + "]</html>";
            }
        }
        return null;
    }
}

