/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.rmi.heclib.dss;

import hec.heclib.dss.IHecDSSUtilities;
import hec.heclib.util.HecTime;
import hec.heclib.util.stringContainer;
import hec.io.DSSIdentifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import mil.army.usace.hec.rmi.csinterface.DSSManager;
import mil.army.usace.hec.rmi.heclib.dss.HecDataManagerRemote;

public class HecDSSUtilitiesRemote
extends HecDataManagerRemote
implements IHecDSSUtilities {
    public HecDSSUtilitiesRemote(DSSManager dssmanager) {
        super(dssmanager);
    }

    public static HecDSSUtilitiesRemote createHecDSSUtilitiesRemote() {
        DSSManager dssmanager = null;
        try {
            dssmanager = HecDSSUtilitiesRemote.getDSSManager();
        }
        catch (Exception e) {
            System.out.println("failed to get dssfilemanager");
        }
        if (dssmanager != null) {
            return new HecDSSUtilitiesRemote(dssmanager);
        }
        return null;
    }

    public void cancelProcess() {
        if (this._dssmanager == null) {
            return;
        }
        try {
            this._dssmanager.cancelProcess(this._dssFileName);
        }
        catch (Exception e) {
            System.out.println("remote dssfilemanager call failed");
        }
    }

    public int getDssFileVersion() {
        return this.zinqir("VERS");
    }

    public int cancelSqueeze() {
        if (this._dssmanager != null && this._dssFileName != null) {
            try {
                this._dssmanager.setDefaultDSSFileName(this._dssFileName);
                this._dssmanager.cancelProcess(this._dssFileName);
            }
            catch (Exception e) {
                System.out.println("remote dssfilemanager call failed");
            }
        }
        return 0;
    }

    public int copyFile(String secondDSSFilename) {
        if (this._dssmanager == null) {
            return -1;
        }
        if (this._dssFileName == null) {
            return -1;
        }
        try {
            return this._dssmanager.copyFile(this._dssFileName, secondDSSFilename);
        }
        catch (Exception e) {
            System.out.println("remote dssfilemanager call failed");
            return -1;
        }
    }

    public int copyRecordsFrom(String toDSSFilename, List<String> pathnameList) {
        if (this._dssmanager == null) {
            return -1;
        }
        if (this._dssFileName == null) {
            return -1;
        }
        try {
            return this._dssmanager.copyRecordsFrom(this._dssFileName, toDSSFilename, pathnameList);
        }
        catch (Exception e) {
            System.out.println("remote dssfilemanager call failed");
            return -1;
        }
    }

    public int copyRecordsInto(String fromDSSFilename, List<String> pathnameList) {
        if (this._dssmanager == null) {
            return -1;
        }
        if (this._dssFileName == null) {
            return -1;
        }
        try {
            return this._dssmanager.copyRecordsInto(this._dssFileName, fromDSSFilename, pathnameList);
        }
        catch (Exception e) {
            System.out.println("remote dssfilemanager call failed");
            return -1;
        }
    }

    public int delete(List<String> pathnameList) {
        if (this._dssmanager == null) {
            return -1;
        }
        if (this._dssFileName == null) {
            return -1;
        }
        try {
            return this._dssmanager.delete(this._dssFileName, pathnameList);
        }
        catch (Exception e) {
            System.out.println("remote dssfilemanager call failed");
            return -1;
        }
    }

    public int duplicateRecords(List<String> pathnameList, List<String> newPathnameList) {
        if (this._dssmanager == null) {
            return -1;
        }
        if (this._dssFileName == null) {
            return -1;
        }
        try {
            return this._dssmanager.duplicateRecords(this._dssFileName, pathnameList, newPathnameList);
        }
        catch (Exception e) {
            System.out.println("remote dssfilemanager call failed");
            return -1;
        }
    }

    public int renameRecords(List<String> pathnameList, List<String> newPathnameList) {
        if (this._dssmanager == null) {
            return -1;
        }
        if (this._dssFileName == null) {
            return -1;
        }
        try {
            return this._dssmanager.renameRecords(this._dssFileName, pathnameList, newPathnameList);
        }
        catch (Exception e) {
            System.out.println("remote dssfilemanager call failed");
            return -1;
        }
    }

    public int squeeze() {
        if (this._dssmanager == null) {
            return -1;
        }
        if (this._dssFileName == null) {
            return -1;
        }
        try {
            return this._dssmanager.squeeze(this._dssFileName);
        }
        catch (Exception e) {
            System.out.println("remote dssfilemanager call failed");
            return -1;
        }
    }

    public int undelete(List<String> pathnames) {
        if (this._dssmanager == null) {
            return -1;
        }
        if (this._dssFileName == null) {
            return -1;
        }
        try {
            return this._dssmanager.undelete(this._dssFileName, pathnames);
        }
        catch (Exception e) {
            System.out.println("remote dssfilemanager call failed");
            return -1;
        }
    }

    public int undoLastDelete() {
        if (this._dssmanager == null) {
            return -1;
        }
        if (this._dssFileName == null) {
            return -1;
        }
        try {
            return this._dssmanager.undoLastDelete(this._dssFileName);
        }
        catch (Exception e) {
            System.out.println("remote dssfilemanager call failed");
            return -1;
        }
    }

    public List<String> getLastDeletePathnames() {
        if (this._dssmanager == null) {
            return new Vector<String>();
        }
        if (this._dssFileName == null) {
            return new Vector<String>();
        }
        try {
            return this._dssmanager.getLastDeletePathnames(this._dssFileName);
        }
        catch (Exception e) {
            System.out.println("remote dssfilemanager call failed");
            return new ArrayList<String>();
        }
    }

    public int checkAllPathnames() {
        if (this._dssmanager == null) {
            return -1;
        }
        if (this._dssFileName == null) {
            return -1;
        }
        try {
            return this._dssmanager.checkAllPathnames(this._dssFileName);
        }
        catch (Exception e) {
            System.out.println("remote dssfilemanager call failed");
            return -1;
        }
    }

    public int checkLinks() {
        if (this._dssmanager == null) {
            return -1;
        }
        if (this._dssFileName == null) {
            return -1;
        }
        try {
            return this._dssmanager.checkLinks(this._dssFileName);
        }
        catch (Exception e) {
            System.out.println("remote dssfilemanager call failed");
            return -1;
        }
    }

    public int checkPathnameBins() {
        if (this._dssmanager == null) {
            return -1;
        }
        if (this._dssFileName == null) {
            return -1;
        }
        try {
            return this._dssmanager.checkPathnameBins(this._dssFileName);
        }
        catch (Exception e) {
            System.out.println("remote dssfilemanager call failed");
            return -1;
        }
    }

    public int fileStats() {
        if (this._dssmanager != null && this._dssFileName != null) {
            try {
                return this._dssmanager.fileStats(this._dssFileName);
            }
            catch (Exception e) {
                System.out.println("remote dssfilemanager call failed");
            }
        }
        return -1;
    }

    public void clearStatus() {
        if (this._dssmanager == null) {
            return;
        }
        if (this._dssFileName == null) {
            return;
        }
        try {
            this._dssmanager.clearStatus(this._dssFileName);
        }
        catch (Exception e) {
            System.out.println("remote dssfilemanager call failed");
        }
    }

    public int forceMultiUserAccess() {
        if (this._dssmanager == null) {
            return -1;
        }
        if (this._dssFileName == null) {
            return -1;
        }
        try {
            return this._dssmanager.forceMultiUserAccess(this._dssFileName);
        }
        catch (Exception e) {
            System.out.println("remote dssfilemanager call failed");
            return -1;
        }
    }

    public int createNewCatalog(int catalogType) {
        if (this._dssmanager == null) {
            return -1;
        }
        if (this._dssFileName == null) {
            return -1;
        }
        try {
            return this._dssmanager.createNewCatalog(this._dssFileName, catalogType);
        }
        catch (Exception e) {
            System.out.println("remote dssfilemanager call failed");
            return -1;
        }
    }

    public String getCatalogName(int catalogType) {
        if (this._dssmanager == null) {
            return "";
        }
        if (this._dssFileName == null) {
            return "";
        }
        try {
            return this._dssmanager.getCatalogName(this._dssFileName, catalogType);
        }
        catch (Exception e) {
            System.out.println("remote dssfilemanager call failed");
            return "";
        }
    }

    public boolean isCatalogValid() {
        if (this._dssmanager == null) {
            return false;
        }
        if (this._dssFileName == null) {
            return false;
        }
        try {
            return this._dssmanager.isCatalogValid(this._dssFileName);
        }
        catch (Exception e) {
            System.out.println("remote dssfilemanager call failed");
            return false;
        }
    }

    public void done() {
        if (this._dssmanager == null) {
            return;
        }
        if (this._dssFileName == null) {
            return;
        }
        try {
            this._dssmanager.done(this._dssFileName);
        }
        catch (Exception e) {
            System.out.println("remote dssfilemanager call failed");
        }
    }

    public void clearError() {
        this.clearSevereError();
    }

    public void getProcessStatus(int[] numberRecs, int[] currentRec) {
        if (this._dssmanager == null) {
            return;
        }
        if (this._dssFileName == null) {
            return;
        }
        try {
            this._dssmanager.getProcessStatus(this._dssFileName, numberRecs, currentRec);
        }
        catch (Exception e) {
            System.out.println("remote dssfilemanager call failed");
        }
    }

    public void setInterrupt(boolean interrupt) {
        if (this._dssmanager == null) {
            return;
        }
        if (this._dssFileName == null) {
            return;
        }
        try {
            this._dssmanager.setInterrupt(this._dssFileName, interrupt);
        }
        catch (Exception e) {
            System.out.println("remote dssfilemanager call failed");
        }
    }

    public boolean checkForSevereDssError() {
        return this.checkForSevereError();
    }

    public int checkForError() {
        return this.checkForSevereError() ? -1 : 0;
    }

    public boolean getTimeSeriesExtents(String pathname, HecTime start, HecTime end) {
        DSSIdentifier dssId = new DSSIdentifier();
        dssId.setFileName(this._dssFileName);
        dssId.setDSSPath(pathname);
        return this.getTimeSeriesExtents(dssId, start, end);
    }

    public int getTSRecordInfo(String pathname, HecTime start, HecTime end, stringContainer units, stringContainer type) {
        DSSIdentifier dssId = new DSSIdentifier();
        dssId.setFileName(this._dssFileName);
        dssId.setDSSPath(pathname);
        return this.getTSRecordInfo(dssId, start, end, units, type);
    }

    public void dss_zset(String parameter, String alpha, int number) {
        this.zset(parameter, alpha, number);
    }

    public void dss_zquery(String parameter, stringContainer alpha, int[] numb) {
        this.zquery(parameter, alpha, numb);
    }
}

