/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.rmi.heclib.dss;

import com.google.common.flogger.FluentLogger;
import hec.heclib.dss.CondensedReference;
import hec.heclib.dss.DSSErrorMessage;
import hec.heclib.dss.HecDSSFileData;
import hec.heclib.util.HecTime;
import hec.heclib.util.Heclib;
import hec.heclib.util.stringContainer;
import hec.io.DSSIdentifier;
import hec.lang.DSSPathString;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import mil.army.usace.hec.rmi.csinterface.ClientServerUtil;
import mil.army.usace.hec.rmi.csinterface.DSSManager;
import mil.army.usace.hec.rmi.csinterface.ResultZinqir;
import mil.army.usace.hec.rmi.csinterface.ResultZquery;
import mil.army.usace.hec.rmi.heclib.dss.HecDssTextRemote;
import mil.army.usace.hec.rmi.heclib.dss.HecPairedDataRemote;
import mil.army.usace.hec.rmi.heclib.dss.HecTimeSeriesRemote;

public class HecDataManagerRemote {
    private static final FluentLogger LOGGER = FluentLogger.forEnclosingClass();
    String _dssFileName;
    private static String _dssmanagerUrl = null;
    DSSManager _dssmanager = null;
    DSSPathString _pathname;
    HecTime _startTime = null;
    HecTime _endTime = null;

    public static void setDSSManagerUrl(String s) {
        _dssmanagerUrl = s;
    }

    public static String getDSSManagerUrl() {
        return _dssmanagerUrl;
    }

    private static DSSManager lookupDssManager() {
        DSSManager dssmanager = null;
        dssmanager = ClientServerUtil.getDssManager();
        return dssmanager;
    }

    protected static DSSManager getDSSManager() throws RemoteException {
        return HecDataManagerRemote.lookupDssManager();
    }

    public static HecDataManagerRemote createHecDataManagerRemote() {
        DSSManager dssmanager = null;
        try {
            dssmanager = HecDataManagerRemote.getDSSManager();
        }
        catch (Exception e) {
            ((FluentLogger.Api)((FluentLogger.Api)LOGGER.atConfig()).withCause((Throwable)e)).log("failed to get dssfilemanager");
        }
        if (dssmanager != null) {
            return new HecDataManagerRemote(dssmanager);
        }
        return null;
    }

    public static List<HecDSSFileData> DssFileManagerStatus() {
        DSSManager dssmanager = null;
        try {
            dssmanager = HecDataManagerRemote.getDSSManager();
            if (dssmanager != null) {
                return dssmanager.DssFileManagerStatus();
            }
        }
        catch (Exception e) {
            ((FluentLogger.Api)((FluentLogger.Api)LOGGER.atConfig()).withCause((Throwable)e)).log("failed to get dssfilemanager");
        }
        return new ArrayList<HecDSSFileData>();
    }

    public static void closeAndClear() {
        DSSManager dssmanager = null;
        try {
            dssmanager = HecDataManagerRemote.getDSSManager();
            if (dssmanager != null) {
                dssmanager.closeAndClear();
            }
        }
        catch (Exception e) {
            ((FluentLogger.Api)((FluentLogger.Api)LOGGER.atConfig()).withCause((Throwable)e)).log("failed to get dssfilemanager");
        }
    }

    public static String defaultDSSFileName() {
        DSSManager dssmanager = null;
        try {
            dssmanager = HecDataManagerRemote.getDSSManager();
            if (dssmanager != null) {
                String name = dssmanager.defaultDSSFileName();
                return name;
            }
        }
        catch (Exception e) {
            ((FluentLogger.Api)((FluentLogger.Api)LOGGER.atConfig()).withCause((Throwable)e)).log("failed to get dssfilemanager");
        }
        return "";
    }

    public static void setDefaultDSSFileName(String name) {
        DSSManager dssmanager = null;
        try {
            dssmanager = HecDataManagerRemote.getDSSManager();
            if (dssmanager != null) {
                dssmanager.setDefaultDSSFileName(name);
            }
        }
        catch (Exception e) {
            ((FluentLogger.Api)((FluentLogger.Api)LOGGER.atConfig()).withCause((Throwable)e)).log("failed to get dssfilemanager");
        }
    }

    public static int parsePathname(String pathname, int[] partPositions) {
        return DSSPathString.parsePathname((String)pathname, (int[])partPositions);
    }

    public static boolean doesDSSFileExist(String DSSFileName) {
        DSSManager dssmanager = null;
        try {
            dssmanager = HecDataManagerRemote.getDSSManager();
            if (dssmanager != null) {
                return dssmanager.doesDSSFileExist(DSSFileName);
            }
        }
        catch (Exception e) {
            ((FluentLogger.Api)((FluentLogger.Api)LOGGER.atConfig()).withCause((Throwable)e)).log("failed to get dssfilemanager");
        }
        return false;
    }

    public static boolean cleanDSSFileName(String inName, stringContainer outName) {
        DSSManager dssmanager = null;
        inName = inName.replace('\\', '/');
        try {
            dssmanager = HecDataManagerRemote.getDSSManager();
            if (dssmanager != null) {
                String outstr = dssmanager.cleanDSSFileName(inName);
                if (outstr == null) {
                    outName.string = inName;
                    return false;
                }
                outName.string = outstr;
                return true;
            }
        }
        catch (Exception e) {
            outName.string = inName;
            ((FluentLogger.Api)((FluentLogger.Api)LOGGER.atConfig()).withCause((Throwable)e)).log("failed to get dssfilemanager");
        }
        return false;
    }

    public static void setMessageLevel(int level) {
        DSSManager dssmanager = null;
        try {
            dssmanager = HecDataManagerRemote.getDSSManager();
            if (dssmanager != null) {
                dssmanager.setMessageLevel(level);
            }
        }
        catch (Exception e) {
            ((FluentLogger.Api)((FluentLogger.Api)LOGGER.atConfig()).withCause((Throwable)e)).log("failed to get dssfilemanager");
        }
    }

    public static void setUnit(int unit) {
        DSSManager dssmanager = null;
        try {
            dssmanager = HecDataManagerRemote.getDSSManager();
            if (dssmanager != null) {
                dssmanager.setUnit(unit);
            }
        }
        catch (Exception e) {
            ((FluentLogger.Api)((FluentLogger.Api)LOGGER.atConfig()).withCause((Throwable)e)).log("failed to get dssfilemanager");
        }
    }

    public List<DSSIdentifier> recordsUpdated(long startTime) {
        DSSManager dssmanager = null;
        try {
            dssmanager = HecDataManagerRemote.getDSSManager();
            if (dssmanager == null || this._dssFileName == null) {
                return null;
            }
            List<DSSIdentifier> dssIdentifierList = dssmanager.recordsUpdated(this._dssFileName, startTime);
            return dssIdentifierList;
        }
        catch (Exception e) {
            ((FluentLogger.Api)((FluentLogger.Api)LOGGER.atConfig()).withCause((Throwable)e)).log("failed to get dssfilemanager");
            return null;
        }
    }

    public HecDataManagerRemote(DSSManager dssmanager) {
        this._dssmanager = dssmanager;
    }

    public DSSManager getRemoteDSSManager() {
        return this._dssmanager;
    }

    public int setDSSFileName(String fname) {
        this._dssFileName = fname;
        try {
            DSSManager dssmanager = HecDataManagerRemote.getDSSManager();
            if (dssmanager != null) {
                return dssmanager.setDSSFileName(this._dssFileName, false);
            }
        }
        catch (Exception e) {
            ((FluentLogger.Api)((FluentLogger.Api)LOGGER.atConfig()).withCause((Throwable)e)).log("failed to get dssfilemanager");
        }
        return -1;
    }

    public String pathname() {
        if (this._pathname == null) {
            return "";
        }
        return this._pathname.getPathname();
    }

    public String aPart() {
        if (this._pathname == null) {
            return "";
        }
        return this._pathname.getAPart();
    }

    public String bPart() {
        if (this._pathname == null) {
            return "";
        }
        return this._pathname.getBPart();
    }

    public String cPart() {
        if (this._pathname == null) {
            return "";
        }
        return this._pathname.getCPart();
    }

    public String dPart() {
        if (this._pathname == null) {
            return "";
        }
        return this._pathname.getDPart();
    }

    public String ePart() {
        if (this._pathname == null) {
            return "";
        }
        return this._pathname.getEPart();
    }

    public String fPart() {
        if (this._pathname == null) {
            return "";
        }
        return this._pathname.getFPart();
    }

    public int setPathname(String path) {
        this._pathname = new DSSPathString(path);
        return 0;
    }

    public void setAPart(String str) {
        if (this._pathname == null) {
            this._pathname = new DSSPathString();
        }
        this._pathname.setAPart(str);
    }

    public void setBPart(String str) {
        if (this._pathname == null) {
            this._pathname = new DSSPathString();
        }
        this._pathname.setBPart(str);
    }

    public void setCPart(String str) {
        if (this._pathname == null) {
            this._pathname = new DSSPathString();
        }
        this._pathname.setCPart(str);
    }

    public void setDPart(String str) {
        if (this._pathname == null) {
            this._pathname = new DSSPathString();
        }
        this._pathname.setDPart(str);
    }

    public void setEPart(String str) {
        if (this._pathname == null) {
            this._pathname = new DSSPathString();
        }
        this._pathname.setEPart(str);
    }

    public void setFPart(String str) {
        if (this._pathname == null) {
            this._pathname = new DSSPathString();
        }
        this._pathname.setFPart(str);
    }

    public void setTimeWindow(HecTime start, HecTime end) {
        this._startTime = start;
        this._endTime = end;
    }

    public HecDataManagerRemote createObject(String pathname) {
        if (this._dssmanager == null) {
            return null;
        }
        try {
            DSSIdentifier dssId;
            String typestr;
            HecDataManagerRemote obj = null;
            if (this._dssFileName == null) {
                this._dssFileName = this._dssmanager.defaultDSSFileName();
            }
            if ((typestr = this._dssmanager.getPathType(dssId = new DSSIdentifier(this._dssFileName, pathname))).equals("TimeSeries")) {
                obj = new HecTimeSeriesRemote(this._dssmanager);
            } else if (typestr.equals("PairedData")) {
                obj = new HecPairedDataRemote(this._dssmanager);
            } else {
                return null;
            }
            obj.setDSSFileName(this._dssFileName);
            obj.setPathname(pathname);
            return obj;
        }
        catch (Exception e) {
            System.out.println("remote dssfilemanager call createObject failed:\n " + e);
            return null;
        }
    }

    public HecDataManagerRemote createTimeSeriesObject(String pathname) {
        if (this._dssmanager == null) {
            return null;
        }
        try {
            if (this._dssFileName == null) {
                this._dssFileName = this._dssmanager.defaultDSSFileName();
            }
            HecTimeSeriesRemote obj = new HecTimeSeriesRemote(this._dssmanager);
            obj.setDSSFileName(this._dssFileName);
            obj.setPathname(pathname);
            return obj;
        }
        catch (Exception e) {
            System.out.println("remote dssfilemanager call createTimeSeriesObject failed:\n " + e);
            return null;
        }
    }

    public HecDataManagerRemote createPairedDataObject(String pathname) {
        if (this._dssmanager == null) {
            return null;
        }
        try {
            if (this._dssFileName == null) {
                this._dssFileName = this._dssmanager.defaultDSSFileName();
            }
            HecPairedDataRemote obj = new HecPairedDataRemote(this._dssmanager);
            obj.setDSSFileName(this._dssFileName);
            obj.setPathname(pathname);
            return obj;
        }
        catch (Exception e) {
            System.out.println("remote dssfilemanager call createPairedDataObject failed:\n " + e);
            return null;
        }
    }

    public HecDataManagerRemote createTextObject(String pathname) {
        if (this._dssmanager == null) {
            return null;
        }
        try {
            if (this._dssFileName == null) {
                this._dssFileName = this._dssmanager.defaultDSSFileName();
            }
            HecDssTextRemote obj = new HecDssTextRemote(this._dssmanager);
            obj.setDSSFileName(this._dssFileName);
            obj.setPathname(pathname);
            return obj;
        }
        catch (Exception e) {
            System.out.println("remote dssfilemanager call createTimeSeriesObject failed:\n " + e);
            return null;
        }
    }

    public Vector getGriddedDataRemote(DSSIdentifier dssId) {
        if (this._dssmanager == null) {
            return null;
        }
        try {
            Vector gridData = this._dssmanager.getGriddedData(dssId);
            return gridData;
        }
        catch (Exception e) {
            System.out.println("Remote DssFileManager call getGriddedDataRemote failed:\n " + e);
            return null;
        }
    }

    public void setForceNewCatalog(boolean b) {
        if (this._dssmanager == null) {
            return;
        }
        if (this._dssFileName == null) {
            return;
        }
        try {
            this._dssmanager.setForceNewCatalog(this._dssFileName, b);
        }
        catch (Exception e) {
            System.out.println("remote dssfilemanager call setForceNewCatalog failed:\n " + e);
        }
    }

    public int searchDSSPaths(String aPart, String bPart, String cPart, String dPart, String ePart, String fPart, Vector pathnameList) {
        if (this._dssmanager == null) {
            return -1;
        }
        try {
            if (this._dssFileName == null) {
                return -1;
            }
            DSSIdentifier dssId = new DSSIdentifier(this._dssFileName);
            Vector pvec = this._dssmanager.searchDSSPaths(dssId, aPart, bPart, cPart, dPart, ePart, fPart);
            if (pvec.size() < 1) {
                return -1;
            }
            pathnameList.removeAllElements();
            Enumeration e = pvec.elements();
            while (e.hasMoreElements()) {
                pathnameList.addElement(e.nextElement());
            }
            return pathnameList.size();
        }
        catch (Exception e) {
            System.out.println("remote dssfilemanager call searchDSSPaths failed:\n " + e);
            return -1;
        }
    }

    public int searchDSSPaths(String scanString, List<String> pathnameList) {
        if (this._dssmanager == null) {
            return -1;
        }
        try {
            if (this._dssFileName == null) {
                return -1;
            }
            DSSIdentifier dssId = new DSSIdentifier(this._dssFileName);
            Vector pvec = this._dssmanager.searchDSSPaths(dssId, scanString);
            if (pvec == null || pvec.size() < 1) {
                return -1;
            }
            pathnameList.clear();
            pathnameList.addAll(pvec);
            return pathnameList.size();
        }
        catch (Exception e) {
            System.out.println("remote dssfilemanager call searchDSSPaths failed:\n " + e);
            return -1;
        }
    }

    public int searchDSSCatalog(String scanString, List<String> pathnameList) {
        if (this._dssmanager == null) {
            return -1;
        }
        try {
            if (this._dssFileName == null) {
                return -1;
            }
            DSSIdentifier dssId = new DSSIdentifier(this._dssFileName);
            Vector pvec = this._dssmanager.searchDSSCatalog(dssId, scanString);
            if (pvec == null || pvec.size() < 1) {
                return -1;
            }
            pathnameList.clear();
            pathnameList.addAll(pvec);
            return pathnameList.size();
        }
        catch (Exception e) {
            System.out.println("remote dssfilemanager call searchDSSPaths failed:\n " + e);
            return -1;
        }
    }

    public String[] getPathnameList(boolean forceUpdate) {
        if (this._dssmanager == null) {
            return null;
        }
        try {
            if (this._dssFileName == null) {
                return null;
            }
            DSSIdentifier dssId = new DSSIdentifier(this._dssFileName);
            return this._dssmanager.getPathnameList(dssId, forceUpdate);
        }
        catch (Exception e) {
            System.out.println("remote dssfilemanager call searchDSSPaths failed:\n " + e);
            return null;
        }
    }

    public Vector<CondensedReference> getCondensedCatalog() {
        if (this._dssFileName == null) {
            return null;
        }
        try {
            return this._dssmanager.getCondensedCatalog(this._dssFileName);
        }
        catch (Exception e) {
            System.out.println("remote dssfilemanager call searchDSSPaths failed:\n " + e);
            return null;
        }
    }

    public int numberRecords() {
        if (this._dssmanager == null) {
            return -1;
        }
        if (this._dssFileName == null) {
            return -1;
        }
        try {
            return this._dssmanager.numberRecords(this._dssFileName);
        }
        catch (Exception e) {
            System.out.println("remote dssfilemanager call numberRecords failed:\n " + e);
            return -1;
        }
    }

    public synchronized String[] getCollectionList(String seedPathname) {
        DSSIdentifier dssId = new DSSIdentifier(this._dssFileName, seedPathname);
        try {
            return this._dssmanager.getCollectionList(dssId);
        }
        catch (RemoteException e) {
            System.out.println("remote dssfilemanager call getCollectionList failed:\n " + e);
            return new String[0];
        }
    }

    public int zinqir(String parameter) {
        if (this._dssmanager == null) {
            return -1;
        }
        if (this._dssFileName == null) {
            return -1;
        }
        try {
            return this._dssmanager.zinqir(this._dssFileName, parameter);
        }
        catch (Exception e) {
            System.out.println("remote dssfilemanager call zinqir failed:\n " + e);
            return -1;
        }
    }

    public void zinqir(String parameter, stringContainer alpha, int[] number) {
        if (this._dssmanager == null) {
            return;
        }
        if (this._dssFileName == null) {
            return;
        }
        try {
            ResultZinqir result = this._dssmanager.zinqir(this._dssFileName, parameter, alpha, number);
            if (result != null) {
                alpha.string = result.getText();
                number[0] = result.getNumber();
            }
        }
        catch (Exception e) {
            System.out.println("remote dssfilemanager call failed");
        }
    }

    public void zquery(String parameter, stringContainer alpha, int[] number) {
        if (this._dssmanager == null) {
            return;
        }
        try {
            ResultZquery result = this._dssmanager.zquery(parameter, alpha, number);
            if (result != null) {
                alpha.string = result.getText();
                number[0] = result.getNumber();
            }
        }
        catch (Exception e) {
            System.out.println("remote dssfilemanager call failed");
        }
    }

    public void zset(String parameter, String alpha, int number) {
        if (this._dssmanager == null) {
            return;
        }
        try {
            this._dssmanager.zset(parameter, alpha, number);
        }
        catch (Exception e) {
            System.out.println("remote dssfilemanager call failed");
        }
    }

    public int recordType(String pathname) {
        if (this._dssmanager == null) {
            return -1;
        }
        if (this._dssFileName == null) {
            return -1;
        }
        try {
            return this._dssmanager.recordType(this._dssFileName, pathname);
        }
        catch (Exception e) {
            System.out.println("remote dssfilemanager call recordType failed:\n " + e);
            return -1;
        }
    }

    public Map<String, Integer> recordTypes(String[] pathnames) {
        HashMap<String, Integer> recordMap = new HashMap<String, Integer>();
        if (this._dssmanager == null) {
            return recordMap;
        }
        if (this._dssFileName == null) {
            return recordMap;
        }
        try {
            return this._dssmanager.recordTypes(this._dssFileName, pathnames);
        }
        catch (Exception e) {
            System.out.println("remote dssfilemanager call recordType failed:\n " + e);
            return recordMap;
        }
    }

    public boolean writeAccess() {
        if (this._dssmanager == null) {
            return false;
        }
        if (this._dssFileName == null) {
            return false;
        }
        try {
            return this._dssmanager.writeAccess(this._dssFileName);
        }
        catch (Exception e) {
            System.out.println("remote dssfilemanager call writeAccess failed:\n " + e);
            return false;
        }
    }

    public void close() {
        if (this._dssmanager == null) {
            return;
        }
        if (this._dssFileName == null) {
            return;
        }
        try {
            this._dssmanager.close(this._dssFileName);
        }
        catch (Exception e) {
            System.out.println("remote dssfilemanager call failed:\n " + e);
        }
    }

    public String DSSFileName() {
        if (this._dssFileName == null) {
            return "";
        }
        return this._dssFileName;
    }

    public boolean fileOpened() {
        if (this._dssmanager == null) {
            return false;
        }
        if (this._dssFileName == null) {
            return false;
        }
        try {
            return this._dssmanager.fileOpened(this._dssFileName);
        }
        catch (Exception e) {
            System.out.println("remote dssfilemanager call failed:\n " + e);
            return false;
        }
    }

    public int open() {
        if (this._dssmanager == null) {
            return -1;
        }
        if (this._dssFileName == null) {
            return -1;
        }
        try {
            this._dssmanager.setDSSFileName(this._dssFileName, false);
            if (this._dssmanager.numberRecords(this._dssFileName) >= 0) {
                return 0;
            }
            return -1;
        }
        catch (Exception e) {
            System.out.println("remote dssfilemanager call failed:\n " + e);
            return -1;
        }
    }

    public boolean fileAccessible() {
        if (this._dssmanager == null) {
            return false;
        }
        if (this._dssFileName == null) {
            return false;
        }
        try {
            return this._dssmanager.fileAccessible(this._dssFileName);
        }
        catch (Exception e) {
            System.out.println("remote dssfilemanager call failed:\n " + e);
            return false;
        }
    }

    public boolean getTimeSeriesExtents(DSSIdentifier dssId, HecTime start, HecTime end) {
        if (this._dssmanager == null) {
            return false;
        }
        try {
            return this._dssmanager.getTimeSeriesExtents(dssId, start, end);
        }
        catch (Exception e) {
            System.out.println("remote dssfilemanager call failed:\n " + e);
            return false;
        }
    }

    public int getTSRecordInfo(DSSIdentifier dssId, HecTime start, HecTime end, stringContainer units, stringContainer type) {
        if (this._dssmanager == null) {
            return -1;
        }
        try {
            return this._dssmanager.getTSRecordInfo(dssId, start, end, units, type);
        }
        catch (Exception e) {
            System.out.println("remote dssfilemanager call failed:\n " + e);
            return -1;
        }
    }

    public int setDSSFileName(String dssFileName, boolean fileMustExist) {
        this._dssFileName = dssFileName;
        if (this._dssmanager != null && this._dssFileName != null) {
            try {
                return this._dssmanager.setDSSFileName(this._dssFileName, fileMustExist);
            }
            catch (Exception e) {
                ((FluentLogger.Api)((FluentLogger.Api)LOGGER.atConfig()).withCause((Throwable)e)).log("remote dssfilemanager call failed");
            }
        }
        return -1;
    }

    public int setDSSFileName(String dssFileName, boolean fileMustExist, int version) {
        this._dssFileName = dssFileName;
        if (this._dssmanager != null && this._dssFileName != null) {
            try {
                return this._dssmanager.setDSSFileName(this._dssFileName, fileMustExist, version);
            }
            catch (Exception e) {
                ((FluentLogger.Api)((FluentLogger.Api)LOGGER.atConfig()).withCause((Throwable)e)).log("remote dssfilemanager call setDSSFileName failed");
            }
        }
        return -1;
    }

    public boolean recordExists(String pathname) {
        if (this._dssmanager != null && this._dssFileName != null) {
            try {
                return this._dssmanager.recordExists(this._dssFileName, pathname);
            }
            catch (Exception e) {
                ((FluentLogger.Api)((FluentLogger.Api)LOGGER.atConfig()).withCause((Throwable)e)).log("remote dssfilemanager call recordExists failed");
            }
        }
        return false;
    }

    public boolean checkForSevereError() {
        if (this._dssmanager != null) {
            try {
                boolean stat = this._dssmanager.checkForSevereError();
                this._dssmanager.clearSevereError();
                return stat;
            }
            catch (Exception e) {
                ((FluentLogger.Api)((FluentLogger.Api)LOGGER.atConfig()).withCause((Throwable)e)).log("remote dssfilemanager call checkForSevereError failed");
            }
        }
        return false;
    }

    public void clearSevereError() {
        if (this._dssmanager == null) {
            Heclib.zset((String)"clear", (String)"", (int)0);
            return;
        }
        try {
            this._dssmanager.clearSevereError();
        }
        catch (Exception e) {
            ((FluentLogger.Api)((FluentLogger.Api)LOGGER.atConfig()).withCause((Throwable)e)).log("remote dssfilemanager call clearSevereError failed");
        }
    }

    public DSSErrorMessage lastSevereErrorMessage() {
        if (this._dssmanager == null) {
            return null;
        }
        try {
            return this._dssmanager.lastSevereErrorMessage();
        }
        catch (Exception e) {
            ((FluentLogger.Api)((FluentLogger.Api)LOGGER.atConfig()).withCause((Throwable)e)).log("remote dssfilemanager call lastSevereErrorMessage failed");
            return null;
        }
    }

    public List<DSSErrorMessage> allSevereErrorMessages() {
        if (this._dssmanager != null) {
            try {
                return this._dssmanager.allSevereErrorMessages();
            }
            catch (Exception e) {
                ((FluentLogger.Api)((FluentLogger.Api)LOGGER.atConfig()).withCause((Throwable)e)).log("remote dssfilemanager call allSevereErrorMessages failed");
            }
        }
        return new Vector<DSSErrorMessage>();
    }
}

