/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.rmi.heclib.dss;

import hec.heclib.util.HecDoubleArray;
import hec.heclib.util.doubleArrayContainer;
import hec.io.DSSIdentifier;
import hec.io.DataContainer;
import hec.io.PairedDataContainer;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Vector;
import mil.army.usace.hec.rmi.csinterface.DSSManager;
import mil.army.usace.hec.rmi.heclib.dss.HecDataManagerRemote;

public class HecPairedDataRemote
extends HecDataManagerRemote {
    doubleArrayContainer _xArray = null;
    Vector _yVector = null;
    transient PairedDataContainer _pairedDataContainer = new PairedDataContainer();

    public HecPairedDataRemote(DSSManager dssmanager) {
        super(dssmanager);
    }

    public int saveDataToDisk() {
        int status = -1;
        return status;
    }

    public int read(HecDoubleArray xArray, Vector vector) {
        int status = -1;
        if (this._dssmanager == null) {
            return status;
        }
        if (xArray == null || vector == null) {
            return status;
        }
        try {
            DSSIdentifier dssId = new DSSIdentifier(this._dssFileName, this._pathname.getPathname());
            Vector avec = this._dssmanager.readPD(dssId);
            if (avec.size() < 2) {
                return -1;
            }
            this._xArray = (doubleArrayContainer)avec.elementAt(0);
            xArray.setSize(this._xArray.array.length);
            for (int j = 0; j < this._xArray.array.length; ++j) {
                xArray.set(j, this._xArray.array[j]);
            }
            this._yVector = (Vector)avec.elementAt(1);
            vector.removeAllElements();
            Enumeration e = this._yVector.elements();
            while (e.hasMoreElements()) {
                vector.addElement(e.nextElement());
            }
            status = this._xArray.length;
        }
        catch (Exception e) {
            System.out.println("remote dssfilemanager call readPD failed");
        }
        return status;
    }

    public int read(PairedDataContainer pairedDataContainer) {
        int status = -1;
        if (this._dssmanager == null) {
            return status;
        }
        try {
            DSSIdentifier dssId = new DSSIdentifier(this._dssFileName, this._pathname.getPathname());
            this._pairedDataContainer = this._dssmanager.readPairedDataContainer(dssId);
        }
        catch (Exception e) {
            System.out.println("remote dssfilemanager call readPD failed");
        }
        if (this._pairedDataContainer.xOrdinates == null) {
            System.out.println("Error in Paired Record. Empty record.");
            return -1;
        }
        this._pairedDataContainer.clone(pairedDataContainer);
        return 0;
    }

    public int Xarray(doubleArrayContainer xArrayContainer) {
        if (this._xArray == null) {
            return -1;
        }
        xArrayContainer.array = this._xArray.array;
        return this._xArray.length;
    }

    public int numberOfCurves() {
        if (this._yVector == null) {
            return -1;
        }
        return this._yVector.size();
    }

    public int Yarray(doubleArrayContainer[] yArraysContainer) {
        if (this._yVector == null || this._yVector.size() != yArraysContainer.length) {
            return -1;
        }
        int i = 0;
        Enumeration e = this._yVector.elements();
        while (e.hasMoreElements()) {
            doubleArrayContainer ac = (doubleArrayContainer)e.nextElement();
            yArraysContainer[i].array = ac.array;
            ++i;
        }
        return i;
    }

    public Vector labels() {
        if (this._dssmanager == null) {
            return new Vector();
        }
        try {
            DSSIdentifier dssId = new DSSIdentifier(this._dssFileName, this._pathname.getPathname());
            return this._dssmanager.readPDLabels(dssId);
        }
        catch (Exception e) {
            System.out.println("remote dssfilemanager call readPD failed");
            return new Vector();
        }
    }

    public String unitsY() {
        return "unitsy";
    }

    public String unitsX() {
        return "unitsy";
    }

    public void setYUnits(String s) {
    }

    public void setXUnits(String s) {
    }

    public void setLabels(Vector vs) {
    }

    public int write(PairedDataContainer pairedDataContainer) {
        if (this._dssmanager == null) {
            return -1;
        }
        int status = 0;
        pairedDataContainer.clone(this._pairedDataContainer);
        try {
            status = this._dssmanager.write((DataContainer)this._pairedDataContainer);
        }
        catch (RemoteException re) {
            System.out.println("Error in hec.heclib.dss.HecPairedDataRemote with DSSManager  " + re);
            return -1;
        }
        return status;
    }
}

