/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.rmi.heclib.dss;

import hec.heclib.dss.DSSPathname;
import hec.heclib.dss.HecDSSRecordInfo;
import hec.heclib.dss.HecTimeSeriesBase;
import hec.heclib.util.HecDoubleArray;
import hec.heclib.util.HecTime;
import hec.heclib.util.HecTimeArray;
import hec.heclib.util.Heclib;
import hec.heclib.util.doubleArrayContainer;
import hec.heclib.util.intArrayContainer;
import hec.io.DSSArrayContainer;
import hec.io.DSSIdentifier;
import hec.io.TimeSeriesCollectionContainer;
import hec.io.TimeSeriesContainer;
import hec.io.TimeSeriesContainerVertDatum;
import hec.util.TextUtil;
import java.io.FileNotFoundException;
import java.rmi.RemoteException;
import mil.army.usace.hec.rmi.csinterface.DSSManager;
import mil.army.usace.hec.rmi.heclib.dss.HecDataManagerRemote;

public class HecTimeSeriesRemote
extends HecDataManagerRemote {
    transient DSSArrayContainer _dssArray = null;
    transient intArrayContainer _timeArray = new intArrayContainer();
    transient doubleArrayContainer _dataArray = new doubleArrayContainer();
    transient TimeSeriesContainer _timeSeriesContainer = new TimeSeriesContainer();
    transient int _regularStorePlan = 0;
    transient int _irregularInFlag = 1;

    public HecTimeSeriesRemote(DSSManager dssmanager) {
        super(dssmanager);
    }

    public int saveDataToDisk() {
        int status = -1;
        return status;
    }

    public int read(HecTimeArray times, HecDoubleArray values) {
        if (this._dssmanager == null) {
            return -1;
        }
        try {
            DSSIdentifier dssId = new DSSIdentifier(this._dssFileName, this._pathname.getPathname());
            dssId.setStartTime(this._startTime);
            dssId.setEndTime(this._endTime);
            this._dssArray = this._dssmanager.read(dssId);
        }
        catch (RemoteException re) {
            System.out.println("Error in hec.heclib.dss.HecTimeSeriesRemote with DSSManager  " + re);
            return -1;
        }
        catch (FileNotFoundException e) {
            System.out.println("Error in hec.heclib.dss.HecTimeSeriesRemote with DSSManager  " + e);
            return -1;
        }
        if (this._dssArray == null) {
            System.out.println("Error in TSRecord. Empty record.");
            return -1;
        }
        if (this._dssArray.dataArray == null) {
            System.out.println("Empty record.");
            return -1;
        }
        this._dataArray.array = this._dssArray.dataArray;
        this._timeArray.array = this._dssArray.timeArray;
        values.setSize(this._dataArray.array.length);
        times.setSize(this._timeArray.array.length);
        HecTime[] ta = times.timeArray();
        for (int j = 0; j < this._dataArray.array.length; ++j) {
            values.set(j, this._dataArray.array[j]);
            HecTime t = new HecTime();
            t.set(this._timeArray.array[j]);
            ta[j] = t;
        }
        return this._dataArray.array.length;
    }

    public int read(TimeSeriesCollectionContainer timeSeriesCollectionContainer, boolean removeMissing) {
        return this.read(timeSeriesCollectionContainer, removeMissing, true);
    }

    public int read(TimeSeriesCollectionContainer timeSeriesCollectionContainer, boolean removeMissing, boolean getCollectionTimes) {
        String pathname;
        if (timeSeriesCollectionContainer.fullName != null && timeSeriesCollectionContainer.fullName.length() > 7) {
            this.setPathname(timeSeriesCollectionContainer.fullName);
            if (timeSeriesCollectionContainer.fileName != null && timeSeriesCollectionContainer.fileName.length() > 0) {
                this.setDSSFileName(timeSeriesCollectionContainer.fileName, true);
            }
        }
        if (!DSSPathname.isaCollectionPath((String)(pathname = this.pathname()))) {
            return -4;
        }
        String[] pathnameList = this.getCollectionList(pathname);
        if (pathnameList == null || pathnameList.length == 0) {
            return -3;
        }
        TimeSeriesContainer[] tscs = new TimeSeriesContainer[pathnameList.length];
        boolean isElev = TextUtil.split((String)pathname, (String)"/")[3].toUpperCase().startsWith("ELEV");
        for (int i = 0; i < pathnameList.length; ++i) {
            this.setPathname(pathnameList[i]);
            Object tsc = null;
            tsc = isElev ? new TimeSeriesContainerVertDatum() : new TimeSeriesContainer();
            this.read((TimeSeriesContainer)tsc, removeMissing);
            if (this.checkForSevereError()) {
                return -10;
            }
            tscs[i] = tsc;
        }
        this.reset();
        this.setPathname(pathname);
        timeSeriesCollectionContainer.set(tscs);
        if (getCollectionTimes) {
            timeSeriesCollectionContainer.getTimes();
        }
        return 0;
    }

    public int read(TimeSeriesContainer timeSeriesContainer, boolean removeMissing) {
        if (this._dssmanager == null) {
            return -1;
        }
        try {
            DSSIdentifier dssId = new DSSIdentifier(this._dssFileName, this._pathname.getPathname());
            dssId.setStartTime(this._startTime);
            dssId.setEndTime(this._endTime);
            boolean getRecordInfo = false;
            if (timeSeriesContainer.otherInfo != null && timeSeriesContainer.otherInfo instanceof HecDSSRecordInfo) {
                getRecordInfo = true;
            }
            this._timeSeriesContainer = this._dssmanager.readTS(dssId, getRecordInfo, removeMissing);
        }
        catch (RemoteException re) {
            System.out.println("Error in hec.heclib.dss.HecTimeSeriesRemote with DSSManager  " + re);
            return -1;
        }
        catch (FileNotFoundException e) {
            System.out.println("Error in hec.heclib.dss.HecTimeSeriesRemote with DSSManager  " + e);
            return -1;
        }
        if (this._timeSeriesContainer.values == null) {
            System.out.println("Error in TSRecord. Empty record.");
            return -1;
        }
        this._timeSeriesContainer.clone(timeSeriesContainer);
        return 0;
    }

    public int write(TimeSeriesContainer timeSeriesContainer) {
        if (this._dssmanager == null) {
            return -1;
        }
        int status = 0;
        timeSeriesContainer.clone(this._timeSeriesContainer);
        try {
            status = this._dssmanager.writeTS(this._timeSeriesContainer, this._regularStorePlan, this._irregularInFlag);
        }
        catch (RemoteException re) {
            System.out.println("Error in hec.heclib.dss.HecTimeSeriesRemote with DSSManager  " + re);
            return -1;
        }
        return status;
    }

    public void setRegularIntervalStorePlan(int regularStorePlan) {
        this._regularStorePlan = regularStorePlan;
    }

    public void setIrregularIntervalInFlag(int inFlag) {
        this._irregularInFlag = inFlag;
    }

    public String units() {
        if (this._dssArray != null) {
            return this._dssArray.getUnits();
        }
        return "";
    }

    public String type() {
        if (this._dssArray != null) {
            return this._dssArray.getType();
        }
        return "";
    }

    public boolean isTimeWindowSet() {
        if (this._startTime == null) {
            return false;
        }
        if (this._endTime == null) {
            return false;
        }
        if (!this._startTime.isDefined()) {
            return false;
        }
        return this._endTime.isDefined();
    }

    public void resetArrayTime() {
        this._dssArray = null;
    }

    public int Xarray(doubleArrayContainer xArrayContainer) {
        if (this._dssArray == null) {
            return -1;
        }
        xArrayContainer.array = this._dataArray.array;
        return this._dataArray.length;
    }

    public int numberArray() {
        if (this._dssArray != null) {
            return this._dataArray.length;
        }
        return 0;
    }

    public void setUnits(String s) {
    }

    public void reset() {
        this.resetArrayTime();
    }

    @Override
    public synchronized String[] getCollectionList(String seedPathname) {
        DSSPathname path = new DSSPathname(seedPathname);
        if (path.dPart().length() != 9) {
            if (this._startTime.isDateDefined()) {
                int[] iblock = new int[1];
                int[] iyr = new int[1];
                int[] imon = new int[1];
                int[] iday = new int[1];
                int ver = 7500;
                int jul = this._startTime.julian();
                int interval = HecTimeSeriesBase.getIntervalFromEPart((String)path.ePart());
                Heclib.zbegdt((int)jul, (int)interval, (int[])iyr, (int[])imon, (int[])iday, (int[])iblock, (int)ver);
                HecTime hecTime = new HecTime();
                hecTime.setYearMonthDay(iyr[0], imon[0], iday[0], 1);
                path.setDPart(hecTime.date(104));
            }
            return super.getCollectionList(path.pathname());
        }
        return super.getCollectionList(seedPathname);
    }
}

