/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.rmi.heclib.dss;

import hec.data.Units;
import hec.heclib.dss.AbstractDssDataManager;
import hec.heclib.dss.CondensedReference;
import hec.heclib.dss.DSSErrorMessage;
import hec.heclib.dss.DSSPathname;
import hec.heclib.dss.DataReference;
import hec.heclib.dss.DssDataManager;
import hec.heclib.dss.HecDSSFileData;
import hec.heclib.dss.HecDSSRecordInfo;
import hec.heclib.dss.HecDataManager;
import hec.heclib.dss.HecDssFileStore;
import hec.heclib.dss.HecDssImage;
import hec.heclib.dss.IHecDSSUtilities;
import hec.heclib.dss.RemoteDssDataManagerProvider;
import hec.heclib.grid.GridData;
import hec.heclib.grid.GridInfo;
import hec.heclib.grid.GriddedData;
import hec.heclib.util.HecTime;
import hec.heclib.util.stringContainer;
import hec.io.ArrayContainer;
import hec.io.DSSIdentifier;
import hec.io.DataContainer;
import hec.io.DssFileContainer;
import hec.io.GridContainer;
import hec.io.PairedDataContainer;
import hec.io.TextContainer;
import hec.io.TimeSeriesCollectionContainer;
import hec.io.TimeSeriesContainer;
import hec.io.TinContainer;
import hec.util.PhotoViewerInfo;
import java.io.File;
import java.rmi.RemoteException;
import java.util.List;
import java.util.TimeZone;
import java.util.Vector;
import mil.army.usace.hec.rmi.csinterface.DSSManager;
import mil.army.usace.hec.rmi.heclib.dss.HecDSSUtilitiesRemote;
import mil.army.usace.hec.rmi.heclib.dss.HecDataManagerRemote;
import mil.army.usace.hec.rmi.heclib.dss.HecDssTextRemote;
import mil.army.usace.hec.rmi.heclib.dss.HecPairedDataRemote;
import mil.army.usace.hec.rmi.heclib.dss.HecTimeSeriesRemote;
import rma.services.annotations.ServiceProvider;

public class RmiDssDataManager
extends AbstractDssDataManager {
    private Vector<String> _lastRemoteDeletedList = new Vector();

    public RmiDssDataManager() {
        super((IHecDSSUtilities)HecDSSUtilitiesRemote.createHecDSSUtilitiesRemote());
    }

    public void setMessageLevel(int level) {
        HecDSSUtilitiesRemote.setMessageLevel(level);
    }

    public int getMessageLevel() {
        return HecDataManager.getMessageLevel();
    }

    public void setUnit(int unit) {
        HecDSSUtilitiesRemote.setUnit(unit);
    }

    public int fileAccessInfo(int[] accessMode, int[] numberAccesses, int[] numberWrites, int[] pidsArray, int[] modesArray, int[] numberPids) {
        return -3;
    }

    public List<String> getLastDeletePathnames() {
        return this._lastRemoteDeletedList;
    }

    public HecDSSUtilitiesRemote dataManager() {
        return (HecDSSUtilitiesRemote)super.dataManager();
    }

    public List<HecDSSFileData> DssFileManagerStatus() {
        return HecDSSUtilitiesRemote.DssFileManagerStatus();
    }

    public int checkForError() {
        if (this.dataManager().checkForSevereDssError()) {
            return 3;
        }
        if (this.getDssFileVersion() == 7) {
            return this.dataManager().checkForError();
        }
        return 0;
    }

    public int recordsUpdated(long startTime, List<String> pathnames, List<Long> updateTimes, List<Integer> recordTypes) {
        List<DSSIdentifier> dssIdentifierList = this.dataManager().recordsUpdated(startTime);
        if (dssIdentifierList == null) {
            return -1;
        }
        pathnames.clear();
        updateTimes.clear();
        recordTypes.clear();
        for (DSSIdentifier dssIdentifier : dssIdentifierList) {
            String dssPath = dssIdentifier.getDSSPath();
            pathnames.add(dssPath);
            long updateTime = dssIdentifier.getUpdateTime();
            updateTimes.add(updateTime);
            dssIdentifier.getType();
            Object recordType = null;
            recordTypes.add((Integer)recordType);
        }
        return 0;
    }

    public void clearSevereError() {
        this.dataManager().clearSevereError();
    }

    public DSSErrorMessage lastErrorMessage() {
        return this.dataManager().lastSevereErrorMessage();
    }

    public void getProcessStatus(int[] numberRecs, int[] currentRec) {
        this.dataManager().getProcessStatus(numberRecs, currentRec);
    }

    public boolean cleanDSSFileName(String inName, stringContainer outName) {
        return HecDSSUtilitiesRemote.cleanDSSFileName(inName, outName);
    }

    public int copyFile(DssDataManager dataManager, String secondDSSFilename) {
        return this.dataManager().copyFile(secondDSSFilename);
    }

    public int copyRecordsFrom(DssDataManager toDataManager, String toDSSFilename, List<String> pathnameList) {
        return this.dataManager().copyRecordsFrom(toDSSFilename, pathnameList);
    }

    public int copyRecordsInto(DssDataManager fromDataManager, String fromDSSFilename, List<String> pathnameList) {
        return this.dataManager().copyRecordsInto(fromDSSFilename, pathnameList);
    }

    public int delete(List<String> pathnameList) {
        this._lastRemoteDeletedList.removeAllElements();
        this._lastRemoteDeletedList.addAll(pathnameList);
        return this.dataManager().delete(pathnameList);
    }

    public boolean doesDSSFileExist(String dssFileName) {
        return HecDSSUtilitiesRemote.doesDSSFileExist(dssFileName);
    }

    public int readData(DataReference dataReference, TimeSeriesContainer timeSeriesContainer, boolean trimMissing) {
        HecTime start = new HecTime();
        HecTime end = new HecTime();
        TimeZone timeZone = this.getTimeZone();
        if (timeZone != null) {
            timeSeriesContainer.timeZoneID = timeZone.getID();
            timeSeriesContainer.timeZoneRawOffset = timeZone.getRawOffset();
        }
        int status = 0;
        HecDataManagerRemote object = this.dataManager().createObject(dataReference.getPath());
        if (object instanceof HecTimeSeriesRemote) {
            dataReference.getTimeWindow((Object)object, start, end);
            object.setTimeWindow(start, end);
            status = ((HecTimeSeriesRemote)object).read(timeSeriesContainer, trimMissing);
            timeSeriesContainer.startHecTime = start;
            timeSeriesContainer.endHecTime = end;
        } else {
            status = -2;
        }
        if (status == 0) {
            if (timeSeriesContainer.numberValues <= 0) {
                status = -1;
            }
            if (this.getDisplayUnitSystem() != 3) {
                Units.convertUnits((TimeSeriesContainer)timeSeriesContainer, (int)this.getDisplayUnitSystem());
            }
        }
        return status;
    }

    public int readData(DataReference dataReference, TimeSeriesCollectionContainer timeSeriesCollectionContainer, boolean trimMissing) {
        HecTime start = new HecTime();
        HecTime end = new HecTime();
        int status = 0;
        HecDataManagerRemote object = this.dataManager().createObject(dataReference.getPath());
        if (object instanceof HecTimeSeriesRemote) {
            dataReference.getTimeWindow((Object)object, start, end);
            object.setTimeWindow(start, end);
            status = ((HecTimeSeriesRemote)object).read(timeSeriesCollectionContainer, trimMissing);
        } else {
            status = -2;
        }
        if (status == 0 && this.getDisplayUnitSystem() != 3) {
            for (TimeSeriesContainer tsCont : timeSeriesCollectionContainer.get()) {
                Units.convertUnits((TimeSeriesContainer)tsCont, (int)this.getDisplayUnitSystem());
            }
        }
        return status;
    }

    public int readData(DataReference dataReference, PairedDataContainer pairedDataContainer) {
        HecDataManagerRemote object = this.dataManager().createPairedDataObject(dataReference.getPath());
        int status = object instanceof HecPairedDataRemote ? ((HecPairedDataRemote)object).read(pairedDataContainer) : -2;
        return status;
    }

    public int readData(DataReference dataReference, TextContainer textContainer) {
        HecDataManagerRemote object = this.dataManager().createTextObject(dataReference.getPath());
        if (object instanceof HecDssTextRemote) {
            int status = ((HecDssTextRemote)object).read(textContainer);
            return status;
        }
        return -1;
    }

    public int readData(DataReference dataReference, ArrayContainer arrayContainer) {
        return -1;
    }

    public int readData(DataReference dataReference, DssFileContainer fileContainer) {
        DSSIdentifier dssId = new DSSIdentifier(dataReference.getFilename(), dataReference.getPathname());
        DSSManager dssManager = this.dataManager().getRemoteDSSManager();
        try {
            DssFileContainer newFileContainer = dssManager.readFileData(dssId);
            if (newFileContainer == null) {
                return -1;
            }
            fileContainer.clone(newFileContainer);
            return 0;
        }
        catch (Exception e) {
            System.out.println(e);
            return -1;
        }
    }

    public boolean getRecordInfo(DataReference dataReference, HecDSSRecordInfo recordInfo) {
        return false;
    }

    public int writeData(TextContainer textContainer) {
        HecDataManagerRemote object = this.dataManager().createTextObject(textContainer.fullName);
        int status = object instanceof HecDssTextRemote ? ((HecDssTextRemote)object).write(textContainer) : -1;
        if (status >= 0) {
            textContainer.modified = false;
        }
        return status;
    }

    public List readGriddedData(DSSIdentifier dssId) {
        if (dssId == null) {
            return null;
        }
        DSSPathname pathName = new DSSPathname(dssId.getDSSPath());
        HecTime time = new HecTime(pathName.dPart());
        dssId.setStartTime(time);
        time = new HecTime(pathName.ePart());
        dssId.setEndTime(time);
        Vector gridVector = null;
        gridVector = this.dataManager().getGriddedDataRemote(dssId);
        if (gridVector == null) {
            return null;
        }
        gridVector.add(pathName);
        return gridVector;
    }

    protected List readTinData(DSSIdentifier dssId, TinContainer tinContainer) {
        if (dssId == null) {
            return null;
        }
        DSSPathname pathName = new DSSPathname(dssId.getDSSPath());
        Vector tinVector = null;
        if (tinVector == null) {
            return null;
        }
        tinVector.addElement(pathName);
        return tinVector;
    }

    public String[] getCatalog(boolean sorted, String pathWithWildChars) {
        return this.dataManager().getPathnameList(false);
    }

    public CondensedReference[] getCondensedCatalog(String pathWithWildChars) {
        CondensedReference[] condRef = new CondensedReference[]{};
        List catalog = this.dataManager().getCondensedCatalog();
        if (catalog != null) {
            condRef = catalog.toArray(condRef);
        }
        return condRef;
    }

    public int convertVersion(String convertFileName) {
        System.out.println("DSS Version Conversion not implemented for remote files");
        return -1;
    }

    public int undelete(List<String> pathnames) {
        int stat = this.dataManager().undelete(pathnames);
        this._lastRemoteDeletedList.removeAll(pathnames);
        return stat;
    }

    public int undoLastDelete() {
        int stat = this.dataManager().undelete(this._lastRemoteDeletedList);
        this._lastRemoteDeletedList.removeAllElements();
        return stat;
    }

    public int writeData(PairedDataContainer pairedDataContainer) {
        HecDataManagerRemote object = this.dataManager().createPairedDataObject(pairedDataContainer.fullName);
        int status = ((HecPairedDataRemote)object).write(pairedDataContainer);
        if (status >= 0) {
            pairedDataContainer.modified = false;
        }
        return status;
    }

    public int writeData(GridContainer gridContainer) {
        int status = -1;
        GridData gridData = gridContainer.getGridData();
        GridInfo gridInfo = gridData.getGridInfo();
        HecTime startTime = new HecTime();
        HecTime endTime = new HecTime();
        startTime.set(gridInfo.getStartTime());
        endTime.set(gridInfo.getEndTime());
        GriddedData griddedData = new GriddedData();
        DSSIdentifier dssId = new DSSIdentifier(this.dataManager().DSSFileName(), gridContainer.fullName);
        dssId.setStartTime(startTime);
        dssId.setEndTime(endTime);
        try {
            status = this.dataManager().getRemoteDSSManager().storeGriddedData(dssId, gridContainer.getGridInfo(), gridContainer.getGridData());
            return status;
        }
        catch (RemoteException e) {
            return status;
        }
    }

    public int writeLocation(DataContainer dataContainer) {
        return -1;
    }

    public int writeData(TimeSeriesContainer timeSeriesContainer, int regularStoreMethod, int irregularStoreMethod) {
        int status;
        HecDataManagerRemote object = this.dataManager().createObject(timeSeriesContainer.fullName);
        timeSeriesContainer.fileName = this.dataManager().DSSFileName();
        if (object instanceof HecTimeSeriesRemote) {
            HecTimeSeriesRemote timeSeriesRemote = (HecTimeSeriesRemote)object;
            timeSeriesRemote.setRegularIntervalStorePlan(regularStoreMethod);
            timeSeriesRemote.setIrregularIntervalInFlag(irregularStoreMethod);
            status = timeSeriesRemote.write(timeSeriesContainer);
        } else {
            status = -1;
        }
        if (status >= 0) {
            timeSeriesContainer.modified = false;
        }
        return status;
    }

    public int writeFile(File file, DSSPathname pathname, boolean imageFile) throws Exception {
        Object fileStore = imageFile ? new HecDssImage() : new HecDssFileStore();
        DSSManager dssManager = this.dataManager().getRemoteDSSManager();
        DssFileContainer fileContainer = fileStore.getFileContainer(file);
        if (fileContainer.fileArray != null && fileContainer.fileArray.length > 0) {
            fileContainer.fullName = pathname.pathname();
            fileContainer.fileName = this.getDSSFileName();
            dssManager.writeFileData(fileContainer);
            return 0;
        }
        return -10;
    }

    public int exportFile(String pathname, File file, String directory) throws Exception {
        DSSManager dssManager = this.dataManager().getRemoteDSSManager();
        DSSIdentifier dssId = new DSSIdentifier(this.getDSSFileName(), pathname);
        DssFileContainer fileContainer = dssManager.readFileData(dssId);
        if (fileContainer.fileArray != null && fileContainer.fileArray.length > 0) {
            HecDssFileStore fileStore = new HecDssFileStore();
            HecDssFileStore.export((DssFileContainer)fileContainer, (File)file, (String)directory);
            return 0;
        }
        return -10;
    }

    public int readImage(DataReference dataSet, PhotoViewerInfo info) throws Exception {
        DSSManager dssManager = this.dataManager().getRemoteDSSManager();
        DSSIdentifier dssId = new DSSIdentifier(this.getDSSFileName(), dataSet.getPathname());
        DssFileContainer fileContainer = dssManager.readFileData(dssId);
        if (fileContainer.fileArray != null && fileContainer.fileArray.length > 0) {
            HecDssImage dssImage = new HecDssImage();
            dssImage.loadImage(info, fileContainer);
            return 0;
        }
        return -10;
    }

    public int readLocation(DataContainer dataContainer) throws Exception {
        return -10;
    }

    public String DSSFileName(int i) {
        return null;
    }

    public boolean isCwmsDb() {
        return false;
    }

    @ServiceProvider(service=RemoteDssDataManagerProvider.class)
    public static class RmiDssDataManagerProvider
    implements RemoteDssDataManagerProvider {
        public DssDataManager createRemoteDssDataManager() {
            return new RmiDssDataManager();
        }
    }
}

