/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.rmi.heclib.grid;

import hec.heclib.util.Heclib;

public class HrapConvertInfo {
    String _site;
    float _HrapCellSize;
    int _LLHrapCellX;
    int _LLHrapCellY;
    int _numHrapCellsX;
    int _numHrapCellsY;
    float _ShgCellSize;
    int _LLShgCellX;
    int _LLShgCellY;
    int _numShgCellsX;
    int _numShgCellsY;

    public HrapConvertInfo() {
        this._site = "NULL";
        this._HrapCellSize = 4762.5f;
        this._LLHrapCellX = 0;
        this._LLHrapCellY = 0;
        this._numHrapCellsX = 0;
        this._numHrapCellsY = 0;
        this._ShgCellSize = 2000.0f;
        this._LLShgCellX = 0;
        this._LLShgCellY = 0;
        this._numShgCellsX = 0;
        this._numShgCellsY = 0;
    }

    public HrapConvertInfo(HrapConvertInfo b) {
        this._site = b._site;
        this._HrapCellSize = b._HrapCellSize;
        this._LLHrapCellX = b._LLHrapCellX;
        this._LLHrapCellY = b._LLHrapCellY;
        this._numHrapCellsX = b._numHrapCellsX;
        this._numHrapCellsY = b._numHrapCellsY;
        this._ShgCellSize = b._ShgCellSize;
        this._LLShgCellX = b._LLShgCellX;
        this._LLShgCellY = b._LLShgCellY;
        this._numShgCellsX = b._numShgCellsX;
        this._numShgCellsY = b._numShgCellsY;
    }

    public void clone(HrapConvertInfo a) {
        a._site = this._site;
        a._HrapCellSize = this._HrapCellSize;
        a._LLHrapCellX = this._LLHrapCellX;
        a._LLHrapCellY = this._LLHrapCellY;
        a._numHrapCellsX = this._numHrapCellsX;
        a._numHrapCellsY = this._numHrapCellsY;
        a._ShgCellSize = this._ShgCellSize;
        a._LLShgCellX = this._LLShgCellX;
        a._LLShgCellY = this._LLShgCellY;
        a._numShgCellsX = this._numShgCellsX;
        a._numShgCellsY = this._numShgCellsY;
    }

    public void show() {
        System.out.println(" \n= = = HRAP to SHG Conversion Table = = =\nSite name: " + this._site + "\nHRAP cell size: " + this._HrapCellSize + "\nHRAP origin: " + this._LLHrapCellX + ", " + this._LLHrapCellY + "\n\trows: " + this._numHrapCellsY + "\n\tcolumns: " + this._numHrapCellsX + "\nSHG cell size: " + this._ShgCellSize + "\nSHG origin: " + this._LLShgCellX + ", " + this._LLShgCellY + "\n\trows: " + this._numShgCellsY + "\n\tcolums: " + this._numShgCellsX);
    }

    public String toString() {
        String valStr = " \n= = = HRAP to SHG Conversion Table = = =\nSite name: " + this._site + "\nHRAP cell size: " + this._HrapCellSize + "\nHRAP origin: " + this._LLHrapCellX + ", " + this._LLHrapCellY + "\n\trows: " + this._numHrapCellsY + "\n\tcolumns: " + this._numHrapCellsX + "\nSHG cell size: " + this._ShgCellSize + "\nSHG origin: " + this._LLShgCellX + ", " + this._LLShgCellY + "\n\trows: " + this._numShgCellsY + "\n\tcolums: " + this._numShgCellsX;
        return valStr;
    }

    int getFlatSize() {
        return 48;
    }

    int[] flatten() {
        int[] flat_site = new int[2];
        Heclib.StringHol((String)this._site, (int)this._site.length(), (int[])flat_site);
        int[] tempholder = new int[12];
        boolean pos = false;
        tempholder[0] = flat_site[0];
        tempholder[1] = flat_site[1];
        tempholder[2] = Float.floatToIntBits(this._HrapCellSize);
        tempholder[3] = this._LLHrapCellX;
        tempholder[4] = this._LLHrapCellY;
        tempholder[5] = this._numHrapCellsX;
        tempholder[6] = this._numHrapCellsY;
        tempholder[7] = Float.floatToIntBits(this._ShgCellSize);
        tempholder[8] = this._LLShgCellX;
        tempholder[9] = this._LLShgCellY;
        tempholder[10] = this._numShgCellsX;
        tempholder[11] = this._numShgCellsY;
        return tempholder;
    }

    public boolean unflatten(int[] flatInfo) {
        if (flatInfo == null) {
            System.out.println("HrapConvertInfo.unflatten: null flat info");
            return false;
        }
        if (flatInfo.length != 12) {
            System.out.println("HrapConvertInfo.unflatten: invalid array size " + flatInfo.length);
            return false;
        }
        int[] flat_site = new int[]{flatInfo[0], flatInfo[1]};
        this._site = Heclib.holString((int[])flat_site, (int)7);
        this._site = new StringBuffer(this._site).reverse().toString();
        this._HrapCellSize = Float.intBitsToFloat(flatInfo[2]);
        this._LLHrapCellX = flatInfo[3];
        this._LLHrapCellY = flatInfo[4];
        this._numHrapCellsX = flatInfo[5];
        this._numHrapCellsY = flatInfo[6];
        this._ShgCellSize = Float.intBitsToFloat(flatInfo[7]);
        this._LLShgCellX = flatInfo[8];
        this._LLShgCellY = flatInfo[9];
        this._numShgCellsX = flatInfo[10];
        this._numShgCellsY = flatInfo[11];
        return true;
    }

    public final int ShgCellSize() {
        return (int)this._ShgCellSize;
    }

    public final int getLLShgCellX() {
        return this._LLShgCellX;
    }

    public final int getLLShgCellY() {
        return this._LLShgCellY;
    }

    public final int getNumShgCellsX() {
        return this._numShgCellsX;
    }

    public final int getNumShgCellsY() {
        return this._numShgCellsY;
    }
}

