/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.rmi.heclib.grid;

import hec.heclib.dss.HecDataManager;
import hec.heclib.grid.AlbersInfo;
import hec.heclib.grid.GridData;
import hec.heclib.grid.GridInfo;
import hec.heclib.grid.HrapInfo;
import hec.heclib.util.Heclib;
import hec.heclib.util.intContainer;
import hec.heclib.util.stringContainer;
import java.io.File;
import java.rmi.RemoteException;
import mil.army.usace.hec.rmi.csinterface.RmiProgress;
import mil.army.usace.hec.rmi.heclib.grid.HrapConvertInfo;
import rma.util.RMAIO;

public class HrapConvertTable
extends HecDataManager {
    HrapConvertInfo _convertInfo;
    short[] _data;
    static int _mathDebug = 0;
    static boolean _noTableCache = false;
    RmiProgress _ui = null;

    public HrapConvertTable() {
        this._convertInfo = new HrapConvertInfo();
        this._data = null;
    }

    public HrapConvertTable(HrapConvertTable a) {
        this._convertInfo = new HrapConvertInfo(a._convertInfo);
        this._data = new short[a._data.length];
        for (int i = 0; i < a._data.length; ++i) {
            this._data[i] = a._data[i];
        }
        this.setDSSFileName(a.DSSFileName());
        this._dssPathname = a._dssPathname;
    }

    public HrapConvertTable(RmiProgress ui) {
        this();
        this._ui = ui;
    }

    public void setSiteName(String site) {
        this._convertInfo._site = site.substring(0, 7);
        if (site.length() > 7) {
            System.out.println("Site name " + site + " longer than 7 characters.\nSite name abbreviated to " + this._convertInfo._site + " for storage.");
        }
    }

    int unCompressTableRow(int oneEnd, int twoEnd, short[] data) {
        data[2] = (short)(0x3FF & oneEnd);
        data[1] = (short)(0x7FF & oneEnd >> 10);
        data[0] = (short)(0x7FF & oneEnd >> 21);
        data[5] = (short)(0x3FF & twoEnd);
        data[4] = (short)(0x3FF & twoEnd >> 10);
        data[3] = (short)(0x3FF & twoEnd >> 20);
        return 0;
    }

    public int retrieveConvertTable() {
        int temp;
        int[] numDataCompressed = new int[1];
        int[] recordType = new int[1];
        int[] exist = new int[1];
        stringContainer charRecordType = new stringContainer();
        String path = this.pathname();
        int pathLength = path.length();
        intContainer lockThreadToken = new intContainer();
        int[] dssTable = this._fileData.requestAccess(lockThreadToken);
        if (dssTable == null) {
            System.out.println("Unable to access DSS file: " + this.DSSFileName());
            return -1;
        }
        Heclib.zdtype((int[])dssTable, (String)path, (int[])numDataCompressed, (int[])exist, (stringContainer)charRecordType, (int[])recordType);
        this._fileData.releaseAccess(lockThreadToken);
        if (exist[0] == -1 && numDataCompressed[0] == 0) {
            System.out.println("Unable to read DSS record " + path + " from " + this.DSSFileName());
            return -1;
        }
        System.out.println("Need to read " + numDataCompressed[0] + " values");
        numDataCompressed[0] = numDataCompressed[0] * 2;
        short[] dataCompressedShort = new short[numDataCompressed[0]];
        int[] nDataCompressed = new int[]{numDataCompressed[0]};
        int[] dummy = new int[1];
        int[] found = new int[1];
        int[] idummy = new int[1];
        int zero = 0;
        int[] convertInfoSize = new int[]{this._convertInfo.getFlatSize()};
        if (convertInfoSize[0] % 4 != 0) {
            this.printErrorMessage("Error in HrapConvertTable.  Illegal info size.");
            return -1;
        }
        convertInfoSize[0] = convertInfoSize[0] / 4;
        int[] flatArray = new int[convertInfoSize[0]];
        System.out.println("\nreading " + path.toUpperCase() + " size=" + convertInfoSize[0] + " numDataCompressed=" + numDataCompressed[0]);
        dssTable = this._fileData.requestAccess(lockThreadToken);
        if (dssTable == null) {
            this.printErrorMessage("Unable to access DSS file: " + this.DSSFileName());
            return -1;
        }
        Heclib.zreadx((int[])dssTable, (String)path.toUpperCase(), (int[])flatArray, (int)convertInfoSize[0], (int[])convertInfoSize, (int[])dummy, (int)zero, (int[])idummy, (int[])dummy, (int)zero, (int[])idummy, (short[])dataCompressedShort, (int)numDataCompressed[0], (int[])nDataCompressed, (int)1, (int[])found);
        this._fileData.releaseAccess(lockThreadToken);
        System.out.println("\nread in " + nDataCompressed[0] + " values");
        if (found[0] == 0) {
            this.printErrorMessage("Unable to read DSS record " + path + " from " + this.DSSFileName());
            return -1;
        }
        this._convertInfo.unflatten(flatArray);
        if (RMAIO.getOSType() != 2) {
            for (int k = 0; k < numDataCompressed[0]; k += 2) {
                temp = dataCompressedShort[k];
                dataCompressedShort[k] = dataCompressedShort[k + 1];
                dataCompressedShort[k + 1] = temp;
            }
        }
        this._convertInfo.show();
        int numCells = this._convertInfo._numShgCellsX * this._convertInfo._numShgCellsY;
        if (numDataCompressed[0] != 4 * numCells) {
            this.printWarningMessage("Inconsistent number of cells and table data in DSS record\n\t" + path + "\n\tin file " + this.DSSFileName() + ".");
        }
        this._data = new short[numCells * 6];
        int[] dataCompressed = new int[numDataCompressed[0] / 2];
        for (int j = 0; j < numDataCompressed[0]; j += 2) {
            temp = dataCompressedShort[j];
            if (temp < 0) {
                temp = temp & Short.MAX_VALUE | 0x8000;
            }
            temp <<= 16;
            int temp2 = dataCompressedShort[j + 1];
            if (temp2 < 0) {
                temp2 = temp2 & Short.MAX_VALUE | 0x8000;
            }
            dataCompressed[j / 2] = temp |= temp2;
        }
        short[] tmpData = new short[6];
        for (int i = 0; i < numCells; ++i) {
            this.unCompressTableRow(dataCompressed[2 * i], dataCompressed[2 * i + 1], tmpData);
            this._data[6 * i] = tmpData[0];
            this._data[6 * i + 1] = tmpData[1];
            this._data[6 * i + 2] = tmpData[2];
            this._data[6 * i + 3] = tmpData[3];
            this._data[6 * i + 4] = tmpData[4];
            this._data[6 * i + 5] = tmpData[5];
        }
        return 0;
    }

    boolean sameCellCoverage(HrapInfo a) {
        boolean sameCoverage = true;
        if (a.getLowerLeftCellX() != this._convertInfo._LLHrapCellX) {
            sameCoverage = false;
        }
        if (a.getLowerLeftCellY() != this._convertInfo._LLHrapCellY) {
            sameCoverage = false;
        }
        if (a.getNumberOfCellsX() != this._convertInfo._numHrapCellsX) {
            sameCoverage = false;
        }
        if (a.getNumberOfCellsY() != this._convertInfo._numHrapCellsY) {
            sameCoverage = false;
        }
        if (a.getCellSize() != this._convertInfo._HrapCellSize) {
            sameCoverage = false;
        }
        if (!sameCoverage) {
            this.printWarningMessage("Not same cell converage: expecting:");
            this.printWarningMessage("LowerLeftX=" + a.getLowerLeftCellX() + " LowerLeftY=" + a.getLowerLeftCellY() + " NumX=" + a.getNumberOfCellsX() + " NumY=" + a.getNumberOfCellsY() + " cellsize=" + a.getCellSize());
            this.printWarningMessage("Got:");
            this.printWarningMessage("LowerLeftX=" + this._convertInfo._LLHrapCellX + " LowerLeftY=" + this._convertInfo._LLHrapCellY + " NumX=" + this._convertInfo._numHrapCellsX + " NumY=" + this._convertInfo._numHrapCellsY + " cellsize=" + this._convertInfo._HrapCellSize);
        }
        return sameCoverage;
    }

    public void setHrapCellSize(float n) {
        this._convertInfo._HrapCellSize = n;
    }

    public void setHrapOrigin(int i, int j) {
        this._convertInfo._LLHrapCellX = i;
        this._convertInfo._LLHrapCellY = j;
    }

    public void setShgOrigin(int i, int j) {
        this._convertInfo._LLShgCellX = i;
        this._convertInfo._LLShgCellY = j;
    }

    public void setHrapGridSize(int i, int j) {
        this._convertInfo._numHrapCellsX = i;
        this._convertInfo._numHrapCellsY = j;
    }

    public void setShgGridSize(int i, int j) {
        this._convertInfo._numShgCellsX = i;
        this._convertInfo._numShgCellsY = j;
    }

    public void setShgCellSize(float n) {
        this._convertInfo._ShgCellSize = n;
    }

    public void setConvertData(short[] datV) {
        this._data = datV;
    }

    public int getShgCellCount() {
        return this._convertInfo._numShgCellsX * this._convertInfo._numShgCellsY;
    }

    public int getShgOriginX() {
        return this._convertInfo._LLShgCellX;
    }

    int getShgOriginY() {
        return this._convertInfo._LLShgCellY;
    }

    int getNumShgCols() {
        return this._convertInfo._numShgCellsX;
    }

    int getNumShgRows() {
        return this._convertInfo._numShgCellsY;
    }

    public short[] getConvertData() {
        return this._data;
    }

    public HrapConvertInfo getInfo() {
        return this._convertInfo;
    }

    public int convertHrapToShg(HrapInfo hrapInfo, GridData hrapData, AlbersInfo shgInfo, GridData shgData, String site) {
        int SHGj;
        float weightedAverage = 0.0f;
        int sumArea = 0;
        if (hrapInfo == null) {
            this.printErrorMessage("No HRAP description available");
            return 1;
        }
        if (hrapData == null) {
            this.printErrorMessage("No HRAP data available");
            return 1;
        }
        if (this._data == null || !this.bPart().equals(site) || !this.sameCellCoverage(hrapInfo) || _noTableCache) {
            String tablePathName = System.getProperty("HECSUP");
            Object tableFileName = tablePathName == null ? "/usr/hec/sup" : tablePathName;
            tableFileName = (String)tableFileName + "/hraptab.dss";
            File convfile = new File((String)tableFileName);
            if (!convfile.canRead() && !(convfile = new File((String)(tableFileName = "hraptab.dss"))).canRead()) {
                this.printErrorMessage("Cannot open HRAP to SHG conversion table file.\nExpecting to find file: $HECSUP/hraptab.dss\n                        /usr/hec/sup/hraptab.dss\n                     or ./hraptab.dss");
                return -1;
            }
        }
        int shgCellCount = this.getShgCellCount();
        short[] tableVector = this.getConvertData();
        if (!this.sameCellCoverage(hrapInfo)) {
            this.printErrorMessage("HRAP Grid description inconsistent.  Not the same cell converage.");
            return 1;
        }
        String gridStartTime = hrapInfo.getStartTime();
        String gridEndTime = hrapInfo.getEndTime();
        int hrapOriginI = hrapInfo.getLowerLeftCellX();
        int hrapOriginJ = hrapInfo.getLowerLeftCellY();
        int hrapRows = hrapInfo.getNumberOfCellsY();
        int hrapCols = hrapInfo.getNumberOfCellsX();
        int shgOriginI = this.getShgOriginX();
        int shgOriginJ = this.getShgOriginY();
        int shgCols = this.getNumShgCols();
        int shgRows = this.getNumShgRows();
        float[] hrapDataVector = hrapData.getData();
        float[] shgDataVector = new float[shgRows * shgCols];
        shgCellCount = 0;
        int calcCnt = 0;
        for (SHGj = 0; SHGj < shgRows; ++SHGj) {
            for (int SHGi = 0; SHGi < shgCols; ++SHGi) {
                int j;
                int i;
                if (tableVector[shgCellCount * 6] == 0) {
                    shgDataVector[shgCellCount] = -3.4028235E38f;
                    ++shgCellCount;
                    continue;
                }
                weightedAverage = 0.0f;
                sumArea = 0;
                for (i = 2; i < 6; ++i) {
                    sumArea += tableVector[shgCellCount * 6 + i];
                }
                boolean noHrapDataValue = false;
                int HRAPi = tableVector[shgCellCount * 6] - hrapOriginI;
                int HRAPj = tableVector[shgCellCount * 6 + 1] - hrapOriginJ;
                if (HRAPj >= hrapRows || HRAPi >= hrapCols || HRAPj < 0 || HRAPi < 0) {
                    this.printWarningMessage("Bad HRAP Position");
                    this.printWarningMessage("hrap row =" + HRAPj + " hrap col=" + HRAPi);
                    if (_mathDebug > 0) {
                        System.out.println("conversionTable=" + tableVector[shgCellCount * 6 + 1] + ", " + tableVector[shgCellCount * 6]);
                        System.out.println(10 + shgCellCount + ": " + SHGi + ", " + SHGj + "(" + (shgOriginI + SHGi) + ", " + (shgOriginJ + SHGj) + ") ");
                    }
                    noHrapDataValue = true;
                }
                int tableCol = 2;
                if (!noHrapDataValue) {
                    for (j = 0; j < 2; ++j) {
                        for (i = 0; i < 2; ++i) {
                            if (tableVector[shgCellCount * 6 + tableCol] != 0) {
                                try {
                                    if (HRAPj + j >= hrapRows || HRAPi + i >= hrapCols || HRAPj + j < 0 || HRAPi + i < 0) {
                                        this.printWarningMessage("Bad HRAP Location");
                                        this.printWarningMessage("hrap row =" + (HRAPj + j) + " hrap col=" + (HRAPi + i));
                                        if (_mathDebug > 0) {
                                            System.out.println("conversionTable=" + tableVector[shgCellCount * 6 + 1] + ", " + tableVector[shgCellCount * 6]);
                                            System.out.println(10 + shgCellCount + ": " + SHGi + ", " + SHGj + "(" + (shgOriginI + SHGi) + ", " + (shgOriginJ + SHGj) + ") ");
                                        }
                                        noHrapDataValue = true;
                                    } else if (hrapDataVector[(HRAPj + j) * hrapCols + HRAPi + i] == -3.4028235E38f) {
                                        noHrapDataValue = true;
                                    } else {
                                        weightedAverage += (float)tableVector[shgCellCount * 6 + tableCol] * hrapDataVector[(HRAPj + j) * hrapCols + HRAPi + i];
                                    }
                                }
                                catch (Exception e) {
                                    this.printErrorMessage("hrap row =" + (HRAPj + j) + " hrap col=" + (HRAPi + i));
                                    this.printErrorMessage("conversionTable=" + tableVector[shgCellCount * 6 + 1] + ", " + tableVector[shgCellCount * 6]);
                                    this.printErrorMessage(10 + shgCellCount + ": " + SHGi + ", " + SHGj + "(" + (shgOriginI + SHGi) + ", " + (shgOriginJ + SHGj) + ") ");
                                    this.printErrorMessage("Exception " + e);
                                }
                            }
                            ++tableCol;
                        }
                    }
                    weightedAverage /= (float)sumArea;
                } else {
                    weightedAverage = 99.99f;
                }
                if (_mathDebug > 0 && calcCnt < 100) {
                    System.out.println(10 + shgCellCount + ": " + SHGi + ", " + SHGj + "(" + (shgOriginI + SHGi) + ", " + (shgOriginJ + SHGj) + "): ");
                    for (j = 0; j < 5; ++j) {
                        System.out.println(tableVector[shgCellCount * 6 + j] + ", ");
                    }
                    System.out.println(tableVector[shgCellCount * 6 + 5]);
                    System.out.println("Sum of overlapping areas: " + sumArea + "\nWeighted average value = " + weightedAverage);
                }
                shgDataVector[shgCellCount] = noHrapDataValue && weightedAverage != 99.99f ? -3.4028235E38f : weightedAverage;
                ++shgCellCount;
                ++calcCnt;
            }
        }
        System.out.println("processed " + shgCellCount + " cells shgRow=" + SHGj);
        shgInfo.setGridTimes(gridStartTime, gridEndTime);
        shgInfo.setParameterInfo(hrapInfo.getDataUnits(), hrapInfo.getDataType());
        shgInfo.setProjectionInfo(2, "METERS", 29.5f, 45.5f, -96.0f, 23.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        shgInfo.setCellInfo(shgOriginI, shgOriginJ, shgCols, shgRows, 2000.0f);
        shgInfo.setRangeInfo(hrapInfo.getRangeNum(), hrapInfo.getRangeLimitTable(), hrapInfo.getNumEqual());
        shgData.initGridData(shgDataVector, (GridInfo)shgInfo);
        return 0;
    }

    void printErrorMessage(String msg) {
        System.out.println("ERROR: " + msg);
        if (this._ui != null) {
            try {
                this._ui.printErrorMessage(msg);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    void printWarningMessage(String msg) {
        System.out.println("WARNING: " + msg);
        if (this._ui != null) {
            try {
                this._ui.printWarningMessage(msg);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    void printMessage(String msg) {
        System.out.println(msg);
        if (this._ui != null) {
            try {
                this._ui.printMessage(msg);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    static {
        _mathDebug = RMAIO.parseInt((String)System.getProperty("hec.gridMath.debug"), (int)0);
    }
}

