/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.rmi.io;

import hec.appInterface.FileOpener;
import hec.io.FileLock;
import hec.io.Identifier;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Vector;
import mil.army.usace.hec.rmi.csinterface.RmiFileManager;

public class FileManagerOpener
implements FileOpener,
Serializable {
    private static final long serialVersionUID = 2841817484931239336L;
    private RmiFileManager _fileManager;
    private String _user;

    public FileManagerOpener(RmiFileManager fm, String user) {
        this._fileManager = fm;
        this._user = user;
    }

    public Identifier openFile(Identifier fileToOpenId, boolean useCache) {
        Identifier id = null;
        try {
            id = this._fileManager.openFile(this._user, fileToOpenId);
        }
        catch (RemoteException e) {
            System.out.println("Error opening file: " + fileToOpenId.getPath() + " Error: " + e.getMessage());
        }
        return id;
    }

    public Identifier createFile(Identifier fileToCreateId) {
        Identifier id = null;
        try {
            id = this._fileManager.newFile(this._user, fileToCreateId);
        }
        catch (RemoteException e) {
            System.out.println("Error creating file: " + fileToCreateId.getPath() + " Error: " + e.getMessage());
        }
        return id;
    }

    public boolean lockFile(Identifier id, FileLock flock) {
        boolean tf = false;
        try {
            tf = this._fileManager.lockFile(id, flock);
        }
        catch (RemoteException re) {
            System.out.println("Error locking file: " + id.getPath() + " Error:" + re.getMessage());
        }
        return tf;
    }

    public boolean unlockFile(Identifier id, FileLock flock) {
        boolean tf = false;
        try {
            tf = this._fileManager.unlockFile(id, flock);
        }
        catch (RemoteException re) {
            System.out.println("Error unlocking file: " + id.getPath() + " Error: " + re.getMessage());
        }
        return tf;
    }

    public List getFileList(String path, String filter) {
        Vector<Identifier> fileList = null;
        try {
            fileList = this._fileManager.getRemoteFileIDList(this._user, path, filter);
        }
        catch (RemoteException re) {
            System.out.println("Error getting file list for " + path + " Error: " + re.getMessage());
        }
        return fileList;
    }

    public List getDriveList() {
        Vector<Identifier> driveList = null;
        try {
            driveList = this._fileManager.getRemoteDriveIDList(this._user);
        }
        catch (RemoteException re) {
            System.out.println("Error getting drive list. Error: " + re.getMessage());
        }
        return driveList;
    }

    public RmiFileManager getRmiFileManager() {
        return this._fileManager;
    }
}

