/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.rmi.io;

import hec.data.DataSetIllegalArgumentException;
import hec.data.Parameter;
import hec.data.Units;
import hec.heclib.util.HecTime;
import hec.io.AsciiDeserializer;
import hec.io.AsciiSerializableConstants;
import hec.io.DSSIdentifier;
import hec.io.Identifier;
import hec.io.PairedDataContainer;
import hec.io.TextFileReference;
import hec.io.TimeSeriesContainer;
import hec.lang.DeserializeObjectException;
import hec.lang.UserId;
import hec.model.PairedValues;
import hec.model.PairedValuesExt;
import hec.model.SeasonalRecord;
import java.io.BufferedReader;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.Map;
import mil.army.usace.hec.rmi.csinterface.BaseDSSManager;
import mil.army.usace.hec.rmi.csinterface.RmiFileManager;
import rma.util.RMAIO;
import rma.util.logging.MarkingClassLogger;
import rma.util.logging.marking.AsciiDeserializerLoggingMarker;

public class HecAsciiDeserializer
extends AsciiDeserializer
implements AsciiSerializableConstants {
    private static final MarkingClassLogger ASCII_DESERIALIZER_LOGGER = MarkingClassLogger.forMarkingClass(AsciiDeserializerLoggingMarker.class);
    private BaseDSSManager _dssManager = null;
    private String _workspacePath = null;
    private RmiFileManager _fileManager = null;

    public HecAsciiDeserializer(BufferedReader in) {
        super(in);
    }

    public void setWorkspacePath(String path) {
        this._workspacePath = path;
    }

    public void setDssFileManager(BaseDSSManager dssManager) {
        this._dssManager = dssManager;
    }

    public void setFileManager(RmiFileManager fileManager) {
        this._fileManager = fileManager;
    }

    protected PairedValuesExt readPairedValuesExtFromDss() {
        this._curParam = RMAIO.getParam((String)this._curLine, (String)"=");
        boolean firstArray = true;
        if (this._curParam.equals("null")) {
            return null;
        }
        try {
            this._in.mark(500);
            String line = this._in.readLine();
            if (line == null || !RMAIO.getType((String)line, (String)"=").trim().equals("DSSPATH")) {
                this._in.reset();
                return null;
            }
            this._curLine = line;
            this._curParam = RMAIO.getParam((String)this._curLine, (String)"=");
            String dssPath = RMAIO.getParam((String)this._curLine, (String)"=");
            this._curLine = this._in.readLine();
            PairedValuesExt pv = new PairedValuesExt();
            if (this._workspacePath == null) {
                ((MarkingClassLogger.Api)ASCII_DESERIALIZER_LOGGER.atInfo()).log("----------------------------------------------------------------------------");
                ((MarkingClassLogger.Api)ASCII_DESERIALIZER_LOGGER.atInfo()).log("Error <readPairedValuesExtFromDSS()> : Null Workspace Path, Returning  ");
                ((MarkingClassLogger.Api)ASCII_DESERIALIZER_LOGGER.atInfo()).log("empty PairedValuesExt object");
                ((MarkingClassLogger.Api)ASCII_DESERIALIZER_LOGGER.atInfo()).log("Can't get here unless Paired Values Ext was written to DSS. Serious Problem");
                ((MarkingClassLogger.Api)ASCII_DESERIALIZER_LOGGER.atInfo()).log("----------------------------------------------------------------------------");
                return pv;
            }
            if (this._dssManager == null) {
                ((MarkingClassLogger.Api)ASCII_DESERIALIZER_LOGGER.atInfo()).log("----------------------------------------------------------------------------");
                ((MarkingClassLogger.Api)ASCII_DESERIALIZER_LOGGER.atInfo()).log("Error <readPairedValuesExtFromDSS()> : Null DSS Manager Path, Returning");
                ((MarkingClassLogger.Api)ASCII_DESERIALIZER_LOGGER.atInfo()).log("empty PairedValuesExt object");
                ((MarkingClassLogger.Api)ASCII_DESERIALIZER_LOGGER.atInfo()).log("Can't get here unless Paired Values Ext was written to DSS. Serious Problem");
                ((MarkingClassLogger.Api)ASCII_DESERIALIZER_LOGGER.atInfo()).log("----------------------------------------------------------------------------");
                return pv;
            }
            String dssFilePath = this._workspacePath + "/" + RMAIO.getParam((String)this._curLine, (String)"=");
            PairedDataContainer pdc = this._dssManager.readPairedDataContainer(new DSSIdentifier(dssFilePath, dssPath));
            for (int z = 0; z < pdc.numberOrdinates; ++z) {
                double[] yords = new double[pdc.yOrdinates.length];
                for (int y = 0; y < pdc.yOrdinates.length; ++y) {
                    yords[y] = pdc.yOrdinates[y][z];
                }
                pv.addPair(pdc.xOrdinates[z], yords);
            }
            try {
                pv.setParamXId(new Parameter(pdc.xparameter).getParameterId());
            }
            catch (DataSetIllegalArgumentException e) {
                pv.setParamXId(-1);
                ((MarkingClassLogger.Api)((MarkingClassLogger.Api)ASCII_DESERIALIZER_LOGGER.atFine()).withCause((Throwable)e)).log();
            }
            try {
                pv.setParamYId(new Parameter(pdc.yparameter).getParameterId());
            }
            catch (DataSetIllegalArgumentException e) {
                pv.setParamYId(-1);
                ((MarkingClassLogger.Api)((MarkingClassLogger.Api)ASCII_DESERIALIZER_LOGGER.atFine()).withCause((Throwable)e)).log();
            }
            if (pv.getParamYId() == -1 && pv.getParamXId() == -1) {
                ((MarkingClassLogger.Api)ASCII_DESERIALIZER_LOGGER.atFine()).log("Undefined units in - %s \nfrom file - %s", (Object)dssPath, (Object)dssFilePath);
            }
            try {
                pv.setUnitSystem(Units.getUnitSystemForUnits((String)pdc.yunits));
            }
            catch (IllegalArgumentException e3) {
                try {
                    pv.setUnitSystem(Units.getUnitSystemForUnits((String)pdc.xunits));
                }
                catch (IllegalArgumentException e5) {
                    ((MarkingClassLogger.Api)((MarkingClassLogger.Api)ASCII_DESERIALIZER_LOGGER.atFine()).withCause((Throwable)e5)).log("Undefined units in - %s \nfrom file - %s", (Object)dssPath, (Object)dssFilePath);
                }
            }
            if (pdc.labelsUsed && pdc.labels != null) {
                pv.setCurveLabels(pdc.labels);
            }
            this._curLine = this._in.readLine();
            while (this._curLine != null) {
                this._curLine = this._curLine.trim();
                if (this._curLine.length() == 0) {
                    this._curLine = this._in.readLine();
                    continue;
                }
                this._curType = RMAIO.getType((String)this._curLine, (String)"=");
                if (this._curType.equals("ID")) {
                    Integer objId = this.readInteger();
                    if (objId != null) {
                        this.putObjectInTable(objId, pv);
                    }
                } else if (this._curType.equals("}")) {
                    return pv;
                }
                this._curLine = this._in.readLine();
            }
        }
        catch (IOException e) {
            ((MarkingClassLogger.Api)ASCII_DESERIALIZER_LOGGER.atWarning()).log("Error reading file in AsciiDeserializer. " + e.toString());
            ((MarkingClassLogger.Api)ASCII_DESERIALIZER_LOGGER.atInfo()).log("Line: " + this._curLine);
            throw new DeserializeObjectException("Error reading file in AsciiDeserializer. Error " + e.toString());
        }
        return new PairedValuesExt();
    }

    protected SeasonalRecord readSeasonalRecordFromDss() {
        this._curParam = RMAIO.getParam((String)this._curLine, (String)"=");
        if ("null".equals(this._curParam)) {
            return null;
        }
        try {
            String dssPath = RMAIO.getParam((String)this._curLine, (String)"=");
            this._curLine = this._in.readLine();
            String dssFilePath = this._workspacePath + "/" + RMAIO.getParam((String)this._curLine, (String)"=");
            this._curLine = this._in.readLine();
            SeasonalRecord sr = new SeasonalRecord();
            if (this._workspacePath == null) {
                ((MarkingClassLogger.Api)ASCII_DESERIALIZER_LOGGER.atInfo()).log("----------------------------------------------------------------------------");
                ((MarkingClassLogger.Api)ASCII_DESERIALIZER_LOGGER.atInfo()).log("Error <readSeasonalRecordFromDSS()> : Null Workspace Path, Returning  ");
                ((MarkingClassLogger.Api)ASCII_DESERIALIZER_LOGGER.atInfo()).log("empty SeasonalRecord object");
                ((MarkingClassLogger.Api)ASCII_DESERIALIZER_LOGGER.atInfo()).log("Can't get here unless SeasonalRecord was written to DSS. Serious Problem");
                ((MarkingClassLogger.Api)ASCII_DESERIALIZER_LOGGER.atInfo()).log("----------------------------------------------------------------------------");
                return sr;
            }
            if (this._dssManager == null) {
                ((MarkingClassLogger.Api)ASCII_DESERIALIZER_LOGGER.atInfo()).log("----------------------------------------------------------------------------");
                ((MarkingClassLogger.Api)ASCII_DESERIALIZER_LOGGER.atInfo()).log("Error <readSeasonalRecordFromDSS()> : Null DSS Manager Path, Returning");
                ((MarkingClassLogger.Api)ASCII_DESERIALIZER_LOGGER.atInfo()).log("empty SeasonRecord object");
                ((MarkingClassLogger.Api)ASCII_DESERIALIZER_LOGGER.atInfo()).log("Can't get here unless SeasonalRecord was written to DSS. Serious Problem");
                ((MarkingClassLogger.Api)ASCII_DESERIALIZER_LOGGER.atInfo()).log("----------------------------------------------------------------------------");
                return sr;
            }
            DSSIdentifier dssId = new DSSIdentifier(dssFilePath, dssPath);
            HecTime end = new HecTime();
            HecTime start = new HecTime();
            while ((this._curLine = this._in.readLine()) != null) {
                this._curLine = this._curLine.trim();
                if (this._curLine.length() == 0) {
                    this._curLine = this._in.readLine();
                    continue;
                }
                this._curType = RMAIO.getType((String)this._curLine, (String)"=");
                if (this._curType.equals("ID")) {
                    Integer objId = this.readInteger();
                    if (objId == null) continue;
                    this.putObjectInTable(objId, sr);
                    continue;
                }
                if (this._curType.equals("interpType")) {
                    this._curParam = RMAIO.getParam((String)this._curLine, (String)"=");
                    sr.setInterpolationType(RMAIO.parseInt((String)this._curParam, (int)0));
                    continue;
                }
                if (this._curType.equals("start")) {
                    this._curParam = RMAIO.getParam((String)this._curLine, (String)"=");
                    start.set(RMAIO.parseInt((String)this._curParam, (int)0));
                    continue;
                }
                if (this._curType.equals("end")) {
                    this._curParam = RMAIO.getParam((String)this._curLine, (String)"=");
                    end.set(RMAIO.parseInt((String)this._curParam, (int)0));
                    continue;
                }
                if (this._curType.equals("param")) {
                    this._curParam = RMAIO.getParam((String)this._curLine, (String)"=");
                    sr.setParameterId(RMAIO.parseInt((String)this._curParam, (int)0));
                    continue;
                }
                if (this._curType.equals("units")) {
                    this._curParam = RMAIO.getParam((String)this._curLine, (String)"=");
                    sr.setUnitSystem(RMAIO.parseInt((String)this._curParam, (int)1));
                    continue;
                }
                if (!this._curType.equals("}")) continue;
            }
            dssId.setTimeWindow(start, end);
            TimeSeriesContainer tsc = null;
            try {
                tsc = this._dssManager.readTS(dssId, false, false);
            }
            catch (Exception e) {
                ((MarkingClassLogger.Api)ASCII_DESERIALIZER_LOGGER.atWarning()).log("Error reading TimeSeries " + dssId + " Error:" + e);
            }
            if (tsc != null) {
                sr.setArrays(tsc.times, tsc.values);
                try {
                    sr.setParameterId(new Parameter(tsc.type).getParameterId());
                }
                catch (DataSetIllegalArgumentException e) {
                    sr.setParameterId(-1);
                    System.out.println("readSeasonalRecordFromDss:" + e + "\n");
                }
                try {
                    sr.setUnitSystem(Units.getUnitSystemForUnits((String)tsc.units));
                }
                catch (IllegalArgumentException e3) {
                    ((MarkingClassLogger.Api)ASCII_DESERIALIZER_LOGGER.atWarning()).log("Undefined units in - " + dssPath + " \nfrom file - " + dssFilePath);
                }
            }
            return sr;
        }
        catch (IOException e) {
            ((MarkingClassLogger.Api)ASCII_DESERIALIZER_LOGGER.atWarning()).log("Error reading file in AsciiDeserializer. " + e.toString());
            ((MarkingClassLogger.Api)ASCII_DESERIALIZER_LOGGER.atInfo()).log("Line: " + this._curLine);
            throw new DeserializeObjectException("Error reading file in AsciiDeserializer. Error " + e.toString());
        }
    }

    private PairedValues readPairedValuesFromDss() {
        try {
            PairedValues pv = new PairedValues();
            this._curParam = RMAIO.getParam((String)this._curLine, (String)"=");
            String dssPath = RMAIO.getParam((String)this._curLine, (String)"=");
            this._curLine = this._in.readLine();
            String dssFilePath = this._workspacePath + "/" + RMAIO.getParam((String)this._curLine, (String)"=");
            if (this._workspacePath == null) {
                ((MarkingClassLogger.Api)ASCII_DESERIALIZER_LOGGER.atInfo()).log("----------------------------------------------------------------------------");
                ((MarkingClassLogger.Api)ASCII_DESERIALIZER_LOGGER.atInfo()).log("Error <readPairedValuesExtFromDSS()> : Null Workspace Path, Returning ");
                ((MarkingClassLogger.Api)ASCII_DESERIALIZER_LOGGER.atInfo()).log("empty PairedValuesExt object");
                ((MarkingClassLogger.Api)ASCII_DESERIALIZER_LOGGER.atInfo()).log("Can't get here unless Paired Values Ext was written to DSS. Serious Problem");
                ((MarkingClassLogger.Api)ASCII_DESERIALIZER_LOGGER.atInfo()).log("----------------------------------------------------------------------------");
                return pv;
            }
            if (this._dssManager == null) {
                ((MarkingClassLogger.Api)ASCII_DESERIALIZER_LOGGER.atInfo()).log("----------------------------------------------------------------------------");
                ((MarkingClassLogger.Api)ASCII_DESERIALIZER_LOGGER.atInfo()).log("Error <readPairedValuesExtFromDSS()> : Null DSS Manager Path, Returning ");
                ((MarkingClassLogger.Api)ASCII_DESERIALIZER_LOGGER.atInfo()).log("empty PairedValuesExt object");
                ((MarkingClassLogger.Api)ASCII_DESERIALIZER_LOGGER.atInfo()).log("Can't get here unless Paired Values Ext was written to DSS. Serious Problem");
                ((MarkingClassLogger.Api)ASCII_DESERIALIZER_LOGGER.atInfo()).log("----------------------------------------------------------------------------");
                return pv;
            }
            PairedDataContainer pdc = this._dssManager.readPairedDataContainer(new DSSIdentifier(dssFilePath, dssPath));
            for (int z = 0; z < pdc.numberOrdinates; ++z) {
                pv.addPair(pdc.xOrdinates[z], pdc.yOrdinates[0][z]);
            }
            try {
                pv.setParamXId(new Parameter(pdc.xparameter).getParameterId());
            }
            catch (DataSetIllegalArgumentException e) {
                pv.setParamXId(-1);
                ((MarkingClassLogger.Api)((MarkingClassLogger.Api)ASCII_DESERIALIZER_LOGGER.atFine()).withCause((Throwable)e)).log();
            }
            try {
                pv.setParamYId(new Parameter(pdc.yparameter).getParameterId());
            }
            catch (DataSetIllegalArgumentException e) {
                pv.setParamYId(-1);
                ((MarkingClassLogger.Api)((MarkingClassLogger.Api)ASCII_DESERIALIZER_LOGGER.atFine()).withCause((Throwable)e)).log();
            }
            try {
                pv.setUnitSystem(Units.getUnitSystemForUnits((String)pdc.yunits));
            }
            catch (IllegalArgumentException e3) {
                try {
                    pv.setUnitSystem(Units.getUnitSystemForUnits((String)pdc.xunits));
                }
                catch (IllegalArgumentException e5) {
                    ((MarkingClassLogger.Api)((MarkingClassLogger.Api)ASCII_DESERIALIZER_LOGGER.atFine()).withCause((Throwable)e5)).log("Undefined units in - %s \nfrom file - %s", (Object)dssPath, (Object)dssFilePath);
                }
            }
            if (pdc.labelsUsed && pdc.labels != null) {
                pv.setCurveLabel(pdc.labels[0]);
            }
            pv.setDatum(pdc.datum);
            pv.setShift(pdc.shift);
            pv.setOffset(pdc.offset);
            this._curLine = this._in.readLine();
            while (this._curLine != null) {
                this._curLine = this._curLine.trim();
                if (this._curLine.length() == 0) {
                    this._curLine = this._in.readLine();
                    continue;
                }
                this._curType = RMAIO.getType((String)this._curLine, (String)"=");
                if (this._curType.equals("ID")) {
                    Integer objId = this.readInteger();
                    if (objId != null) {
                        this.putObjectInTable(objId, pv);
                    }
                } else if (this._curType.equals("}")) {
                    return pv;
                }
                this._curLine = this._in.readLine();
            }
        }
        catch (IOException e) {
            ((MarkingClassLogger.Api)ASCII_DESERIALIZER_LOGGER.atWarning()).log("Error reading file in AsciiDeserializer. " + e.toString());
            ((MarkingClassLogger.Api)ASCII_DESERIALIZER_LOGGER.atInfo()).log("Line: " + this._curLine);
            throw new DeserializeObjectException("Error reading file in AsciiDeserializer. Error " + e.toString());
        }
        return new PairedValues();
    }

    protected Object readOBJECT(Object oldobj) {
        Object obj;
        this._curParam = RMAIO.getParam((String)this._curLine, (String)"=");
        if (this._curParam.equals("null")) {
            obj = null;
        } else {
            Class<?> c;
            this._curParam = this.getNewClassMapping(this._curParam);
            if (this._curParam.equals("hec.model.PairedValues") && this._version >= 3) {
                return this.readPairedValues();
            }
            if (this._curParam.equals("hec.model.PairedValuesExt") && (obj = this.readPairedValuesExtFromDss()) != null) {
                return obj;
            }
            if (this._curParam.equals("hec.model.SeasonalRecord") && this._version >= 4) {
                return this.readSeasonalRecord();
            }
            if (this._curParam.equals("hec.io.TextFileReference") && this._version >= 5) {
                return this.readTextFileReference();
            }
            try {
                c = Class.forName(this._curParam);
            }
            catch (ClassNotFoundException e) {
                ((MarkingClassLogger.Api)ASCII_DESERIALIZER_LOGGER.atWarning()).log("Error finding class for object " + this._curParam + " Error " + e.toString());
                ((MarkingClassLogger.Api)ASCII_DESERIALIZER_LOGGER.atInfo()).log("Line: " + this._curLine);
                throw new DeserializeObjectException("Error finding class for object " + this._curParam + " Error " + e.toString());
            }
            catch (NoClassDefFoundError ne) {
                ((MarkingClassLogger.Api)ASCII_DESERIALIZER_LOGGER.atWarning()).log("Error finding class for object " + this._curParam + " Error " + ne.toString());
                ((MarkingClassLogger.Api)ASCII_DESERIALIZER_LOGGER.atInfo()).log("Line: " + this._curLine);
                throw new DeserializeObjectException("Error finding class for object " + this._curParam + " Error " + ne.toString());
            }
            catch (UnsatisfiedLinkError e) {
                ((MarkingClassLogger.Api)ASCII_DESERIALIZER_LOGGER.atWarning()).log("Error finding class for object " + this._curParam + " Error " + e.toString());
                ((MarkingClassLogger.Api)ASCII_DESERIALIZER_LOGGER.atWarning()).log("Line: " + this._curLine);
                throw new DeserializeObjectException("Error finding class for object " + this._curParam + " Error " + e.toString());
            }
            if (c.isArray()) {
                return this.readArrayOBJECT(oldobj);
            }
            if (oldobj != null && oldobj.getClass() == c) {
                obj = oldobj;
            } else {
                int idx = this._curParam.indexOf("$");
                if (idx > 0) {
                    try {
                        Class<?> oc = Class.forName(this._curParam.substring(0, idx));
                    }
                    catch (ClassNotFoundException e) {
                        ((MarkingClassLogger.Api)ASCII_DESERIALIZER_LOGGER.atWarning()).log("Error finding outer class for object " + this._curParam.substring(0, idx) + " Error " + e.toString());
                        ((MarkingClassLogger.Api)ASCII_DESERIALIZER_LOGGER.atInfo()).log("Line: " + this._curLine);
                        throw new DeserializeObjectException("Error finding class for object " + this._curParam + " Error " + e.toString());
                    }
                    catch (NoClassDefFoundError ce) {
                        ((MarkingClassLogger.Api)ASCII_DESERIALIZER_LOGGER.atWarning()).log("Error finding outer class for object " + this._curParam + " Error " + ce.toString());
                        ((MarkingClassLogger.Api)ASCII_DESERIALIZER_LOGGER.atInfo()).log("Line: " + this._curLine);
                        throw new DeserializeObjectException("Error finding class for object " + this._curParam + " Error " + ce.toString());
                    }
                    Object[] params = new Object[]{oldobj};
                    try {
                        obj = c.getDeclaredConstructors()[0].newInstance(params);
                    }
                    catch (IllegalAccessException | InstantiationException | UnsatisfiedLinkError e) {
                        ((MarkingClassLogger.Api)ASCII_DESERIALIZER_LOGGER.atWarning()).log("Error creating inner class object " + c.getName() + " Error " + e);
                        ((MarkingClassLogger.Api)ASCII_DESERIALIZER_LOGGER.atInfo()).log("Line: " + this._curLine);
                        throw new DeserializeObjectException("Error creating object " + c.getName() + " Error " + e);
                    }
                    catch (NoSuchMethodError e) {
                        ((MarkingClassLogger.Api)ASCII_DESERIALIZER_LOGGER.atWarning()).log("Error creating inner class object. (probably no default constructor) " + c.getName() + " Error " + e);
                        ((MarkingClassLogger.Api)ASCII_DESERIALIZER_LOGGER.atInfo()).log("Line: " + this._curLine);
                        throw new DeserializeObjectException("Error creating object. (probably no default constructor) " + c.getName() + " Error " + e);
                    }
                    catch (InvocationTargetException e) {
                        ((MarkingClassLogger.Api)ASCII_DESERIALIZER_LOGGER.atWarning()).log("Error creating inner class object " + c.getName() + " Error " + e.toString() + " " + e.getMessage());
                        ((MarkingClassLogger.Api)ASCII_DESERIALIZER_LOGGER.atInfo()).log("Line: " + this._curLine);
                        throw new DeserializeObjectException("Error creating object " + c.getName() + " Error " + e.toString() + " " + e.getMessage());
                    }
                }
                try {
                    obj = c.newInstance();
                }
                catch (IllegalAccessException | InstantiationException | UnsatisfiedLinkError e) {
                    ((MarkingClassLogger.Api)ASCII_DESERIALIZER_LOGGER.atWarning()).log("Error creating object " + c.getName() + " Error " + e);
                    ((MarkingClassLogger.Api)ASCII_DESERIALIZER_LOGGER.atInfo()).log("Line: " + this._curLine);
                    throw new DeserializeObjectException("Error creating object " + c.getName() + " Error " + e);
                }
                catch (NoSuchMethodError e) {
                    ((MarkingClassLogger.Api)ASCII_DESERIALIZER_LOGGER.atWarning()).log("Error creating object. (probably no default constructor) " + c.getName() + " Error " + e);
                    ((MarkingClassLogger.Api)ASCII_DESERIALIZER_LOGGER.atInfo()).log("Line: " + this._curLine);
                    throw new DeserializeObjectException("Error creating object. (probably no default constructor) " + c.getName() + " Error " + e);
                }
            }
        }
        try {
            this._curLine = this._in.readLine();
            while (this._curLine != null) {
                if (this._curLine.length() == 0) {
                    this._curLine = this._in.readLine();
                    continue;
                }
                this._curType = RMAIO.getType((String)this._curLine, (String)"=");
                if (_showTiming) {
                    System.out.print(".");
                }
                if (this._curType.equals("ID")) {
                    Integer id = this.readInteger();
                    if (id != null) {
                        this._objectTable.put(id, obj);
                    }
                } else if (this._curType.equals("FLD")) {
                    this.readObjectField(obj);
                } else if (this._curType.equals("{COLLECT")) {
                    if (obj instanceof Collection) {
                        this.readObjectCollection((Collection)obj);
                    } else {
                        ((MarkingClassLogger.Api)ASCII_DESERIALIZER_LOGGER.atWarning()).log("incorrect Collection data in AsciiDeserialize");
                        this.skipToNextEnd();
                    }
                } else if (this._curType.equals("{MAP")) {
                    if (obj instanceof Map) {
                        this.readObjectMap((Map)obj);
                    } else {
                        ((MarkingClassLogger.Api)ASCII_DESERIALIZER_LOGGER.atWarning()).log("incorrect Map data in AsciiDeserialize");
                        this.skipToNextEnd();
                    }
                } else {
                    if (this._curType.indexOf("}") == 0) {
                        return obj;
                    }
                    if (this._curType.indexOf("{") == 0) {
                        this.skipToNextEnd();
                    }
                }
                this._curLine = this._in.readLine();
            }
        }
        catch (IOException e) {
            ((MarkingClassLogger.Api)ASCII_DESERIALIZER_LOGGER.atWarning()).log("Error reading file in AsciiDeserializer. " + e.toString());
            ((MarkingClassLogger.Api)ASCII_DESERIALIZER_LOGGER.atInfo()).log("Line: " + this._curLine);
            throw new DeserializeObjectException("Error reading file in AsciiDeserializer. Error " + e.toString());
        }
        return obj;
    }

    protected SeasonalRecord readSeasonalRecord() {
        SeasonalRecord sr;
        this._curParam = RMAIO.getParam((String)this._curLine, (String)"=");
        if (this._curParam.equals("null")) {
            sr = null;
        } else {
            sr = new SeasonalRecord();
            try {
                while ((this._curLine = this._in.readLine()) != null) {
                    if (this._curLine.length() == 0) {
                        this._curLine = this._in.readLine();
                        continue;
                    }
                    this._curType = RMAIO.getType((String)this._curLine, (String)"=");
                    if (this._curType.equals("DSSPATH")) {
                        return this.readSeasonalRecordFromDss();
                    }
                    if (this._curType.equals("ID")) {
                        Integer id = this.readInteger();
                        if (id == null) continue;
                        this._objectTable.put(id, sr);
                        continue;
                    }
                    if (this._curType.equals("REF")) {
                        return (SeasonalRecord)this.readREFERENCE();
                    }
                    if (this._curType.equals("FLD")) {
                        this.readObjectField(sr);
                        continue;
                    }
                    if (this._curType.indexOf("}") == 0) {
                        return sr;
                    }
                    if (this._curType.indexOf("{") != 0) continue;
                    this.skipToNextEnd();
                }
            }
            catch (IOException e) {
                ((MarkingClassLogger.Api)ASCII_DESERIALIZER_LOGGER.atWarning()).log("Error reading file in AsciiDeserializer. " + e.toString());
                ((MarkingClassLogger.Api)ASCII_DESERIALIZER_LOGGER.atInfo()).log("Line: " + this._curLine);
                throw new DeserializeObjectException("Error reading file in AsciiDeserializer. Error " + e.toString());
            }
        }
        return sr;
    }

    protected PairedValues readPairedValues() {
        PairedValues pv;
        this._curParam = RMAIO.getParam((String)this._curLine, (String)"=");
        double[] xValues = null;
        double[] yValues = null;
        boolean firstArray = true;
        if (this._curParam.equals("null")) {
            pv = null;
        } else {
            pv = new PairedValues();
            try {
                this._curLine = this._in.readLine();
                while (this._curLine != null) {
                    if (this._curLine.length() == 0) {
                        this._curLine = this._in.readLine();
                        continue;
                    }
                    this._curType = RMAIO.getType((String)this._curLine, (String)"=");
                    if (this._curType.equals("DSSPATH")) {
                        return this.readPairedValuesFromDss();
                    }
                    if (this._curType.equals("ID")) {
                        Integer id = this.readInteger();
                        if (id != null) {
                            this._objectTable.put(id, pv);
                        }
                    } else if (this._curType.equals("{[")) {
                        this._curParam = RMAIO.getParam((String)this._curLine, (String)"=");
                        int len = RMAIO.parseInt((String)this._curParam);
                        if (len == Integer.MIN_VALUE) continue;
                        if (firstArray) {
                            xValues = new double[len];
                            this.readArrayElements(xValues);
                            firstArray = false;
                        } else {
                            yValues = new double[len];
                            this.readArrayElements(yValues);
                            for (int i = 0; i < len; ++i) {
                                pv.addPair(xValues[i], yValues[i]);
                            }
                        }
                    } else if (this._curType.equals("FLD")) {
                        this.readObjectField(pv);
                    } else {
                        if (this._curType.indexOf("}") == 0) {
                            return pv;
                        }
                        if (this._curType.indexOf("{") == 0) {
                            this.skipToNextEnd();
                        }
                    }
                    this._curLine = this._in.readLine();
                }
            }
            catch (IOException e) {
                ((MarkingClassLogger.Api)ASCII_DESERIALIZER_LOGGER.atWarning()).log("Error reading file in AsciiDeserializer. " + e.toString());
                ((MarkingClassLogger.Api)ASCII_DESERIALIZER_LOGGER.atInfo()).log("Line: " + this._curLine);
                throw new DeserializeObjectException("Error reading file in AsciiDeserializer. Error " + e.toString());
            }
        }
        return pv;
    }

    protected TextFileReference readTextFileReference() {
        TextFileReference retval;
        this._curParam = RMAIO.getParam((String)this._curLine, (String)"=");
        if (this._curParam.equals("null")) {
            retval = null;
        } else {
            retval = new TextFileReference();
            try {
                this._curLine = this._in.readLine();
                while (this._curLine != null) {
                    if (this._curLine.length() == 0) {
                        this._curLine = this._in.readLine();
                        continue;
                    }
                    this._curType = RMAIO.getType((String)this._curLine, (String)"=");
                    if (this._curType.equals("FILEPATH")) {
                        this._curParam = RMAIO.getParam((String)this._curLine, (String)"=");
                        String filepath = RMAIO.getParam((String)this._curLine, (String)"=");
                        retval.setFilename(filepath);
                        if (this._workspacePath == null) {
                            ((MarkingClassLogger.Api)ASCII_DESERIALIZER_LOGGER.atInfo()).log("----------------------------------------------------------------------------");
                            ((MarkingClassLogger.Api)ASCII_DESERIALIZER_LOGGER.atInfo()).log("Error <readTextFileReference()> : Null Workspace Path, Returning ");
                            ((MarkingClassLogger.Api)ASCII_DESERIALIZER_LOGGER.atInfo()).log("empty TextFileReference object");
                            ((MarkingClassLogger.Api)ASCII_DESERIALIZER_LOGGER.atInfo()).log("Can't get here unless TextFileReference was written to File. Serious Problem");
                            ((MarkingClassLogger.Api)ASCII_DESERIALIZER_LOGGER.atInfo()).log("----------------------------------------------------------------------------");
                            return retval;
                        }
                        if (this._fileManager == null) {
                            ((MarkingClassLogger.Api)ASCII_DESERIALIZER_LOGGER.atInfo()).log("----------------------------------------------------------------------------");
                            ((MarkingClassLogger.Api)ASCII_DESERIALIZER_LOGGER.atInfo()).log("Error <readTextFileReference()> : Null FileManager, Returning ");
                            ((MarkingClassLogger.Api)ASCII_DESERIALIZER_LOGGER.atInfo()).log("empty TextFileReference object");
                            ((MarkingClassLogger.Api)ASCII_DESERIALIZER_LOGGER.atInfo()).log("Can't get here unless TextFileReference was written to File. Serious Problem");
                            ((MarkingClassLogger.Api)ASCII_DESERIALIZER_LOGGER.atInfo()).log("----------------------------------------------------------------------------");
                            return retval;
                        }
                        if (!this.readFile(this._fileManager, this._workspacePath, retval)) {
                            ((MarkingClassLogger.Api)ASCII_DESERIALIZER_LOGGER.atInfo()).log("----------------------------------------------------------------------------");
                            ((MarkingClassLogger.Api)ASCII_DESERIALIZER_LOGGER.atInfo()).log("Error <readTextFileReference()> : The referenced file:" + filepath + " could not be read.");
                            ((MarkingClassLogger.Api)ASCII_DESERIALIZER_LOGGER.atInfo()).log("Can't get here unless TextFileReference was written to File. Serious Problem");
                            ((MarkingClassLogger.Api)ASCII_DESERIALIZER_LOGGER.atInfo()).log("----------------------------------------------------------------------------");
                        }
                    } else if (this._curType.equals("ID")) {
                        Integer id = this.readInteger();
                        if (id != null) {
                            this._objectTable.put(id, retval);
                        }
                    } else if (this._curType.equals("FLD")) {
                        this.readObjectField(retval);
                    } else {
                        if (this._curType.indexOf("}") == 0) {
                            return retval;
                        }
                        if (this._curType.indexOf("{") == 0) {
                            this.skipToNextEnd();
                        }
                    }
                    this._curLine = this._in.readLine();
                }
            }
            catch (IOException e) {
                ((MarkingClassLogger.Api)ASCII_DESERIALIZER_LOGGER.atWarning()).log("Error reading file in AsciiDeserializer. " + e.toString());
                ((MarkingClassLogger.Api)ASCII_DESERIALIZER_LOGGER.atInfo()).log("Line: " + this._curLine);
                throw new DeserializeObjectException("Error reading file in AsciiDeserializer. Error " + e.toString());
            }
        }
        return retval;
    }

    protected boolean readFile(RmiFileManager fm, String workspacePath, TextFileReference tfr) throws IOException {
        boolean retval = false;
        String filename = tfr.getFilename();
        String fullFilePath = workspacePath != null && !workspacePath.isEmpty() ? RMAIO.concatPath((String)workspacePath, (String)filename) : filename;
        if (fm != null && fullFilePath != null) {
            Identifier remoteId = HecAsciiDeserializer.openFile(fm, fullFilePath);
            retval = tfr.readValue(remoteId);
        }
        return retval;
    }

    public static Identifier openFile(RmiFileManager fm, String filepath) throws RemoteException {
        Identifier remoteId = null;
        if (fm != null && fm.fileExists(filepath)) {
            Identifier tfrId = new Identifier(filepath);
            remoteId = fm.openFile(UserId.getUserId(), tfrId);
        }
        return remoteId;
    }
}

