/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.rmi.io;

import hec.heclib.util.HecDouble;
import hec.heclib.util.HecDoubleArray;
import hec.heclib.util.HecTime;
import hec.io.AsciiSerializable;
import hec.io.AsciiSerializableConstants;
import hec.io.AsciiSerializer;
import hec.io.DSSIdentifier;
import hec.io.DataContainer;
import hec.io.Identifier;
import hec.io.PairedDataContainer;
import hec.io.TextFileReference;
import hec.io.TimeSeriesContainer;
import hec.lang.UserId;
import hec.model.PairedValues;
import hec.model.PairedValuesExt;
import hec.model.SeasonalRecord;
import java.awt.Color;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.PathIterator;
import java.io.BufferedWriter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.rmi.RemoteException;
import java.time.Duration;
import java.util.ArrayList;
import mil.army.usace.hec.rmi.csinterface.BaseDSSManager;
import mil.army.usace.hec.rmi.csinterface.RmiFileManager;
import rma.util.DoubleVector;
import rma.util.IntVector;
import rma.util.LongVector;
import rma.util.RMAConst;
import rma.util.RMAIO;

public class HecAsciiSerializer
extends AsciiSerializer
implements AsciiSerializableConstants {
    BaseDSSManager _dssManager = null;
    RmiFileManager _fileManager = null;
    String _workspacePath = null;

    public HecAsciiSerializer(BufferedWriter out) {
        super(out);
    }

    public void setDssFileManager(BaseDSSManager dssManager) {
        this._dssManager = dssManager;
    }

    public void setFileManager(RmiFileManager fileManager) {
        this._fileManager = fileManager;
    }

    public void setWorkspacePath(String path) {
        if (path == null) {
            return;
        }
        this._workspacePath = path;
    }

    protected void writeSeasonalRecordToDss(SeasonalRecord sr) throws IOException {
        Integer id = this.getTableObjectIndex(sr);
        if (id != null) {
            this._outLine.setLength(0);
            this._outLine.append(this._strIndent);
            this._outLine.append("REF");
            this._outLine.append("=");
            this._outLine.append(id.toString());
            this._out.write(this._outLine.substring(0));
            this._out.newLine();
            return;
        }
        if (this._workspacePath == null) {
            throw new NullPointerException("Workspace Path is Null when trying to write SeasonalRecord to DSS");
        }
        Integer objId = this.addTableObject(sr);
        this._outLine.setLength(0);
        this._outLine.append(this._strIndent);
        this._outLine.append("{");
        this._outLine.append("=");
        this._outLine.append(sr.getClass().getName());
        this._out.write(this._outLine.substring(0));
        this._out.newLine();
        this._outLine.setLength(0);
        this.incrementRecursion();
        DSSIdentifier dssId = sr.getDSSIdentifier();
        this._outLine.append(this._strIndent);
        this._outLine.append("DSSPATH");
        this._outLine.append("=");
        this._outLine.append(dssId.getDSSPath());
        this._out.write(this._outLine.substring(0));
        this._out.newLine();
        this._outLine.setLength(0);
        this._outLine.append(this._strIndent);
        this._outLine.append("DSSFILEPATH");
        this._outLine.append("=");
        String filepath = dssId.getFileName();
        filepath = RMAIO.getRelativePath((String)this._workspacePath, (String)filepath);
        if (filepath.startsWith("/")) {
            filepath = filepath.substring(1);
        }
        this._outLine.append(filepath);
        this._out.write(this._outLine.substring(0));
        this._out.newLine();
        this._outLine.setLength(0);
        this._outLine.append(this._strIndent);
        this._outLine.append("interpType");
        this._outLine.append("=");
        this._outLine.append(sr.getInterpolationType());
        this._out.write(this._outLine.substring(0));
        this._out.newLine();
        int[] times = sr.getTimeArray();
        if (times != null && times.length > 0) {
            this._outLine.setLength(0);
            this._outLine.append(this._strIndent);
            this._outLine.append("start");
            this._outLine.append("=");
            this._outLine.append(times[0]);
            this._out.write(this._outLine.substring(0));
            this._out.newLine();
            this._outLine.setLength(0);
            this._outLine.append(this._strIndent);
            this._outLine.append("end");
            this._outLine.append("=");
            this._outLine.append(times[times.length - 1]);
            this._out.write(this._outLine.substring(0));
            this._out.newLine();
        }
        this._outLine.setLength(0);
        this._outLine.append(this._strIndent);
        this._outLine.append("param");
        this._outLine.append("=");
        this._outLine.append(sr.getParameterId());
        this._out.write(this._outLine.substring(0));
        this._out.newLine();
        this._outLine.setLength(0);
        this._outLine.setLength(0);
        this._outLine.append(this._strIndent);
        this._outLine.append("units");
        this._outLine.append("=");
        this._outLine.append(sr.getUnitSystem());
        this._out.write(this._outLine.substring(0));
        this._out.newLine();
        this._outLine.setLength(0);
        this._outLine.append(this._strIndent);
        this._outLine.append("ID");
        this._outLine.append("=");
        this._outLine.append(objId.toString());
        this._out.write(this._outLine.toString());
        this._out.newLine();
        this.decrementRecursion();
        this._out.write(this._strIndent + "}");
        this._out.newLine();
        TimeSeriesContainer tsc = new TimeSeriesContainer();
        tsc.fullName = dssId.getDSSPath();
        tsc.fileName = dssId.getFileName();
        tsc.values = sr.getDataArray();
        tsc.times = sr.getTimeArray();
        tsc.numberValues = tsc.values.length;
        tsc.units = sr.getUnitsString();
        tsc.type = sr.getParamIdString();
        int rv = this._dssManager.write((DataContainer)tsc);
        if (rv != 0) {
            System.out.println("writeSeasonalRecordToDss: Error writing SeasonRecord to DSS path=" + tsc.fileName + " path=" + tsc.fullName + " rv=" + rv);
        }
    }

    protected void writePairedValuesExtToDss(PairedValuesExt pve) throws IOException {
        Integer id = this.getTableObjectIndex(pve);
        if (id != null) {
            this._outLine.setLength(0);
            this._outLine.append(this._strIndent);
            this._outLine.append("REF");
            this._outLine.append("=");
            this._outLine.append(id.toString());
            this._out.write(this._outLine.toString());
            this._out.newLine();
            return;
        }
        if (this._workspacePath == null) {
            throw new NullPointerException("Workspace Path is Null when trying to write PairedValues to DSS");
        }
        Integer objId = this.addTableObject(pve);
        this._outLine.setLength(0);
        this._outLine.append(this._strIndent);
        this._outLine.append("{");
        this._outLine.append("=");
        this._outLine.append(pve.getClass().getName());
        this._out.write(this._outLine.toString());
        this._out.newLine();
        this._outLine.setLength(0);
        this.incrementRecursion();
        this._outLine.append("DSSPATH");
        this._outLine.append("=");
        this._outLine.append(pve.getDssIdentifier().getDSSPath());
        this._out.write(this._outLine.toString());
        this._out.newLine();
        this._outLine.setLength(0);
        this._outLine.append("DSSFILEPATH");
        this._outLine.append("=");
        String filepath = pve.getDssIdentifier().getFileName();
        if (filepath.startsWith(this._workspacePath) && (filepath = filepath.substring(this._workspacePath.length())).startsWith("/")) {
            filepath = filepath.substring(1);
        }
        this._outLine.append(filepath);
        this._out.write(this._outLine.toString());
        this._out.newLine();
        this._outLine.setLength(0);
        this._outLine.append(this._strIndent);
        this._outLine.append("ID");
        this._outLine.append("=");
        this._outLine.append(objId.toString());
        this._out.write(this._outLine.toString());
        this._out.newLine();
        this.decrementRecursion();
        this._out.write(this._strIndent + "}");
        this._out.newLine();
        DSSIdentifier dssId = pve.getDssIdentifier();
        PairedDataContainer pdc = new PairedDataContainer();
        pdc.fullName = dssId.getDSSPath();
        pdc.fileName = dssId.getFileName();
        pdc.xOrdinates = pve.getXArray();
        pdc.yOrdinates = pve.getYData();
        pdc.numberCurves = pve.getNumberCurves();
        pdc.numberOrdinates = pve.size();
        pdc.xparameter = pve.getParamXString();
        pdc.yparameter = pve.getParamYString();
        pdc.xunits = pve.getParamXUnitsString();
        pdc.yunits = pve.getParamYUnitsString();
        pdc.xtype = pve.getParamXString();
        pdc.ytype = pve.getParamYString();
        if (pve.hasCurveLabels()) {
            pdc.labels = pve.getCurveLabels();
            pdc.labelsUsed = true;
        }
        pdc.storedAsdoubles = true;
        this._dssManager.write((DataContainer)pdc);
    }

    private void writePairedValuesToDss(PairedValues pv) throws IOException {
        if (this._workspacePath == null) {
            throw new NullPointerException("Workspace Path is Null when trying to write PairedValues to DSS");
        }
        Integer objId = this.addTableObject(pv);
        this._outLine.setLength(0);
        this._outLine.append(this._strIndent);
        this._outLine.append("{");
        this._outLine.append("=");
        this._outLine.append("hec.model.PairedValues");
        this._out.write(this._outLine.toString());
        this._out.newLine();
        this._outLine.setLength(0);
        this.incrementRecursion();
        this._outLine.append(this._strIndent);
        this._outLine.append("DSSPATH");
        this._outLine.append("=");
        this._outLine.append(pv.getDssIdentifer().getDSSPath());
        this._out.write(this._outLine.toString());
        this._out.newLine();
        this._outLine.setLength(0);
        this._outLine.append(this._strIndent);
        this._outLine.append("DSSFILEPATH");
        this._outLine.append("=");
        String filepath = pv.getDssIdentifer().getFileName();
        if (filepath.startsWith(this._workspacePath) && (filepath = filepath.substring(this._workspacePath.length())).startsWith("/")) {
            filepath = filepath.substring(1);
        }
        this._outLine.append(filepath);
        this._out.write(this._outLine.toString());
        this._out.newLine();
        this._outLine.setLength(0);
        this._outLine.append(this._strIndent);
        this._outLine.append("ID");
        this._outLine.append("=");
        this._outLine.append(objId.toString());
        this._out.write(this._outLine.toString());
        this._out.newLine();
        this.decrementRecursion();
        this._out.write(this._strIndent + "}");
        this._out.newLine();
        DSSIdentifier dssId = pv.getDssIdentifer();
        HecDoubleArray dArray = new HecDoubleArray(pv.getXArray());
        PairedDataContainer pdc = new PairedDataContainer();
        pdc.fullName = dssId.getDSSPath();
        pdc.fileName = dssId.getFileName();
        pdc.xOrdinates = pv.getXArray();
        pdc.yOrdinates = new double[1][pv.size()];
        pdc.yOrdinates[0] = pv.getYArray();
        pdc.numberCurves = 1;
        pdc.numberOrdinates = pv.size();
        if (pdc.xOrdinates != null) {
            pdc.numberOrdinates = pdc.xOrdinates.length;
        }
        pdc.xparameter = pv.getParamXString();
        pdc.yparameter = pv.getParamYString();
        pdc.xunits = pv.getParamXUnitsString();
        pdc.yunits = pv.getParamYUnitsString();
        if (pv.hasCurveLabel()) {
            pdc.labels = new String[1];
            pdc.labels[0] = pv.getCurveLabel();
            pdc.labelsUsed = true;
        }
        pdc.xtype = pv.getParamXString();
        pdc.ytype = pv.getParamYString();
        pdc.xprecision = this.estimateMaxPrecision(pdc.xOrdinates);
        pdc.yprecision = this.estimateMaxPrecision(pdc.yOrdinates[0]);
        dArray.set(pdc.yOrdinates[0]);
        pdc.datum = pv.getDatum();
        pdc.shift = pv.getShift();
        pdc.offset = pv.getOffset();
        if (!RMAConst.isValidValue((double)pdc.datum)) {
            pdc.datum = -3.4028234663852886E38;
        }
        if (!RMAConst.isValidValue((double)pdc.shift)) {
            pdc.shift = -3.4028234663852886E38;
        }
        if (!RMAConst.isValidValue((double)pdc.offset)) {
            pdc.offset = -3.4028234663852886E38;
        }
        pdc.storedAsdoubles = true;
        this._dssManager.write((DataContainer)pdc);
    }

    private int estimateMaxPrecision(double[] values) {
        int precision = 0;
        HecDouble hDbl = new HecDouble();
        for (int i = 0; i < values.length; ++i) {
            hDbl.set(Double.toString(values[i]));
            if (hDbl.precision() <= precision) continue;
            precision = hDbl.precision();
        }
        return precision;
    }

    protected void writeObject(Object obj) throws IOException {
        Class<?> c = null;
        if (obj != null) {
            c = obj.getClass();
        }
        String type = null;
        String val = null;
        if (c != null && c.isPrimitive()) {
            type = "VAL";
            val = obj.toString();
        } else if (obj instanceof Class) {
            type = "L";
            val = ((Class)obj).getName();
        } else if (c != null && c.isEnum()) {
            this.writeEnumData(obj);
        } else if (obj instanceof String) {
            type = "STR";
            val = ((String)obj).replace('\n', '\u0001');
        } else if (obj instanceof Integer) {
            type = "I";
            val = obj.toString();
        } else if (obj instanceof Byte) {
            type = "B";
            val = obj.toString();
        } else if (obj instanceof Float) {
            type = "F";
            val = obj.toString();
        } else if (obj instanceof Double) {
            type = "D";
            val = obj.toString();
        } else if (obj instanceof Long) {
            type = "J";
            val = obj.toString();
        } else if (obj instanceof Short) {
            type = "S";
            val = obj.toString();
        } else if (obj instanceof Character) {
            type = "C";
            val = obj.toString();
        } else if (obj instanceof Boolean) {
            type = "Z";
            val = obj.toString();
        } else if (obj instanceof Area) {
            Shape shape = (Shape)obj;
            this._outLine.setLength(0);
            this._outLine.append(this._strIndent);
            this._outLine.append("java.awt.Shape=" + shape.getClass().getName());
            this._out.write(this._outLine.toString());
            this._out.newLine();
            PathIterator path = shape.getPathIterator(null);
            double[] p = new double[6];
            ArrayList polygonList = new ArrayList();
            ArrayList<double[]> pointList = null;
            while (!path.isDone()) {
                int style = path.currentSegment(p);
                switch (style) {
                    case 0: {
                        if (pointList != null) {
                            polygonList.add(pointList);
                        }
                        pointList = new ArrayList<double[]>();
                        pointList.add(new double[]{p[0], p[1]});
                        break;
                    }
                    case 3: {
                        if (pointList == null) break;
                        pointList.add(new double[]{p[2], p[3]});
                        break;
                    }
                    case 2: {
                        if (pointList == null) break;
                        pointList.add(new double[]{p[4], p[5]});
                        break;
                    }
                    case 1: {
                        if (pointList == null) break;
                        pointList.add(new double[]{p[0], p[1]});
                        break;
                    }
                    case 4: {
                        if (pointList == null) break;
                        polygonList.add(pointList);
                        pointList = null;
                    }
                }
                path.next();
            }
            this.writeObject(polygonList);
        } else if (obj instanceof HecTime) {
            HecTime ht = (HecTime)obj;
            this._outLine.setLength(0);
            this._outLine.append(this._strIndent);
            this._outLine.append("hec.heclib.util.HecTime");
            this._outLine.append("=");
            this._outLine.append(ht.value());
            this._outLine.append(",");
            this._outLine.append(ht.timeIncrement());
            this._out.write(this._outLine.toString());
            this._out.newLine();
        } else if (obj instanceof Color) {
            Color color = (Color)obj;
            this._outLine.setLength(0);
            this._outLine.append(this._strIndent);
            this._outLine.append("java.awt.Color");
            this._outLine.append("=");
            this._outLine.append(color.getRGB());
            this._out.write(this._outLine.toString());
            this._out.newLine();
        } else if (obj instanceof Insets) {
            Insets insets = (Insets)obj;
            this._outLine.setLength(0);
            this._outLine.append(this._strIndent);
            this._outLine.append("java.awt.Insets");
            this._outLine.append("=");
            this._outLine.append(insets.top + "," + insets.left + "," + insets.bottom + "," + insets.right);
            this._out.write(this._outLine.toString());
            this._out.newLine();
        } else if (obj instanceof Duration) {
            Duration duration = (Duration)obj;
            this._outLine.setLength(0);
            this._outLine.append(this._strIndent);
            this._outLine.append("java.time.Duration");
            this._outLine.append("=");
            this._outLine.append(duration.toString());
            this._out.write(this._outLine.toString());
            this._out.newLine();
        } else if (obj instanceof Font) {
            Font font = (Font)obj;
            this._outLine.setLength(0);
            this._outLine.append(this._strIndent);
            this._outLine.append("java.awt.Font");
            this._outLine.append("=");
            this._outLine.append(font.getFontName() + "," + font.getSize() + "," + font.getStyle());
            this._out.write(this._outLine.toString());
            this._out.newLine();
        } else if (obj instanceof PairedValues) {
            this.writePairedValues((PairedValues)obj);
        } else if (obj instanceof PairedValuesExt && ((PairedValuesExt)obj).getDssIdentifier() != null && ((PairedValuesExt)obj).size() > 0) {
            this.writePairedValuesExtToDss((PairedValuesExt)obj);
        } else if (obj instanceof SeasonalRecord && ((SeasonalRecord)obj).getDSSIdentifier() != null && this._dssManager != null && ((SeasonalRecord)obj).size() > 0) {
            this.writeSeasonalRecordToDss((SeasonalRecord)obj);
        } else if (obj instanceof TextFileReference) {
            this.writeTextFileReference((TextFileReference)obj);
        } else {
            if (obj instanceof LongVector) {
                LongVector lc = (LongVector)obj;
                lc.trimToSize();
            } else if (obj instanceof IntVector) {
                IntVector iv = (IntVector)obj;
                iv.trimToSize();
            } else if (obj instanceof DoubleVector) {
                DoubleVector dv = (DoubleVector)obj;
                dv.trimToSize();
            }
            if (obj == null) {
                this._out.write(this._strIndent + "{=null");
                this._out.newLine();
                this._out.write(this._strIndent + "}");
                this._out.newLine();
                return;
            }
            Integer id = this.getTableObjectIndex(obj);
            if (id != null) {
                type = "REF";
                val = id.toString();
            } else {
                id = this.addTableObject(obj);
                this._outLine.setLength(0);
                this._outLine.append(this._strIndent);
                this._outLine.append("{");
                this._outLine.append("=");
                this._outLine.append(obj.getClass().getName());
                this._out.write(this._outLine.toString());
                this._out.newLine();
                this.incrementRecursion();
                this._outLine.setLength(0);
                this._outLine.append(this._strIndent);
                this._outLine.append("ID");
                this._outLine.append("=");
                this._outLine.append(id.toString());
                this._out.write(this._outLine.toString());
                this._out.newLine();
                if (c.isArray()) {
                    this.writeArray(obj);
                } else {
                    this.writeObjectFields(obj);
                }
                this.decrementRecursion();
                this._out.write(this._strIndent + "}");
                this._out.newLine();
            }
        }
        if (type != null && val != null) {
            this._outLine.setLength(0);
            this._outLine.append(this._strIndent);
            this._outLine.append(type);
            this._outLine.append("=");
            this._outLine.append(val);
            this._out.write(this._outLine.toString());
            this._out.newLine();
        }
    }

    protected void writePairedValues(PairedValues pv) throws IOException {
        Integer id = this.getTableObjectIndex(pv);
        if (id != null) {
            this._outLine.setLength(0);
            this._outLine.append(this._strIndent);
            this._outLine.append("REF");
            this._outLine.append("=");
            this._outLine.append(id.toString());
            this._out.write(this._outLine.toString());
            this._out.newLine();
        } else {
            if (pv.size() > 0 && pv.getDssIdentifer() != null && this._dssManager != null) {
                this.writePairedValuesToDss(pv);
                return;
            }
            id = this.addTableObject(pv);
            this._outLine.setLength(0);
            this._outLine.append(this._strIndent);
            this._outLine.append("{");
            this._outLine.append("=");
            this._outLine.append("hec.model.PairedValues");
            this._out.write(this._outLine.toString());
            this._out.newLine();
            this.incrementRecursion();
            this._outLine.setLength(0);
            this._outLine.append(this._strIndent);
            this._outLine.append("ID");
            this._outLine.append("=");
            this._outLine.append(id.toString());
            this._out.write(this._outLine.toString());
            this._out.newLine();
            double[] xarray = pv.getXArray();
            this.writeArray(xarray);
            double[] yarray = pv.getYArray();
            this.writeArray(yarray);
            Class<PairedValues> c = PairedValues.class;
            Field[] fieldArray = c.getDeclaredFields();
            for (int i = 0; i < fieldArray.length; ++i) {
                int mods;
                if (fieldArray[i].getName().equals("_dataVector") || Modifier.isTransient(mods = fieldArray[i].getModifiers()) || Modifier.isStatic(mods)) continue;
                Object fldObj = null;
                if (Modifier.isPublic(mods)) {
                    try {
                        fldObj = fieldArray[i].get(pv);
                    }
                    catch (IllegalAccessException e) {
                        fldObj = null;
                    }
                } else {
                    fldObj = pv.getFieldObject(fieldArray[i]);
                }
                if (fldObj != null && !this.writeField(fieldArray[i], fldObj)) break;
            }
            this.decrementRecursion();
            this._out.write(this._strIndent + "}");
            this._out.newLine();
        }
    }

    protected void writeTextFileReference(TextFileReference tfr) throws IOException {
        Integer id = this.getTableObjectIndex(tfr);
        if (id != null) {
            this.writeTypeParamLine("REF", id.toString());
        } else {
            Integer objId = this.addTableObject(tfr);
            this.writeTypeParamLine("{", "hec.io.TextFileReference");
            this.incrementRecursion();
            boolean externalWriteWorked = false;
            if (this._fileManager != null) {
                externalWriteWorked = this.writeFile(this._fileManager, this._workspacePath, tfr);
            }
            if (externalWriteWorked) {
                this.writeTypeParamLine("FILEPATH", tfr.getFilename());
                this.writeTypeParamLine("ID", objId.toString());
            } else {
                this.writeTypeParamLine("ID", objId.toString());
                this.writeFields((AsciiSerializable)tfr, TextFileReference.class.getDeclaredFields());
            }
            this.decrementRecursion();
            this._out.write(this._strIndent + "}");
            this._out.newLine();
        }
    }

    private boolean writeFile(RmiFileManager fm, String workspacePath, TextFileReference tfr) throws IOException {
        boolean worked = false;
        String filepath = tfr.getFilename();
        String fullFilePath = workspacePath != null && !workspacePath.isEmpty() ? RMAIO.concatPath((String)workspacePath, (String)filepath) : filepath;
        String stringContents = tfr.getValue();
        if (stringContents == null || stringContents.isEmpty()) {
            if (fm.fileExists(fullFilePath)) {
                fm.deleteFile(fullFilePath);
            }
            worked = false;
        } else {
            Identifier remoteId = HecAsciiSerializer.openOrCreate(fm, fullFilePath);
            worked = tfr.writeValue(remoteId);
        }
        return worked;
    }

    public static Identifier openOrCreate(RmiFileManager fm, String filepath) throws RemoteException {
        Identifier remoteId = null;
        if (fm != null) {
            if (fm.fileExists(filepath)) {
                Identifier tfrId = new Identifier(filepath);
                remoteId = fm.openFile(UserId.getUserId(), tfrId);
            } else {
                Identifier tfrId = new Identifier(filepath);
                remoteId = fm.newFile(UserId.getUserId(), tfrId);
            }
        }
        return remoteId;
    }
}

